/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.complexity.TSEExpandedNodeExtension;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.g8;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEChildGraphUI;
import com.tomsawyer.editor.ui.TSEDefaultNodeUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class TSENode
extends TSDNode
implements TSESolidObject,
TSEInspectable {
    public static TSEInspectorPropertyID NAME_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Name"), class$java$lang$String == null ? (class$java$lang$String = TSENode.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID URL_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("URL"), class$java$lang$String == null ? (class$java$lang$String = TSENode.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSENode.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSENode.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID X_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("X_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSENode.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID Y_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Y_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSENode.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID RESIZABILITY_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Resizability"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSENode.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String NO_FIT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("No_Fit");
    public static final String TIGHT_FIT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Fit");
    public static final String TIGHT_WIDTH_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Width");
    public static final String TIGHT_HEIGHT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Height");
    public static final String TIGHT_FIT_PRESERVE_ASPECT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Fit_Preserve_Aspect");
    public static final String PRESERVE_ASPECT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Preserve_Aspect");
    TSENodeUI nodeUI;
    TSENodeUI originalUI;
    boolean dragged;
    boolean selected;
    double aspectRatio;
    int resizability;
    boolean highlighted;
    URL url;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    protected TSENode() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.setResizability(this.getDefaultResizability());
        this.setUI(this.newNodeUI());
    }

    protected TSNodeLabel newLabel() {
        return new TSENodeLabel();
    }

    protected TSConnector newConnector() {
        return new TSEConnector();
    }

    protected TSENodeUI newNodeUI() {
        return new TSEDefaultNodeUI();
    }

    public TSEChildGraphUI newChildGraphUI() {
        return new TSEChildGraphUI();
    }

    public TSEObjectUI getUI() {
        return this.nodeUI;
    }

    public TSENodeUI getNodeUI() {
        return this.nodeUI;
    }

    public void setUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSENodeUI) {
            this.nodeUI = (TSENodeUI)tSEObjectUI;
            this.nodeUI.setOwner(this);
            if (this.nodeUI.getShape() != null) {
                this.setShape(this.nodeUI.getShape());
            }
        }
    }

    public TSEObjectUI getOriginalUI() {
        return this.originalUI;
    }

    public TSENodeUI getOriginalNodeUI() {
        return this.originalUI;
    }

    public void setOriginalUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSENodeUI) {
            this.originalUI = (TSENodeUI)tSEObjectUI;
        }
    }

    public void setTag(Object object) {
        boolean bl = false;
        if (this.getOwnerGraph() != null) {
            bl = this.getOwnerGraph().isCoalesce();
            this.getOwnerGraph().setCoalesce(true);
        }
        super.setTag(object);
        if (this.nodeUI != null) {
            this.nodeUI.onTextChanged(this.getText());
        }
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().setCoalesce(bl);
        }
    }

    public boolean locallyContains(double d, double d2) {
        boolean bl = super.locallyContains(d, d2);
        if (!bl) {
            TSConstRect tSConstRect;
            TSENodeUI tSENodeUI = (TSENodeUI)this.getUI();
            if (tSENodeUI != null && tSENodeUI.hasHideMark()) {
                tSConstRect = tSENodeUI.getLocalHideMarkBounds().intersection(this.getLocalBounds());
                boolean bl2 = bl = tSConstRect != null && tSConstRect.contains(d, d2);
            }
            if (!bl && tSENodeUI != null && tSENodeUI.hasChildGraphMark()) {
                tSConstRect = tSENodeUI.getLocalChildGraphMarkBounds().intersection(this.getLocalBounds());
                bl = tSConstRect != null && tSConstRect.contains(d, d2);
            }
        }
        return bl;
    }

    public boolean locallyContains(double d, double d2, double d3, double d4) {
        boolean bl = super.locallyContains(d, d2, d3, d4);
        if (!bl) {
            TSConstRect tSConstRect;
            TSENodeUI tSENodeUI = (TSENodeUI)this.getUI();
            if (tSENodeUI != null && tSENodeUI.hasHideMark()) {
                tSConstRect = tSENodeUI.getLocalHideMarkBounds().intersection(this.getLocalBounds());
                boolean bl2 = bl = tSConstRect != null && tSConstRect.contains(d, d2, d3, d4);
            }
            if (!bl && tSENodeUI != null && tSENodeUI.hasChildGraphMark()) {
                tSConstRect = tSENodeUI.getLocalChildGraphMarkBounds().intersection(this.getLocalBounds());
                bl = tSConstRect != null && tSConstRect.contains(d, d2, d3, d4);
            }
        }
        return bl;
    }

    public boolean locallyIntersectsNodeFrame(TSPoint tSPoint) {
        boolean bl = super.locallyIntersectsNodeFrame(tSPoint);
        if (!bl) {
            TSConstRect tSConstRect;
            TSENodeUI tSENodeUI = (TSENodeUI)this.getUI();
            if (tSENodeUI != null && tSENodeUI.hasHideMark()) {
                tSConstRect = tSENodeUI.getLocalHideMarkBounds().intersection(this.getLocalBounds());
                boolean bl2 = bl = tSConstRect != null && tSConstRect.contains(tSPoint.getX(), tSPoint.getY());
            }
            if (!bl && tSENodeUI != null && tSENodeUI.hasChildGraphMark()) {
                tSConstRect = tSENodeUI.getLocalChildGraphMarkBounds().intersection(this.getLocalBounds());
                bl = tSConstRect != null && tSConstRect.contains(tSPoint.getX(), tSPoint.getY());
            }
        }
        return bl;
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        boolean bl = super.locallyIntersects(d, d2, d3, d4);
        if (!bl) {
            TSConstRect tSConstRect;
            TSENodeUI tSENodeUI = (TSENodeUI)this.getUI();
            if (tSENodeUI != null && tSENodeUI.hasHideMark()) {
                tSConstRect = tSENodeUI.getLocalHideMarkBounds().intersection(this.getLocalBounds());
                boolean bl2 = bl = tSConstRect != null && tSConstRect.intersects(d, d2, d3, d4);
            }
            if (!bl && tSENodeUI != null && tSENodeUI.hasChildGraphMark()) {
                tSConstRect = tSENodeUI.getLocalChildGraphMarkBounds().intersection(this.getLocalBounds());
                bl = tSConstRect != null && tSConstRect.intersects(d, d2, d3, d4);
            }
        }
        return bl;
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (this.getUI() != null) {
            this.getUI().onOwnerInserted();
        }
        if (tSGraphObject.getOwnerGraphManager() != null) {
            TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSEGraphManager)tSGraphObject.getOwnerGraphManager());
            Iterator iterator = this.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSENodeUI tSENodeUI;
                TSEEdge tSEEdge = (TSEEdge)iterator.next();
                if (!TSHidingManager.isHidden(tSEEdge)) continue;
                TSENode tSENode = null;
                if (this == tSEEdge.getSourceNode()) {
                    tSENode = (TSENode)tSEEdge.getTargetNode();
                } else if (this == tSEEdge.getTargetNode()) {
                    tSENode = (TSENode)tSEEdge.getSourceNode();
                }
                if (tSENode == null || !tSENode.isViewable() || (tSENodeUI = (TSENodeUI)tSENode.getUI()).hasHideMark()) continue;
                tSENodeUI.updateHideMark();
            }
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        Object object;
        this.setSelected(false);
        this.setHighlighted(false);
        this.setLabelsSelected(false);
        this.setConnectorLabelsSelected(false);
        this.setConnectorsSelected(false);
        Iterator iterator = this.buildInOutEdges(0).iterator();
        while (iterator.hasNext()) {
            object = (TSEEdge)iterator.next();
            ((TSEEdge)object).setSelected(false);
        }
        if (this.getUI() != null) {
            this.getUI().onOwnerRemoved();
        }
        super.onRemove(tSGraphObject);
        if (tSGraphObject.getOwnerGraphManager() != null) {
            object = (TSEHidingManager)TSEHidingManager.getManager((TSEGraphManager)tSGraphObject.getOwnerGraphManager());
            Iterator iterator2 = this.disconnectedEdges().iterator();
            while (iterator2.hasNext()) {
                TSEEdge tSEEdge = (TSEEdge)iterator2.next();
                if (!TSHidingManager.isHidden(tSEEdge)) continue;
                TSENode tSENode = null;
                if (this == tSEEdge.getSourceNode()) {
                    tSENode = (TSENode)tSEEdge.getTargetNode();
                } else if (this == tSEEdge.getTargetNode()) {
                    tSENode = (TSENode)tSEEdge.getSourceNode();
                }
                if (tSENode == null || !tSENode.isViewable()) continue;
                ((TSENodeUI)tSENode.getUI()).updateHideMark();
            }
        }
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getUI() != null) {
            this.getUI().onOwnerDiscarded();
        }
        super.onDiscard(tSGraphObject);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (bl == this.selected || bl && !this.isViewable()) {
            return;
        }
        TSEGraph tSEGraph = (TSEGraph)this.getOwner();
        if (tSEGraph == null) {
            throw new IllegalStateException("node has no owner");
        }
        TSESelectionChangeEvent tSESelectionChangeEvent = new TSESelectionChangeEvent(2L, new TSESelectionChangeEventData(this, bl));
        if (tSEGraph.fireEvent(tSESelectionChangeEvent, true)) {
            if (bl) {
                this.selected = true;
                tSEGraph.selectedNodesList.add(this);
            } else {
                this.selected = false;
                tSEGraph.selectedNodesList.remove(this);
            }
            tSEGraph.fireEvent(tSESelectionChangeEvent);
        }
    }

    public void setLabelsSelected(boolean bl) {
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            TSENodeLabel tSENodeLabel = (TSENodeLabel)iterator.next();
            tSENodeLabel.setSelected(bl);
        }
    }

    public void setConnectorLabelsSelected(boolean bl) {
        Iterator iterator = this.connectors().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((TSEConnector)iterator.next()).labels().iterator();
            while (iterator2.hasNext()) {
                ((TSEConnectorLabel)iterator2.next()).setSelected(bl);
            }
        }
    }

    public void setConnectorsSelected(boolean bl) {
        Iterator iterator = this.connectors().iterator();
        while (iterator.hasNext()) {
            TSEConnector tSEConnector = (TSEConnector)iterator.next();
            tSEConnector.setSelected(bl);
        }
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public void setDragged(boolean bl) {
        this.dragged = bl;
    }

    public void copy(Object object, boolean bl) {
        this.resizability = this.getDefaultResizability();
        super.copy(object, bl);
        if (object instanceof TSENode) {
            this.resizability = 0x1000000;
            TSENode tSENode = (TSENode)object;
            this.url = tSENode.getURL();
            Object object2 = this.getTag();
            if (tSENode.isExpanded()) {
                if (tSENode.getOriginalUI() != null) {
                    this.setUI((TSENodeUI)tSENode.getOriginalUI().clone());
                }
                this.setOriginalUI((TSENodeUI)tSENode.getUI().clone());
                TSEExpandedNodeExtension tSEExpandedNodeExtension = (TSEExpandedNodeExtension)((TSDChildGraphForestEdge)tSENode.getChildGraphForestEdge()).getExpandedNodeExtension();
                this.resizability = tSEExpandedNodeExtension.getPreExpandResizability();
            } else {
                this.setUI((TSENodeUI)tSENode.getUI().clone());
                if (tSENode.getOriginalUI() != null) {
                    this.setOriginalUI((TSENodeUI)tSENode.getOriginalUI().clone());
                }
                if (object2 != this.getTag()) {
                    this.setTag(object2);
                }
                this.resizability = tSENode.getResizability();
            }
        } else if (object instanceof TSDNode && ((TSDNode)object).isExpanded()) {
            this.setUI(this.newChildGraphUI());
        }
        this.selected = false;
        this.dragged = false;
        this.highlighted = false;
    }

    public double getMinimumWidth() {
        double d = 1.0;
        if (this.getUI() != null) {
            return Math.max(this.getNodeUI().getMinimumWidth(), d);
        }
        return d;
    }

    public double getMinimumHeight() {
        double d = 1.0;
        if (this.getUI() != null) {
            return Math.max(this.getNodeUI().getMinimumHeight(), d);
        }
        return d;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(NAME_ID);
        list.add(URL_ID);
        if (this.nodeUI != null) {
            this.nodeUI.getInspectorPropertyIDs(list);
        }
        if ((this.getResizability() & 0x1000000) == 0 && !this.isExpanded()) {
            list.add(RESIZABILITY_ID);
        }
        list.add(WIDTH_ID);
        list.add(HEIGHT_ID);
        list.add(X_CENTER_ID);
        list.add(Y_CENTER_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            if (this.getTag() instanceof String) {
                return new TSEInspectorProperty(new String((String)this.getTag()));
            }
            return new TSEInspectorProperty(new String());
        }
        if (this.nodeUI != null && (tSEInspectorProperty = this.nodeUI.getInspectorProperty(tSEInspectorPropertyID)) != null) {
            return tSEInspectorProperty;
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            if (this.getURL() != null) {
                return new TSEInspectorProperty(this.getURL().toExternalForm());
            }
            return new TSEInspectorProperty(new String());
        }
        if (tSEInspectorPropertyID.equals(RESIZABILITY_ID)) {
            tSEInspectorProperty = new g8(this);
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(NO_FIT_STRING, new Integer(0));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_FIT_STRING, new Integer(1 | 2));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_WIDTH_STRING, new Integer(1));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_HEIGHT_STRING, new Integer(2));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_FIT_PRESERVE_ASPECT_STRING, new Integer(1 | 2 | 4));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(PRESERVE_ASPECT_STRING, new Integer(4));
            return tSEInspectorProperty;
        }
        if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterX()), new Double(-999999.0), new Double(999999.0));
        }
        if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterY()), new Double(-999999.0), new Double(999999.0));
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            int n = this.getResizability();
            if (this.isExpanded() || (n & 0x1000000) != 0 || (n & 1) != 0) {
                return new TSEInspectorProperty((Object)new Double(this.getLocalWidth()), false);
            }
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalWidth()), new Double(this.getMinimumWidth()), new Double(99999.0));
        }
        if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            int n = this.getResizability();
            if (this.isExpanded() || (n & 0x1000000) != 0 || (n & 2) != 0) {
                return new TSEInspectorProperty((Object)new Double(this.getLocalHeight()), false);
            }
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalHeight()), new Double(this.getMinimumHeight()), new Double(99999.0));
        }
        return null;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            this.setTag(tSEInspectorProperty.getValue());
            return 2;
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            URL uRL = TSSystem.getValidatedURL((String)tSEInspectorProperty.getValue());
            this.setURL(uRL);
            return 2;
        }
        if (this.nodeUI != null) {
            int n = this.nodeUI.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
            if (n != 0) {
                return n;
            }
        }
        if (tSEInspectorPropertyID.equals(RESIZABILITY_ID) && tSEInspectorProperty instanceof g8) {
            ((g8)tSEInspectorProperty).a(this);
            return 2;
        }
        if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
            this.setLocalCenterX((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
            this.setLocalCenterY((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalOriginalWidth(d);
            this.setLocalWidth(d);
            return 2;
        }
        if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalOriginalHeight(d);
            this.setLocalHeight(d);
            return 2;
        }
        return 0;
    }

    public int levelNumber() {
        return 2;
    }

    public TSRect adjustBounds(double d, double d2, double d3, double d4, TSRect tSRect) {
        return super.adjustBounds(d, d2, d3, d4, tSRect);
    }

    public TSSize adjustSize(double d, double d2, double d3, double d4, TSSize tSSize) {
        double d5 = d;
        double d6 = d2;
        int n = this.getResizability();
        if ((n & 0x1000000) != 0) {
            d5 = d3;
            d6 = d4;
        } else {
            double d7 = this.getMinimumWidth();
            double d8 = this.getMinimumHeight();
            double d9 = this.getAspectRatio();
            d5 = (n & 1) != 0 ? Math.max(d7, this.getTightWidth()) : Math.max(d7, d);
            d6 = (n & 2) != 0 ? Math.max(d8, this.getTightHeight()) : Math.max(d8, d2);
            if ((n & 4) != 0) {
                if ((n & 8) != 0) {
                    if (d6 * d9 > d5) {
                        d6 = d5 / d9;
                    } else {
                        d5 = d6 * d9;
                    }
                } else if (d6 * d9 > d5) {
                    d5 = d6 * d9;
                } else {
                    d6 = d5 / d9;
                }
                if (d5 < d7) {
                    d6 *= d7 / d5;
                    d5 = d7;
                }
                if (d6 < d8) {
                    d5 *= d8 / d6;
                    d6 = d8;
                }
            }
        }
        if (tSSize == null) {
            tSSize = new TSSize(d5, d6);
        } else {
            tSSize.setSize(d5, d6);
        }
        return tSSize;
    }

    public final TSSize adjustSize(double d, double d2, TSSize tSSize) {
        return this.adjustSize(d, d2, this.getLocalWidth(), this.getLocalHeight(), tSSize);
    }

    public double getTightWidth() {
        if (this.isExpanded()) {
            TSConstRect tSConstRect = TSNestingManager.getNestedGraph(this).getLocalBounds();
            TSRect tSRect = TSNestingManager.expandRectWithMargins(this, tSConstRect);
            return tSRect.getWidth();
        }
        if (this.getUI() != null) {
            return Math.max(this.getNodeUI().getTightWidth(), this.getMinimumWidth());
        }
        return this.getMinimumWidth();
    }

    public double getTightHeight() {
        if (this.isExpanded()) {
            TSConstRect tSConstRect = TSNestingManager.getNestedGraph(this).getLocalBounds();
            TSRect tSRect = TSNestingManager.expandRectWithMargins(this, tSConstRect);
            return tSRect.getHeight();
        }
        if (this.getUI() != null) {
            return Math.max(this.getNodeUI().getTightHeight(), this.getMinimumHeight());
        }
        return this.getMinimumHeight();
    }

    public void resize() {
        double d = this.getLocalWidth();
        double d2 = this.getLocalHeight();
        this.setLocalAdjustedSize(d, d2);
        double d3 = this.getLocalWidth();
        double d4 = this.getLocalHeight();
        if (d != d3 || d2 != d4) {
            this.setLocalAdjustedOriginalSize(d3, d4);
        }
    }

    public void setAdjustedBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = this.adjustBounds(d, d2, d3, d4, null);
        this.setBounds(tSRect);
    }

    public void setAdjustedBounds(TSRect tSRect) {
        this.setAdjustedBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalAdjustedSize(double d, double d2) {
        TSSize tSSize = this.adjustSize(d, d2, null);
        this.setLocalSize(tSSize);
    }

    public void setLocalAdjustedSize(TSSize tSSize) {
        this.setLocalAdjustedSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public void setAdjustedSize(double d, double d2) {
        this.setLocalAdjustedSize(d, d2);
    }

    public void setAdjustedSize(TSSize tSSize) {
        this.setAdjustedSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public void setLocalAdjustedOriginalSize(double d, double d2) {
        TSSize tSSize = this.adjustSize(d, d2, null);
        this.setLocalOriginalSize(tSSize);
    }

    public void setLocalAdjustedOriginalSize(TSSize tSSize) {
        this.setLocalAdjustedOriginalSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public void setAdjustedOriginalSize(double d, double d2) {
        this.setLocalAdjustedOriginalSize(d, d2);
    }

    public void setAdjustedOriginalSize(TSSize tSSize) {
        this.setAdjustedOriginalSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public void setResizability(int n) {
        this.aspectRatio = this.getLocalWidth() / this.getLocalHeight();
        int n2 = this.resizability;
        this.resizability = n;
        if (n2 != n) {
            this.resize();
            if (this.getOwnerGraph() != null) {
                this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(2L, new TSEPropertyChangeEventData(this, new Integer(n2), new Integer(n))));
            }
        }
    }

    public int getResizability() {
        return this.resizability;
    }

    public int getDefaultResizability() {
        return 0;
    }

    public void setAspectRatio(double d) {
        this.aspectRatio = d;
        this.resize();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(4L, new TSEPropertyChangeEventData(this, uRL2, uRL)));
        }
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public String getToolTipText() {
        return this.getText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

