/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Shape;

public class TSELineGrid
extends TSEGrid {
    static final TSEColor[] COLORS = new TSEColor[]{new TSEColor(204, 255, 255), new TSEColor(153, 204, 204), new TSEColor(102, 153, 153)};
    private int cellsPerSubgrid;
    private int dropoutThreshold;
    private int subgridCount;
    private TSEColor[] colors;

    public TSELineGrid() {
        this.setCellsPerSubgrid(this.getDefaultCellsPerSubgrid());
        this.setDropoutThreshold(this.getDefaultDropoutThreshold());
        this.setSubgridCount(this.getDefaultSubgridCount());
        this.setColors(this.getDefaultColors());
    }

    public int getCellsPerSubgrid() {
        return this.cellsPerSubgrid;
    }

    public void setCellsPerSubgrid(int n) {
        if (n > 1) {
            this.cellsPerSubgrid = n;
        }
    }

    public int getDefaultCellsPerSubgrid() {
        return 5;
    }

    public int getDropoutThreshold() {
        return this.dropoutThreshold;
    }

    public void setDropoutThreshold(int n) {
        if (n > 0) {
            this.dropoutThreshold = n;
        }
    }

    public int getDefaultDropoutThreshold() {
        return 8;
    }

    public int getSubgridCount() {
        return this.subgridCount;
    }

    public void setSubgridCount(int n) {
        if (n > 0) {
            this.subgridCount = n;
        }
    }

    public int getDefaultSubgridCount() {
        return 3;
    }

    public void setColors(TSEColor[] tSEColorArray) {
        this.colors = tSEColorArray;
    }

    public TSEColor[] getColors() {
        return this.colors;
    }

    public TSEColor[] getDefaultColors() {
        return COLORS;
    }

    protected void drawRow(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n6 == 0 && n4 > (n7 = this.getDropoutThreshold() * (int)Math.pow(this.getCellsPerSubgrid(), n5 + 1))) {
            this.selectColor(tSEGraphics, ++n5);
        }
        tSEGraphics.drawLine(n, n3, n2, n3);
    }

    protected void drawColumn(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n6 == 0 && n4 > (n7 = this.getDropoutThreshold() * (int)Math.pow(this.getCellsPerSubgrid(), n5 + 1))) {
            this.selectColor(tSEGraphics, ++n5);
        }
        tSEGraphics.drawLine(n3, n, n3, n2);
    }

    protected void selectColor(TSEGraphics tSEGraphics, int n) {
        if (this.colors != null && n < this.colors.length) {
            tSEGraphics.setColor(this.colors[n]);
        }
    }

    protected void drawSubgrid(TSEGraphics tSEGraphics, TSConstRect tSConstRect, double d, double d2, int n, int n2) {
        block9: {
            int n3;
            int n4;
            int n5;
            int n6;
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            int n7 = tSTransform.xToDevice(tSConstRect.getLeft());
            int n8 = tSTransform.yToDevice(tSConstRect.getBottom());
            int n9 = tSTransform.xToDevice(tSConstRect.getRight());
            int n10 = tSTransform.yToDevice(tSConstRect.getTop());
            this.selectColor(tSEGraphics, n);
            if (tSTransform.widthToDevice(d) >= this.getDropoutThreshold()) {
                n6 = (int)(tSConstRect.getLeft() / d);
                n5 = (int)(tSConstRect.getRight() / d);
                n4 = tSTransform.widthToDevice(d);
                if (n < this.getSubgridCount() - 1) {
                    for (n3 = n6; n3 <= n5; ++n3) {
                        if (n3 % this.getCellsPerSubgrid() == 0) continue;
                        this.drawColumn(tSEGraphics, n8, n10, tSTransform.xToDevice((double)n3 * d), n4, n, n2);
                    }
                } else {
                    for (n3 = n6; n3 <= n5; ++n3) {
                        this.drawColumn(tSEGraphics, n8, n10, tSTransform.xToDevice((double)n3 * d), n4, n, n2);
                    }
                }
            }
            if (tSTransform.heightToDevice(d2) < this.getDropoutThreshold()) break block9;
            n6 = (int)(tSConstRect.getBottom() / d2);
            n5 = (int)(tSConstRect.getTop() / d2);
            n4 = tSTransform.heightToDevice(d2);
            if (n < this.getSubgridCount() - 1) {
                for (n3 = n6; n3 <= n5; ++n3) {
                    if (n3 % this.getCellsPerSubgrid() == 0) continue;
                    this.drawRow(tSEGraphics, n7, n9, tSTransform.yToDevice((double)n3 * d2), n4, n, n2);
                }
            } else {
                for (n3 = n6; n3 <= n5; ++n3) {
                    this.drawRow(tSEGraphics, n7, n9, tSTransform.yToDevice((double)n3 * d2), n4, n, n2);
                }
            }
        }
    }

    public void draw(TSEGraphics tSEGraphics, TSConstRect tSConstRect) {
        int n;
        Shape shape = tSEGraphics.getClip();
        tSEGraphics.clipRect(tSConstRect);
        double d = this.getXSpacing();
        double d2 = this.getYSpacing();
        int n2 = 0;
        if (this.getCellsPerSubgrid() > 1) {
            n = this.getDropoutThreshold();
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            while (tSTransform.widthToDevice(d) < n || tSTransform.heightToDevice(d2) < n) {
                d *= (double)this.getCellsPerSubgrid();
                d2 *= (double)this.getCellsPerSubgrid();
                ++n2;
            }
        }
        for (n = 0; n < this.getSubgridCount(); ++n) {
            this.drawSubgrid(tSEGraphics, tSConstRect, d, d2, n, n2);
            d *= (double)this.getCellsPerSubgrid();
            d2 *= (double)this.getCellsPerSubgrid();
        }
        tSEGraphics.setClip(shape);
    }
}

