/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.editor.TSEDockableDialog;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.util.TSSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class TSEDockingManager
extends ComponentAdapter
implements MouseListener {
    Container mainWindow;
    JRootPane rootPane;
    int mainDockingIndex;
    boolean enabled;
    int oldX = 0;
    int oldY = 0;
    int dockingDistance;
    int snapDistance = 20;
    int undockPositionX;
    int undockPositionY;
    boolean resized = false;
    int portionOfSide;
    Vector dockedWindows;
    Vector undockedWindows;
    ImageIcon icon;
    public static final int LEFT_SIDE = 1;
    public static final int TOP_SIDE = 2;
    public static final int RIGHT_SIDE = 3;
    public static final int BOTTOM_SIDE = 4;

    public TSEDockingManager(Container container) {
        this(container, null);
    }

    public TSEDockingManager(Container container, ImageIcon imageIcon) {
        this.icon = imageIcon;
        this.enabled = true;
        this.mainWindow = container;
        this.rootPane = (JRootPane)this.mainWindow.getParent().getParent();
        for (int i = 0; i < this.mainWindow.getComponents().length; ++i) {
            if (!(this.mainWindow.getComponents()[i] instanceof JTabbedPane) && !(this.mainWindow.getComponents()[i] instanceof JDesktopPane) && !(this.mainWindow.getComponents()[i] instanceof TSEGraphWindow)) continue;
            this.mainDockingIndex = i;
            break;
        }
        this.setDockingDistance(3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2 && TSSystem.isJVM13orAbove()) {
            try {
                JInternalFrame jInternalFrame = (JInternalFrame)((BasicInternalFrameTitlePane)mouseEvent.getSource()).getParent();
                this.undockPositionX = mouseEvent.getPoint().x + jInternalFrame.getLocationOnScreen().x - 50;
                this.undockPositionY = mouseEvent.getPoint().y + jInternalFrame.getLocationOnScreen().y;
                this.replaceInternalFrame(jInternalFrame);
                this.showUndockedWindow(jInternalFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (TSSystem.isJVM13orAbove()) {
            try {
                JInternalFrame jInternalFrame = (JInternalFrame)((BasicInternalFrameTitlePane)mouseEvent.getSource()).getParent();
                this.undockPositionX = mouseEvent.getPoint().x + jInternalFrame.getLocationOnScreen().x - 50;
                this.undockPositionY = mouseEvent.getPoint().y + jInternalFrame.getLocationOnScreen().y;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resized = true;
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (!this.enabled) {
            return;
        }
        if (componentEvent.getSource() instanceof TSEDockableDialog) {
            TSEDockableDialog tSEDockableDialog = (TSEDockableDialog)componentEvent.getSource();
            int n = this.findPosition(tSEDockableDialog);
            if (n > 0 && tSEDockableDialog.isVisible()) {
                this.insertComponent(tSEDockableDialog, n);
            }
        } else if (componentEvent.getSource() instanceof JInternalFrame) {
            JInternalFrame jInternalFrame = (JInternalFrame)componentEvent.getSource();
            if (!(Math.abs(jInternalFrame.getLocation().x - this.oldX) <= 0 && Math.abs(jInternalFrame.getLocation().y - this.oldY) <= 0 || this.resized)) {
                this.replaceInternalFrame(jInternalFrame);
                this.showUndockedWindow(jInternalFrame);
            } else {
                this.resized = false;
            }
        }
    }

    public boolean hasDockedWindows() {
        int n = 0;
        if (this.undockedWindows != null) {
            n = this.undockedWindows.size();
        }
        return n > 0;
    }

    public void showUndockedWindow(JInternalFrame jInternalFrame) {
        TSEDockableDialog tSEDockableDialog = this.findDockableDialog(jInternalFrame);
        tSEDockableDialog.setDocked(false);
        ((Component)tSEDockableDialog).setLocation(this.undockPositionX, this.undockPositionY);
        tSEDockableDialog.setContentPane(jInternalFrame.getContentPane());
        ((Component)tSEDockableDialog).setVisible(true);
        this.dockedWindows.remove(jInternalFrame);
        this.undockedWindows.remove(tSEDockableDialog);
    }

    public void replaceInternalFrame(TSEDockableDialog tSEDockableDialog) {
        JInternalFrame jInternalFrame = this.findInternalFrame(tSEDockableDialog);
        tSEDockableDialog.setContentPane(jInternalFrame.getContentPane());
        this.replaceInternalFrame(jInternalFrame);
        this.dockedWindows.remove(jInternalFrame);
        this.undockedWindows.remove(tSEDockableDialog);
    }

    public void replaceInternalFrame(JInternalFrame jInternalFrame) {
        JSplitPane jSplitPane = (JSplitPane)jInternalFrame.getParent();
        if (jSplitPane.getLeftComponent() == jInternalFrame) {
            if (jSplitPane.getParent() instanceof JSplitPane) {
                if (((JSplitPane)jSplitPane.getParent()).getLeftComponent() == jSplitPane) {
                    ((JSplitPane)jSplitPane.getParent()).setLeftComponent(jSplitPane.getRightComponent());
                } else {
                    ((JSplitPane)jSplitPane.getParent()).setRightComponent(jSplitPane.getRightComponent());
                }
            } else {
                jSplitPane.getParent().add(jSplitPane.getRightComponent(), "Center", this.mainDockingIndex);
                jSplitPane.getParent().remove(jSplitPane);
            }
        } else if (jSplitPane.getParent() instanceof JSplitPane) {
            if (((JSplitPane)jSplitPane.getParent()).getLeftComponent() == jSplitPane) {
                ((JSplitPane)jSplitPane.getParent()).setLeftComponent(jSplitPane.getLeftComponent());
            } else {
                ((JSplitPane)jSplitPane.getParent()).setRightComponent(jSplitPane.getLeftComponent());
            }
        } else {
            jSplitPane.getParent().add(jSplitPane.getLeftComponent(), "Center", this.mainDockingIndex);
            jSplitPane.getParent().remove(jSplitPane);
        }
        if (this.mainWindow.getComponent(this.mainDockingIndex) instanceof JSplitPane) {
            this.checkDividerLocation((JSplitPane)this.mainWindow.getComponent(this.mainDockingIndex));
        }
        this.rootPane.paintAll(this.rootPane.getGraphics());
    }

    private void associateWindows(TSEDockableDialog tSEDockableDialog, JInternalFrame jInternalFrame) {
        if (this.dockedWindows == null) {
            this.dockedWindows = new Vector();
        }
        if (this.undockedWindows == null) {
            this.undockedWindows = new Vector();
        }
        if (this.dockedWindows.contains(jInternalFrame)) {
            this.undockedWindows.setElementAt(tSEDockableDialog, this.dockedWindows.indexOf(jInternalFrame));
        } else if (this.undockedWindows.contains(tSEDockableDialog)) {
            this.dockedWindows.setElementAt(jInternalFrame, this.undockedWindows.indexOf(tSEDockableDialog));
        } else {
            this.dockedWindows.addElement(jInternalFrame);
            this.undockedWindows.addElement(tSEDockableDialog);
        }
    }

    public JInternalFrame findInternalFrame(TSEDockableDialog tSEDockableDialog) {
        try {
            return (JInternalFrame)this.dockedWindows.get(this.undockedWindows.indexOf(tSEDockableDialog));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TSEDockableDialog findDockableDialog(JInternalFrame jInternalFrame) {
        try {
            return (TSEDockableDialog)this.undockedWindows.get(this.dockedWindows.indexOf(jInternalFrame));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Component findInsertPlace(TSEDockableDialog tSEDockableDialog, int n, JSplitPane jSplitPane) {
        Component component = null;
        if (jSplitPane.getOrientation() == 0) {
            switch (n) {
                case 1: 
                case 3: {
                    if (tSEDockableDialog.getLocation().y < jSplitPane.getDividerLocation() + this.mainWindow.getLocationOnScreen().y) {
                        component = jSplitPane.getLeftComponent();
                        break;
                    }
                    component = jSplitPane.getRightComponent();
                    break;
                }
                case 2: {
                    component = jSplitPane.getLeftComponent();
                    break;
                }
                case 4: {
                    component = jSplitPane.getRightComponent();
                }
            }
            this.portionOfSide = tSEDockableDialog.getLocation().x < this.mainWindow.getLocationOnScreen().x + this.mainWindow.getComponent((int)this.mainDockingIndex).getSize().width / 2 ? 1 : 2;
        } else {
            switch (n) {
                case 1: {
                    component = jSplitPane.getLeftComponent();
                    break;
                }
                case 3: {
                    component = jSplitPane.getRightComponent();
                    break;
                }
                case 2: 
                case 4: {
                    component = tSEDockableDialog.getLocation().x + 100 < jSplitPane.getDividerLocation() + this.mainWindow.getLocationOnScreen().x ? jSplitPane.getLeftComponent() : jSplitPane.getRightComponent();
                }
            }
            this.portionOfSide = tSEDockableDialog.getLocation().y < this.mainWindow.getLocationOnScreen().y + this.mainWindow.getComponent((int)this.mainDockingIndex).getSize().height / 2 ? 1 : 2;
        }
        if (component instanceof JSplitPane) {
            component = this.findInsertPlace(tSEDockableDialog, n, (JSplitPane)component);
        }
        return component;
    }

    public void insertComponent(TSEDockableDialog tSEDockableDialog, int n) {
        JSplitPane jSplitPane = null;
        Container container = null;
        int n2 = -1;
        for (int i = 0; i < this.mainWindow.getComponents().length; ++i) {
            if (!(this.mainWindow.getComponents()[i] instanceof JTabbedPane) && !(this.mainWindow.getComponents()[i] instanceof JDesktopPane) && !(this.mainWindow.getComponents()[i] instanceof TSEGraphWindow)) continue;
            this.mainDockingIndex = i;
            break;
        }
        Component component = this.mainWindow.getComponent(this.mainDockingIndex);
        JInternalFrame jInternalFrame = new JInternalFrame();
        jInternalFrame.addComponentListener(this);
        jInternalFrame.setVisible(true);
        jInternalFrame.setPreferredSize(tSEDockableDialog.getDockedSize());
        jInternalFrame.setContentPane(tSEDockableDialog.getContentPane());
        JComponent jComponent = ((BasicInternalFrameUI)jInternalFrame.getUI()).getNorthPane();
        if (jComponent != null) {
            jComponent.addMouseListener(this);
        }
        if (this.icon != null && this.icon.getImage() != null) {
            jInternalFrame.setFrameIcon(this.icon);
        }
        try {
            tSEDockableDialog.setDocked(true);
            jInternalFrame.setTitle(tSEDockableDialog.getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (component instanceof JSplitPane) {
            component = this.findInsertPlace(tSEDockableDialog, n, (JSplitPane)component);
        }
        if (component instanceof JInternalFrame) {
            container = component.getParent();
            if (((JSplitPane)container).getLeftComponent() == component) {
                n2 = 0;
            } else if (((JSplitPane)container).getRightComponent() == component) {
                n2 = 1;
            }
            if (((JSplitPane)container).getOrientation() == 1) {
                if ((n == 1 || n == 3) && this.portionOfSide == 1 || n == 2) {
                    jSplitPane = new JSplitPane(0, jInternalFrame, component);
                } else if ((n == 1 || n == 3) && this.portionOfSide == 2 || n == 4) {
                    jSplitPane = new JSplitPane(0, component, jInternalFrame);
                }
                if (n2 == 0 && ((JSplitPane)container).getRightComponent() instanceof JInternalFrame || n2 == 1 && ((JSplitPane)container).getLeftComponent() instanceof JInternalFrame) {
                    jSplitPane.setOrientation(1);
                }
            } else {
                if ((n == 2 || n == 4) && this.portionOfSide == 1 || n == 1) {
                    jSplitPane = new JSplitPane(1, jInternalFrame, component);
                } else if ((n == 2 || n == 4) && this.portionOfSide == 2 || n == 3) {
                    jSplitPane = new JSplitPane(1, component, jInternalFrame);
                }
                if (n2 == 0 && ((JSplitPane)container).getBottomComponent() instanceof JInternalFrame || n2 == 1 && ((JSplitPane)container).getTopComponent() instanceof JInternalFrame) {
                    jSplitPane.setOrientation(0);
                }
            }
            if (n2 == 0) {
                ((JSplitPane)container).setLeftComponent(jSplitPane);
            } else if (n2 == 1) {
                ((JSplitPane)container).setRightComponent(jSplitPane);
            } else {
                TSSystem.tsAssert(false);
            }
        } else {
            container = component.getParent();
            switch (n) {
                case 1: {
                    jSplitPane = new JSplitPane(1, jInternalFrame, component);
                    break;
                }
                case 2: {
                    jSplitPane = new JSplitPane(0, jInternalFrame, component);
                    break;
                }
                case 3: {
                    jSplitPane = new JSplitPane(1, component, jInternalFrame);
                    break;
                }
                case 4: {
                    jSplitPane = new JSplitPane(0, component, jInternalFrame);
                }
            }
            container.remove(component);
            container.add((Component)jSplitPane, this.mainDockingIndex);
        }
        if (this.mainWindow.getComponent(this.mainDockingIndex) instanceof JSplitPane) {
            this.checkDividerLocation((JSplitPane)this.mainWindow.getComponent(this.mainDockingIndex));
        }
        ((Component)tSEDockableDialog).setVisible(false);
        this.rootPane.paintAll(this.rootPane.getGraphics());
        this.oldX = jInternalFrame.getLocation().x;
        this.oldY = jInternalFrame.getLocation().y;
        this.associateWindows(tSEDockableDialog, jInternalFrame);
    }

    public int findPosition(TSEDockableDialog tSEDockableDialog) {
        double d;
        double d2;
        double d3;
        boolean bl = false;
        int n = tSEDockableDialog.getLocation().x;
        int n2 = tSEDockableDialog.getLocation().y;
        Component component = this.mainWindow.getComponent(this.mainDockingIndex);
        try {
            d3 = component.getLocationOnScreen().x;
            d2 = component.getLocationOnScreen().y;
            d = this.mainWindow.getLocationOnScreen().x;
            double d4 = this.mainWindow.getLocationOnScreen().y;
        }
        catch (Exception exception) {
            return 1;
        }
        int n3 = component.getSize().width;
        int n4 = component.getSize().height;
        int n5 = -1;
        if ((double)n > d3 && (double)n < d3 + (double)this.getDockingDistance()) {
            n5 = 1;
        } else if ((double)n2 > d2 && (double)n2 < d2 + (double)this.getDockingDistance() && (double)n > d3 && (double)(n + tSEDockableDialog.getSize().width) < d3 + (double)n3) {
            n5 = 2;
        } else if ((double)(n + tSEDockableDialog.getSize().width) < d3 + (double)n3 && (double)(n + tSEDockableDialog.getSize().width) > d3 + (double)n3 - (double)this.getDockingDistance()) {
            n5 = 3;
        } else if ((double)(n2 + tSEDockableDialog.getSize().height) < d2 + (double)n4 && (double)(n2 + tSEDockableDialog.getSize().height) > d2 + (double)n4 - (double)this.getDockingDistance() && (double)n > d3 && (double)(n + tSEDockableDialog.getSize().width) < d3 + (double)n3) {
            n5 = 4;
        }
        if ((double)(n + tSEDockableDialog.getSize().width) < d + (double)(this.getSnapDistance() / 2) && (double)(n + tSEDockableDialog.getSize().width) > d - (double)this.getSnapDistance()) {
            ((Component)tSEDockableDialog).setLocation((int)d - tSEDockableDialog.getSize().width - 4, n2);
            bl = true;
        } else if ((double)n > d + (double)n3 - (double)(this.getSnapDistance() / 2) && (double)n < d + (double)n3 + (double)this.getSnapDistance()) {
            ((Component)tSEDockableDialog).setLocation((int)d + n3 + 4, n2);
            bl = true;
        }
        tSEDockableDialog.setAttached(bl);
        return n5;
    }

    public int checkDividerLocation(JSplitPane jSplitPane) {
        int n = 0;
        Component component = jSplitPane.getRightComponent();
        Component component2 = jSplitPane.getLeftComponent();
        this.mainWindow.validate();
        int n2 = -1;
        if (component2 instanceof JInternalFrame || component instanceof JTabbedPane || component instanceof JDesktopPane || component instanceof TSEGraphWindow) {
            n2 = jSplitPane.getOrientation() == 1 ? (int)component2.getPreferredSize().getWidth() : (int)component2.getPreferredSize().getHeight();
            n = 1;
        }
        if (component instanceof JInternalFrame || component2 instanceof JTabbedPane || component2 instanceof JDesktopPane || component2 instanceof TSEGraphWindow) {
            if (jSplitPane.getOrientation() == 0) {
                n2 = jSplitPane.getSize().height - 10 - (int)component.getPreferredSize().getHeight();
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                n2 = jSplitPane.getSize().width - 10 - (int)component.getPreferredSize().getWidth();
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            n = 1;
        }
        if (component2 instanceof JInternalFrame && component instanceof JInternalFrame) {
            n2 = jSplitPane.getOrientation() == 0 ? jSplitPane.getSize().height / 2 : jSplitPane.getSize().width / 2;
            n = 0;
        }
        if (n2 > -1) {
            jSplitPane.setDividerLocation(n2);
        }
        if (component2 instanceof JSplitPane) {
            n = this.checkDividerLocation((JSplitPane)component2);
        }
        if (component instanceof JSplitPane) {
            n = this.checkDividerLocation((JSplitPane)component);
        }
        return n;
    }

    public void updateGraphWindow(TSEGraphWindow tSEGraphWindow) {
        if (this.mainWindow.getComponent(0) instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)this.mainWindow.getComponent(0);
            this.updateGraphWindow(jSplitPane, tSEGraphWindow);
            this.checkDividerLocation(jSplitPane);
            jSplitPane.validate();
            tSEGraphWindow.fitInWindow(true);
        }
    }

    private void updateGraphWindow(JSplitPane jSplitPane, TSEGraphWindow tSEGraphWindow) {
        if (jSplitPane.getLeftComponent() instanceof TSEGraphWindow) {
            jSplitPane.setLeftComponent(tSEGraphWindow);
            return;
        }
        if (jSplitPane.getRightComponent() instanceof TSEGraphWindow) {
            jSplitPane.setRightComponent(tSEGraphWindow);
            return;
        }
        if (jSplitPane.getLeftComponent() instanceof JSplitPane) {
            this.updateGraphWindow((JSplitPane)jSplitPane.getLeftComponent(), tSEGraphWindow);
        }
        if (jSplitPane.getRightComponent() instanceof JSplitPane) {
            this.updateGraphWindow((JSplitPane)jSplitPane.getRightComponent(), tSEGraphWindow);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setDockingDistance(int n) {
        this.dockingDistance = n;
    }

    public int getDockingDistance() {
        return this.dockingDistance;
    }

    public void setSnapDistance(int n) {
        this.snapDistance = n;
    }

    public int getSnapDistance() {
        return this.snapDistance;
    }
}

