/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.util.TSSystem;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class TSBaseTransform
implements Cloneable,
Serializable {
    double scaleX;
    double scaleY;
    double offsetX;
    double offsetY;

    public TSBaseTransform() {
        this.setScaleX(1.0);
        this.setScaleY(1.0);
        this.setOffsetX(0.0);
        this.setOffsetY(0.0);
    }

    public int xToDevice(double d) {
        return (int)Math.round(d * this.getScaleX() + this.getOffsetX());
    }

    public int yToDevice(double d) {
        return (int)Math.round(d * this.getScaleY() + this.getOffsetY());
    }

    public Point pointToDevice(TSConstPoint tSConstPoint) {
        return new Point((int)Math.round(tSConstPoint.getX() * this.getScaleX() + this.getOffsetX()), (int)Math.round(tSConstPoint.getY() * this.getScaleY() + this.getOffsetY()));
    }

    public Point pointToDevice(double d, double d2) {
        return new Point((int)Math.round(d * this.getScaleX() + this.getOffsetX()), (int)Math.round(d2 * this.getScaleY() + this.getOffsetY()));
    }

    public int widthToDevice(double d) {
        return (int)Math.round(d * Math.abs(this.getScaleX()));
    }

    public int heightToDevice(double d) {
        return (int)Math.round(d * Math.abs(this.getScaleY()));
    }

    public Dimension sizeToDevice(TSConstSize tSConstSize) {
        return new Dimension((int)Math.round(tSConstSize.getWidth() * Math.abs(this.getScaleX())), (int)Math.round(tSConstSize.getHeight() * Math.abs(this.getScaleY())));
    }

    public Dimension sizeToDevice(double d, double d2) {
        return new Dimension((int)Math.round(d * Math.abs(this.getScaleX())), (int)Math.round(d2 * Math.abs(this.getScaleY())));
    }

    public Rectangle boundsToDevice(TSConstRect tSConstRect) {
        return this.boundsToDevice(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public Rectangle boundsToDevice(double d, double d2, double d3, double d4) {
        int n = (int)Math.round(d * this.scaleX + this.offsetX);
        int n2 = (int)Math.round(d3 * this.scaleX + this.offsetX);
        int n3 = (int)Math.round(d4 * this.scaleY + this.offsetY);
        int n4 = (int)Math.round(d2 * this.scaleY + this.offsetY);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public int distanceToDevice(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        Point point = this.pointToDevice(tSConstPoint);
        Point point2 = this.pointToDevice(tSConstPoint2);
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        return (int)Math.round(Math.sqrt(n * n + n2 * n2));
    }

    public double xToWorld(int n) {
        if (this.getScaleX() == 0.0) {
            return Double.NaN;
        }
        return ((double)n - this.getOffsetX()) / this.getScaleX();
    }

    public double yToWorld(int n) {
        if (this.getScaleY() == 0.0) {
            return Double.NaN;
        }
        return ((double)n - this.getOffsetY()) / this.getScaleY();
    }

    public TSConstPoint pointToWorld(Point point) {
        return new TSConstPoint(this.xToWorld(point.x), this.yToWorld(point.y));
    }

    public TSConstPoint pointToWorld(int n, int n2) {
        return new TSConstPoint(this.xToWorld(n), this.yToWorld(n2));
    }

    public double widthToWorld(int n) {
        if (this.getScaleX() == 0.0) {
            return Double.NaN;
        }
        return (double)n / Math.abs(this.getScaleX());
    }

    public double heightToWorld(int n) {
        if (this.getScaleY() == 0.0) {
            return Double.NaN;
        }
        return (double)n / Math.abs(this.getScaleY());
    }

    public TSConstSize sizeToWorld(Dimension dimension) {
        return new TSConstSize(this.widthToWorld(dimension.width), this.heightToWorld(dimension.height));
    }

    public TSConstSize sizeToWorld(int n, int n2) {
        return new TSConstSize(this.widthToWorld(n), this.heightToWorld(n2));
    }

    public TSConstRect boundsToWorld(Rectangle rectangle) {
        return new TSConstRect(this.xToWorld(rectangle.x), this.yToWorld(rectangle.y + rectangle.height), this.xToWorld(rectangle.x + rectangle.width), this.yToWorld(rectangle.y));
    }

    public TSConstRect boundsToWorld(int n, int n2, int n3, int n4) {
        return new TSConstRect(this.xToWorld(n), this.yToWorld(n2 + n4), this.xToWorld(n + n3), this.yToWorld(n2));
    }

    public double distanceToWorld(Point point, Point point2) {
        TSConstPoint tSConstPoint = this.pointToWorld(point);
        TSConstPoint tSConstPoint2 = this.pointToWorld(point2);
        double d = tSConstPoint2.getX() - tSConstPoint.getX();
        double d2 = tSConstPoint2.getY() - tSConstPoint.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScale(double d) {
        this.setScaleX(d);
        this.setScaleY(d);
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public void magnifyX(double d) {
        this.scaleX *= d;
    }

    public void magnifyY(double d) {
        this.scaleY *= d;
    }

    public void magnify(double d) {
        this.magnifyX(d);
        this.magnifyY(d);
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetX(double d) {
        this.offsetX = d;
    }

    public void setOffsetY(double d) {
        this.offsetY = d;
    }

    public void shiftX(double d) {
        this.offsetX += d;
    }

    public void shiftY(double d) {
        this.offsetY += d;
    }

    public void shift(double d) {
        this.shiftX(d);
        this.shiftY(d);
    }

    public boolean equals(Object object) {
        if (object instanceof TSBaseTransform) {
            TSBaseTransform tSBaseTransform = (TSBaseTransform)object;
            return tSBaseTransform.getScaleX() == this.getScaleX() && tSBaseTransform.getScaleY() == this.getScaleY() && tSBaseTransform.getOffsetX() == this.getOffsetX() && tSBaseTransform.getOffsetY() == this.getOffsetY();
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.scaleX);
        long l2 = Double.doubleToLongBits(this.scaleY);
        long l3 = Double.doubleToLongBits(this.offsetX);
        long l4 = Double.doubleToLongBits(this.offsetY);
        int n = (int)(l ^ l >>> 32);
        int n2 = (int)(l2 ^ l2 >>> 32);
        int n3 = (int)(l3 ^ l3 >>> 32);
        int n4 = (int)(l4 ^ l4 >>> 32);
        return n ^ n2 >>> 8 ^ n3 >>> 16 ^ n4 >>> 24;
    }

    public String toString() {
        return this.getClass().getName() + TSSystem.eol + '{' + TSSystem.eol + "\tscaleX = " + this.getScaleX() + TSSystem.eol + "\tscaleY = " + this.getScaleY() + TSSystem.eol + "\toffsetX = " + this.getOffsetX() + TSSystem.eol + "\toffsetY = " + this.getOffsetY() + TSSystem.eol + '}';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public void copy(Object object) {
        TSBaseTransform tSBaseTransform = (TSBaseTransform)object;
        this.scaleX = tSBaseTransform.scaleX;
        this.scaleY = tSBaseTransform.scaleY;
        this.offsetX = tSBaseTransform.offsetX;
        this.offsetY = tSBaseTransform.offsetY;
    }
}

