/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSInsertEdgeCommand
extends TSCommand {
    TSDGraph graph;
    TSDEdge edge;
    List graphs;
    List margins;

    public TSInsertEdgeCommand(TSDGraph tSDGraph, TSDEdge tSDEdge) {
        this.graph = tSDGraph;
        this.edge = tSDEdge;
    }

    protected void doAction() throws Throwable {
        if (this.graph.fireEvent(new TSGraphChangeEvent(4L, new TSGraphChangeEventData(this.edge, null, this.graph)), true)) {
            this.insertEdge();
        } else {
            this.setAddToUndoStack(false);
        }
    }

    private void insertEdge() {
        this.storeOldMargins();
        if (this.graph.isIntergraph()) {
            this.graph.getOwnerGraphManager().insert(this.edge, this.edge.getSourceNode(), this.edge.getTargetNode());
        } else {
            this.graph.insert(this.edge);
        }
    }

    protected void undoAction() throws Throwable {
        this.graph.remove(this.edge);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.insertEdge();
    }

    public List getAffectedObjects() {
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        if (this.edge != null) {
            vector.add(this.edge);
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.edge.isOwned()) {
            this.edge.dispose();
        }
    }

    public TSDGraph getGraph() {
        return this.graph;
    }

    public TSDEdge getEdge() {
        return this.edge;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

