/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;

public class TSDeleteChildGraphCommand
extends TSCommand {
    TSGraphMember graphMember;
    TSGraph childGraph;
    boolean isExpanded;
    boolean compressMetaEdges;

    public TSDeleteChildGraphCommand(TSGraphMember tSGraphMember) {
        if (tSGraphMember == null || !tSGraphMember.hasChildGraph()) {
            throw new IllegalArgumentException();
        }
        this.graphMember = tSGraphMember;
        this.childGraph = null;
        this.isExpanded = false;
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graphMember.getOwner().getOwner();
        this.compressMetaEdges = tSDGraphManager.getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        long l = this.graphMember instanceof TSNode ? 32768L : 65536L;
        if (this.graphMember.getChildGraph().fireEvent(new TSGraphChangeEvent(l, new TSGraphChangeEventData(this.graphMember, this.graphMember.getChildGraph(), null)), true)) {
            this.deleteChildGraph();
        } else {
            this.setAddToUndoStack(false);
        }
    }

    private void deleteChildGraph() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graphMember.getOwner().getOwner();
        this.childGraph = this.graphMember.getChildGraph();
        this.isExpanded = this.graphMember.isExpanded();
        if (this.isExpanded) {
            this.collapse(tSDGraphManager, this.graphMember);
        }
        this.graphMember.setChildGraph(null);
    }

    protected void collapse(TSDGraphManager tSDGraphManager, TSGraphMember tSGraphMember) {
        TSNestingManager tSNestingManager = TSNestingManager.getManager(tSDGraphManager);
        TSNestingManager.collapse((TSDNode)tSGraphMember);
    }

    protected void undoAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graphMember.getOwner().getOwner();
        this.graphMember.setChildGraph(this.childGraph);
        if (this.isExpanded) {
            this.expand(tSDGraphManager, this.graphMember);
        }
    }

    protected void expand(TSDGraphManager tSDGraphManager, TSGraphMember tSGraphMember) {
        TSNestingManager tSNestingManager = TSNestingManager.getManager(tSDGraphManager);
        TSNestingManager.expand((TSDNode)tSGraphMember);
    }

    protected void redoAction() throws Throwable {
        this.deleteChildGraph();
    }

    protected void doCleanup() {
        if (this.childGraph.getParent() == null) {
            this.childGraph.dispose();
        }
    }

    protected TSGraphMember getGraphMember() {
        return this.graphMember;
    }
}

