/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddNodeCommand
extends TSCommand {
    private boolean typeSpecified;
    int nodeType = -1;
    double x;
    double y;
    TSDGraph graph;
    TSDNode node;
    List graphs;
    List margins;

    public TSAddNodeCommand(TSDGraph tSDGraph, double d, double d2) {
        this.typeSpecified = false;
        this.graph = tSDGraph;
        this.x = d;
        this.y = d2;
    }

    public TSAddNodeCommand(int n, TSDGraph tSDGraph, double d, double d2) {
        this.typeSpecified = true;
        this.nodeType = n;
        this.graph = tSDGraph;
        this.x = d;
        this.y = d2;
    }

    protected void doAction() throws Throwable {
        boolean bl = this.graph.isFiringEvents();
        this.graph.setFireEvents(false);
        this.node = this.typeSpecified ? (TSDNode)this.graph.addNode(this.nodeType) : (TSDNode)this.graph.addNode();
        this.node.setCenter(this.x, this.y);
        this.node.getOwnerGraph().remove(this.node);
        this.graph.setFireEvents(bl);
        TSGraphChangeEvent tSGraphChangeEvent = new TSGraphChangeEvent(2L, new TSGraphChangeEventData(this.node, null, this.graph));
        if (this.graph.fireEvent(tSGraphChangeEvent, true)) {
            this.node.getOwnerGraph().insert(this.node);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.graph.remove(this.node);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.graph.insert(this.node);
    }

    public List getAffectedObjects() {
        Vector<TSDNode> vector = new Vector<TSDNode>();
        if (this.node != null) {
            vector.add(this.node);
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.node.isOwned()) {
            this.node.dispose();
        }
    }

    public int getType() {
        return this.nodeType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public TSDGraph getGraph() {
        return this.graph;
    }

    public TSDNode getNode() {
        return this.node;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    public void setMarginLists(List list, List list2) {
        this.graphs = new Vector(list);
        this.margins = new Vector(list2);
    }
}

