/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSAbstractShape;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstSegment;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.util.TSProperty;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class TSPolygonShape
extends TSAbstractShape {
    public static final String POINTS = "points";
    List points;

    public TSPolygonShape() {
        this.points = new LinkedList();
        this.points.add(new TSConstPoint(0.0, 0.0));
        this.points.add(new TSConstPoint(0.0, 100.0));
        this.points.add(new TSConstPoint(100.0, 100.0));
        this.points.add(new TSConstPoint(100.0, 0.0));
    }

    public TSPolygonShape(List list) {
        if (list == null || list.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.points = new Vector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TSConstPoint)) continue;
            TSConstPoint tSConstPoint = (TSConstPoint)e;
            this.points.add(new TSConstPoint(tSConstPoint.getX(), tSConstPoint.getY()));
        }
        if (this.points.size() < 2) {
            throw new IllegalArgumentException();
        }
    }

    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        if (this.getOwner() == null) {
            d4 = d;
            d3 = d2;
        } else {
            d4 = (d - this.getOwner().getLocalLeft()) * 100.0 / this.getOwner().getLocalWidth();
            d3 = (d2 - this.getOwner().getLocalBottom()) * 100.0 / this.getOwner().getLocalHeight();
        }
        if (d4 >= 0.0 && d3 >= 0.0) {
            if (d4 <= 100.0) {
                if (d3 <= 100.0) {
                    int n = 0;
                    double d5 = 0.0;
                    Iterator iterator = this.points.iterator();
                    TSConstPoint tSConstPoint = null;
                    TSConstPoint tSConstPoint2 = null;
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        tSConstPoint = (TSConstPoint)iterator.next();
                        if (tSConstPoint.getY() == d3) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        iterator = this.points.iterator();
                        tSConstPoint = (TSConstPoint)iterator.next();
                    }
                    Iterator iterator2 = this.points.iterator();
                    while (iterator2.hasNext()) {
                        iterator2.next();
                        if (iterator.hasNext()) {
                            tSConstPoint2 = (TSConstPoint)iterator.next();
                        } else {
                            iterator = this.points.iterator();
                            tSConstPoint2 = (TSConstPoint)iterator.next();
                        }
                        double d6 = tSConstPoint2.getX() - tSConstPoint.getX();
                        double d7 = tSConstPoint2.getY() - tSConstPoint.getY();
                        if (d7 != 0.0) {
                            double d8;
                            double d9 = d4 - tSConstPoint.getX();
                            double d10 = d3 - tSConstPoint.getY();
                            if (tSConstPoint2.getY() == d3 && tSConstPoint2.getX() >= d4) {
                                d5 = tSConstPoint.getY();
                            }
                            if (tSConstPoint.getY() == d3 && tSConstPoint.getX() >= d4 && d5 > d3 != tSConstPoint2.getY() > d3) {
                                --n;
                            }
                            if ((d8 = d10 / d7) >= 0.0 && d8 <= 1.0 && d8 * d6 >= d9) {
                                ++n;
                            }
                        }
                        tSConstPoint = tSConstPoint2;
                    }
                    return n & true;
                }
            }
        }
        return false;
    }

    public TSConstPoint intersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.points.size() < 2) {
            throw new IllegalStateException(Integer.toString(this.points.size()));
        }
        TSPoint tSPoint = null;
        if (this.getOwner() == null) {
            d8 = 1.0;
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        } else {
            d7 = this.getOwner().getLocalWidth() / 100.0;
            d8 = this.getOwner().getLocalHeight() / 100.0;
            d5 = this.getOwner().getLocalLeft();
            d6 = this.getOwner().getLocalBottom();
        }
        TSConstPoint tSConstPoint = (TSConstPoint)this.points.get(this.points.size() - 1);
        double d9 = d5 + tSConstPoint.getX() * d7;
        double d10 = d6 + tSConstPoint.getY() * d8;
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            double d11;
            tSConstPoint = (TSConstPoint)iterator.next();
            double d12 = d5 + tSConstPoint.getX() * d7;
            TSConstPoint tSConstPoint2 = TSConstSegment.intersection(d9, d10, d12, d11 = d6 + tSConstPoint.getY() * d8, d, d2, d3, d4);
            if (tSConstPoint2 != null) {
                if (tSPoint == null) {
                    tSPoint = new TSPoint(tSConstPoint2);
                } else if (tSConstPoint2.distanceSquared(d3, d4) < tSPoint.distanceSquared(d3, d4)) {
                    tSPoint.setLocation(tSConstPoint2);
                }
            }
            d9 = d12;
            d10 = d11;
        }
        return tSPoint;
    }

    public double xIntersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.points.size() < 2) {
            throw new IllegalStateException(Integer.toString(this.points.size()));
        }
        double d9 = Double.NaN;
        if (this.getOwner() == null) {
            d8 = 1.0;
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        } else {
            d7 = this.getOwner().getLocalWidth() / 100.0;
            d8 = this.getOwner().getLocalHeight() / 100.0;
            d5 = this.getOwner().getLocalLeft();
            d6 = this.getOwner().getLocalBottom();
        }
        TSConstPoint tSConstPoint = (TSConstPoint)this.points.get(this.points.size() - 1);
        double d10 = d5 + tSConstPoint.getX() * d7;
        double d11 = d6 + tSConstPoint.getY() * d8;
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            double d12;
            tSConstPoint = (TSConstPoint)iterator.next();
            double d13 = d5 + tSConstPoint.getX() * d7;
            double d14 = TSConstSegment.xIntersection(d10, d11, d13, d12 = d6 + tSConstPoint.getY() * d8, d, d2, d3, d4);
            if (!Double.isNaN(d14)) {
                if (Double.isNaN(d9)) {
                    d9 = d14;
                } else if (Math.abs(d3 - d14) < Math.abs(d3 - d9)) {
                    d9 = d14;
                }
            }
            d10 = d13;
            d11 = d12;
        }
        return d9;
    }

    public double yIntersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (this.points.size() < 2) {
            throw new IllegalStateException(Integer.toString(this.points.size()));
        }
        double d9 = Double.NaN;
        if (this.getOwner() == null) {
            d8 = 1.0;
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        } else {
            d7 = this.getOwner().getLocalWidth() / 100.0;
            d8 = this.getOwner().getLocalHeight() / 100.0;
            d5 = this.getOwner().getLocalLeft();
            d6 = this.getOwner().getLocalBottom();
        }
        TSConstPoint tSConstPoint = (TSConstPoint)this.points.get(this.points.size() - 1);
        double d10 = d5 + tSConstPoint.getX() * d7;
        double d11 = d6 + tSConstPoint.getY() * d8;
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            double d12;
            tSConstPoint = (TSConstPoint)iterator.next();
            double d13 = d5 + tSConstPoint.getX() * d7;
            double d14 = TSConstSegment.yIntersection(d10, d11, d13, d12 = d6 + tSConstPoint.getY() * d8, d, d2, d3, d4);
            if (!Double.isNaN(d14)) {
                if (Double.isNaN(d9)) {
                    d9 = d14;
                } else if (Math.abs(d4 - d14) < Math.abs(d4 - d9)) {
                    d9 = d14;
                }
            }
            d10 = d13;
            d11 = d12;
        }
        return d9;
    }

    protected void copy(TSAbstractShape tSAbstractShape) {
        super.copy(tSAbstractShape);
        TSPolygonShape tSPolygonShape = (TSPolygonShape)tSAbstractShape;
        this.points = new Vector();
        Iterator iterator = tSPolygonShape.points().iterator();
        while (iterator.hasNext()) {
            TSConstPoint tSConstPoint = (TSConstPoint)iterator.next();
            this.points.add(new TSConstPoint(tSConstPoint));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.points.size());
        stringBuffer.append("[ ");
        stringBuffer.append(this.points.size());
        stringBuffer.append(' ');
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            TSConstPoint tSConstPoint = (TSConstPoint)iterator.next();
            stringBuffer.append(" (");
            stringBuffer.append(tSConstPoint.getX());
            stringBuffer.append(", ");
            stringBuffer.append(tSConstPoint.getY());
            stringBuffer.append(')');
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public static TSPolygonShape fromString(String string) {
        List list = TSPolygonShape.buildPointList(string);
        TSPolygonShape tSPolygonShape = new TSPolygonShape(list);
        return tSPolygonShape;
    }

    public static List buildPointList(String string) {
        try {
            Vector<TSConstPoint> vector = new Vector<TSConstPoint>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[()], ");
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                double d = Double.valueOf(string2);
                string2 = stringTokenizer.nextToken();
                double d2 = Double.valueOf(string2);
                vector.add(new TSConstPoint(d, d2));
                --n;
            }
            if (n != 0) {
                throw new Exception(Integer.toString(n));
            }
            return vector;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public int hashCode() {
        double d = 0.0;
        Iterator iterator = this.points().iterator();
        while (iterator.hasNext()) {
            TSConstPoint tSConstPoint = (TSConstPoint)iterator.next();
            d += tSConstPoint.getX() + tSConstPoint.getY();
        }
        return (int)(d * (double)this.points().size());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TSPolygonShape)) {
            return false;
        }
        TSPolygonShape tSPolygonShape = (TSPolygonShape)object;
        if (tSPolygonShape.points().size() != this.points().size()) {
            return false;
        }
        int n = tSPolygonShape.points().size();
        int n2 = tSPolygonShape.points().indexOf(this.points().get(0));
        if (n2 == -1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.points().get(i).equals(tSPolygonShape.points().get(n2))) {
                return false;
            }
            ++n2;
            n2 %= n;
        }
        return true;
    }

    public List points() {
        return this.points;
    }

    public void setProperty(TSProperty tSProperty) {
        String string = tSProperty.getValue().toString();
        if (POINTS.equals(tSProperty.getName())) {
            List list;
            this.points = list = TSPolygonShape.buildPointList(string);
        } else {
            super.setProperty(tSProperty);
        }
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.points().isEmpty()) {
            list.add(new TSProperty(POINTS, this.toString()));
        }
        return list;
    }
}

