/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSRectangularObjectLabel;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;

public class TSNodeLabel
extends TSRectangularObjectLabel {
    protected TSNodeLabel() {
    }

    protected TSNodeLabel(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    public void setLocalOffset(String string, double d) {
        TSDNode tSDNode = (TSDNode)this.getOwner();
        String string2 = string.toLowerCase();
        if (string2.equals(TSDNode.NODE_BOTTOM)) {
            this.setLocalOffset(0.0, -1.0, 0.0, -d);
        } else if (string2.equals(TSDNode.NODE_LEFT)) {
            this.setLocalOffset(-1.0, 0.0, -d, 0.0);
        } else if (string2.equals(TSDNode.NODE_RIGHT)) {
            this.setLocalOffset(1.0, 0.0, d, 0.0);
        } else if (string2.equals(TSDNode.NODE_TOP)) {
            this.setLocalOffset(0.0, 1.0, 0.0, d);
        } else {
            this.setDefaultOffset();
        }
    }

    public void setDefaultOffset() {
        this.setLocalOffset(((TSDNode)this.getOwner()).getDefaultLabelDirection(), ((TSDNode)this.getOwner()).getDefaultLabelDistance());
    }

    public TSConstPoint getLocalAttachmentPoint() {
        TSSystem.tsAssert(this.getOwner() != null);
        TSConstPoint tSConstPoint = null;
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (tSDNode.getShape().contains(this.getLocalCenter())) {
            tSConstPoint = tSDNode.getLocalBounds().getCenter();
        } else if (tSDNode.getLocalWidth() == 0.0 || tSDNode.getLocalHeight() == 0.0) {
            double d = tSDNode.getLocalWidth() == 0.0 ? tSDNode.getLocalCenterX() : (this.getLocalCenterX() - tSDNode.getLocalLeft() <= 0.0 ? tSDNode.getLocalLeft() : (this.getLocalCenterX() - tSDNode.getLocalRight() >= 0.0 ? tSDNode.getLocalRight() : this.getLocalCenterX()));
            double d2 = tSDNode.getLocalHeight() == 0.0 ? tSDNode.getLocalCenterY() : (this.getLocalCenterY() - tSDNode.getLocalBottom() <= 0.0 ? tSDNode.getLocalBottom() : (this.getLocalCenterY() - tSDNode.getLocalTop() >= 0.0 ? tSDNode.getLocalTop() : this.getLocalCenterY()));
            tSConstPoint = new TSConstPoint(d, d2);
        } else {
            tSConstPoint = tSDNode.getShape().intersection(tSDNode.getLocalBounds().getCenterX(), tSDNode.getLocalBounds().getCenterY(), this.getLocalCenterX(), this.getLocalCenterY());
        }
        return tSConstPoint;
    }

    void notifyOwnerOnMove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDNode tSDNode = (TSDNode)this.getOwner();
            tSDNode.updateNodeBoundsOnLabelMove(tSConstRect, this.getLocalBounds());
        }
    }

    void notifyOwnerOnResize(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDNode tSDNode = (TSDNode)this.getOwner();
            tSDNode.updateNodeBoundsOnLabelResize(tSConstRect, this.getLocalBounds());
        }
    }
}

