/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSSystem;
import java.util.Iterator;

public abstract class TSGNode
extends TSNode
implements TSSolidGeometricObject {
    public boolean contains(TSConstPoint tSConstPoint) {
        return this.contains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean locallyContains(TSConstPoint tSConstPoint) {
        return this.locallyContains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean contains(TSConstRect tSConstRect) {
        return this.contains(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean locallyContains(TSConstRect tSConstRect) {
        return this.locallyContains(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return this.intersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.locallyIntersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.getLocalCenterY() - this.getLocalHeight() / 2.0;
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.getLocalCenterX() - this.getLocalWidth() / 2.0;
    }

    public double getRight() {
        double d = this.getLocalRight();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.getLocalCenterX() + this.getLocalWidth() / 2.0;
    }

    public double getTop() {
        double d = this.getLocalTop();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.getLocalCenterY() + this.getLocalHeight() / 2.0;
    }

    public TSConstPoint getCenter() {
        TSPoint tSPoint = new TSPoint(this.getLocalCenter());
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalCenter() {
        return new TSConstPoint(this.getLocalCenterX(), this.getLocalCenterY());
    }

    public void getLocalCenter(TSPoint tSPoint) {
        tSPoint.setLocation(this.getLocalCenterX(), this.getLocalCenterY());
    }

    public TSConstSize getSize() {
        return this.getLocalSize();
    }

    public TSConstSize getLocalSize() {
        return new TSConstSize(this.getLocalWidth(), this.getLocalHeight());
    }

    public void setBounds(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect);
    }

    public void setLocalBounds(TSConstRect tSConstRect) {
        this.setLocalBounds(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public void setCenter(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint);
    }

    public void setLocalCenter(TSConstPoint tSConstPoint) {
        this.setLocalCenter(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public void setCenterX(double d) {
        TSPoint tSPoint = new TSPoint(d, d);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenterX(tSPoint.getX());
    }

    public void setLocalCenterX(double d) {
        this.setLocalCenter(d, this.getLocalCenterY());
    }

    public void setCenterY(double d) {
        TSPoint tSPoint = new TSPoint(d, d);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenterY(tSPoint.getY());
    }

    public void setLocalCenterY(double d) {
        this.setLocalCenter(this.getLocalCenterX(), d);
    }

    public void setSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize);
    }

    public void setLocalSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveBy(TSConstSize tSConstSize) {
        this.moveBy(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveByLocal(TSConstSize tSConstSize) {
        this.setLocalCenter(this.getLocalCenterX() + tSConstSize.getWidth(), this.getLocalCenterY() + tSConstSize.getHeight());
    }

    public void moveBy(double d, double d2) {
        this.moveByLocal(d, d2);
    }

    public void moveByLocal(double d, double d2) {
        this.setLocalCenter(this.getLocalCenterX() + d, this.getLocalCenterY() + d2);
    }

    public void recomputeIncidentClippingPoints() {
        TSDEdge tSDEdge;
        TSPEdge tSPEdge;
        TSEdge tSEdge;
        Iterator iterator = this.inEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (tSEdge instanceof TSPEdge) {
                tSPEdge = (TSPEdge)tSEdge;
                tSDEdge = (TSDEdge)tSPEdge.getOwner();
                if (tSPEdge == tSDEdge.getSourceEdge()) {
                    tSDEdge.recomputeClippingPoints();
                    continue;
                }
                if (tSPEdge != tSDEdge.getTargetEdge()) continue;
                tSDEdge.recomputeClippingPoints();
                continue;
            }
            if (!(tSEdge instanceof TSDEdge)) continue;
            ((TSDEdge)tSEdge).recomputeClippingPoints();
        }
        iterator = this.outEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (tSEdge instanceof TSPEdge) {
                tSPEdge = (TSPEdge)tSEdge;
                tSDEdge = (TSDEdge)tSPEdge.getOwner();
                if (tSPEdge == tSDEdge.getSourceEdge()) {
                    tSDEdge.recomputeClippingPoints();
                    continue;
                }
                if (tSPEdge != tSDEdge.getTargetEdge()) continue;
                tSDEdge.recomputeClippingPoints();
                continue;
            }
            if (!(tSEdge instanceof TSDEdge)) continue;
            ((TSDEdge)tSEdge).recomputeClippingPoints();
        }
    }

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tisPathNode = " + this.isPathNode() + TSSystem.eol + "\tbounds = " + this.getLocalBounds();
    }

    public int levelNumber() {
        return 1;
    }

    public TSGraph getTransformGraph() {
        TSGraph tSGraph = this.getOwnerGraph();
        TSDEdge tSDEdge = null;
        if (this.isPathNode()) {
            tSDEdge = (TSDEdge)this.getOwner();
        }
        if (tSDEdge != null && tSDEdge.isIntergraphEdge()) {
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraph().getOwnerGraphManager();
            tSGraph = (TSDGraph)tSDGraphManager.getCommonOwnerGraph(tSDEdge);
        }
        return tSGraph;
    }

    public abstract double getLocalWidth();

    public abstract double getLocalHeight();

    public abstract double getLocalCenterX();

    public abstract double getLocalCenterY();

    public abstract void setLocalBounds(double var1, double var3, double var5, double var7);

    public abstract void setLocalCenter(double var1, double var3);

    public abstract TSConstRect getLocalBounds();

    public abstract boolean locallyIntersects(double var1, double var3, double var5, double var7);

    public abstract boolean locallyContains(double var1, double var3);

    public abstract void setLocalSize(double var1, double var3);

    public abstract boolean contains(double var1, double var3);

    public abstract boolean contains(double var1, double var3, double var5, double var7);

    public abstract boolean locallyContains(double var1, double var3, double var5, double var7);

    public abstract boolean intersects(double var1, double var3, double var5, double var7);

    public abstract void setCenter(double var1, double var3);

    public abstract double getCenterY();

    public abstract double getCenterX();
}

