/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.cy;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;

public class TSEdgeLabel
extends TSLabel {
    double dx;
    double dy;
    double lengthProportion;

    protected TSEdgeLabel() {
    }

    protected TSEdgeLabel(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.lengthProportion = 0.0;
        this.dx = 0.0;
        this.dy = 0.0;
        double d = this.getLocalDefaultWidth() / 2.0;
        double d2 = this.getLocalDefaultHeight() / 2.0;
        this.assignBounds(-d, -d2, d, d2);
    }

    public void setLocalSize(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignSize(d, d2);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && tSGraphObject.isOwned() && ((TSDGraph)tSGraphObject.getOwner()).isGeometryChangeNotified()) {
            this.notifyEdgeOnResize(tSConstRect);
        }
        this.fireLabelResizedEvent(tSConstRect);
    }

    public void setLocalCenter(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignCenter(d, d2);
        if (this.isOwned() && this.getOwner().isOwned() && ((TSDGraph)this.getOwner().getOwner()).isGeometryChangeNotified()) {
            this.notifyEdgeOnMove(tSConstRect);
        }
        this.fireLabelMovedEvent(tSConstRect);
    }

    public void setOffset(TSConstSize tSConstSize) {
        this.setLocalOffset(tSConstSize);
    }

    public void setLocalOffset(TSConstSize tSConstSize) {
        this.setLocalOffset(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void setOffset(double d, double d2) {
        this.setLocalOffset(d, d2);
    }

    public void setLocalOffset(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignOffset(d, d2);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && tSGraphObject.isOwned() && ((TSDGraph)tSGraphObject.getOwner()).isGeometryChangeNotified()) {
            this.notifyEdgeOnMove(tSConstRect);
        }
        this.fireLabelMovedEvent(tSConstRect);
    }

    public void setOffsetX(double d) {
        this.setLocalOffsetX(d);
    }

    public void setLocalOffsetX(double d) {
        this.setLocalOffset(d, this.getLocalOffsetY());
    }

    public void setOffsetY(double d) {
        this.setLocalOffsetY(d);
    }

    public void setLocalOffsetY(double d) {
        this.setLocalOffset(this.getLocalOffsetX(), d);
    }

    public void setDistanceFromSource(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Double.toString(d));
        }
        if (d != this.lengthProportion) {
            TSConstRect tSConstRect = this.getLocalBounds();
            this.assignDistanceFromSource(d);
            TSGraphObject tSGraphObject = this.getOwner();
            if (this.isOwned() && tSGraphObject.isOwned() && ((TSDGraph)tSGraphObject.getOwner()).isGeometryChangeNotified()) {
                this.notifyEdgeOnMove(tSConstRect);
            }
            this.fireLabelMovedEvent(tSConstRect);
        }
    }

    public TSConstPoint getAttachmentPoint() {
        TSPoint tSPoint = new TSPoint(this.getLocalAttachmentPoint());
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph((TSDGraph)this.getOwner().getOwner()).expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalAttachmentPoint() {
        TSConstPoint tSConstPoint;
        TSSystem.tsAssert(this.isOwned());
        TSSystem.tsAssert(this.getOwner() != null);
        TSSystem.tsAssert(0.0 <= this.getDistanceFromSource());
        TSSystem.tsAssert(this.getDistanceFromSource() <= 1.0);
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        if (this.getDistanceFromSource() == 0.0) {
            tSConstPoint = tSDEdge.getLocalSourcePoint();
        } else if (this.getDistanceFromSource() == 1.0) {
            tSConstPoint = tSDEdge.getLocalTargetPoint();
        } else {
            double d;
            TSPEdge tSPEdge = tSDEdge.getSourceEdge();
            double d2 = tSPEdge.length();
            for (d = tSDEdge.length() * this.getDistanceFromSource(); tSPEdge != tSDEdge.getTargetEdge() && !(d2 >= d); d -= d2) {
                tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
                d2 = tSPEdge.length();
            }
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = d / d2;
            }
            tSConstPoint = tSPEdge.getLocalPointOnEdge(d3);
        }
        return tSConstPoint;
    }

    public double getAttachmentX() {
        return this.getAttachmentPoint().getX();
    }

    public double getLocalAttachmentX() {
        return this.getLocalAttachmentPoint().getX();
    }

    public double getAttachmentY() {
        return this.getAttachmentPoint().getY();
    }

    public double getLocalAttachmentY() {
        return this.getLocalAttachmentPoint().getY();
    }

    public TSConstPoint getDrawableAttachmentPoint() {
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
        TSConstPoint tSConstPoint = this.getLocalAttachmentPoint();
        if (tSDNode.contains(tSConstPoint)) {
            tSConstPoint = tSDEdge.getSourceClippingPoint();
        } else if (tSDNode2.contains(tSConstPoint)) {
            tSConstPoint = tSDEdge.getTargetClippingPoint();
        }
        return new TSConstPoint(tSConstPoint);
    }

    public double getDistanceFromSource() {
        return this.lengthProportion;
    }

    public TSConstSize getOffset() {
        return this.getLocalOffset();
    }

    public TSConstSize getLocalOffset() {
        return new TSConstSize(this.dx, this.dy);
    }

    public double getOffsetX() {
        return this.getLocalOffsetX();
    }

    public double getLocalOffsetX() {
        return this.dx;
    }

    public double getOffsetY() {
        return this.getLocalOffsetY();
    }

    public double getLocalOffsetY() {
        return this.dy;
    }

    public TSDGraph getTransformGraph() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        return this.getTransformGraph(tSDGraph);
    }

    protected TSDGraph getTransformGraph(TSDGraph tSDGraph) {
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        if (tSDEdge.isIntergraphEdge()) {
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraph().getOwnerGraphManager();
            tSDGraph = (TSDGraph)tSDGraphManager.getCommonOwnerGraph(tSDEdge);
        }
        return tSDGraph;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)object;
        this.dx = tSEdgeLabel.dx;
        this.dy = tSEdgeLabel.dy;
        this.lengthProportion = tSEdgeLabel.lengthProportion;
    }

    void notifyEdgeOnMove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDEdge tSDEdge = (TSDEdge)this.getOwner();
            tSDEdge.updateEdgeBoundsOnLabelMove(tSConstRect, this.getLocalBounds());
        }
    }

    void notifyEdgeOnResize(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDEdge tSDEdge = (TSDEdge)this.getOwner();
            tSDEdge.updateEdgeBoundsOnLabelResize(tSConstRect, this.getLocalBounds());
        }
    }

    boolean updateBounds() {
        TSConstPoint tSConstPoint = this.getLocalAttachmentPoint();
        double d = tSConstPoint.getX();
        double d2 = tSConstPoint.getY();
        if (this.getLocalCenterX() == (d += this.getLocalOffsetX()) && this.getLocalCenterY() == (d2 += this.getLocalOffsetY())) {
            return false;
        }
        TSConstRect tSConstRect = this.getLocalBounds();
        super.assignCenter(d, d2);
        this.notifyEdgeOnMove(tSConstRect);
        this.fireLabelMovedEvent(tSConstRect);
        return true;
    }

    public void assignCenter(double d, double d2) {
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        if (tSDEdge != null) {
            Cloneable cloneable;
            TSConstPoint tSConstPoint = new TSConstPoint(d, d2);
            double d3 = 0.0;
            double d4 = Double.POSITIVE_INFINITY;
            TSPoint tSPoint = new TSPoint();
            double d5 = 0.0;
            cy cy2 = new cy(tSDEdge);
            while (cy2.hasNext()) {
                double d6;
                cloneable = (TSPEdge)cy2.next();
                double d7 = ((TSGEdge)cloneable).getLocalProjectionPoint(tSConstPoint, tSPoint);
                double d8 = tSConstPoint.getX() - tSPoint.getX();
                double d9 = d8 * d8 + (d6 = tSConstPoint.getY() - tSPoint.getY()) * d6;
                if (d9 < d4) {
                    d5 = d3 + d7;
                    d4 = d9;
                }
                d3 += ((TSPEdge)cloneable).length();
            }
            this.lengthProportion = d3 == 0.0 ? 0.0 : Math.min(1.0, d5 / d3);
            cloneable = this.getLocalAttachmentPoint();
            this.assignOffset(d - ((TSConstPoint)cloneable).getX(), d2 - ((TSConstPoint)cloneable).getY());
        }
        super.assignCenter(d, d2);
    }

    void assignOffset(double d, double d2) {
        this.labelBounds.moveBy(d - this.getLocalOffsetX(), d2 - this.getLocalOffsetY());
        this.dx = d;
        this.dy = d2;
        this.ltShiftBounds();
    }

    void assignDistanceFromSource(double d) {
        this.lengthProportion = d;
        this.ltShiftBounds();
    }

    public void ltShiftBounds() {
        TSConstPoint tSConstPoint = this.getLocalAttachmentPoint();
        this.labelBounds.setCenter(tSConstPoint.getX() + this.getLocalOffsetX(), tSConstPoint.getY() + this.getLocalOffsetY());
    }

    protected void fireLabelMovedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !this.getLocalCenter().equals(tSConstRect.getCenter())) {
            this.getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }

    protected void fireLabelResizedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !this.getLocalSize().equals(tSConstRect.getSize())) {
            this.getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(131072L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }
}

