/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGeometricObject;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.cv;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.cw;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f0;
import com.tomsawyer.util.f2;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSDGraph
extends TSGraph
implements TSGeometricObject {
    static final int TOP_SIDE = 16;
    static final int RIGHT_SIDE = 32;
    static final int BOTTOM_SIDE = 64;
    static final int LEFT_SIDE = 128;
    public static final int WITH_BENDS = 1;
    public static final int WITH_LABELS = 2;
    public static final int WITH_CONNECTORS = 4;
    public static final int WITH_EVERYTHING = 7;
    TSGraphTailor tailor;
    TSRect graphBounds;
    boolean staleBounds;
    boolean recomputeBounds;
    int edgeLabelCount;
    int nodeLabelCount;
    int connectorLabelCount;
    boolean graphChangeNotified;
    static final int HIDEGRAPH = 1;
    static final int VIEWABLE = 2;
    int flags2;
    TSExpTransform transform;
    public TSDGraph hideOrHideFromGraph;

    protected TSDGraph() {
    }

    protected void initGraphObject() {
        this.initGraphObject(false);
    }

    private void initGraphObject(boolean bl) {
        if (!bl) {
            super.initGraphObject();
        }
        f2.f(f2.aw);
        this.tailor = new TSGraphTailor(this);
        this.graphBounds = new TSRect();
        this.setBoundsStale(true);
        this.setBoundsUpdatingEnabled(true);
        this.setGeometryChangeNotified(this.isGeometryChangeNotifiedByDefault());
        this.transform = new TSExpTransform();
        this.hideOrHideFromGraph = null;
    }

    public void insert(TSEdge tSEdge) {
        ((TSDEdge)tSEdge).recomputeClippingPoints();
        super.insert(tSEdge);
    }

    public TSGraphMember getParent() {
        TSGraphMember tSGraphMember = this.isHideGraph() ? this.hideFromGraph().getParent() : super.getParent();
        return tSGraphMember;
    }

    public void setViewability(boolean bl) {
        this.flags2 = bl ? (this.flags2 |= 2) : (this.flags2 &= 0xFFFFFFFD);
    }

    public TSDEdge getMetaEdge(TSDNode tSDNode, TSDNode tSDNode2) {
        if (tSDNode != null && tSDNode2 != null) {
            Cloneable cloneable;
            Iterator iterator;
            if (this.isIntergraph()) {
                iterator = this.disconnectedEdges().iterator();
            } else {
                cloneable = new Vector();
                cloneable.addAll(this.edges());
                cloneable.addAll(this.disconnectedEdges());
                iterator = cloneable.iterator();
            }
            while (iterator.hasNext()) {
                cloneable = (TSDEdge)iterator.next();
                if (!((TSDEdge)cloneable).isMetaEdge() || ((TSEdge)cloneable).getSourceNode() != tSDNode || ((TSEdge)cloneable).getTargetNode() != tSDNode2) continue;
                return cloneable;
            }
        }
        return null;
    }

    public TSDEdge getMetaEdge(TSDEdge tSDEdge, TSDNode tSDNode, TSDNode tSDNode2) {
        if (tSDNode != null && tSDNode2 != null) {
            Cloneable cloneable;
            Iterator iterator;
            if (this.isIntergraph()) {
                iterator = this.disconnectedEdges().iterator();
            } else {
                cloneable = new Vector();
                cloneable.addAll(this.edges());
                cloneable.addAll(this.disconnectedEdges());
                iterator = cloneable.iterator();
            }
            while (iterator.hasNext()) {
                cloneable = (TSDEdge)iterator.next();
                if (!((TSDEdge)cloneable).isMetaEdge() || ((TSEdge)cloneable).getSourceNode() != tSDNode || ((TSEdge)cloneable).getTargetNode() != tSDNode2) continue;
                return cloneable;
            }
        }
        return null;
    }

    public void buildMetaEdges(List list, boolean bl, boolean bl2) {
        if (list != null) {
            TSDEdge tSDEdge;
            Iterator iterator = this.edges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (!tSDEdge.isMetaEdge()) continue;
                list.add(tSDEdge);
            }
            if (bl) {
                iterator = this.disconnectedEdges().iterator();
                while (iterator.hasNext()) {
                    tSDEdge = (TSDEdge)iterator.next();
                    if (!tSDEdge.isMetaEdge()) continue;
                    list.add(tSDEdge);
                }
            }
            if (bl2 && this.hideGraph() != null && (this.hideGraph().numberOfEdges() != 0 || this.hideGraph().numberOfDisconnectedEdges() != 0)) {
                iterator = this.hideGraph().edges().iterator();
                while (iterator.hasNext()) {
                    tSDEdge = (TSDEdge)iterator.next();
                    if (!tSDEdge.isMetaEdge()) continue;
                    list.add(tSDEdge);
                }
                iterator = this.hideGraph().disconnectedEdges().iterator();
                while (iterator.hasNext()) {
                    tSDEdge = (TSDEdge)iterator.next();
                    if (!tSDEdge.isMetaEdge()) continue;
                    list.add(tSDEdge);
                }
            }
        }
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        this.expandedTransformRect(tSRect);
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        if (this.areBoundsStale()) {
            this.updateBounds();
        }
        return new TSConstRect(this.graphBounds);
    }

    public TSConstPoint getCenter() {
        TSPoint tSPoint = new TSPoint(this.getLocalCenter());
        this.expandedTransformPoint(tSPoint);
        return tSPoint;
    }

    public TSConstPoint getLocalCenter() {
        return this.graphBounds.getCenter();
    }

    public TSConstSize getSize() {
        return this.getLocalSize();
    }

    public TSConstSize getLocalSize() {
        return this.graphBounds.getSize();
    }

    public double getCenterX() {
        double d = this.getLocalCenterX();
        d = this.expandedTransformX(d);
        return d;
    }

    public double getLocalCenterX() {
        return this.graphBounds.getCenterX();
    }

    public double getCenterY() {
        double d = this.getLocalCenterY();
        d = this.expandedTransformY(d);
        return d;
    }

    public double getLocalCenterY() {
        return this.graphBounds.getCenterY();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return this.graphBounds.getHeight();
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return this.graphBounds.getWidth();
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        d = this.expandedTransformX(d);
        return d;
    }

    public double getLocalLeft() {
        return this.graphBounds.getLeft();
    }

    public double getRight() {
        double d = this.getLocalRight();
        d = this.expandedTransformX(d);
        return d;
    }

    public double getLocalRight() {
        return this.graphBounds.getRight();
    }

    public double getTop() {
        double d = this.getLocalTop();
        d = this.expandedTransformY(d);
        return d;
    }

    public double getLocalTop() {
        return this.graphBounds.getTop();
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        d = this.expandedTransformY(d);
        return d;
    }

    public double getLocalBottom() {
        return this.graphBounds.getBottom();
    }

    public void restoreOriginalNodeSizes() {
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            tSDNode.assignSize(tSDNode.getOriginalWidth(), tSDNode.getOriginalHeight());
        }
        this.updateBounds();
    }

    public void setCenter(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        this.setLocalCenter(tSPoint);
    }

    public void setLocalCenter(TSConstPoint tSConstPoint) {
        this.setLocalCenter(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public void setCenter(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        this.inverseExpandedTransformPoint(tSPoint);
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setLocalCenter(double d, double d2) {
        Object object;
        Object object2;
        Object object3;
        TSGraphObject tSGraphObject;
        Object object4;
        TSGraphObject tSGraphObject2;
        double d3 = d - this.getLocalCenterX();
        double d4 = d2 - this.getLocalCenterY();
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSDNode)iterator.next();
            ((TSDNode)tSGraphObject2).setLocalCenter(((TSDNode)tSGraphObject2).getLocalCenterX() + d3, ((TSDNode)tSGraphObject2).getLocalCenterY() + d4);
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSDEdge)iterator.next();
            object4 = ((TSDEdge)tSGraphObject2).bendIterator();
            while (object4.hasNext()) {
                tSGraphObject = (TSPNode)object4.next();
                tSGraphObject.assignCenter(tSGraphObject.getLocalCenterX() + d3, tSGraphObject.getLocalCenterY() + d4);
            }
        }
        tSGraphObject2 = this.getOwnerGraphManager();
        object4 = ((TSGraphManager)tSGraphObject2).intergraphEdges();
        tSGraphObject = null;
        if (object4.size() > 0) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (TSDEdge)object3.next();
                if (!((TSDEdge)object2).isReachable() || (tSGraphObject = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner((TSDEdge)object2)) != this) continue;
                object = ((TSDEdge)object2).bendIterator();
                while (object.hasNext()) {
                    TSPNode tSPNode = (TSPNode)object.next();
                    tSPNode.assignCenter(tSPNode.getLocalCenterX() + d3, tSPNode.getLocalCenterY() + d4);
                }
            }
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDEdge)iterator.next();
            object2 = ((TSDEdge)object3).bendIterator();
            while (object2.hasNext()) {
                object = (TSPNode)object2.next();
                ((TSPNode)object).assignCenter(((TSPNode)object).getLocalCenterX() + d3, ((TSPNode)object).getLocalCenterY() + d4);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDEdge)iterator.next();
            ((TSDEdge)object3).ltUpdateBoundsOfLabels();
        }
        if (object4.size() > 0) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (TSDEdge)object3.next();
                if (tSGraphObject != this || !((TSDEdge)object2).isReachable()) continue;
                ((TSDEdge)object2).ltUpdateBoundsOfLabels();
            }
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDEdge)iterator.next();
            ((TSDEdge)object3).ltUpdateBoundsOfLabels();
        }
        iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDNode)iterator.next();
            ((TSDNode)object3).ltUpdateBoundsOfLabels();
            object2 = ((TSDNode)object3).connectors().iterator();
            while (object2.hasNext()) {
                object = (TSConnector)object2.next();
                ((TSConnector)object).ltUpdateBoundsOfLabels();
            }
        }
        this.updateBounds();
    }

    public boolean intersects(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.locallyIntersects(tSRect);
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.graphBounds.intersects(tSConstRect);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        this.inverseExpandedTransformRect(tSRect);
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        return this.graphBounds.intersects(d, d2, d3, d4);
    }

    public TSGraph getGreatestAncestor() {
        TSDGraph tSDGraph = this;
        TSGraphMember tSGraphMember = this.getParent();
        while (tSGraphMember != null && tSGraphMember.isOwned()) {
            TSDGraph tSDGraph2 = (TSDGraph)tSGraphMember.getOwner();
            if (tSDGraph2.isHideGraph()) {
                tSDGraph = tSDGraph2.hideFromGraph();
            } else {
                tSDGraph = (TSDGraph)tSGraphMember.getTransformGraph();
                if (tSDGraph == null) {
                    tSDGraph = (TSDGraph)tSGraphMember.getChildGraph();
                    break;
                }
            }
            tSGraphMember = tSDGraph.getParent();
        }
        return tSDGraph;
    }

    public boolean areBoundsStale() {
        return this.staleBounds;
    }

    public void emptyTopology() {
        this.setBoundsUpdatingEnabled(false);
        super.emptyTopology();
        this.setBoundsUpdatingEnabled(true);
        this.initGraphObject(true);
    }

    public void setAllPathNodesVisited(boolean bl) {
        TSGraphObject tSGraphObject;
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDEdge)iterator.next();
            ((TSDEdge)tSGraphObject).setAllPathNodesVisited(bl);
        }
        tSGraphObject = this.getOwnerGraphManager();
        List list = ((TSGraphManager)tSGraphObject).intergraphEdges();
        if (list.size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                TSDGraph tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge);
                if (tSDGraph != this) continue;
                tSDEdge.setAllPathNodesVisited(bl);
            }
        }
    }

    public boolean isOverPathEdge(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.isLocallyOverPathEdge(tSRect);
    }

    public boolean isLocallyOverPathEdge(TSRect tSRect) {
        TSGraphObject tSGraphObject;
        Object object;
        Object object2;
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        List list = tSGraphManager.intergraphEdges();
        if (list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TSDEdge)object2.next();
                tSGraphObject = (TSDGraph)((TSGEdge)object).getTransformGraph();
                if (tSGraphObject != this || !((TSDEdge)object).isViewable() || !((TSDEdge)object).isVisible() || !((TSDEdge)object).isLocallyOverPathEdge(tSRect)) continue;
                return true;
            }
        }
        if ((object2 = this.getLocalLastNodeTouchingBounds(tSRect, null)) != null && ((TSDNode)object2).isExpanded()) {
            object = (TSDGraph)((TSGraphMember)object2).getChildGraph();
            ((TSDGraph)object).inverseExpandedTransformRect(this, tSRect);
            return ((TSDGraph)object).isLocallyOverPathEdge(tSRect);
        }
        object = this.edges().iterator();
        while (object.hasNext()) {
            tSGraphObject = (TSDEdge)object.next();
            if (!((TSDEdge)tSGraphObject).isVisible() || !((TSDEdge)tSGraphObject).isLocallyOverPathEdge(tSRect)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverNode(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverNode(tSPoint);
    }

    public boolean isLocallyOverNode(TSPoint tSPoint) {
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode = (TSDNode)f02.b();
            if (!tSDNode.isVisible() || !tSDNode.locallyContains(tSPoint)) continue;
            if (tSDNode.isExpanded()) {
                if (tSDNode.locallyIntersectsNodeFrame(tSPoint)) {
                    return true;
                }
                TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
                tSDGraph.inverseExpandedTransformPoint(this, tSPoint);
                return tSDGraph.isLocallyOverNode(tSPoint);
            }
            return true;
        }
        return false;
    }

    public boolean isOverEdgeLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverEdgeLabel(tSPoint);
    }

    public boolean isLocallyOverEdgeLabel(TSPoint tSPoint) {
        TSGraphObject tSGraphObject;
        Object object;
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        List list = tSGraphManager.intergraphEdges();
        if (list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSDEdge)object.next();
                TSDGraph tSDGraph = (TSDGraph)((TSGEdge)tSGraphObject).getTransformGraph();
                if (tSDGraph != this || !((TSDEdge)tSGraphObject).isViewable() || !((TSDEdge)tSGraphObject).isVisible() || !((TSDEdge)tSGraphObject).isLocallyOverLabel(tSPoint)) continue;
                return true;
            }
        }
        if ((object = this.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint, tSPoint), null)) != null && ((TSDNode)object).isExpanded()) {
            tSGraphObject = (TSDGraph)((TSGraphMember)object).getChildGraph();
            ((TSDGraph)tSGraphObject).inverseExpandedTransformPoint(this, tSPoint);
            return ((TSDGraph)tSGraphObject).isLocallyOverEdgeLabel(tSPoint);
        }
        for (f0 f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            tSGraphObject = (TSDEdge)f02.b();
            if (!((TSDEdge)tSGraphObject).isVisible() || !((TSDEdge)tSGraphObject).isLocallyOverLabel(tSPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverNodeLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverNodeLabel(tSPoint);
    }

    public boolean isLocallyOverNodeLabel(TSPoint tSPoint) {
        TSDNode tSDNode = this.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint, tSPoint), null);
        if (tSDNode != null && tSDNode.isExpanded()) {
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
            tSDGraph.inverseExpandedTransformPoint(this, tSPoint);
            return tSDGraph.isLocallyOverNodeLabel(tSPoint);
        }
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode2 = (TSDNode)f02.b();
            if (!tSDNode2.isVisible() || !tSDNode2.isLocallyOverLabel(tSPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverConnector(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverConnector(tSPoint);
    }

    public boolean isLocallyOverConnector(TSPoint tSPoint) {
        TSDNode tSDNode = this.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint, tSPoint), null);
        if (tSDNode != null && tSDNode.isExpanded()) {
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
            tSDGraph.inverseExpandedTransformPoint(this, tSPoint);
            return tSDGraph.isLocallyOverConnector(tSPoint);
        }
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode2 = (TSDNode)f02.b();
            if (!tSDNode2.isVisible() || !tSDNode2.isLocallyOverConnector(tSPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverConnectorLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverConnectorLabel(tSPoint);
    }

    public boolean isLocallyOverConnectorLabel(TSPoint tSPoint) {
        TSDNode tSDNode = this.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint, tSPoint), null);
        if (tSDNode != null && tSDNode.isExpanded()) {
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
            tSDGraph.inverseExpandedTransformPoint(this, tSPoint);
            return tSDGraph.isLocallyOverConnectorLabel(tSPoint);
        }
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode2 = (TSDNode)f02.b();
            for (f0 f03 = ((de)tSDNode2.connectors()).b(); f03 != null; f03 = f03.d()) {
                TSConnector tSConnector = (TSConnector)f03.b();
                if (!tSConnector.isVisible() || !tSConnector.isLocallyOverLabel(tSPoint)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOverPathNode(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        this.inverseExpandedTransformPoint(tSPoint);
        return this.isLocallyOverPathNode(tSPoint);
    }

    public boolean isLocallyOverPathNode(TSPoint tSPoint) {
        TSGraphObject tSGraphObject;
        Object object;
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        List list = tSGraphManager.intergraphEdges();
        if (list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSDEdge)object.next();
                TSDGraph tSDGraph = (TSDGraph)((TSGEdge)tSGraphObject).getTransformGraph();
                if (tSDGraph != this || !((TSDEdge)tSGraphObject).isViewable() || !((TSDEdge)tSGraphObject).isVisible() || !((TSDEdge)tSGraphObject).isLocallyOverPathNode(tSPoint)) continue;
                return true;
            }
        }
        if ((object = this.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint, tSPoint), null)) != null && ((TSDNode)object).isExpanded()) {
            tSGraphObject = (TSDGraph)((TSGraphMember)object).getChildGraph();
            ((TSDGraph)tSGraphObject).inverseExpandedTransformPoint(this, tSPoint);
            return ((TSDGraph)tSGraphObject).isLocallyOverPathNode(tSPoint);
        }
        for (f0 f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            tSGraphObject = (TSDEdge)f02.b();
            if (!((TSDEdge)tSGraphObject).isVisible() || !((TSDEdge)tSGraphObject).isLocallyOverPathNode(tSPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverSolidGeometricGraphObject(TSConstPoint tSConstPoint) {
        return this.isOverNode(tSConstPoint) || this.isOverEdgeLabel(tSConstPoint) || this.isOverPathNode(tSConstPoint) || this.isOverNodeLabel(tSConstPoint) || this.isOverConnectorLabel(tSConstPoint) || this.isOverConnector(tSConstPoint);
    }

    public TSConstRect getFrameBounds() {
        TSRect tSRect = new TSRect(this.getLocalFrameBounds());
        this.expandedTransformRect(tSRect);
        return tSRect;
    }

    public TSConstRect getLocalFrameBounds() {
        TSRect tSRect = new TSRect(this.graphBounds);
        TSGraphTailor tSGraphTailor = this.getTailor();
        double d = tSGraphTailor.getLeftMarginSpacing().getCombinedSpacing(tSRect.getWidth());
        double d2 = tSGraphTailor.getRightMarginSpacing().getCombinedSpacing(tSRect.getWidth());
        double d3 = tSGraphTailor.getBottomMarginSpacing().getCombinedSpacing(tSRect.getHeight());
        double d4 = tSGraphTailor.getTopMarginSpacing().getCombinedSpacing(tSRect.getHeight());
        tSRect.setBounds(tSRect.getLeft() - d, tSRect.getBottom() - d3, tSRect.getRight() + d2, tSRect.getTop() + d4);
        return tSRect;
    }

    public List getNodesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalNodesTouchingBounds(tSRect, list);
    }

    public List getLocalNodesTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSDNode>();
        }
        Iterator iterator = this.nodeSet.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible() || !tSDNode.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSDNode);
        }
        return vector;
    }

    public TSDNode getFirstNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstNodeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDNode getLocalFirstNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        boolean bl = tSGeometricObject == null;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible() || !tSDNode.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSDNode;
            }
            bl = tSDNode.equals(tSGeometricObject);
        }
        return null;
    }

    public TSDNode getLastNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastNodeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDNode getLocalLastNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        boolean bl = tSGeometricObject == null;
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode = (TSDNode)f02.b();
            if (!tSDNode.isVisible() || !tSDNode.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSDNode;
            }
            bl = tSDNode.equals(tSGeometricObject);
        }
        return null;
    }

    public List getEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalEdgesTouchingBounds(tSRect, list);
    }

    public List getLocalEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        if (!this.edgeSet.isEmpty()) {
            Iterator iterator = this.edgeSet.iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (!tSDEdge.isVisible() || !tSDEdge.locallyIntersects(tSConstRect)) continue;
                list.add(0, tSDEdge);
            }
        }
        list = this.getLocalIntergraphEdgesTouchingBounds(tSConstRect, list);
        return list;
    }

    public TSDEdge getFirstEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDEdge getLocalFirstEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        boolean bl = tSGeometricObject == null;
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible() || !tSDEdge.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSDEdge;
            }
            bl = tSDEdge.equals(tSGeometricObject);
        }
        return null;
    }

    public TSDEdge getLastEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDEdge getLocalLastEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        boolean bl = tSGeometricObject == null;
        for (f0 f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            TSDEdge tSDEdge = (TSDEdge)f02.b();
            if (!tSDEdge.isVisible() || !tSDEdge.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSDEdge;
            }
            bl = tSDEdge.equals(tSGeometricObject);
        }
        return null;
    }

    public List getIntergraphEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalIntergraphEdgesTouchingBounds(tSRect, list);
    }

    public List getLocalIntergraphEdgesTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSDEdge>();
        }
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        Iterator iterator = tSDGraphManager.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible() || !tSDEdge.isViewable() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSDEdge);
        }
        return vector;
    }

    public TSDEdge getFirstIntergraphEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstIntergraphEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDEdge getLocalFirstIntergraphEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSDEdge tSDEdge;
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraphManager().queryIntergraph();
        if (tSDGraph == null) {
            return null;
        }
        Iterator iterator = tSDGraph.disconnectedEdges().iterator();
        while (tSGeometricObject != null && iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge != tSGeometricObject) continue;
            tSGeometricObject = null;
        }
        tSDEdge = null;
        while (iterator.hasNext() && tSDEdge == null) {
            tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.getTransformGraph() == this && tSDEdge.isVisible() && tSDEdge.isViewable() && tSDEdge.locallyIntersects(tSConstRect)) continue;
            tSDEdge = null;
        }
        return tSDEdge;
    }

    public TSDEdge getLastIntergraphEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastIntergraphEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSDEdge getLocalLastIntergraphEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSDEdge tSDEdge;
        f0 f02;
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraphManager().queryIntergraph();
        if (tSDGraph == null) {
            return null;
        }
        for (f02 = ((de)tSDGraph.freeSet).b(); tSGeometricObject != null && f02 != null; f02 = f02.d()) {
            tSDEdge = (TSDEdge)f02.b();
            if (tSDEdge != tSGeometricObject) continue;
            tSGeometricObject = null;
        }
        tSDEdge = null;
        while (f02 != null && tSDEdge == null) {
            tSDEdge = (TSDEdge)f02.b();
            if (!(tSDEdge.getTransformGraph() == this && tSDEdge.isVisible() && tSDEdge.isViewable() && tSDEdge.locallyIntersects(tSConstRect))) {
                tSDEdge = null;
            }
            f02 = f02.d();
        }
        return tSDEdge;
    }

    public List getConnectorsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalConnectorsTouchingBounds(tSRect, list);
    }

    public List getLocalConnectorsTouchingBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            list = tSDNode.getLocalConnectorsTouchingBounds(tSConstRect, list);
        }
        return list;
    }

    public TSConnector getFirstConnectorTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstConnectorTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSConnector getLocalFirstConnectorTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSConnector tSConnector;
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible() || (tSConnector = tSDNode.getLocalFirstConnectorTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSConnector;
        }
        return null;
    }

    public TSConnector getLastConnectorTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastConnectorTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSConnector getLocalLastConnectorTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSConnector tSConnector;
            TSDNode tSDNode = (TSDNode)f02.b();
            if (!tSDNode.isVisible() || (tSConnector = tSDNode.getLocalLastConnectorTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSConnector;
        }
        return null;
    }

    public List getPathEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalPathEdgesTouchingBounds(tSRect, list);
    }

    public List getLocalPathEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSDEdge tSDEdge;
        Iterator iterator;
        TSDGraphManager tSDGraphManager;
        if (list == null) {
            list = new Vector();
        }
        if ((tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager()) != null && tSDGraphManager.queryIntergraph() != null) {
            iterator = tSDGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || !tSDEdge.isVisible()) continue;
                list = tSDEdge.getLocalPathEdgesTouchingBounds(tSConstRect, list);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible()) continue;
            list = tSDEdge.getLocalPathEdgesTouchingBounds(tSConstRect, list);
        }
        return list;
    }

    public TSPEdge getFirstPathEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstPathEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSPEdge getLocalFirstPathEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSGEdge tSGEdge;
        TSGraphObject tSGraphObject;
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDEdge)iterator.next();
            if (!((TSDEdge)tSGraphObject).isVisible() || (tSGEdge = ((TSDEdge)tSGraphObject).getLocalFirstPathEdgeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSGEdge;
        }
        tSGraphObject = (TSDGraphManager)this.getOwnerGraphManager();
        if (tSGraphObject != null && ((TSGraphManager)tSGraphObject).queryIntergraph() != null) {
            iterator = ((TSGraphManager)tSGraphObject).intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSPEdge tSPEdge;
                tSGEdge = (TSDEdge)iterator.next();
                if (!((TSDEdge)tSGEdge).isVisible() || this != ((TSDGraphManager)tSGraphObject).getCommonNestedGraphOwner((TSDEdge)tSGEdge) || !((TSDEdge)tSGEdge).isViewable() || (tSPEdge = ((TSDEdge)tSGEdge).getLocalFirstPathEdgeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSPEdge;
            }
        }
        return null;
    }

    public TSPEdge getLastPathEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastPathEdgeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSPEdge getLocalLastPathEdgeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSPEdge tSPEdge;
        TSDEdge tSDEdge;
        f0 f02;
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        TSGraph tSGraph = null;
        if (tSDGraphManager != null) {
            tSGraph = tSDGraphManager.queryIntergraph();
        }
        if (tSGraph != null) {
            for (f02 = ((de)tSGraph.freeSet).b(); f02 != null; f02 = f02.d()) {
                tSDEdge = (TSDEdge)f02.b();
                if (!tSDEdge.isVisible() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || (tSPEdge = tSDEdge.getLocalLastPathEdgeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSPEdge;
            }
        }
        for (f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            tSDEdge = (TSDEdge)f02.b();
            if (!tSDEdge.isVisible() || (tSPEdge = tSDEdge.getLocalLastPathEdgeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSPEdge;
        }
        return null;
    }

    public List getPathNodesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalPathNodesTouchingBounds(tSRect, list);
    }

    public List getLocalPathNodesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSDEdge tSDEdge;
        Iterator iterator;
        TSDGraphManager tSDGraphManager;
        if (list == null) {
            list = new Vector();
        }
        if ((tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager()) != null && tSDGraphManager.queryIntergraph() != null) {
            iterator = tSDGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || !tSDEdge.isVisible()) continue;
                list = tSDEdge.getLocalPathNodesTouchingBounds(tSConstRect, list);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible()) continue;
            list = tSDEdge.getLocalPathNodesTouchingBounds(tSConstRect, list);
        }
        return list;
    }

    public TSPNode getFirstPathNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstPathNodeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSPNode getLocalFirstPathNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSGraphMember tSGraphMember;
        TSGraphObject tSGraphObject;
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDEdge)iterator.next();
            if (!((TSDEdge)tSGraphObject).isVisible() || (tSGraphMember = ((TSDEdge)tSGraphObject).getLocalFirstPathNodeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSGraphMember;
        }
        tSGraphObject = (TSDGraphManager)this.getOwnerGraphManager();
        if (tSGraphObject != null && ((TSGraphManager)tSGraphObject).queryIntergraph() != null) {
            iterator = ((TSGraphManager)tSGraphObject).intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSPNode tSPNode;
                tSGraphMember = (TSDEdge)iterator.next();
                if (!((TSDEdge)tSGraphMember).isVisible() || this != ((TSDGraphManager)tSGraphObject).getCommonNestedGraphOwner((TSDEdge)tSGraphMember) || !((TSDEdge)tSGraphMember).isViewable() || (tSPNode = ((TSDEdge)tSGraphMember).getLocalFirstPathNodeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSPNode;
            }
        }
        return null;
    }

    public TSPNode getLastPathNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastPathNodeTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSPNode getLocalLastPathNodeTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSPNode tSPNode;
        TSDEdge tSDEdge;
        f0 f02;
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        TSGraph tSGraph = null;
        if (tSDGraphManager != null) {
            tSGraph = tSDGraphManager.queryIntergraph();
        }
        if (tSGraph != null) {
            for (f02 = ((de)tSGraph.freeSet).b(); f02 != null; f02 = f02.d()) {
                tSDEdge = (TSDEdge)f02.b();
                if (!tSDEdge.isVisible() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || (tSPNode = tSDEdge.getLocalLastPathNodeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSPNode;
            }
        }
        for (f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            tSDEdge = (TSDEdge)f02.b();
            if (!tSDEdge.isVisible() || (tSPNode = tSDEdge.getLocalLastPathNodeTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSPNode;
        }
        return null;
    }

    public List getNodeLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalNodeLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalNodeLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            list = tSDNode.getLocalLabelsTouchingBounds(tSConstRect, list);
        }
        return list;
    }

    public TSNodeLabel getFirstNodeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstNodeLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSNodeLabel getLocalFirstNodeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSNodeLabel tSNodeLabel;
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible() || (tSNodeLabel = tSDNode.getLocalFirstLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSNodeLabel;
        }
        return null;
    }

    public TSNodeLabel getLastNodeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastNodeLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSNodeLabel getLocalLastNodeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSNodeLabel tSNodeLabel;
            TSDNode tSDNode = (TSDNode)f02.b();
            if (!tSDNode.isVisible() || (tSNodeLabel = tSDNode.getLocalLastLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSNodeLabel;
        }
        return null;
    }

    public List getEdgeLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalEdgeLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalEdgeLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSDEdge tSDEdge;
        Iterator iterator;
        TSDGraphManager tSDGraphManager;
        if (list == null) {
            list = new Vector();
        }
        if ((tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager()) != null && tSDGraphManager.queryIntergraph() != null) {
            iterator = tSDGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || !tSDEdge.isVisible()) continue;
                list = tSDEdge.getLocalLabelsTouchingBounds(tSConstRect, list);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible()) continue;
            list = tSDEdge.getLocalLabelsTouchingBounds(tSConstRect, list);
        }
        return list;
    }

    public TSEdgeLabel getFirstEdgeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstEdgeLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSEdgeLabel getLocalFirstEdgeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSGraphObject tSGraphObject;
        TSGraphObject tSGraphObject2;
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSDEdge)iterator.next();
            if (!((TSDEdge)tSGraphObject2).isVisible() || (tSGraphObject = ((TSDEdge)tSGraphObject2).getLocalFirstLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSGraphObject;
        }
        tSGraphObject2 = (TSDGraphManager)this.getOwnerGraphManager();
        if (tSGraphObject2 != null && ((TSGraphManager)tSGraphObject2).queryIntergraph() != null) {
            iterator = ((TSGraphManager)tSGraphObject2).intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSEdgeLabel tSEdgeLabel;
                tSGraphObject = (TSDEdge)iterator.next();
                if (!((TSDEdge)tSGraphObject).isVisible() || this != ((TSDGraphManager)tSGraphObject2).getCommonNestedGraphOwner((TSDEdge)tSGraphObject) || !((TSDEdge)tSGraphObject).isViewable() || (tSEdgeLabel = ((TSDEdge)tSGraphObject).getLocalFirstLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSEdgeLabel;
            }
        }
        return null;
    }

    public TSEdgeLabel getLastEdgeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastEdgeLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSEdgeLabel getLocalLastEdgeLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSEdgeLabel tSEdgeLabel;
        TSDEdge tSDEdge;
        f0 f02;
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        TSGraph tSGraph = null;
        if (tSDGraphManager != null) {
            tSGraph = tSDGraphManager.queryIntergraph();
        }
        if (tSGraph != null) {
            for (f02 = ((de)tSGraph.freeSet).b(); f02 != null; f02 = f02.d()) {
                tSDEdge = (TSDEdge)f02.b();
                if (!tSDEdge.isVisible() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable() || (tSEdgeLabel = tSDEdge.getLocalLastLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSEdgeLabel;
            }
        }
        for (f02 = ((de)this.edgeSet).b(); f02 != null; f02 = f02.d()) {
            tSDEdge = (TSDEdge)f02.b();
            if (!tSDEdge.isVisible() || (tSEdgeLabel = tSDEdge.getLocalLastLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
            return tSEdgeLabel;
        }
        return null;
    }

    public List getConnectorLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalConnectorLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalConnectorLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            Iterator iterator2 = tSDNode.connectors().iterator();
            while (iterator2.hasNext()) {
                TSConnector tSConnector = (TSConnector)iterator2.next();
                if (!tSConnector.isVisible()) continue;
                list = tSConnector.getLocalLabelsTouchingBounds(tSConstRect, list);
            }
        }
        return list;
    }

    public TSConnectorLabel getFirstConnectorLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalFirstConnectorLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSConnectorLabel getLocalFirstConnectorLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            Iterator iterator2 = tSDNode.connectors().iterator();
            while (iterator2.hasNext()) {
                TSConnectorLabel tSConnectorLabel;
                TSConnector tSConnector = (TSConnector)iterator.next();
                if (!tSConnector.isVisible() || (tSConnectorLabel = tSConnector.getLocalFirstLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSConnectorLabel;
            }
        }
        return null;
    }

    public TSConnectorLabel getLastConnectorLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalLastConnectorLabelTouchingBounds(tSRect, tSGeometricObject);
    }

    public TSConnectorLabel getLocalLastConnectorLabelTouchingBounds(TSConstRect tSConstRect, TSGeometricObject tSGeometricObject) {
        for (f0 f02 = ((de)this.nodeSet).b(); f02 != null; f02 = f02.d()) {
            TSDNode tSDNode = (TSDNode)f02.b();
            if (!tSDNode.isVisible()) continue;
            for (f0 f03 = ((de)tSDNode.connectors()).b(); f03 != null; f03 = f03.d()) {
                TSConnectorLabel tSConnectorLabel;
                TSConnector tSConnector = (TSConnector)f03.b();
                if (!tSConnector.isVisible() || (tSConnectorLabel = tSConnector.getLocalLastLabelTouchingBounds(tSConstRect, tSGeometricObject)) == null) continue;
                return tSConnectorLabel;
            }
        }
        return null;
    }

    public List getNodesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalNodesInsideBounds(tSRect, list);
    }

    public List getLocalNodesInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSDNode>();
        }
        Iterator iterator = this.nodeSet.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible() || !tSDNode.locallyInside(tSConstRect)) continue;
            vector.add(0, tSDNode);
        }
        return vector;
    }

    public List getEdgesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalEdgesInsideBounds(tSRect, list);
    }

    public List getLocalEdgesInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.edgeSet.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible() || !tSDEdge.locallyInside(tSConstRect)) continue;
            list.add(0, tSDEdge);
        }
        list = this.getIntergraphEdgesInsideBounds(tSConstRect, list);
        return list;
    }

    public List getIntergraphEdgesInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSDEdge>();
        }
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        Iterator iterator = tSDGraphManager.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible() || !tSDEdge.isViewable() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.inside(tSConstRect)) continue;
            vector.add(0, tSDEdge);
        }
        return vector;
    }

    public List getConnectorsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalConnectorsInsideBounds(tSRect, list);
    }

    public List getLocalConnectorsInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            list = tSDNode.getLocalConnectorsInsideBounds(tSConstRect, list);
        }
        return list;
    }

    public List getPathEdgesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalPathEdgesInsideBounds(tSRect, list);
    }

    public List getLocalPathEdgesInsideBounds(TSConstRect tSConstRect, List list) {
        TSDEdge tSDEdge;
        Iterator iterator;
        TSDGraphManager tSDGraphManager;
        if (list == null) {
            list = new Vector();
        }
        if ((tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager()) != null && tSDGraphManager.queryIntergraph() != null) {
            iterator = tSDGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (!tSDEdge.isVisible() || this != tSDGraphManager.getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable()) continue;
                list = tSDEdge.getLocalPathEdgesInsideBounds(tSConstRect, list);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible()) continue;
            list = tSDEdge.getLocalPathEdgesInsideBounds(tSConstRect, list);
        }
        return list;
    }

    public List getPathNodesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalPathNodesInsideBounds(tSConstRect, list);
    }

    public List getLocalPathNodesInsideBounds(TSConstRect tSConstRect, List list) {
        TSGraphObject tSGraphObject;
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDEdge)iterator.next();
            if (!((TSDEdge)tSGraphObject).isVisible()) continue;
            list = ((TSDEdge)tSGraphObject).getLocalPathNodesInsideBounds(tSConstRect, list);
        }
        tSGraphObject = (TSDGraphManager)this.getOwnerGraphManager();
        if (tSGraphObject != null && ((TSGraphManager)tSGraphObject).queryIntergraph() != null) {
            iterator = ((TSGraphManager)tSGraphObject).intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (!tSDEdge.isVisible() || this != ((TSDGraphManager)tSGraphObject).getCommonNestedGraphOwner(tSDEdge) || !tSDEdge.isViewable()) continue;
                list = tSDEdge.getLocalPathNodesInsideBounds(tSConstRect, list);
            }
        }
        return list;
    }

    public List getNodeLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalNodeLabelsInsideBounds(tSRect, list);
    }

    public List getLocalNodeLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            list = tSDNode.getLocalLabelsInsideBounds(tSConstRect, list);
        }
        return list;
    }

    public List getEdgeLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalEdgeLabelsInsideBounds(tSRect, list);
    }

    public List getLocalEdgeLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible()) continue;
            list = tSDEdge.getLocalLabelsInsideBounds(tSConstRect, list);
        }
        list = this.getIntergraphEdgeLabelsInsideBounds(tSConstRect, list);
        return list;
    }

    public List getIntergraphEdgeLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.getOwnerGraphManager().intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isVisible() || !tSDEdge.isViewable()) continue;
            list = tSDEdge.getLabelsInsideBounds(tSConstRect, list);
        }
        return list;
    }

    public List getConnectorLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        return this.getLocalConnectorLabelsInsideBounds(tSRect, list);
    }

    public List getLocalConnectorLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        if (list == null) {
            list = new Vector();
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isVisible()) continue;
            Iterator iterator2 = tSDNode.connectors().iterator();
            while (iterator2.hasNext()) {
                TSConnector tSConnector = (TSConnector)iterator2.next();
                if (!tSConnector.isVisible()) continue;
                list = tSConnector.getLocalLabelsInsideBounds(tSConstRect, list);
            }
        }
        return list;
    }

    public TSGraphTailor getTailor() {
        return this.tailor;
    }

    protected void onEdgeBecomesConnected(TSEdge tSEdge) {
        super.onEdgeBecomesConnected(tSEdge);
        this.edgeLabelCount += ((TSDEdge)tSEdge).numberOfLabels();
    }

    protected void onEdgeBecomesDisconnected(TSEdge tSEdge) {
        super.onEdgeBecomesDisconnected(tSEdge);
        this.edgeLabelCount -= ((TSDEdge)tSEdge).numberOfLabels();
    }

    public int numberOfEdgeLabels() {
        return this.edgeLabelCount;
    }

    void onNodeBecomesInserted(TSNode tSNode) {
        this.nodeLabelCount += ((TSDNode)tSNode).numberOfLabels();
        this.connectorLabelCount += ((TSDNode)tSNode).numberOfConnectorLabels();
    }

    void onNodeBecomesRemoved(TSNode tSNode) {
        this.nodeLabelCount -= ((TSDNode)tSNode).numberOfLabels();
        this.connectorLabelCount -= ((TSDNode)tSNode).numberOfConnectorLabels();
    }

    public int numberOfNodeLabels() {
        return this.nodeLabelCount;
    }

    public int numberOfConnectorLabels() {
        return this.connectorLabelCount;
    }

    public int numberOfLabels() {
        return this.numberOfNodeLabels() + this.numberOfEdgeLabels() + this.numberOfConnectorLabels();
    }

    public void insert(TSNode tSNode) {
        Object object;
        Object object2;
        TSSystem.tsAssert(tSNode instanceof TSDNode, "Bad node type");
        super.insert(tSNode);
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        if (tSNode.isExpanded() && !this.isHideGraph()) {
            object2 = TSNestingManager.getNestedGraphsWithin((TSDGraph)tSNode.getChildGraph());
            object = object2.iterator();
            while (object.hasNext()) {
                ((TSDGraph)object.next()).setViewability(this.isViewable());
            }
        }
        if (tSDGraphManager != null) {
            object2 = new Vector();
            object2 = tSNode.buildIncidentIntergraphEdgeList(true, true, false, true);
            object = object2.iterator();
            while (object.hasNext()) {
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)object.next();
                if (!tSDEdge.isReachable() || (tSDGraph = tSDGraphManager.getCommonNestedGraphOwner(tSDEdge)) == null) continue;
                tSDGraph.updateGraphBoundsOnInsert(tSDEdge.getLocalBounds(7));
            }
        }
        this.updateGraphBoundsOnInsert(((TSDNode)tSNode).getLocalBounds(7));
        if (tSNode.isExpanded()) {
            object2 = TSNestingManager.fitToNestedGraph((TSDNode)tSNode);
            object = (TSDGraph)tSNode.getChildGraph();
            ((TSDGraph)object).updateTransform((TSExpTransform)object2);
        }
    }

    public void remove(TSNode tSNode) {
        Object object;
        Object object2;
        TSSystem.tsAssert(tSNode instanceof TSDNode, "Bad node type");
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        List list = new Vector();
        Vector<TSDGraph> vector = new Vector<TSDGraph>();
        list = tSNode.buildIncidentIntergraphEdgeList(true, true, false, true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (TSDEdge)iterator.next();
            if (!((TSDEdge)object2).isReachable() || (object = tSDGraphManager.getCommonNestedGraphOwner((TSDEdge)object2)) == null) continue;
            vector.add((TSDGraph)object);
        }
        if (tSNode.hasChildGraph()) {
            object2 = new de();
            tSNode.getChildGraph().buildAllChildGraphList((List)object2);
            ((df)object2).add(tSNode.getChildGraph());
            object = ((df)object2).iterator();
            while (object.hasNext()) {
                ((TSDGraph)object.next()).setViewability(false);
            }
        }
        super.remove(tSNode);
        this.updateGraphBoundsOnRemove(((TSDNode)tSNode).getLocalBounds(7));
        object2 = vector.iterator();
        while (object2.hasNext()) {
            object = (TSDGraph)object2.next();
            ((TSDGraph)object).updateBounds();
        }
    }

    public void remove(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge instanceof TSDEdge, "Bad edge type");
        TSDGraph tSDGraph = (TSDGraph)tSEdge.getTransformGraph();
        super.remove(tSEdge);
        if (tSEdge.isIntergraphEdge() && ((TSDEdge)tSEdge).isReachable() && tSDGraph != null && !tSDGraph.isHideGraph()) {
            tSDGraph.updateGraphBoundsOnRemove(((TSDEdge)tSEdge).getLocalBounds(7));
        }
    }

    void setBounds(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        this.inverseExpandedTransformRect(tSRect);
        this.setLocalBounds(tSRect);
    }

    public void setLocalBounds(TSConstRect tSConstRect) {
        TSSystem.tsAssert(tSConstRect != null);
        if (!tSConstRect.equals(this.graphBounds)) {
            TSConstRect tSConstRect2 = new TSConstRect(this.graphBounds);
            this.graphBounds.setBounds(tSConstRect);
            this.fireEvent(new TSDrawingChangeEvent(0x800000L, new TSDrawingChangeEventData(this, tSConstRect2, tSConstRect)));
        }
    }

    public void setBoundsStale(boolean bl) {
        this.staleBounds = bl;
    }

    protected void notifyParentOnBoundsUpdate() {
        TSGraphMember tSGraphMember = this.getParent();
        if (tSGraphMember != null && tSGraphMember.isExpanded()) {
            TSNestingManager tSNestingManager = TSNestingManager.getManager((TSDGraphManager)this.getOwnerGraphManager());
            tSNestingManager.updateOnNestedGraphBoundsChange((TSDNode)tSGraphMember);
        }
    }

    public boolean isBoundsUpdatingEnabled() {
        return this.recomputeBounds;
    }

    public void setBoundsUpdatingEnabled(boolean bl) {
        this.recomputeBounds = bl;
    }

    public void updateBounds() {
        TSRect tSRect = new TSRect();
        if (this.numberOfNodes() > 0) {
            TSDEdge tSDEdge;
            Iterator iterator;
            f0 f02 = ((de)this.nodeSet).a();
            tSRect.setBounds(((TSDNode)f02.b()).getLocalBounds(7));
            for (f02 = f02.a(); f02 != null; f02 = f02.a()) {
                ((TSDNode)f02.b()).mergeLocalBounds(tSRect, 7);
            }
            TSGraphManager tSGraphManager = this.getOwnerGraphManager();
            List list = tSGraphManager.intergraphEdges();
            if (tSGraphManager != null && list.size() > 0) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    TSDGraph tSDGraph;
                    tSDEdge = (TSDEdge)iterator.next();
                    if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this) continue;
                    tSDEdge.recomputeClippingPoints();
                    tSDEdge.mergeLocalBounds(tSRect, 7);
                }
            }
            iterator = this.edges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                tSDEdge.recomputeClippingPoints();
                tSDEdge.mergeLocalBounds(tSRect, 7);
            }
        }
        this.setBoundsStale(false);
        if (this.graphBounds != null && (this.graphBounds.getBottom() != tSRect.getBottom() || this.graphBounds.getTop() != tSRect.getTop() || this.graphBounds.getRight() != tSRect.getRight() || this.graphBounds.getLeft() != tSRect.getLeft())) {
            this.setLocalBounds(tSRect);
        }
        this.notifyParentOnBoundsUpdate();
    }

    void updateGraphBoundsRightSide() {
        List list;
        Cloneable cloneable;
        double d = Double.NEGATIVE_INFINITY;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDNode)iterator.next();
            double d2 = ((TSDNode)cloneable).getLocalRight(7);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (!this.isHideGraph() && (list = ((TSGraphManager)(cloneable = this.getOwnerGraphManager())).intergraphEdges()).size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                double d3;
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this || !((d3 = tSDEdge.getLocalRight(7)) > d)) continue;
                d = d3;
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDEdge)iterator.next();
            double d4 = ((TSDEdge)cloneable).getLocalRight(7);
            if (!(d4 > d)) continue;
            d = d4;
        }
        TSSystem.tsAssert(this.isHideGraph() || d >= this.graphBounds.getLeft());
        if (this.graphBounds.getRight() != d) {
            cloneable = new TSRect(this.graphBounds);
            ((TSRect)cloneable).setRight(d);
            this.setLocalBounds((TSConstRect)cloneable);
            this.notifyParentOnBoundsUpdate();
        }
    }

    void updateGraphBoundsLeftSide() {
        List list;
        Cloneable cloneable;
        double d = Double.POSITIVE_INFINITY;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDNode)iterator.next();
            double d2 = ((TSDNode)cloneable).getLocalLeft(7);
            if (!(d2 < d)) continue;
            d = d2;
        }
        if (!this.isHideGraph() && (list = ((TSGraphManager)(cloneable = this.getOwnerGraphManager())).intergraphEdges()).size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                double d3;
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this || !((d3 = tSDEdge.getLocalLeft(7)) < d)) continue;
                d = d3;
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDEdge)iterator.next();
            double d4 = ((TSDEdge)cloneable).getLocalLeft(7);
            if (!(d4 < d)) continue;
            d = d4;
        }
        if (this.graphBounds.getLeft() != d) {
            cloneable = new TSRect(this.graphBounds);
            ((TSRect)cloneable).setLeft(d);
            this.setLocalBounds((TSConstRect)cloneable);
            this.notifyParentOnBoundsUpdate();
        }
    }

    void updateGraphBoundsTopSide() {
        List list;
        Cloneable cloneable;
        double d = Double.NEGATIVE_INFINITY;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDNode)iterator.next();
            double d2 = ((TSDNode)cloneable).getLocalTop(7);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (!this.isHideGraph() && (list = ((TSGraphManager)(cloneable = this.getOwnerGraphManager())).intergraphEdges()).size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                double d3;
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this || !((d3 = tSDEdge.getLocalTop(7)) > d)) continue;
                d = d3;
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDEdge)iterator.next();
            double d4 = ((TSDEdge)cloneable).getLocalTop(7);
            if (!(d4 > d)) continue;
            d = d4;
        }
        TSSystem.tsAssert(this.isHideGraph() || d >= this.graphBounds.getBottom());
        if (this.graphBounds.getTop() != d) {
            cloneable = new TSRect(this.graphBounds);
            ((TSRect)cloneable).setTop(d);
            this.setLocalBounds((TSConstRect)cloneable);
            this.notifyParentOnBoundsUpdate();
        }
    }

    void updateGraphBoundsBottomSide() {
        List list;
        Cloneable cloneable;
        double d = Double.POSITIVE_INFINITY;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDNode)iterator.next();
            double d2 = ((TSDNode)cloneable).getLocalBottom(7);
            if (!(d2 < d)) continue;
            d = d2;
        }
        if (!this.isHideGraph() && (list = ((TSGraphManager)(cloneable = this.getOwnerGraphManager())).intergraphEdges()).size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                double d3;
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this || !((d3 = tSDEdge.getLocalBottom(7)) < d)) continue;
                d = d3;
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDEdge)iterator.next();
            double d4 = ((TSDEdge)cloneable).getLocalBottom(7);
            if (!(d4 < d)) continue;
            d = d4;
        }
        if (this.graphBounds.getBottom() != d) {
            cloneable = new TSRect(this.graphBounds);
            ((TSRect)cloneable).setBottom(d);
            this.setLocalBounds((TSConstRect)cloneable);
            this.notifyParentOnBoundsUpdate();
        }
    }

    void updateGraphBoundsAllSides(int n) {
        List list;
        Cloneable cloneable;
        boolean bl = this.isCoalesce();
        this.setCoalesce(true);
        TSRect tSRect = null;
        boolean bl2 = (n & 0x80) != 0;
        boolean bl3 = (n & 0x20) != 0;
        boolean bl4 = (n & 0x10) != 0;
        boolean bl5 = (n & 0x40) != 0;
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDNode)iterator.next();
            if (tSRect == null) {
                tSRect = new TSRect(((TSDNode)cloneable).getLocalBounds(7));
                continue;
            }
            ((TSDNode)cloneable).mergeLocalBounds(tSRect, 7);
        }
        if (!this.isHideGraph() && (list = ((TSGraphManager)(cloneable = this.getOwnerGraphManager())).intergraphEdges()).size() > 0) {
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!tSDEdge.isReachable() || (tSDGraph = ((TSDGraphManager)this.getOwnerGraphManager()).getCommonNestedGraphOwner(tSDEdge)) != this) continue;
                if (tSRect == null) {
                    tSRect = new TSRect(tSDEdge.getLocalBounds(7));
                    continue;
                }
                tSDEdge.mergeLocalBounds(tSRect, 7);
            }
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            cloneable = (TSDEdge)iterator.next();
            if (tSRect == null) {
                tSRect = new TSRect(((TSDEdge)cloneable).getLocalBounds(7));
                continue;
            }
            ((TSDEdge)cloneable).mergeLocalBounds(tSRect, 7);
        }
        if (tSRect != null) {
            cloneable = new TSRect(this.graphBounds);
            boolean bl6 = false;
            if (bl2 && ((TSConstRect)cloneable).getLeft() != tSRect.getLeft()) {
                ((TSRect)cloneable).setLeft(tSRect.getLeft());
                bl6 = true;
            }
            if (bl3 && ((TSConstRect)cloneable).getRight() != tSRect.getRight()) {
                ((TSRect)cloneable).setRight(tSRect.getRight());
                bl6 = true;
            }
            if (bl4 && ((TSConstRect)cloneable).getTop() != tSRect.getTop()) {
                ((TSRect)cloneable).setTop(tSRect.getTop());
                bl6 = true;
            }
            if (bl5 && ((TSConstRect)cloneable).getBottom() != tSRect.getBottom()) {
                ((TSRect)cloneable).setBottom(tSRect.getBottom());
                bl6 = true;
            }
            if (bl6) {
                this.setLocalBounds((TSConstRect)cloneable);
                this.notifyParentOnBoundsUpdate();
            }
        }
        this.setCoalesce(bl);
    }

    int computeContactBits(TSConstRect tSConstRect) {
        int n = 0;
        if (tSConstRect.getTop() >= this.graphBounds.getTop()) {
            n += 17;
        }
        if (tSConstRect.getBottom() <= this.graphBounds.getBottom()) {
            n += 65;
        }
        if (tSConstRect.getLeft() <= this.graphBounds.getLeft()) {
            n += 129;
        }
        if (tSConstRect.getRight() >= this.graphBounds.getRight()) {
            n += 33;
        }
        return n;
    }

    void updateConstantMargins() {
        TSGraphTailor tSGraphTailor = this.getTailor();
        boolean bl = this.isFiringEvents();
        this.setFireEvents(false);
        tSGraphTailor.setTopConstantMargin(tSGraphTailor.getOriginalTopConstantMargin());
        tSGraphTailor.setBottomConstantMargin(tSGraphTailor.getOriginalBottomConstantMargin());
        tSGraphTailor.setLeftConstantMargin(tSGraphTailor.getOriginalLeftConstantMargin());
        tSGraphTailor.setRightConstantMargin(tSGraphTailor.getOriginalRightConstantMargin());
        this.setFireEvents(bl);
    }

    protected void updateGraphBoundsOnInsert(TSConstRect tSConstRect) {
        if (this.getOwnerGraphManager() != null && !((TSDGraphManager)this.getOwnerGraphManager()).isFileReadingInProgress()) {
            this.updateConstantMargins();
            if (this.recomputeBounds) {
                if (this.graphBounds.isEmpty()) {
                    this.setLocalBounds(tSConstRect);
                } else {
                    TSRect tSRect = new TSRect(this.graphBounds);
                    tSRect.merge(tSConstRect);
                    this.setLocalBounds(tSRect);
                }
                this.notifyParentOnBoundsUpdate();
                this.setBoundsStale(false);
            } else {
                this.setBoundsStale(true);
            }
        }
    }

    protected void updateGraphBoundsOnRemove(TSConstRect tSConstRect) {
        if (this.getOwnerGraphManager() == null || !((TSDGraphManager)this.getOwnerGraphManager()).isFileReadingInProgress()) {
            this.updateConstantMargins();
            if (this.recomputeBounds) {
                if (!this.graphBounds.contains(tSConstRect)) {
                    this.updateBounds();
                    return;
                }
                int n = this.computeContactBits(tSConstRect);
                if ((n & 0xF) == 1) {
                    if ((n & 0x80) != 0) {
                        this.updateGraphBoundsLeftSide();
                    } else if ((n & 0x20) != 0) {
                        this.updateGraphBoundsRightSide();
                    } else if ((n & 0x10) != 0) {
                        this.updateGraphBoundsTopSide();
                    } else if ((n & 0x40) != 0) {
                        this.updateGraphBoundsBottomSide();
                    }
                } else if ((n & 0xF) == 4 && this.numberOfNodes() <= 0) {
                    TSRect tSRect = new TSRect(this.graphBounds);
                    tSRect.setWidth(0.0);
                    tSRect.setHeight(0.0);
                    this.setLocalBounds(tSRect);
                    this.notifyParentOnBoundsUpdate();
                } else if (n > 0) {
                    this.updateGraphBoundsAllSides(n);
                }
                this.setBoundsStale(false);
            } else {
                this.setBoundsStale(true);
            }
        }
    }

    protected void updateGraphBoundsOnMove(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.getOwnerGraphManager() != null && !((TSDGraphManager)this.getOwnerGraphManager()).isFileReadingInProgress()) {
            this.updateConstantMargins();
            if (this.recomputeBounds) {
                int n = this.computeContactBits(tSConstRect);
                if (n == 0) {
                    TSRect tSRect = new TSRect(this.graphBounds);
                    boolean bl = tSRect.merge(tSConstRect2);
                    this.setLocalBounds(tSRect);
                    if (bl) {
                        this.notifyParentOnBoundsUpdate();
                    }
                } else if ((n & 0xF) == 3) {
                    this.updateGraphBoundsAllSides(n);
                    TSRect tSRect = new TSRect(this.graphBounds);
                    boolean bl = tSRect.merge(tSConstRect2);
                    this.setLocalBounds(tSRect);
                    if (bl) {
                        this.notifyParentOnBoundsUpdate();
                    }
                } else if ((n & 0xF) == 4) {
                    if (this.numberOfNodes() <= 1) {
                        this.updateBounds();
                    } else {
                        this.updateGraphBoundsAllSides(n);
                        TSRect tSRect = new TSRect(this.graphBounds);
                        boolean bl = tSRect.merge(tSConstRect2);
                        this.setLocalBounds(tSRect);
                        if (bl) {
                            this.notifyParentOnBoundsUpdate();
                        }
                    }
                } else {
                    boolean bl = true;
                    if ((n & 0x80) != 0 && tSConstRect.getLeft() < tSConstRect2.getLeft()) {
                        bl = false;
                    }
                    if ((n & 0x20) != 0 && tSConstRect.getRight() > tSConstRect2.getRight()) {
                        bl = false;
                    }
                    if ((n & 0x40) != 0 && tSConstRect.getBottom() < tSConstRect2.getBottom()) {
                        bl = false;
                    }
                    if ((n & 0x10) != 0 && tSConstRect.getTop() > tSConstRect2.getTop()) {
                        bl = false;
                    }
                    if (bl) {
                        TSRect tSRect = new TSRect(this.graphBounds);
                        boolean bl2 = tSRect.merge(tSConstRect2);
                        this.setLocalBounds(tSRect);
                        if (bl2) {
                            this.notifyParentOnBoundsUpdate();
                        }
                    } else {
                        this.updateGraphBoundsAllSides(n);
                        TSRect tSRect = new TSRect(this.graphBounds);
                        boolean bl3 = tSRect.merge(tSConstRect2);
                        this.setLocalBounds(tSRect);
                        if (bl3) {
                            this.notifyParentOnBoundsUpdate();
                        }
                    }
                }
                this.setBoundsStale(false);
            } else {
                this.setBoundsStale(true);
            }
        }
    }

    protected void updateGraphBoundsOnResize(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.getOwnerGraphManager() != null && !((TSDGraphManager)this.getOwnerGraphManager()).isFileReadingInProgress()) {
            if (this.recomputeBounds) {
                if (!this.graphBounds.contains(tSConstRect)) {
                    this.updateConstantMargins();
                    this.updateBounds();
                    return;
                }
                if (tSConstRect.getWidth() <= tSConstRect2.getWidth() && tSConstRect.getHeight() <= tSConstRect2.getHeight()) {
                    TSRect tSRect = new TSRect(this.graphBounds);
                    boolean bl = tSRect.merge(tSConstRect2);
                    this.setLocalBounds(tSRect);
                    if (bl) {
                        this.updateConstantMargins();
                        this.notifyParentOnBoundsUpdate();
                    }
                } else {
                    this.updateGraphBoundsOnRemove(tSConstRect);
                    this.updateGraphBoundsOnInsert(tSConstRect2);
                }
                this.setBoundsStale(false);
            } else {
                this.setBoundsStale(true);
            }
        }
    }

    public void transfer(TSGraph tSGraph) {
        TSSystem.tsAssert(tSGraph instanceof TSDGraph);
        this.setBoundsUpdatingEnabled(false);
        super.transfer(tSGraph);
        TSDGraph tSDGraph = (TSDGraph)tSGraph;
        this.setHideGraph(tSDGraph.isHideGraph());
        this.hideOrHideFromGraph = tSDGraph.hideOrHideFromGraph;
        if (this.hideOrHideFromGraph != null) {
            this.hideOrHideFromGraph.hideOrHideFromGraph = this;
        }
        tSDGraph.hideOrHideFromGraph = null;
        this.setBoundsUpdatingEnabled(true);
        this.updateBounds();
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        this.nodeLabelCount = 0;
        this.edgeLabelCount = 0;
        this.connectorLabelCount = 0;
        if (object instanceof TSDGraph) {
            TSDGraph tSDGraph = (TSDGraph)object;
            this.tailor.copy(tSDGraph.tailor);
            this.graphBounds.setBounds(tSDGraph.graphBounds);
            this.staleBounds = tSDGraph.staleBounds;
            this.recomputeBounds = tSDGraph.recomputeBounds;
            this.setGeometryChangeNotified(tSDGraph.isGeometryChangeNotified());
            this.setHideGraph(tSDGraph.isHideGraph());
            this.setViewability(tSDGraph.isViewable());
            this.transform = tSDGraph.getClonedTransform();
        }
    }

    protected void duplicateTopology(TSGraph tSGraph, boolean bl, boolean bl2, boolean bl3) {
        TSDGraph tSDGraph;
        TSDGraph tSDGraph2;
        super.duplicateTopology(tSGraph, bl, bl2, bl3);
        if (tSGraph instanceof TSDGraph && bl3 && (tSDGraph2 = (tSDGraph = (TSDGraph)tSGraph).hideGraph()) != null) {
            TSDGraph tSDGraph3 = this.allocateHideGraph();
            tSDGraph2.setUtilityObject(tSDGraph3);
            tSDGraph3.copy(tSDGraph2, bl, null, null, true, true);
        }
    }

    protected void createMapping(Map map, Map map2) {
        super.createMapping(map, map2);
        if (this.hideGraph() != null) {
            this.hideGraph().createMapping(map, map2);
        }
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        if (!bl && this.hideGraph() != null) {
            bl = this.hideGraph().utilityObjectInUse();
        }
        return bl;
    }

    public void nullifyUtilityObject() {
        super.nullifyUtilityObject();
        if (this.hideGraph() != null) {
            this.hideGraph().nullifyUtilityObject();
        }
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().setChildGraph(null);
            this.getOwnerGraphManager().discard(this);
        }
        super.dispose();
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        TSGraphMember tSGraphMember;
        Iterator iterator;
        l = super.assignIDs(tSGraphObjectTable, l);
        if (TSHidingManager.hasHiddenNodes(this)) {
            iterator = this.hideGraph().nodes().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDNode)iterator.next();
                l = ((TSDNode)tSGraphMember).assignIDs(tSGraphObjectTable, l);
            }
        }
        if (TSHidingManager.hasHiddenEdges(this)) {
            iterator = this.hideGraph().edges().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDEdge)iterator.next();
                l = ((TSDEdge)tSGraphMember).assignIDs(tSGraphObjectTable, l);
            }
            iterator = this.hideGraph().disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDEdge)iterator.next();
                l = ((TSDEdge)tSGraphMember).assignIDs(tSGraphObjectTable, l);
            }
        }
        return l;
    }

    public void readGMF(Reader reader, TSOptionData tSOptionData) throws IOException {
        this.readGMF(reader, tSOptionData, true);
    }

    public void readGMF(Reader reader, TSOptionData tSOptionData, boolean bl) throws IOException {
        this.emptyTopology();
        cv cv2 = (cv)this.newGMFReader(reader);
        cv2.a(tSOptionData);
        cv2.a(this, bl);
        this.updateBounds();
    }

    protected cw newGMFReader(Reader reader) {
        return new cv(reader);
    }

    protected TSNode newNode() {
        return new TSDNode();
    }

    protected TSNode newNode(int n) {
        return new TSDNode();
    }

    protected TSEdge newEdge() {
        throw new UnsupportedOperationException("This cannot be used at this level. Use the graph manager's newEdge method instead.");
    }

    protected TSEdge newEdge(int n) {
        throw new UnsupportedOperationException("This cannot be used at this level. Use the graph manager's newEdge method instead.");
    }

    public TSEdge addEdge(TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(tSNode2 != null);
        TSSystem.tsAssert(tSNode.isOwned());
        TSSystem.tsAssert(tSNode2.isOwned());
        TSEdge tSEdge = ((TSDGraphManager)this.getOwnerGraphManager()).newEdge();
        tSEdge.setSourceNode(tSNode);
        tSEdge.setTargetNode(tSNode2);
        this.insert(tSEdge);
        return tSEdge;
    }

    public TSEdge addEdge(int n, TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(tSNode2 != null);
        TSSystem.tsAssert(tSNode.isOwned());
        TSSystem.tsAssert(tSNode2.isOwned());
        TSEdge tSEdge = ((TSDGraphManager)this.getOwnerGraphManager()).newEdge(n);
        tSEdge.setSourceNode(tSNode);
        tSEdge.setTargetNode(tSNode2);
        this.insert(tSEdge);
        return tSEdge;
    }

    public TSDGraph getMainDisplayGraph() {
        TSDGraphManager tSDGraphManager = null;
        if (this.isHideGraph() && this.getOwner() != null) {
            tSDGraphManager = (TSDGraphManager)this.getOwner().getOwner();
        } else if (this.getOwner() != null) {
            tSDGraphManager = (TSDGraphManager)this.getOwner();
        }
        if (tSDGraphManager != null) {
            return tSDGraphManager.getMainDisplayGraph();
        }
        return null;
    }

    public boolean isMainDisplayGraph() {
        return this == this.getMainDisplayGraph();
    }

    public List buildEdges(int n) {
        List list = super.buildEdges(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (((n & 4) == 0 || !tSDEdge.isMetaEdge()) && (n & 4) != 0 || ((n & 8) == 0 || tSDEdge.isMetaEdge()) && (n & 8) != 0 || ((n & 0x10) == 0 || !tSDEdge.isViewable()) && (n & 0x10) != 0 || ((n & 0x20) == 0 || tSDEdge.isViewable()) && (n & 0x20) != 0 || ((n & 0x40) == 0 || !tSDEdge.isReachable()) && (n & 0x40) != 0 || ((n & 0x80) == 0 || tSDEdge.isReachable()) && (n & 0x80) != 0) continue;
            de2.add(tSDEdge);
        }
        return de2;
    }

    public List buildNodes(int n) {
        List list = this.nodes();
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (((n & 0x100) == 0 || !tSDNode.isExpanded()) && (n & 0x100) != 0 || ((n & 0x200) == 0 || tSDNode.isExpanded()) && (n & 0x200) != 0 || ((n & 0x400) == 0 || !TSNestingManager.isCollapsed(tSDNode)) && (n & 0x400) != 0 || ((n & 0x800) == 0 || TSNestingManager.isCollapsed(tSDNode)) && (n & 0x800) != 0 || ((n & 0x10) == 0 || !tSDNode.isViewable()) && (n & 0x10) != 0 || ((n & 0x20) == 0 || tSDNode.isViewable()) && (n & 0x20) != 0 || ((n & 0x40) == 0 || !tSDNode.isReachable()) && (n & 0x40) != 0 || ((n & 0x80) == 0 || tSDNode.isReachable()) && (n & 0x80) != 0) continue;
            de2.add(tSDNode);
        }
        return de2;
    }

    public List buildNodeLabels(int n) {
        List list = this.buildNodes(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            de2.addAll(tSDNode.labels());
        }
        return de2;
    }

    public List buildEdgeLabels(int n) {
        List list = this.buildEdges(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            de2.addAll(tSDEdge.labels());
        }
        return de2;
    }

    public List buildConnectorLabels(int n) {
        List list = this.buildNodes(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            Iterator iterator2 = tSDNode.connectors().iterator();
            while (iterator2.hasNext()) {
                TSConnector tSConnector = (TSConnector)iterator2.next();
                de2.addAll(tSConnector.labels());
            }
        }
        return de2;
    }

    public TSConstRect getViewBounds(boolean bl) {
        TSConstRect tSConstRect = this.getLocalViewBounds();
        if (!bl) {
            this.expandedTransformRect((TSRect)tSConstRect);
        }
        return tSConstRect;
    }

    public TSConstRect getLocalViewBounds() {
        TSConstRect tSConstRect;
        if (TSNestingManager.isNested(this)) {
            tSConstRect = this.getViewBoundsInNodeCoordSystem();
            this.inverseExpandedTransformRect(this.nestedWithinGraph(), (TSRect)tSConstRect);
        } else {
            tSConstRect = this.getLocalFrameBounds();
        }
        return tSConstRect;
    }

    TSConstRect getViewBoundsInNodeCoordSystem() {
        TSSystem.tsAssert(TSNestingManager.isNested(this));
        TSRect tSRect = new TSRect(TSNestingManager.nestedWithinNode(this).getLocalBounds());
        TSGraphTailor tSGraphTailor = this.getTailor();
        double d = tSGraphTailor.getLeftNestedViewSpacing().getCombinedSpacing(tSRect.getWidth());
        double d2 = tSGraphTailor.getRightNestedViewSpacing().getCombinedSpacing(tSRect.getWidth());
        double d3 = tSGraphTailor.getBottomNestedViewSpacing().getCombinedSpacing(tSRect.getHeight());
        double d4 = tSGraphTailor.getTopNestedViewSpacing().getCombinedSpacing(tSRect.getHeight());
        tSRect.setBounds(tSRect.getLeft() + d, tSRect.getBottom() + d3, tSRect.getRight() - d2, tSRect.getTop() - d4);
        return tSRect;
    }

    public TSExpTransform getTransform() {
        return this.transform;
    }

    public TSExpTransform getClonedTransform() {
        TSExpTransform tSExpTransform = new TSExpTransform();
        tSExpTransform.copy(this.getTransform());
        return tSExpTransform;
    }

    public TSExpTransform getLocalToMainDisplayGraphTransform() {
        TSExpTransform tSExpTransform = new TSExpTransform();
        TSDGraph tSDGraph = null;
        tSDGraph = this.isHideGraph() ? this.hideFromGraph() : this;
        while (!tSDGraph.isMainDisplayGraph() && tSDGraph.nestedWithinGraph() != null) {
            tSExpTransform = TSExpTransform.compose(tSExpTransform, tSDGraph.getTransform());
            tSDGraph = tSDGraph.nestedWithinGraph();
        }
        if (tSDGraph.isMainDisplayGraph()) {
            return tSExpTransform;
        }
        return null;
    }

    TSDGraph nestedWithinGraph() {
        return TSNestingManager.nestedWithinGraph(this);
    }

    public void updateTransform(TSExpTransform tSExpTransform) {
        if (!tSExpTransform.equals(this.transform)) {
            this.transform.copy(tSExpTransform);
        }
    }

    public boolean expandedTransformPoint(TSDGraph tSDGraph, TSPoint tSPoint) {
        TSDGraph tSDGraph2;
        TSDGraph tSDGraph3 = this;
        while (tSDGraph3 != tSDGraph && (tSDGraph2 = tSDGraph3.nestedWithinGraph()) != null) {
            tSDGraph3.getTransform().transformPoint(tSPoint, tSPoint);
            tSDGraph3 = tSDGraph2;
        }
        return tSDGraph3 == tSDGraph;
    }

    public boolean expandedTransformPoint(TSPoint tSPoint) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null && tSDGraph != this ? this.expandedTransformPoint(tSDGraph, tSPoint) : false;
        return bl;
    }

    public boolean expandedTransformRect(TSDGraph tSDGraph, TSRect tSRect) {
        TSDGraph tSDGraph2;
        TSDGraph tSDGraph3 = this;
        while (tSDGraph3 != tSDGraph && (tSDGraph2 = TSNestingManager.nestedWithinGraph(tSDGraph3)) != null) {
            tSDGraph3.getTransform().transformRect(tSRect, tSRect);
            tSDGraph3 = tSDGraph2;
        }
        return tSDGraph3 == tSDGraph;
    }

    public boolean expandedTransformRect(TSRect tSRect) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null && tSDGraph != this ? this.expandedTransformRect(tSDGraph, tSRect) : false;
        return bl;
    }

    public boolean expandedTransformSize(TSDGraph tSDGraph, TSSize tSSize) {
        TSDGraph tSDGraph2;
        TSDGraph tSDGraph3 = this;
        while (tSDGraph3 != tSDGraph && (tSDGraph2 = tSDGraph3.nestedWithinGraph()) != null) {
            tSDGraph3.getTransform().transformSize(tSSize, tSSize);
            tSDGraph3 = tSDGraph2;
        }
        return tSDGraph3 == tSDGraph;
    }

    public boolean expandedTransformSize(TSSize tSSize) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null && tSDGraph != this ? this.expandedTransformSize(tSDGraph, tSSize) : false;
        return bl;
    }

    public double expandedTransformX(TSDGraph tSDGraph, double d) {
        TSDGraph tSDGraph2;
        TSDGraph tSDGraph3 = this;
        while (tSDGraph3 != tSDGraph && (tSDGraph2 = tSDGraph3.nestedWithinGraph()) != null) {
            d = tSDGraph3.getTransform().transformX(d);
            tSDGraph3 = tSDGraph2;
        }
        return d;
    }

    public double expandedTransformX(double d) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        if (tSDGraph != null && tSDGraph != this) {
            d = this.expandedTransformX(tSDGraph, d);
        }
        return d;
    }

    public double expandedTransformY(TSDGraph tSDGraph, double d) {
        TSDGraph tSDGraph2;
        TSDGraph tSDGraph3 = this;
        while (tSDGraph3 != tSDGraph && (tSDGraph2 = tSDGraph3.nestedWithinGraph()) != null) {
            d = tSDGraph3.getTransform().transformY(d);
            tSDGraph3 = tSDGraph2;
        }
        return d;
    }

    public double expandedTransformY(double d) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        if (tSDGraph != null && tSDGraph != this) {
            d = this.expandedTransformY(tSDGraph, d);
        }
        return d;
    }

    public boolean inverseExpandedTransformPoint(TSDGraph tSDGraph, TSPoint tSPoint) {
        boolean bl;
        TSDGraph tSDGraph2 = this.nestedWithinGraph();
        if (this == tSDGraph) {
            bl = true;
        } else if (tSDGraph2 != null) {
            bl = tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            this.getTransform().inverseTransformPoint(tSPoint, tSPoint);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean inverseExpandedTransformPoint(TSPoint tSPoint) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null ? this.inverseExpandedTransformPoint(tSDGraph, tSPoint) : false;
        return bl;
    }

    public boolean inverseExpandedTransformRect(TSDGraph tSDGraph, TSRect tSRect) {
        boolean bl;
        TSDGraph tSDGraph2 = this.nestedWithinGraph();
        if (this == tSDGraph) {
            bl = true;
        } else if (tSDGraph2 != null) {
            bl = tSDGraph2.inverseExpandedTransformRect(tSDGraph, tSRect);
            this.getTransform().inverseTransformRect(tSRect, tSRect);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean inverseExpandedTransformRect(TSRect tSRect) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null ? this.inverseExpandedTransformRect(tSDGraph, tSRect) : false;
        return bl;
    }

    public boolean inverseExpandedTransformSize(TSDGraph tSDGraph, TSSize tSSize) {
        boolean bl;
        TSDGraph tSDGraph2 = this.nestedWithinGraph();
        if (this == tSDGraph) {
            bl = true;
        } else if (tSDGraph2 != null) {
            bl = tSDGraph2.inverseExpandedTransformSize(tSDGraph, tSSize);
            this.getTransform().inverseTransformSize(tSSize, tSSize);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean inverseExpandedTransformSize(TSSize tSSize) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        boolean bl = tSDGraph != null ? this.inverseExpandedTransformSize(tSDGraph, tSSize) : false;
        return bl;
    }

    public double inverseExpandedTransformX(TSDGraph tSDGraph, double d) {
        TSDGraph tSDGraph2 = this.nestedWithinGraph();
        if (tSDGraph != this && tSDGraph2 != null) {
            d = tSDGraph2.inverseExpandedTransformX(tSDGraph, d);
            d = this.getTransform().inverseTransformX(d);
        }
        return d;
    }

    public double inverseExpandedTransformX(double d) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        if (tSDGraph != null) {
            d = this.inverseExpandedTransformX(tSDGraph, d);
        }
        return d;
    }

    public double inverseExpandedTransformY(TSDGraph tSDGraph, double d) {
        TSDGraph tSDGraph2 = this.nestedWithinGraph();
        if (tSDGraph != this && tSDGraph2 != null) {
            d = tSDGraph2.inverseExpandedTransformY(tSDGraph, d);
            d = this.getTransform().inverseTransformY(d);
        }
        return d;
    }

    public double inverseExpandedTransformY(double d) {
        TSDGraph tSDGraph = this.getMainDisplayGraph();
        if (tSDGraph != null) {
            d = this.inverseExpandedTransformY(tSDGraph, d);
        }
        return d;
    }

    boolean getTransformCoef(TSDGraph tSDGraph, TSPoint tSPoint, TSPoint tSPoint2) {
        boolean bl = false;
        tSPoint.setLocation(0.0, 0.0);
        tSPoint2.setLocation(1.0, 1.0);
        if (tSDGraph != this) {
            TSPoint tSPoint3 = new TSPoint(0.0, 0.0);
            TSPoint tSPoint4 = new TSPoint(1.0, 1.0);
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwner();
            TSNestingManager tSNestingManager = TSNestingManager.getManager(tSDGraphManager);
            TSDGraph tSDGraph2 = tSNestingManager.getCommonNestedGraphOwner(this, tSDGraph);
            if (tSDGraph.getExpandedTransformCoef(tSDGraph2, tSPoint3, tSPoint4) && this.getInverseExpandedTransformCoef(tSDGraph2, tSPoint, tSPoint2)) {
                tSPoint.setLocation(tSPoint.getX() + tSPoint3.getX() * tSPoint2.getX(), tSPoint.getY() + tSPoint4.getY() * tSPoint2.getY());
                tSPoint2.setLocation(tSPoint2.getX() * tSPoint4.getX(), tSPoint2.getY() * tSPoint4.getY());
                bl = true;
            }
        }
        return bl;
    }

    boolean getInverseExpandedTransformCoef(TSDGraph tSDGraph, TSPoint tSPoint, TSPoint tSPoint2) {
        boolean bl = false;
        tSPoint.setLocation(0.0, 0.0);
        tSPoint2.setLocation(1.0, 1.0);
        if (this == tSDGraph) {
            bl = true;
        } else if (tSDGraph != null && this.nestedWithinGraph() != null) {
            TSDGraph tSDGraph2 = this;
            TSDGraph tSDGraph3 = tSDGraph2.nestedWithinGraph();
            TSExpTransform tSExpTransform = tSDGraph2.getTransform();
            double d = 0.0;
            double d2 = tSExpTransform.getOffsetX();
            double d3 = 1.0 / tSExpTransform.getScaleX();
            double d4 = 0.0;
            double d5 = tSExpTransform.getOffsetY();
            double d6 = 1.0 / tSExpTransform.getScaleY();
            while (tSDGraph3 != null && tSDGraph3 != tSDGraph) {
                tSDGraph2 = tSDGraph3;
                tSDGraph3 = tSDGraph2.nestedWithinGraph();
                tSExpTransform = tSDGraph2.getTransform();
                d -= d2 * d3;
                d4 -= d5 * d6;
                d2 = tSExpTransform.getOffsetX();
                d5 = tSExpTransform.getOffsetY();
                d3 *= tSExpTransform.getScaleX();
                d6 *= tSExpTransform.getScaleY();
            }
            if (tSDGraph3 == tSDGraph) {
                tSPoint.setLocation(d - d2 * d3, d4 - d5 * d6);
                tSPoint2.setLocation(d3, d6);
                bl = true;
            }
        }
        return bl;
    }

    boolean getExpandedTransformCoef(TSDGraph tSDGraph, TSPoint tSPoint, TSPoint tSPoint2) {
        boolean bl = false;
        tSPoint.setLocation(0.0, 0.0);
        tSPoint2.setLocation(1.0, 1.0);
        if (this == tSDGraph) {
            bl = true;
        } else if (tSDGraph != null && this.nestedWithinGraph() != null) {
            double d;
            double d2;
            TSDGraph tSDGraph2 = this;
            TSExpTransform tSExpTransform = tSDGraph2.getTransform();
            double d3 = d2 = 1.0 / tSExpTransform.getScaleX();
            double d4 = 0.0;
            double d5 = tSExpTransform.getOffsetX();
            double d6 = d = 1.0 / tSExpTransform.getScaleY();
            double d7 = 0.0;
            double d8 = tSExpTransform.getOffsetY();
            for (tSDGraph2 = tSDGraph2.nestedWithinGraph(); tSDGraph2 != null && tSDGraph2 != tSDGraph; tSDGraph2 = tSDGraph2.nestedWithinGraph()) {
                tSExpTransform = tSDGraph2.getTransform();
                d2 = 1.0 / tSExpTransform.getScaleX();
                d = 1.0 / tSExpTransform.getScaleY();
                d3 *= d2;
                d6 *= d;
                d4 = (d4 + d5) * d2;
                d7 = (d7 + d8) * d;
                d5 = tSExpTransform.getOffsetX();
                d8 = tSExpTransform.getOffsetY();
            }
            if (tSDGraph2 == tSDGraph) {
                tSPoint.setLocation(d5 + d4, d8 + d7);
                tSPoint2.setLocation(d3, d6);
                bl = true;
            }
        }
        return bl;
    }

    public TSDGraph hideGraph() {
        if (this.isHideGraph()) {
            return null;
        }
        return this.hideOrHideFromGraph;
    }

    public TSDGraph hideFromGraph() {
        if (this.isHideGraph()) {
            return this.hideOrHideFromGraph;
        }
        return null;
    }

    public TSGraphManager getOwnerGraphManager() {
        if (this.isHideGraph()) {
            return (TSGraphManager)this.hideFromGraph().getOwner();
        }
        return (TSGraphManager)this.getOwner();
    }

    public TSDGraph allocateHideGraph() {
        TSDGraph tSDGraph = null;
        if (!this.isHideGraph()) {
            if (this.hideOrHideFromGraph == null) {
                tSDGraph = this.newHideGraph();
                tSDGraph.setViewability(false);
                tSDGraph.setOwner(this);
                tSDGraph.setOwned(true);
                this.setHideLink(tSDGraph);
            } else {
                tSDGraph = this.hideOrHideFromGraph;
            }
        } else {
            tSDGraph = null;
        }
        return tSDGraph;
    }

    public TSDGraph newHideGraph() {
        return new TSDGraph();
    }

    void setHideLink(TSDGraph tSDGraph) {
        if (!this.isHideGraph()) {
            tSDGraph.setHideGraph(true);
            this.hideOrHideFromGraph = tSDGraph;
            tSDGraph.hideOrHideFromGraph = this;
        }
    }

    public int levelNumber() {
        return 1;
    }

    public boolean isHideGraph() {
        return (this.flags2 & 1) != 0;
    }

    public void setHideGraph(boolean bl) {
        this.flags2 = bl ? (this.flags2 |= 1) : (this.flags2 &= 0xFFFFFFFE);
    }

    public boolean isViewable() {
        return (this.flags2 & 2) != 0;
    }

    public boolean isReachable() {
        TSDGraph tSDGraph = this;
        if (tSDGraph.isHideGraph() || !tSDGraph.isOwned()) {
            return false;
        }
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
        TSDGraph tSDGraph2 = (TSDGraph)tSDGraphManager.getMainDisplayGraph().getGreatestAncestor();
        while (tSDGraph != null && tSDGraph != tSDGraph2 && !tSDGraph.isHideGraph()) {
            TSGraphMember tSGraphMember = tSDGraph.getParent();
            if (tSGraphMember != null && tSGraphMember.isOwned()) {
                tSDGraph = (TSDGraph)tSGraphMember.getTransformGraph();
                continue;
            }
            return false;
        }
        return tSDGraph != null && !tSDGraph.isHideGraph();
    }

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tbounds = " + this.graphBounds + TSSystem.eol + "\tstaleBounds = " + this.areBoundsStale();
    }

    public void setGeometryChangeNotified(boolean bl) {
        this.graphChangeNotified = bl;
    }

    public boolean isGeometryChangeNotified() {
        return this.graphChangeNotified;
    }

    public boolean isGeometryChangeNotifiedByDefault() {
        return true;
    }
}

