/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSRectangularObjectLabel;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;

public class TSConnectorLabel
extends TSRectangularObjectLabel {
    protected TSConnectorLabel() {
    }

    protected TSConnectorLabel(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    public void setLocalOffset(String string, double d) {
        TSConnector tSConnector = (TSConnector)this.getOwner();
        String string2 = string.toLowerCase();
        if (string2.equals(TSConnector.CONNECTOR_BOTTOM)) {
            this.setLocalOffset(0.0, -1.0, 0.0, -d);
        } else if (string2.equals(TSConnector.CONNECTOR_LEFT)) {
            this.setLocalOffset(-1.0, 0.0, -d, 0.0);
        } else if (string2.equals(TSConnector.CONNECTOR_RIGHT)) {
            this.setLocalOffset(1.0, 0.0, d, 0.0);
        } else if (string2.equals(TSConnector.CONNECTOR_TOP)) {
            this.setLocalOffset(0.0, 1.0, 0.0, d);
        } else {
            this.setDefaultOffset();
        }
    }

    public void setDefaultOffset() {
        this.setLocalOffset(((TSConnector)this.getOwner()).getDefaultLabelDirection(), ((TSConnector)this.getOwner()).getDefaultLabelDistance());
    }

    public TSConstPoint getLocalAttachmentPoint() {
        TSSystem.tsAssert(this.getOwner() != null);
        TSConstPoint tSConstPoint = null;
        TSConnector tSConnector = (TSConnector)this.getOwner();
        if (tSConnector.getShape().contains(this.getLocalCenter())) {
            tSConstPoint = tSConnector.getLocalBounds().getCenter();
        } else if (tSConnector.getLocalWidth() == 0.0 || tSConnector.getLocalHeight() == 0.0) {
            double d = tSConnector.getLocalWidth() == 0.0 ? tSConnector.getLocalCenterX() : (this.getLocalCenterX() - tSConnector.getLocalLeft() <= 0.0 ? tSConnector.getLocalLeft() : (this.getLocalCenterX() - tSConnector.getLocalRight() >= 0.0 ? tSConnector.getLocalRight() : this.getLocalCenterX()));
            double d2 = tSConnector.getLocalHeight() == 0.0 ? tSConnector.getLocalCenterY() : (this.getLocalCenterY() - tSConnector.getLocalBottom() <= 0.0 ? tSConnector.getLocalBottom() : (this.getLocalCenterY() - tSConnector.getLocalTop() >= 0.0 ? tSConnector.getLocalTop() : this.getLocalCenterY()));
            tSConstPoint = new TSConstPoint(d, d2);
        } else {
            tSConstPoint = tSConnector.getShape().intersection(tSConnector.getLocalBounds().getCenterX(), tSConnector.getLocalBounds().getCenterY(), this.getLocalCenterX(), this.getLocalCenterY());
        }
        return tSConstPoint;
    }

    void notifyOwnerOnMove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSConnector tSConnector = (TSConnector)this.getOwner();
            tSConnector.updateConnectorBoundsOnLabelMove(tSConstRect, this.getLocalBounds());
        }
    }

    void notifyOwnerOnResize(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSConnector tSConnector = (TSConnector)this.getOwner();
            tSConnector.updateConnectorBoundsOnLabelResize(tSConstRect, this.getLocalBounds());
        }
    }

    protected void fireLabelMovedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwner() != null && this.getOwner().getOwner().getOwnerGraph() != null && !this.getLocalCenter().equals(tSConstRect.getCenter())) {
            this.getOwner().getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }

    protected void fireLabelResizedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwner() != null && this.getOwner().getOwner().getOwnerGraph() != null && !this.getLocalSize().equals(tSConstRect.getSize())) {
            this.getOwner().getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(131072L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }

    public TSGraph getOwnerGraph() {
        TSGraphObject tSGraphObject = this.getOwner();
        if (tSGraphObject != null && tSGraphObject.getOwner() != null) {
            return (TSGraph)tSGraphObject.getOwner().getOwner();
        }
        return null;
    }
}

