/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.TSMoveControl;
import com.tomsawyer.diagramming.command.gr;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.graph.event.TSEventManager;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSMoveGroupCommand
extends TSCommand {
    df nodeList;
    df pathNodeReferenceList;
    df edgeLabelList;
    df nodeLabelList;
    df connectorLabelList;
    TSConstPoint oldPoint;
    TSConstPoint newPoint;
    List graphs;
    List changedGraphs;
    List margins;

    public TSMoveGroupCommand(List list, List list2, List list3, List list4, List list5, List list6, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        this.oldPoint = tSConstPoint;
        this.newPoint = tSConstPoint2;
        this.nodeList = new df(list2);
        this.edgeLabelList = new df(list4);
        this.nodeLabelList = new df(list5);
        this.connectorLabelList = new df(list6);
        this.graphs = list;
        this.pathNodeReferenceList = new df();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            TSPNode tSPNode = (TSPNode)iterator.next();
            TSDEdge tSDEdge = (TSDEdge)tSPNode.getOwner();
            int n = tSDEdge.getPathNodeIndex(tSPNode);
            gr gr2 = new gr(this, tSDEdge, n);
            this.pathNodeReferenceList.add(gr2);
        }
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        TSMoveControl tSMoveControl = this.newMoveControl();
        tSMoveControl.init(this.graphs, this.nodeList, this.getPathNodes(), this.edgeLabelList, this.nodeLabelList, this.connectorLabelList);
        tSMoveControl.onStartAt(this.oldPoint.getX(), this.oldPoint.getY());
        tSMoveControl.onDropAt(this.newPoint.getX(), this.newPoint.getY());
        this.setAddToUndoStack(tSMoveControl.isSomethingMoved());
    }

    protected TSMoveControl newMoveControl() {
        return new TSMoveControl();
    }

    protected void undoAction() throws Throwable {
        TSMoveControl tSMoveControl = this.newMoveControl();
        tSMoveControl.init(this.graphs, this.nodeList, this.getPathNodes(), this.edgeLabelList, this.nodeLabelList, this.connectorLabelList);
        tSMoveControl.onStartAt(this.newPoint.getX(), this.newPoint.getY());
        TSEventManager tSEventManager = ((TSDGraph)this.graphs.get(0)).getOwnerGraphManager().getEventManager();
        boolean bl = tSEventManager.isFiringVetoableEvents();
        tSEventManager.setFireVetoableEvents(false);
        tSMoveControl.onDropAt(this.oldPoint.getX(), this.oldPoint.getY());
        tSEventManager.setFireVetoableEvents(bl);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        TSMoveControl tSMoveControl = this.newMoveControl();
        tSMoveControl.init(this.graphs, this.nodeList, this.getPathNodes(), this.edgeLabelList, this.nodeLabelList, this.connectorLabelList);
        tSMoveControl.onStartAt(this.oldPoint.getX(), this.oldPoint.getY());
        TSEventManager tSEventManager = ((TSDGraph)this.graphs.get(0)).getOwnerGraphManager().getEventManager();
        boolean bl = tSEventManager.isFiringVetoableEvents();
        tSEventManager.setFireVetoableEvents(false);
        tSMoveControl.onDropAt(this.newPoint.getX(), this.newPoint.getY());
        tSEventManager.setFireVetoableEvents(bl);
    }

    public TSConstPoint getOldPoint() {
        return this.oldPoint;
    }

    public TSConstPoint getNewPoint() {
        return this.newPoint;
    }

    public List getGraphs() {
        return this.graphs;
    }

    public List getNodes() {
        return this.nodeList;
    }

    public List getEdgeLabels() {
        return this.edgeLabelList;
    }

    public List getNodeLabels() {
        return this.nodeLabelList;
    }

    public List getConnectorLabels() {
        return this.connectorLabelList;
    }

    public List getPathNodes() {
        df df2 = new df();
        Iterator iterator = this.pathNodeReferenceList.iterator();
        while (iterator.hasNext()) {
            gr gr2 = (gr)iterator.next();
            TSDEdge tSDEdge = gr2.a();
            int n = gr2.b();
            TSPNode tSPNode = tSDEdge.getPathNodeAt(n);
            df2.add(tSPNode);
        }
        return df2;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)((TSDGraph)this.graphs.get(0)).getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.changedGraphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.changedGraphs, false);
            if (this.changedGraphs != null) {
                Iterator iterator = this.changedGraphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.changedGraphs != null) {
            Iterator iterator = this.changedGraphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    public void setMarginLists(List list, List list2) {
        this.changedGraphs = new Vector(list);
        this.margins = new Vector(list2);
    }

    public boolean isCoalesced() {
        return true;
    }
}

