/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming.adjustment;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.adjustment.TSAdjustmentAfterActionInput;
import com.tomsawyer.diagramming.adjustment.TSAdjustmentAlgorithm;
import com.tomsawyer.diagramming.adjustment.cf;
import com.tomsawyer.diagramming.adjustment.ch;
import com.tomsawyer.diagramming.adjustment.ck;
import com.tomsawyer.diagramming.adjustment.cl;
import com.tomsawyer.diagramming.adjustment.cm;
import com.tomsawyer.diagramming.adjustment.cn;
import com.tomsawyer.diagramming.adjustment.co;
import com.tomsawyer.diagramming.adjustment.cp;
import com.tomsawyer.diagramming.adjustment.cq;
import com.tomsawyer.diagramming.adjustment.cr;
import com.tomsawyer.diagramming.adjustment.gm;
import com.tomsawyer.diagramming.adjustment.gn;
import com.tomsawyer.diagramming.adjustment.go;
import com.tomsawyer.diagramming.adjustment.gp;
import com.tomsawyer.diagramming.adjustment.gq;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.util.TSSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class TSAdjustmentAfterActionAlgorithm {
    private TSAdjustmentAfterActionInput input;
    private Map nodeListMap;
    private List nodeList;
    private Set nodeSet;
    private Set expandedNodeSet;
    private Map nodeBoundsMap;

    public void setInput(TSAdjustmentAfterActionInput tSAdjustmentAfterActionInput) {
        this.input = tSAdjustmentAfterActionInput;
    }

    public TSAdjustmentAfterActionInput getInput() {
        return this.input;
    }

    public void run() {
        TSSystem.tsAssert(this.input != null, "No input data");
        TSSystem.tsAssert(this.input.getGraphManager() != null, "No graph manager");
        TSSystem.tsAssert(this.input.getNodeList() != null, "No list of nodes");
        if (this.input.getActionType() != 4) {
            this.createNodeListPerGraph();
            ArrayList<TSDGraph> arrayList = new ArrayList<TSDGraph>();
            arrayList.add(this.input.getGraphManager().getMainDisplayGraph());
            TSNestingManager.buildAllNestedGraphList(this.input.getGraphManager().getMainDisplayGraph(), arrayList, false);
            this.storeBoundsBeforeAction(arrayList);
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                this.adjustSingleGraph((TSDGraph)listIterator.previous());
            }
        }
    }

    private void createNodeListPerGraph() {
        this.nodeListMap = new HashMap();
        Iterator iterator = this.input.getNodeList().iterator();
        while (iterator.hasNext()) {
            ArrayList<TSGNode> arrayList;
            TSGNode tSGNode = (TSGNode)iterator.next();
            TSDGraph tSDGraph = null;
            if (tSGNode instanceof TSPNode) {
                arrayList = (TSDEdge)tSGNode.getOwner();
                tSDGraph = (TSDGraph)((TSGEdge)((Object)arrayList)).getTransformGraph();
            } else {
                tSDGraph = (TSDGraph)tSGNode.getOwnerGraph();
            }
            arrayList = (List)this.nodeListMap.get(tSDGraph);
            if (arrayList == null) {
                arrayList = new ArrayList<TSGNode>();
                this.nodeListMap.put(tSDGraph, arrayList);
            }
            arrayList.add(tSGNode);
        }
    }

    private void storeBoundsBeforeAction(List list) {
        this.nodeBoundsMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            Iterator iterator2 = cf.a(tSDGraph).iterator();
            while (iterator2.hasNext()) {
                TSGNode tSGNode = (TSGNode)iterator2.next();
                this.nodeBoundsMap.put(tSGNode, new TSConstRect(this.input.getBoundsBeforeAction(tSGNode)));
            }
        }
    }

    private void adjustSingleGraph(TSDGraph tSDGraph) {
        this.nodeList = (List)this.nodeListMap.get(tSDGraph);
        if (this.nodeList == null) {
            this.nodeList = new ArrayList();
        }
        this.nodeSet = new HashSet(this.nodeList);
        this.collectExpandedNodes(tSDGraph);
        if (this.input.getActionType() == 1) {
            this.removeOverlaps(tSDGraph);
            this.compact(tSDGraph);
        } else {
            this.removeOverlaps(tSDGraph);
        }
    }

    private void compact(TSDGraph tSDGraph) {
        boolean bl = this.nodeList.size() <= 10;
        TSAdjustmentAlgorithm tSAdjustmentAlgorithm = null;
        ch ch2 = null;
        if (bl) {
            tSAdjustmentAlgorithm = new cl();
            ch2 = new cm();
        } else {
            tSAdjustmentAlgorithm = new cp();
            ch2 = new cq();
        }
        tSAdjustmentAlgorithm.setInput(ch2);
        ch2.a(tSDGraph);
        if (bl) {
            ((cm)ch2).a(this.input.getSpacing());
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                TSGNode tSGNode = (TSGNode)iterator.next();
                ((cm)ch2).a(tSGNode);
                ((cm)ch2).a((TSConstRect)this.nodeBoundsMap.get(tSGNode));
                tSAdjustmentAlgorithm.run();
            }
        } else {
            ((cq)ch2).a(this.nodeList);
            ((cq)ch2).a(this.nodeBoundsMap);
            ((cq)ch2).a(this.input.getSpacing());
            tSAdjustmentAlgorithm.run();
        }
    }

    private void removeOverlaps(TSDGraph tSDGraph) {
        boolean bl = this.nodeList.size() <= 10;
        TSAdjustmentAlgorithm tSAdjustmentAlgorithm = null;
        ck ck2 = null;
        if (bl) {
            tSAdjustmentAlgorithm = new cn();
            ck2 = new co();
        } else {
            tSAdjustmentAlgorithm = new cr();
            ck2 = new ck();
        }
        tSAdjustmentAlgorithm.setInput(ck2);
        ck2.a(tSDGraph);
        ck2.a(this.input.getSpacing());
        switch (this.input.getActionType()) {
            case 0: {
                ck2.a(new gm(this, null));
                break;
            }
            case 1: {
                ck2.a(new gn(this, null));
                break;
            }
            case 2: {
                ck2.a(new go(this, null));
                break;
            }
            case 3: {
                ck2.a(new gp(this, null));
                break;
            }
            case 5: {
                ck2.a(new gq(this, null));
            }
        }
        if (bl) {
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                ((co)ck2).a((TSGNode)iterator.next());
                tSAdjustmentAlgorithm.run();
            }
        } else {
            tSAdjustmentAlgorithm.run();
        }
    }

    private void collectExpandedNodes(TSDGraph tSDGraph) {
        this.expandedNodeSet = new HashSet();
        Iterator iterator = tSDGraph.nodes().iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isExpanded() || this.nodeSet.contains(tSDNode) || this.input.getBoundsBeforeAction(tSDNode).equals(tSDNode.getLocalBounds())) continue;
            this.nodeList.add(tSDNode);
            this.expandedNodeSet.add(tSDNode);
        }
    }

    private boolean overlapBeforeAction(TSGNode tSGNode, TSGNode tSGNode2) {
        TSConstRect tSConstRect = (TSConstRect)this.nodeBoundsMap.get(tSGNode);
        TSConstRect tSConstRect2 = (TSConstRect)this.nodeBoundsMap.get(tSGNode2);
        return tSConstRect.getLeft() - this.input.getSpacing() < tSConstRect2.getRight() + this.input.getSpacing() && tSConstRect2.getLeft() - this.input.getSpacing() < tSConstRect.getRight() + this.input.getSpacing() && tSConstRect.getBottom() - this.input.getSpacing() < tSConstRect2.getTop() + this.input.getSpacing() && tSConstRect2.getBottom() - this.input.getSpacing() < tSConstRect.getTop() + this.input.getSpacing();
    }

    static /* synthetic */ boolean access$500(TSAdjustmentAfterActionAlgorithm tSAdjustmentAfterActionAlgorithm, TSGNode tSGNode, TSGNode tSGNode2) {
        return tSAdjustmentAfterActionAlgorithm.overlapBeforeAction(tSGNode, tSGNode2);
    }

    static /* synthetic */ Set access$600(TSAdjustmentAfterActionAlgorithm tSAdjustmentAfterActionAlgorithm) {
        return tSAdjustmentAfterActionAlgorithm.nodeSet;
    }
}

