/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSResizeControl {
    public static final int IDLE = 100;
    public static final int RESIZING = 200;
    public static final int DONE = 300;
    public static final int ABORTED = 400;
    public static final int MODE_INVALID = 0;
    public static final int MODE_TOP = 1;
    public static final int MODE_BOTTOM = 2;
    public static final int MODE_RIGHT = 4;
    public static final int MODE_LEFT = 8;
    public static final int MODE_TOP_RIGHT = 5;
    public static final int MODE_TOP_LEFT = 9;
    public static final int MODE_BOTTOM_RIGHT = 6;
    public static final int MODE_BOTTOM_LEFT = 10;
    public static final int INVALID_GRAPPLE = 0;
    public static final int GRAPPLE_N = 1;
    public static final int GRAPPLE_S = 2;
    public static final int GRAPPLE_E = 4;
    public static final int GRAPPLE_W = 8;
    public static final int GRAPPLE_C = 16;
    public static final int GRAPPLE_NE = 5;
    public static final int GRAPPLE_NW = 9;
    public static final int GRAPPLE_SE = 6;
    public static final int GRAPPLE_SW = 10;
    TSSolidGeometricObject sizedGraphObject;
    Vector affectedEdges;
    Vector affectedNodeLabels;
    int mode;
    double newLeft;
    double newRight;
    double newTop;
    double newBottom;
    double oldLeft;
    double oldBottom;
    double oldRight;
    double oldTop;
    double oldOriginalWidth;
    double oldOriginalHeight;
    int state;
    boolean preventResizeInversion;

    public TSResizeControl() {
        this.setGrapple(0);
        this.init(null, 0);
    }

    public void init(TSSolidGeometricObject tSSolidGeometricObject, int n) {
        block6: {
            block5: {
                if (tSSolidGeometricObject == null || !tSSolidGeometricObject.isOwned()) break block5;
                if (n != 0) break block6;
            }
            this.setState(300);
            return;
        }
        this.setResizeMode(n);
        this.sizedGraphObject = tSSolidGeometricObject;
        if (tSSolidGeometricObject instanceof TSDNode) {
            TSDNode tSDNode = (TSDNode)tSSolidGeometricObject;
            this.affectedEdges = new Vector();
            this.affectedEdges.addAll(tSDNode.inEdges());
            this.affectedEdges.addAll(tSDNode.outEdges());
            Iterator iterator = tSDNode.getOwnerGraph().getOwnerGraphManager().intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if ((TSDNode)tSEdge.getSourceNode() != tSDNode && (TSDNode)tSEdge.getTargetNode() != tSDNode || !tSEdge.isViewable()) continue;
                this.affectedEdges.add(tSEdge);
            }
            this.affectedNodeLabels = new Vector();
            this.affectedNodeLabels.addAll(tSDNode.labels());
        }
        this.preventResizeInversion = false;
        this.setState(100);
    }

    public int getGrapple() {
        return this.getResizeMode();
    }

    public int getResizeMode() {
        return this.mode;
    }

    public void onStart() {
        if (this.getState() != 100 || this.sizedGraphObject == null) {
            return;
        }
        this.oldLeft = this.newLeft = this.sizedGraphObject.getLocalLeft();
        this.oldBottom = this.newBottom = this.sizedGraphObject.getLocalBottom();
        this.oldRight = this.newRight = this.sizedGraphObject.getLocalRight();
        this.oldTop = this.newTop = this.sizedGraphObject.getLocalTop();
        if (this.sizedGraphObject instanceof TSDNode) {
            TSDNode tSDNode = (TSDNode)this.sizedGraphObject;
            this.oldOriginalWidth = tSDNode.getLocalOriginalWidth();
            this.oldOriginalHeight = tSDNode.getLocalOriginalHeight();
        }
        this.setState(200);
    }

    public void onDragTo(double d, double d2) {
        if (this.getState() != 200 || this.sizedGraphObject == null) {
            return;
        }
        double d3 = this.newRight - this.newLeft;
        double d4 = this.newTop - this.newBottom;
        int n = this.getResizeMode();
        if ((n & 1) != 0) {
            d4 = d2 - this.newBottom;
        } else if ((n & 2) != 0) {
            d4 = this.newTop - d2;
        }
        if ((n & 8) != 0) {
            d3 = this.newRight - d;
        } else if ((n & 4) != 0) {
            d3 = d - this.newLeft;
        }
        TSSize tSSize = this.adjustSize(d3, d4, null);
        this.assignSize(tSSize);
        TSConstSize tSConstSize = this.sizedGraphObject.getLocalSize();
        if (!this.preventResizeInversion && (d3 < 0.0 || d4 < 0.0)) {
            if (d3 < 0.0) {
                if ((n & 8) != 0) {
                    this.setResizeMode(n ^ 8 | 4);
                    this.newLeft = this.newRight;
                    this.newRight = this.newLeft + tSConstSize.getWidth();
                } else if ((n & 4) != 0) {
                    this.setResizeMode(n ^ 4 | 8);
                    this.newRight = this.newLeft;
                    this.newLeft = this.newRight - tSConstSize.getWidth();
                }
            }
            if (d4 < 0.0) {
                if ((n & 1) != 0) {
                    this.setResizeMode(n ^ 1 | 2);
                    this.newTop = this.newBottom;
                    this.newBottom = this.newTop - tSConstSize.getHeight();
                } else if ((n & 2) != 0) {
                    this.setResizeMode(n ^ 2 | 1);
                    this.newBottom = this.newTop;
                    this.newTop = this.newBottom + tSConstSize.getHeight();
                }
            }
        } else {
            if ((n & 1) != 0) {
                this.newTop = this.newBottom + tSConstSize.getHeight();
            } else if ((n & 2) != 0) {
                this.newBottom = this.newTop - tSConstSize.getHeight();
            }
            if ((n & 8) != 0) {
                this.newLeft = this.newRight - tSConstSize.getWidth();
            } else if ((n & 4) != 0) {
                this.newRight = this.newLeft + tSConstSize.getWidth();
            }
        }
        TSRect tSRect = this.adjustBounds(this.newLeft, this.newBottom, this.newRight, this.newTop, null);
        this.assignBounds(tSRect);
        if (this.sizedGraphObject instanceof TSDNode) {
            TSDNode tSDNode = (TSDNode)this.sizedGraphObject;
            Iterator iterator = this.getAffectedEdges().iterator();
            while (iterator.hasNext()) {
                ((TSDEdge)iterator.next()).ltUpdateBoundsOfLabels();
            }
            tSDNode.ltUpdateBoundsOfLabels();
        }
    }

    public void onDropAt(double d, double d2) {
        if (this.getState() != 200 || this.sizedGraphObject == null) {
            return;
        }
        this.onDragTo(d, d2);
        TSRect tSRect = this.adjustBounds(this.oldLeft, this.oldBottom, this.oldRight, this.oldTop, null);
        this.assignBounds(tSRect);
        TSRect tSRect2 = this.adjustBounds(this.newLeft, this.newBottom, this.newRight, this.newTop, null);
        this.setLocalBounds(tSRect2);
        if (this.affectedEdges != null) {
            this.affectedEdges.clear();
        }
        if (this.affectedNodeLabels != null) {
            this.affectedNodeLabels.clear();
        }
        this.sizedGraphObject = null;
        this.setState(300);
    }

    public void onCancel() {
        if (this.getState() != 200 || this.sizedGraphObject == null) {
            return;
        }
        TSRect tSRect = this.adjustBounds(this.oldLeft, this.oldBottom, this.oldRight, this.oldTop, null);
        this.assignBounds(tSRect);
        if (this.sizedGraphObject instanceof TSDNode) {
            TSDEdge tSDEdge;
            TSDNode tSDNode = (TSDNode)this.sizedGraphObject;
            tSDNode.setLocalOriginalSize(this.oldOriginalWidth, this.oldOriginalHeight);
            Iterator iterator = tSDNode.inEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                tSDEdge.ltUpdateBoundsOfLabels();
            }
            iterator = tSDNode.outEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                tSDEdge.ltUpdateBoundsOfLabels();
            }
            tSDNode.ltUpdateBoundsOfLabels();
        }
        this.setState(400);
    }

    public void setLocalSize(double d, double d2) {
        if (this.getState() != 200 || this.sizedGraphObject == null) {
            return;
        }
        this.sizedGraphObject.setLocalSize(d, d2);
        this.newLeft = this.sizedGraphObject.getLocalLeft();
        this.newTop = this.sizedGraphObject.getLocalTop();
        this.newRight = this.sizedGraphObject.getLocalRight();
        this.newBottom = this.sizedGraphObject.getLocalBottom();
    }

    private TSRect adjustBounds(double d, double d2, double d3, double d4, TSRect tSRect) {
        if (this.sizedGraphObject instanceof TSDNode) {
            tSRect = ((TSDNode)this.sizedGraphObject).adjustBounds(d, d2, d3, d4, tSRect);
        } else if (this.sizedGraphObject instanceof TSLabel) {
            tSRect = ((TSLabel)this.sizedGraphObject).adjustBounds(d, d2, d3, d4, tSRect);
        }
        return tSRect;
    }

    private TSSize adjustSize(double d, double d2, TSSize tSSize) {
        if (this.sizedGraphObject instanceof TSDNode) {
            tSSize = ((TSDNode)this.sizedGraphObject).adjustSize(d, d2, tSSize);
        } else if (this.sizedGraphObject instanceof TSLabel) {
            tSSize = ((TSLabel)this.sizedGraphObject).adjustSize(d, d2, tSSize);
        }
        return tSSize;
    }

    private void setLocalBounds(TSRect tSRect) {
        this.sizedGraphObject.setLocalBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    private void assignBounds(TSRect tSRect) {
        double d = tSRect.getLeft();
        double d2 = tSRect.getBottom();
        double d3 = tSRect.getRight();
        double d4 = tSRect.getTop();
        if (this.sizedGraphObject instanceof TSDNode) {
            ((TSDNode)this.sizedGraphObject).assignBounds(d, d2, d3, d4);
        } else if (this.sizedGraphObject instanceof TSLabel) {
            ((TSLabel)this.sizedGraphObject).assignBounds(d, d2, d3, d4);
        }
    }

    private void assignSize(TSSize tSSize) {
        double d = tSSize.getWidth();
        double d2 = tSSize.getHeight();
        if (this.sizedGraphObject instanceof TSDNode) {
            ((TSDNode)this.sizedGraphObject).assignSize(d, d2);
        } else if (this.sizedGraphObject instanceof TSLabel) {
            ((TSLabel)this.sizedGraphObject).assignSize(d, d2);
        }
    }

    public void reset() {
        if (this.getState() == 400) {
            this.setState(300);
        }
    }

    private void setState(int n) {
        this.state = n;
    }

    private void setGrapple(int n) {
        this.setResizeMode(n);
    }

    private void setResizeMode(int n) {
        this.mode = n;
    }

    public void setPreventResizeInversion(boolean bl) {
        this.preventResizeInversion = bl;
    }

    public boolean getPreventResizeInversion() {
        return this.preventResizeInversion;
    }

    public List getAffectedEdges() {
        return this.affectedEdges;
    }

    public List getAffectedNodeLabels() {
        return this.affectedNodeLabels;
    }

    public int getState() {
        return this.state;
    }

    public TSConstRect getOldBounds() {
        return new TSConstRect(this.oldLeft, this.oldTop, this.oldRight, this.oldBottom);
    }

    public TSConstRect getNewBounds() {
        return new TSConstRect(this.newLeft, this.newTop, this.newRight, this.newBottom);
    }

    public TSConstSize getOldOriginalSize() {
        if (this.sizedGraphObject instanceof TSDNode) {
            return new TSConstSize(this.oldOriginalWidth, this.oldOriginalHeight);
        }
        return null;
    }
}

