/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity.command;

import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSUnhideCommand
extends TSCommand {
    TSDGraph graph;
    List graphList;
    boolean deep;
    List edgeLists;
    List nodeLists;
    List intergraphEdges;
    boolean compressMetaEdges;

    public TSUnhideCommand() {
    }

    public TSUnhideCommand(TSDGraph tSDGraph, boolean bl) {
        this.graph = tSDGraph;
        this.deep = bl;
        this.edgeLists = null;
        this.nodeLists = null;
        this.intergraphEdges = new Vector();
    }

    public TSUnhideCommand(List list, List list2) {
        TSSystem.tsAssert(list != null && list.size() > 0 || list2 != null && list2.size() > 0);
        this.intergraphEdges = new Vector();
        this.nodeLists = new df();
        this.edgeLists = new df();
        if (list != null) {
            this.nodeLists.addAll(list);
        }
        if (list2 != null) {
            this.edgeLists.addAll(list2);
        }
        this.deep = false;
    }

    protected void init() {
        if (this.nodeLists != null && this.edgeLists != null) {
            this.graph = this.nodeLists != null && this.nodeLists.size() != 0 ? ((TSDGraph)((TSDNode)this.nodeLists.get(0)).getOwner()).hideFromGraph() : (TSDGraph)((TSDEdge)this.edgeLists.get(0)).getOwner();
        } else {
            TSHidingManager tSHidingManager = TSHidingManager.getManager((TSDGraphManager)this.graph.getOwner());
            if (!this.deep) {
                this.graphList = null;
                tSHidingManager.getHiddenObjects(this.graph);
                this.nodeLists = new Vector();
                this.edgeLists = new Vector();
                this.nodeLists.addAll(tSHidingManager.getResultNodeList());
                this.edgeLists.addAll(tSHidingManager.getResultEdgeList());
            } else {
                this.graphList = new df();
                TSNestingManager.buildAllNestedGraphList(this.graph, this.graphList, true);
                this.graphList.add(0, this.graph);
                Iterator iterator = this.graphList.iterator();
                this.edgeLists = new Vector();
                this.nodeLists = new Vector();
                while (iterator.hasNext()) {
                    Vector vector = new Vector();
                    Vector vector2 = new Vector();
                    TSDGraph tSDGraph = (TSDGraph)iterator.next();
                    tSHidingManager.getHiddenObjects(tSDGraph);
                    vector2.addAll(tSHidingManager.getResultNodeList());
                    vector.addAll(tSHidingManager.getResultEdgeList());
                    if (vector.size() != 0 || vector2.size() != 0) {
                        this.edgeLists.add(vector);
                        this.nodeLists.add(vector2);
                        continue;
                    }
                    iterator.remove();
                }
            }
            tSHidingManager.clearResultLists();
        }
        this.compressMetaEdges = ((TSDGraphManager)this.graph.getOwner()).getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        if (!this.deep) {
            boolean bl;
            TSGraphMember tSGraphMember;
            Iterator iterator = this.edgeLists.iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDEdge)iterator.next();
                if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(512L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
                iterator.remove();
            }
            iterator = this.nodeLists.iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDNode)iterator.next();
                if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(256L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
                iterator.remove();
            }
            boolean bl2 = bl = !this.nodeLists.isEmpty() || !this.edgeLists.isEmpty();
            if (bl) {
                tSHidingManager.unhide(this.graph, this.nodeLists, this.edgeLists, true);
                this.nodeLists = new Vector();
                this.edgeLists = new Vector();
                this.nodeLists.addAll(tSHidingManager.getResultNodeList());
                this.edgeLists.addAll(tSHidingManager.getResultEdgeList());
                Iterator iterator2 = this.nodeLists.iterator();
                while (iterator2.hasNext()) {
                    TSDNode tSDNode = (TSDNode)iterator2.next();
                    List list = tSDNode.buildIncidentIntergraphEdgeList(true, true, true, true);
                    Iterator iterator3 = list.iterator();
                    while (iterator3.hasNext()) {
                        TSDEdge tSDEdge = (TSDEdge)iterator3.next();
                        if (this.intergraphEdges.contains(tSDEdge)) continue;
                        this.intergraphEdges.add(tSDEdge);
                    }
                }
            } else {
                this.setAddToUndoStack(false);
            }
        } else {
            Iterator iterator = this.graphList.iterator();
            Iterator iterator4 = this.nodeLists.iterator();
            Iterator iterator5 = this.edgeLists.iterator();
            TSDGraph tSDGraph = null;
            List list = null;
            List list2 = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                tSDGraph = (TSDGraph)iterator.next();
                list2 = (List)iterator4.next();
                list = (List)iterator5.next();
                this.preprocessLists(list2, list, (TSDGraphManager)this.graph.getOwnerGraphManager());
                boolean bl3 = !list2.isEmpty() || !list.isEmpty();
                boolean bl4 = bl = bl || bl3;
                if (!bl3) continue;
                tSHidingManager.unhide(tSDGraph, list2, list, true);
                list2 = tSHidingManager.getResultNodeList();
                list = tSHidingManager.getResultEdgeList();
                Iterator iterator6 = list2.iterator();
                while (iterator6.hasNext()) {
                    TSDNode tSDNode = (TSDNode)iterator6.next();
                    List list3 = tSDNode.buildIncidentIntergraphEdgeList(true, true, true, true);
                    Iterator iterator7 = list3.iterator();
                    while (iterator7.hasNext()) {
                        TSDEdge tSDEdge = (TSDEdge)iterator7.next();
                        if (this.intergraphEdges.contains(tSDEdge)) continue;
                        this.intergraphEdges.add(tSDEdge);
                    }
                }
            }
            this.setAddToUndoStack(bl);
        }
        tSHidingManager.clearResultLists();
    }

    protected void preprocessLists(List list, List list2, TSDGraphManager tSDGraphManager) {
        TSGraphMember tSGraphMember;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDEdge)iterator.next();
            if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(512L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
            iterator.remove();
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDNode)iterator.next();
            if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(256L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
            iterator.remove();
        }
    }

    protected void redoAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        if (!this.deep) {
            tSHidingManager.unhide(this.graph, this.nodeLists, this.edgeLists, false);
        } else {
            Iterator iterator = this.graphList.iterator();
            Iterator iterator2 = this.edgeLists.iterator();
            Iterator iterator3 = this.nodeLists.iterator();
            TSDGraph tSDGraph = null;
            while (iterator.hasNext()) {
                tSDGraph = (TSDGraph)iterator.next();
                List list = (List)iterator3.next();
                List list2 = (List)iterator2.next();
                tSHidingManager.unhide(tSDGraph, list, list2, false);
            }
        }
        tSHidingManager.clearResultLists();
    }

    protected void undoAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        if (!this.deep) {
            tSHidingManager.hide(this.graph, this.nodeLists, this.edgeLists);
        } else {
            Iterator iterator = this.graphList.iterator();
            Iterator iterator2 = this.edgeLists.iterator();
            Iterator iterator3 = this.nodeLists.iterator();
            TSDGraph tSDGraph = null;
            while (iterator.hasNext()) {
                tSDGraph = (TSDGraph)iterator.next();
                tSHidingManager.hide(tSDGraph, (List)iterator3.next(), (List)iterator2.next());
            }
        }
        tSHidingManager.clearResultLists();
    }

    public boolean isCoalesced() {
        return true;
    }

    public boolean isOrderPreservedInCoalescing() {
        return true;
    }
}

