/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.ct;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TSCollapseCommand
extends TSCommand {
    List nodeList;
    protected boolean compressMetaEdges;
    List graphs;
    List margins;
    private List oldClippingList = new LinkedList();

    public TSCollapseCommand() {
        this.nodeList = new Vector();
    }

    public TSCollapseCommand(TSDGraph tSDGraph, boolean bl) {
        this.nodeList = new Vector();
        df df2 = new df();
        if (!bl) {
            TSNestingManager.buildNestedGraphList(tSDGraph, df2, false);
        } else {
            TSNestingManager.buildAllNestedGraphList(tSDGraph, df2, false);
        }
        Iterator iterator = df2.iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph2 = (TSDGraph)iterator.next();
            if (!(tSDGraph2.getParent() instanceof TSDNode)) continue;
            TSDNode tSDNode = (TSDNode)tSDGraph2.getParent();
            this.nodeList.add(tSDNode);
        }
        if (this.nodeList.size() == 0) {
            this.setAddToUndoStack(false);
        }
        this.compressMetaEdges = ((TSDGraphManager)tSDGraph.getOwner()).getCompressMetaEdges();
    }

    public TSCollapseCommand(List list) {
        this.nodeList = list != null ? list : new Vector();
        if (this.nodeList.size() == 0) {
            this.setAddToUndoStack(false);
            this.compressMetaEdges = true;
        } else {
            this.compressMetaEdges = ((TSDGraphManager)((TSDNode)this.nodeList.get(0)).getOwner().getOwner()).getCompressMetaEdges();
        }
    }

    public TSCollapseCommand(TSDNode tSDNode) {
        this((List)null);
        this.nodeList.add(tSDNode);
        this.setAddToUndoStack(true);
        this.compressMetaEdges = ((TSDGraphManager)tSDNode.getOwner().getOwner()).getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        TSDGraphManager tSDGraphManager = (TSDGraphManager)((TSDNode)this.nodeList.get(0)).getOwner().getOwner();
        Iterator iterator = this.getNodeList().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.hasChildGraph() || !tSDNode.isExpanded()) continue;
            if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(2L, new TSComplexityChangeEventData(tSDNode, null, null)), true)) {
                this.storeOldClippings(tSDNode);
                TSNestingManager.collapse(tSDNode);
                tSDNode.adjustIncidentClippings();
                bl = true;
                continue;
            }
            iterator.remove();
        }
        this.setAddToUndoStack(bl);
    }

    protected void undoAction() throws Throwable {
        if (!this.nodeList.isEmpty()) {
            Vector vector = new Vector();
            vector.addAll(this.nodeList);
            Collections.reverse(vector);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode = (TSDNode)iterator.next();
                if (!tSDNode.hasChildGraph() || tSDNode.isExpanded()) continue;
                TSNestingManager.expand(tSDNode);
            }
            this.restoreMargins();
            this.restoreOldClippings();
        }
    }

    public boolean isCoalesced() {
        return true;
    }

    protected List getNodeList() {
        return this.nodeList;
    }

    protected boolean isCompressMetaEdges() {
        return this.compressMetaEdges;
    }

    protected void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)((TSDNode)this.nodeList.get(0)).getOwner().getOwner();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    protected void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    protected void storeOldClippings(TSDNode tSDNode) {
        LinkedList<Object> linkedList;
        TSDEdge tSDEdge;
        Iterator iterator = tSDNode.inEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            linkedList = new LinkedList<Object>();
            linkedList.add(tSDEdge);
            linkedList.add(new ct(tSDEdge.getTargetClipping()));
            linkedList.add(new Boolean(false));
            this.oldClippingList.add(linkedList);
        }
        iterator = tSDNode.outEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            linkedList = new LinkedList();
            linkedList.add(tSDEdge);
            linkedList.add(new ct(tSDEdge.getSourceClipping()));
            linkedList.add(new Boolean(true));
            this.oldClippingList.add(linkedList);
        }
        iterator = tSDNode.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            linkedList = new LinkedList();
            linkedList.add(tSDEdge);
            if (tSDEdge.getSourceNode() == tSDNode) {
                linkedList.add(new ct(tSDEdge.getSourceClipping()));
                linkedList.add(new Boolean(true));
            } else if (tSDEdge.getTargetNode() == tSDNode) {
                linkedList.add(new ct(tSDEdge.getTargetClipping()));
                linkedList.add(new Boolean(false));
            }
            this.oldClippingList.add(linkedList);
        }
        iterator = tSDNode.buildIncidentIntergraphEdgeList(true, true, true, true).iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.getSourceNode() == tSDNode) {
                linkedList = new LinkedList();
                linkedList.add(tSDEdge);
                linkedList.add(new ct(tSDEdge.getSourceClipping()));
                linkedList.add(new Boolean(true));
                this.oldClippingList.add(linkedList);
                continue;
            }
            if (tSDEdge.getTargetNode() != tSDNode) continue;
            linkedList = new LinkedList();
            linkedList.add(tSDEdge);
            linkedList.add(new ct(tSDEdge.getTargetClipping()));
            linkedList.add(new Boolean(false));
            this.oldClippingList.add(linkedList);
        }
    }

    protected void restoreOldClippings() {
        Iterator iterator = this.oldClippingList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            TSDEdge tSDEdge = (TSDEdge)list.get(0);
            ct ct2 = (ct)list.get(1);
            Boolean bl = (Boolean)list.get(2);
            if (bl.booleanValue()) {
                tSDEdge.setSourceClipping(ct2);
                continue;
            }
            tSDEdge.setTargetClipping(ct2);
        }
    }
}

