/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity;

import com.tomsawyer.complexity.TSComplexityManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSFindChildParent;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSHidingManager
extends TSComplexityManager {
    private static List managerList = new Vector();

    protected TSHidingManager(TSDGraphManager tSDGraphManager) {
        super(tSDGraphManager);
        if (tSDGraphManager == null) {
            throw new NullPointerException("Cannot create hiding manager, graph manager is null");
        }
        managerList.add(this);
    }

    public void hide(TSDGraph tSDGraph, List list, List list2) {
        f2.a(f2.bf);
        TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager();
        if (tSDGraphManager == this.graphManager && tSDGraphManager != null && !tSDGraph.isHideGraph() && !tSDGraph.isIntergraph() && (list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            df df2 = new df();
            df df3 = new df();
            TSHidingManager.collectListsToBeHidden(tSDGraph, list, list2, df2, df3);
            if (df2.size() > 0 || df3.size() > 0) {
                this.performHide(tSDGraph, df2, df3);
            }
            Iterator iterator = df3.iterator();
            while (iterator.hasNext()) {
                this.onEdgeHidden((TSDEdge)iterator.next());
            }
            Iterator iterator2 = df2.iterator();
            while (iterator2.hasNext()) {
                this.onNodeHidden((TSDNode)iterator2.next());
            }
            this.resultNodeList.clear();
            this.resultNodeList.addAll(df2);
            this.resultEdgeList.clear();
            this.resultEdgeList.addAll(df3);
        }
    }

    static void collectListsToBeHidden(TSDGraph tSDGraph, List list, List list2, List list3, List list4) {
        Object object;
        Object object2;
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TSDNode)object2.next();
                if (((TSNode)object).getOwnerGraph() != tSDGraph || ((TSNode)object).isVisited()) continue;
                list3.add(object);
                ((TSNode)object).setVisited(true);
            }
        }
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                object2 = (TSDEdge)object.next();
                if (((TSEdge)object2).getOwnerGraph() != tSDGraph || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
        }
        if (list3.size() > 0) {
            object = tSDGraph.edges().iterator();
            while (object.hasNext()) {
                object2 = (TSDEdge)object.next();
                if (!((TSEdge)object2).getSourceNode().isVisited() && !((TSEdge)object2).getTargetNode().isVisited() || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDEdge)iterator.next();
                if (!((TSEdge)object2).getSourceNode().isVisited() && !((TSEdge)object2).getTargetNode().isVisited() || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
        }
    }

    void performHide(TSDGraph tSDGraph, List list, List list2) {
        TSDGraph tSDGraph2 = tSDGraph.allocateHideGraph();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            tSDEdge.setTraversed(false);
            tSDGraph.remove(tSDEdge);
            tSDGraph2.insert(tSDEdge);
        }
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator2.next();
            tSDNode.setVisited(false);
            tSDGraph.remove(tSDNode);
            tSDGraph2.insert(tSDNode);
        }
    }

    static TSDGraph newHideGraph(TSDGraph tSDGraph) {
        TSDGraph tSDGraph2 = null;
        if (!tSDGraph.isHideGraph()) {
            if (tSDGraph.hideOrHideFromGraph == null) {
                tSDGraph2 = (TSDGraph)tSDGraph.getOwnerGraphManager().addGraph();
                tSDGraph.getOwnerGraphManager().remove(tSDGraph2);
                tSDGraph2.setViewability(false);
                tSDGraph2.setOwner(tSDGraph);
                tSDGraph2.setOwned(true);
                TSHidingManager.setHideLink(tSDGraph, tSDGraph2);
                TSHidingManager.setHideLink(tSDGraph, tSDGraph2);
            } else {
                tSDGraph2 = tSDGraph.hideOrHideFromGraph;
            }
        } else {
            tSDGraph2 = null;
        }
        return tSDGraph2;
    }

    static void setHideLink(TSDGraph tSDGraph, TSDGraph tSDGraph2) {
        if (!tSDGraph.isHideGraph()) {
            tSDGraph2.setHideGraph(true);
            tSDGraph.hideOrHideFromGraph = tSDGraph2;
            tSDGraph2.hideOrHideFromGraph = tSDGraph;
        }
    }

    public static boolean isHideGraph(TSDGraph tSDGraph) {
        return tSDGraph.isHideGraph();
    }

    public boolean containsHideGraphs(TSDGraph tSDGraph) {
        boolean bl;
        boolean bl2 = bl = tSDGraph.hideGraph() != null;
        if (!bl) {
            List list = null;
            TSNestingManager.buildAllNestedGraphList(tSDGraph, list, false);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                bl = ((TSDGraph)iterator.next()).hideGraph() != null;
            }
        }
        return bl;
    }

    public void unhide(TSDGraph tSDGraph, List list, List list2, boolean bl) {
        f2.a(f2.bf);
        TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager();
        if (tSDGraphManager == this.graphManager && tSDGraphManager != null && tSDGraph.hideGraph() != null && !tSDGraph.isHideGraph() && !tSDGraph.isIntergraph() && (list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            df df2 = new df();
            df df3 = new df();
            this.collectListsToBeUnhidden(tSDGraph, list, list2, df2, df3, bl);
            if (df2.size() > 0 || df3.size() > 0) {
                this.performUnhide(tSDGraph, df2, df3);
            }
            Iterator iterator = df3.iterator();
            while (iterator.hasNext()) {
                this.onEdgeUnhidden((TSDEdge)iterator.next());
            }
            Iterator iterator2 = df2.iterator();
            while (iterator2.hasNext()) {
                this.onNodeUnhidden((TSDNode)iterator2.next());
            }
            this.resultNodeList.clear();
            this.resultNodeList.addAll(df2);
            this.resultEdgeList.clear();
            this.resultEdgeList.addAll(df3);
        }
    }

    void collectListsToBeUnhidden(TSDGraph tSDGraph, List list, List list2, List list3, List list4, boolean bl) {
        Object object;
        Object object2;
        TSDGraph tSDGraph2 = tSDGraph.hideGraph();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TSDNode)object2.next();
                if (((TSNode)object).getOwnerGraph() != tSDGraph2 || ((TSNode)object).isVisited()) continue;
                list3.add(object);
                ((TSNode)object).setVisited(true);
            }
        }
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                object2 = (TSDEdge)object.next();
                if (((TSEdge)object2).getOwnerGraph() != tSDGraph2 || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
        }
        if (bl) {
            TSDNode tSDNode;
            TSDNode tSDNode2;
            object = tSDGraph2.edges().iterator();
            while (object.hasNext()) {
                object2 = (TSDEdge)object.next();
                tSDNode2 = (TSDNode)((TSEdge)object2).getSourceNode();
                tSDNode = (TSDNode)((TSEdge)object2).getTargetNode();
                if (!tSDNode2.isVisited()) {
                    if (TSHidingManager.isHidden(tSDNode2)) continue;
                }
                if (!tSDNode.isVisited()) {
                    if (TSHidingManager.isHidden(tSDNode)) continue;
                }
                if (!tSDNode2.isVisited() && !tSDNode.isVisited() || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
            Iterator iterator = tSDGraph2.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDEdge)iterator.next();
                tSDNode2 = (TSDNode)((TSEdge)object2).getSourceNode();
                tSDNode = (TSDNode)((TSEdge)object2).getTargetNode();
                if (!tSDNode2.isVisited()) {
                    if (TSHidingManager.isHidden(tSDNode2)) continue;
                }
                if (!tSDNode.isVisited()) {
                    if (TSHidingManager.isHidden(tSDNode)) continue;
                }
                if (!tSDNode2.isVisited() && !tSDNode.isVisited() || ((TSEdge)object2).isTraversed()) continue;
                list4.add(object2);
                ((TSEdge)object2).setTraversed(true);
            }
        }
    }

    void performUnhide(TSDGraph tSDGraph, List list, List list2) {
        TSDGraph tSDGraph2 = tSDGraph.hideGraph();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            tSDNode.setVisited(false);
            tSDGraph2.remove(tSDNode);
            tSDGraph.insert(tSDNode);
        }
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator2.next();
            tSDEdge.setTraversed(false);
            tSDGraph2.remove(tSDEdge);
            TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
            TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
            TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager();
            tSDGraphManager.insert(tSDEdge, tSDNode, tSDNode2);
            if (!tSDEdge.isIntergraphEdge() || tSDEdge.isViewable()) continue;
            Vector<TSDEdge> vector = new Vector<TSDEdge>();
            vector.add(tSDEdge);
        }
    }

    public void unhideAll(TSDGraph tSDGraph) {
        if (!(tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null || tSDGraph.hideGraph().numberOfNodes() == 0 && tSDGraph.hideGraph().numberOfEdges() == 0 && tSDGraph.hideGraph().numberOfDisconnectedEdges() == 0)) {
            this.unhide(tSDGraph, tSDGraph.hideGraph().nodes(), tSDGraph.hideGraph().disconnectedEdges(), true);
        }
    }

    public static boolean isHidden(TSDNode tSDNode) {
        boolean bl = false;
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
        while (!bl && tSDGraph != null) {
            if (tSDGraph.isHideGraph()) {
                bl = true;
                continue;
            }
            if (tSDGraph.getParent() != null) {
                tSDGraph = (TSDGraph)tSDGraph.getParent().getOwner();
                continue;
            }
            tSDGraph = null;
        }
        return bl;
    }

    public static boolean isHidden(TSDEdge tSDEdge) {
        boolean bl = false;
        TSDGraph tSDGraph = (TSDGraph)tSDEdge.getOwnerGraph();
        while (!bl && tSDGraph != null) {
            if (tSDGraph.isHideGraph()) {
                bl = true;
                continue;
            }
            if (tSDGraph.getParent() != null) {
                tSDGraph = (TSDGraph)tSDGraph.getParent().getOwner();
                continue;
            }
            tSDGraph = null;
        }
        return bl;
    }

    public TSDGraph hideGraph(TSDGraph tSDGraph) {
        return tSDGraph.hideGraph();
    }

    public TSDGraph hideFromGraph(TSDGraph tSDGraph) {
        return tSDGraph.hideFromGraph();
    }

    public void setHideGraph(TSDGraph tSDGraph, boolean bl) {
        tSDGraph.setHideGraph(bl);
    }

    public TSDEdge unhideIncidentEdge(TSDNode tSDNode, TSDEdge tSDEdge) {
        TSDEdge tSDEdge2 = null;
        if (tSDEdge != null && tSDNode.getOwnerGraph() != null && (tSDEdge.getSourceNode() == tSDNode || tSDEdge.getTargetNode() == tSDNode)) {
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwner();
            TSDGraph tSDGraph2 = tSDGraph.hideGraph();
            TSDNode tSDNode2 = null;
            tSDNode2 = tSDEdge.getSourceNode() == tSDNode ? (TSDNode)tSDEdge.getTargetNode() : (TSDNode)tSDEdge.getSourceNode();
            df df2 = new df();
            df df3 = new df();
            if (tSDNode2 != null && tSDNode2.getOwnerGraph() == tSDGraph2) {
                df2.add(tSDNode2);
            }
            if (tSDEdge.getOwnerGraph() == tSDGraph2) {
                df3.add(tSDEdge);
            }
            this.unhide(tSDGraph, df2, df3, false);
            if (TSHidingManager.isHidden(tSDEdge)) {
                tSDEdge2 = tSDEdge;
            }
        }
        return tSDEdge2;
    }

    public void findHiddenIncidentEdgeList(TSDNode tSDNode) {
        this.resultEdgeList.clear();
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceNode() != tSDNode && tSDEdge.getTargetNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    public void findHiddenIncidentIncomingEdgeList(TSDNode tSDNode) {
        this.resultEdgeList.clear();
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getTargetNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    public void findHiddenIncidentOutgoingEdgeList(TSDNode tSDNode) {
        this.resultEdgeList.clear();
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    public boolean hasHiddenIncidentEdges(TSDNode tSDNode) {
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceNode() != tSDNode && tSDEdge.getTargetNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasHiddenIncidentOutgoingEdges(TSDNode tSDNode) {
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasHiddenIncidentIncomingEdges(TSDNode tSDNode) {
        TSDGraph tSDGraph = this.hideGraph((TSDGraph)tSDNode.getOwnerGraph());
        if (tSDGraph != null) {
            Iterator iterator = tSDGraph.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getTargetNode() != tSDNode || !TSHidingManager.isHidden(tSDEdge)) continue;
                return true;
            }
        }
        return false;
    }

    public void hideChildren(TSDNode tSDNode, int n) {
        this.resultNodeList.clear();
        this.resultEdgeList.clear();
        tSDNode.findChildren(this.resultNodeList, this.resultEdgeList, n);
        this.hide((TSDGraph)tSDNode.getOwner(), this.resultNodeList, null);
    }

    public void unhideChildren(TSDNode tSDNode, int n) {
        this.findHiddenChildren(tSDNode, n);
        this.unhide((TSDGraph)tSDNode.getOwner(), this.resultNodeList, null, true);
    }

    public void hideParents(TSDNode tSDNode, int n) {
        tSDNode.findParents(this.resultNodeList, this.resultEdgeList, n);
        this.hide((TSDGraph)tSDNode.getOwner(), this.resultNodeList, null);
    }

    public void unhideParents(TSDNode tSDNode, int n) {
        this.findHiddenParents(tSDNode, n);
        this.unhide((TSDGraph)tSDNode.getOwner(), this.resultNodeList, null, true);
    }

    public static boolean hasHiddenNodes(TSDGraph tSDGraph) {
        return tSDGraph.hideGraph() != null && tSDGraph.hideGraph().numberOfNodes() > 0;
    }

    public static boolean hasHiddenEdges(TSDGraph tSDGraph) {
        TSDGraph tSDGraph2 = tSDGraph.hideGraph();
        return tSDGraph2 != null && tSDGraph2.numberOfEdges() + tSDGraph2.numberOfDisconnectedEdges() > 0;
    }

    public void getHiddenObjects(TSDGraph tSDGraph) {
        TSDGraph tSDGraph2 = tSDGraph.hideGraph();
        this.resultNodeList.clear();
        this.resultEdgeList.clear();
        if (tSDGraph2 == null) {
            return;
        }
        this.resultNodeList.addAll(tSDGraph2.nodes());
        this.resultEdgeList.addAll(tSDGraph2.edges());
        this.resultEdgeList.addAll(tSDGraph2.disconnectedEdges());
    }

    public void onNodeHidden(TSDNode tSDNode) {
        TSDGraph tSDGraph = ((TSDGraph)tSDNode.getOwnerGraph()).hideFromGraph();
        tSDGraph.fireEvent(new TSComplexityChangeEvent(64L, new TSComplexityChangeEventData(tSDNode, null, null)));
    }

    public void onEdgeHidden(TSDEdge tSDEdge) {
        TSDGraph tSDGraph = ((TSDGraph)tSDEdge.getOwnerGraph()).hideFromGraph();
        tSDGraph.fireEvent(new TSComplexityChangeEvent(128L, new TSComplexityChangeEventData(tSDEdge, null, null)));
    }

    public void onNodeUnhidden(TSDNode tSDNode) {
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
        tSDGraph.fireEvent(new TSComplexityChangeEvent(256L, new TSComplexityChangeEventData(tSDNode, null, null)));
    }

    public void onEdgeUnhidden(TSDEdge tSDEdge) {
        TSDGraph tSDGraph = (TSDGraph)tSDEdge.getOwnerGraph();
        tSDGraph.fireEvent(new TSComplexityChangeEvent(512L, new TSComplexityChangeEventData(tSDEdge, null, null)));
    }

    public boolean hasHiddenObjects() {
        boolean bl = false;
        Iterator iterator = this.graphManager.graphs(bl).iterator();
        TSDGraph tSDGraph = null;
        while (iterator.hasNext()) {
            tSDGraph = (TSDGraph)iterator.next();
            if (tSDGraph.hideGraph() == null || tSDGraph.hideGraph().numberOfNodes() == 0 && tSDGraph.hideGraph().numberOfEdges() == 0 && tSDGraph.hideGraph().numberOfDisconnectedEdges() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasHiddenViewableObjects() {
        boolean bl = false;
        Iterator iterator = this.graphManager.graphs(bl).iterator();
        TSDGraph tSDGraph = null;
        while (iterator.hasNext()) {
            tSDGraph = (TSDGraph)iterator.next();
            if (tSDGraph.hideGraph() == null || tSDGraph.hideGraph().numberOfNodes() == 0 && tSDGraph.hideGraph().numberOfEdges() == 0 && tSDGraph.hideGraph().numberOfDisconnectedEdges() == 0 || !tSDGraph.isViewable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHiddenChildren(TSDNode tSDNode) {
        boolean bl = false;
        this.resultNodeList.clear();
        this.resultEdgeList.clear();
        this.findHiddenChildren(tSDNode, -2L);
        if (this.resultNodeList.size() != 0) {
            bl = true;
            this.resultNodeList.clear();
        }
        return bl;
    }

    public boolean hasHiddenParents(TSDNode tSDNode) {
        boolean bl = false;
        this.resultNodeList.clear();
        this.resultEdgeList.clear();
        this.findHiddenParents(tSDNode, -2L);
        if (this.resultNodeList.size() != 0) {
            bl = true;
            this.resultNodeList.clear();
        }
        return bl;
    }

    public boolean hasHiddenNeighbors(TSDNode tSDNode) {
        return this.hasHiddenNeighbors(tSDNode, -2L);
    }

    public boolean hasHiddenNeighbors(TSDNode tSDNode, long l) {
        boolean bl = false;
        this.resultNodeList.clear();
        this.resultEdgeList.clear();
        this.findHiddenNeighbors(tSDNode, l);
        if (!this.resultNodeList.isEmpty() || !this.resultEdgeList.isEmpty()) {
            bl = true;
            this.resultNodeList.clear();
            this.resultEdgeList.clear();
        }
        return bl;
    }

    public void findHiddenAndUnhiddenChildren(TSDNode tSDNode, long l) {
        if (tSDNode.getOwnerGraph() != null) {
            this.clearResultLists();
            this.findChildrenAndOrParentsInBothGraphs(tSDNode, tSDNode.findType(1), this.resultNodeList, this.resultEdgeList, l);
        }
    }

    public void findHiddenAndUnhiddenParents(TSDNode tSDNode, long l) {
        if (tSDNode.getOwnerGraph() != null) {
            this.clearResultLists();
            this.findChildrenAndOrParentsInBothGraphs(tSDNode, tSDNode.findType(2), this.resultNodeList, this.resultEdgeList, l);
        }
    }

    public void findHiddenChildren(TSDNode tSDNode, long l) {
        if (tSDNode.getOwnerGraph() != null && ((TSDGraph)tSDNode.getOwner()).hideGraph() != null) {
            df df2 = new df();
            df df3 = new df();
            this.findChildrenAndOrParentsInBothGraphs(tSDNode, tSDNode.findType(1), df2, df3, l);
            this.resultNodeList.clear();
            Iterator iterator = df2.iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode2 = (TSDNode)iterator.next();
                if (!TSHidingManager.isHidden(tSDNode2)) continue;
                this.resultNodeList.add(tSDNode2);
            }
            this.resultEdgeList.clear();
            Iterator iterator2 = df3.iterator();
            while (iterator2.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    public void findHiddenParents(TSDNode tSDNode, long l) {
        if (tSDNode.getOwnerGraph() != null && ((TSDGraph)tSDNode.getOwner()).hideGraph() != null) {
            df df2 = new df();
            df df3 = new df();
            this.findChildrenAndOrParentsInBothGraphs(tSDNode, tSDNode.findType(2), df2, df3, l);
            this.resultNodeList.clear();
            Iterator iterator = df2.iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode2 = (TSDNode)iterator.next();
                if (!TSHidingManager.isHidden(tSDNode2)) continue;
                this.resultNodeList.add(tSDNode2);
            }
            this.resultEdgeList.clear();
            Iterator iterator2 = df3.iterator();
            while (iterator2.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    public void findHiddenNeighbors(TSDNode tSDNode, long l) {
        if (tSDNode.getOwnerGraph() != null && ((TSDGraph)tSDNode.getOwner()).hideGraph() != null) {
            df df2 = new df();
            df df3 = new df();
            this.findChildrenAndOrParentsInBothGraphs(tSDNode, tSDNode.findType(3), df2, df3, l);
            this.resultNodeList.clear();
            Iterator iterator = df2.iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode2 = (TSDNode)iterator.next();
                if (!TSHidingManager.isHidden(tSDNode2)) continue;
                this.resultNodeList.add(tSDNode2);
            }
            this.resultEdgeList.clear();
            Iterator iterator2 = df3.iterator();
            while (iterator2.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                if (!TSHidingManager.isHidden(tSDEdge)) continue;
                this.resultEdgeList.add(tSDEdge);
            }
        }
    }

    void findChildrenAndOrParentsInBothGraphs(TSDNode tSDNode, int n, List list, List list2, long l) {
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwner();
        if (tSDGraph != null) {
            TSDGraph tSDGraph2 = tSDGraph.isHideGraph() ? tSDGraph.hideFromGraph() : tSDGraph.hideGraph();
            if (list != null || list2 != null) {
                TSFindChildParent tSFindChildParent = new TSFindChildParent(tSDGraph, tSDNode, list, list2, l, tSDGraph2, n);
                tSFindChildParent.run();
            }
        }
    }

    public static TSHidingManager getManager(TSDGraphManager tSDGraphManager) {
        TSHidingManager tSHidingManager = TSHidingManager.hasManager(tSDGraphManager);
        if (tSHidingManager == null) {
            tSHidingManager = new TSHidingManager(tSDGraphManager);
        }
        return tSHidingManager;
    }

    protected static TSHidingManager hasManager(TSDGraphManager tSDGraphManager) {
        Iterator iterator = managerList.iterator();
        TSHidingManager tSHidingManager = null;
        while (iterator.hasNext() && tSHidingManager == null) {
            TSHidingManager tSHidingManager2 = (TSHidingManager)iterator.next();
            if (tSHidingManager2.getGraphManager() != tSDGraphManager) continue;
            tSHidingManager = tSHidingManager2;
        }
        return tSHidingManager;
    }

    public static void discardManager(TSDGraphManager tSDGraphManager) {
        TSHidingManager tSHidingManager = TSHidingManager.hasManager(tSDGraphManager);
        if (tSHidingManager != null) {
            managerList.remove(tSHidingManager);
        }
    }

    public static void clearManagerList() {
        managerList = new Vector();
    }
}

