/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.algorithm.geometric.intervaltree;

import com.tomsawyer.algorithm.geometric.intervaltree.TSConstInterval;
import com.tomsawyer.algorithm.geometric.intervaltree.br;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TSIntervalTree {
    private br root;

    public TSIntervalTree(List list) {
        double[] dArray = this.getMidpoints(list);
        this.root = this.createSubtree(dArray, 0, dArray.length - 1);
    }

    public boolean add(TSConstInterval tSConstInterval) {
        br br2 = this.getCoveredTreeNode(tSConstInterval);
        boolean bl = false;
        if (br2 != null) {
            bl = br2.d().add(tSConstInterval) && br2.e().add(tSConstInterval);
        }
        return bl;
    }

    public boolean remove(TSConstInterval tSConstInterval) {
        br br2 = this.getCoveredTreeNode(tSConstInterval);
        boolean bl = false;
        if (br2 != null) {
            bl = br2.d().remove(tSConstInterval) && br2.e().remove(tSConstInterval);
        }
        return bl;
    }

    public List getIntersectedIntervals(TSConstInterval tSConstInterval) {
        ArrayList arrayList = new ArrayList();
        br br2 = this.root;
        while (br2 != null && (tSConstInterval.getMax() < br2.a() || tSConstInterval.getMin() > br2.a())) {
            if (tSConstInterval.getMax() < br2.a()) {
                this.getMinIntersectedIntervals(br2, tSConstInterval.getMax(), arrayList);
                br2 = br2.b();
                continue;
            }
            this.getMaxIntersectedIntervals(br2, tSConstInterval.getMin(), arrayList);
            br2 = br2.c();
        }
        if (br2 != null) {
            this.getIntervals(br2, arrayList);
            br br3 = br2.b();
            while (br3 != null) {
                if (tSConstInterval.getMin() <= br3.a()) {
                    this.getIntervals(br3, arrayList);
                    this.getIntervalsRecursive(br3.c(), arrayList);
                    br3 = br3.b();
                    continue;
                }
                this.getMaxIntersectedIntervals(br3, tSConstInterval.getMin(), arrayList);
                br3 = br3.c();
            }
            br br4 = br2.c();
            while (br4 != null) {
                if (tSConstInterval.getMax() >= br4.a()) {
                    this.getIntervals(br4, arrayList);
                    this.getIntervalsRecursive(br4.b(), arrayList);
                    br4 = br4.c();
                    continue;
                }
                this.getMinIntersectedIntervals(br4, tSConstInterval.getMax(), arrayList);
                br4 = br4.b();
            }
        }
        return arrayList;
    }

    public List getContainingIntervals(double d) {
        ArrayList arrayList = new ArrayList();
        br br2 = this.root;
        while (br2 != null) {
            if (d <= br2.a()) {
                this.getMinIntersectedIntervals(br2, d, arrayList);
                br2 = br2.b();
                continue;
            }
            this.getMaxIntersectedIntervals(br2, d, arrayList);
            br2 = br2.c();
        }
        return arrayList;
    }

    private double[] getMidpoints(List list) {
        int n;
        double[] dArray = new double[list.size()];
        Iterator iterator = list.iterator();
        for (n = 0; n < dArray.length; ++n) {
            TSConstInterval tSConstInterval = (TSConstInterval)iterator.next();
            dArray[n] = (tSConstInterval.getMin() + tSConstInterval.getMax()) / 2.0;
        }
        Arrays.sort(dArray);
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0 && dArray[i - 1] == dArray[i]) continue;
            ++n;
        }
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0 && dArray[i - 1] == dArray[i]) continue;
            dArray2[n2] = dArray[i];
            ++n2;
        }
        return dArray2;
    }

    private br createSubtree(double[] dArray, int n, int n2) {
        br br2 = null;
        if (n <= n2) {
            int n3 = (n + n2) / 2;
            br2 = new br(dArray[n3], this.createSubtree(dArray, n, n3 - 1), this.createSubtree(dArray, n3 + 1, n2));
        }
        return br2;
    }

    private br getCoveredTreeNode(TSConstInterval tSConstInterval) {
        br br2 = this.root;
        while (br2 != null && (tSConstInterval.getMax() < br2.a() || tSConstInterval.getMin() > br2.a())) {
            if (tSConstInterval.getMax() < br2.a()) {
                br2 = br2.b();
                continue;
            }
            br2 = br2.c();
        }
        return br2;
    }

    private void getMinIntersectedIntervals(br br2, double d, List list) {
        Iterator iterator = br2.d().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            TSConstInterval tSConstInterval = (TSConstInterval)iterator.next();
            if (tSConstInterval.getMin() > d) {
                bl = true;
                continue;
            }
            list.add(tSConstInterval);
        }
    }

    private void getMaxIntersectedIntervals(br br2, double d, List list) {
        Iterator iterator = br2.e().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            TSConstInterval tSConstInterval = (TSConstInterval)iterator.next();
            if (tSConstInterval.getMax() < d) {
                bl = true;
                continue;
            }
            list.add(tSConstInterval);
        }
    }

    private void getIntervals(br br2, List list) {
        if (br2 != null) {
            list.addAll(br2.d());
        }
    }

    private void getIntervalsRecursive(br br2, List list) {
        if (br2 != null) {
            this.getIntervals(br2, list);
            this.getIntervalsRecursive(br2.b(), list);
            this.getIntervalsRecursive(br2.c(), list);
        }
    }
}

