/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.spi.AutomaticExtraClasspathProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntSettings {
    private static final String PROP_VERBOSITY = "verbosity";
    private static final String PROP_PROPERTIES = "properties";
    private static final String PROP_SAVE_ALL = "saveAll";
    private static final String PROP_CUSTOM_DEFS = "customDefs";
    public static final String PROP_ANT_HOME = "antHome";
    public static final String PROP_EXTRA_CLASSPATH = "extraClasspath";
    public static final String PROP_AUTOMATIC_EXTRA_CLASSPATH = "automaticExtraClasspath";
    private static final String PROP_AUTO_CLOSE_TABS = "autoCloseTabs";
    private static final String PROP_ALWAYS_SHOW_OUTPUT = "alwaysShowOutput";
    private static IntrospectedInfo customDefs;
    private static String antVersion;
    private static File defaultAntHome;
    private static List<File> defAECP;
    private static Lookup.Result<AutomaticExtraClasspathProvider> aecpResult;
    private static final PropertyChangeSupport pcs;

    private AntSettings() {
    }

    private static Preferences prefs() {
        return NbPreferences.forModule(AntSettings.class);
    }

    public static int getVerbosity() {
        return AntSettings.prefs().getInt(PROP_VERBOSITY, 2);
    }

    public static void setVerbosity(int n) {
        AntSettings.prefs().putInt(PROP_VERBOSITY, n);
    }

    public static Map<String, String> getProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : AntSettings.prefs().get(PROP_PROPERTIES, "build.compiler.emacs=true").split("\n")) {
            String[] stringArray = string.split("=", 2);
            if (stringArray.length != 2) {
                Logger.getLogger(AntSettings.class.getName()).warning("Unexpected name=value pair: '" + string + "'");
                continue;
            }
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    public static void setProperties(Map<String, String> map) {
        if (!(map instanceof SortedMap)) {
            map = new TreeMap<String, String>(map);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
        }
        AntSettings.prefs().put(PROP_PROPERTIES, stringBuilder.toString());
    }

    public static boolean getSaveAll() {
        return AntSettings.prefs().getBoolean(PROP_SAVE_ALL, true);
    }

    public static void setSaveAll(boolean bl) {
        AntSettings.prefs().putBoolean(PROP_SAVE_ALL, bl);
    }

    public static synchronized IntrospectedInfo getCustomDefs() {
        if (customDefs == null) {
            customDefs = IntrospectedInfoSerializer.instance.load(AntSettings.prefs().node(PROP_CUSTOM_DEFS));
        }
        return customDefs;
    }

    public static synchronized void setCustomDefs(IntrospectedInfo introspectedInfo) {
        IntrospectedInfoSerializer.instance.store(AntSettings.prefs().node(PROP_CUSTOM_DEFS), introspectedInfo);
        customDefs = introspectedInfo;
    }

    public static String getAntVersion() {
        if (antVersion == null) {
            antVersion = AntBridge.getInterface().getAntVersion();
        }
        return antVersion;
    }

    private static synchronized File getDefaultAntHome() {
        if (defaultAntHome == null) {
            File file = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (file == null) {
                return null;
            }
            defaultAntHome = file.getParentFile().getParentFile();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("getDefaultAntHome: " + defaultAntHome);
            }
        }
        assert (defaultAntHome != null);
        return defaultAntHome;
    }

    public static File getAntHome() {
        String string = AntSettings.prefs().get(PROP_ANT_HOME, null);
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("getAntHomeWithDefault: antHome=" + string);
        }
        if (string != null) {
            return new File(string);
        }
        return AntSettings.getDefaultAntHome();
    }

    public static void setAntHome(File file) {
        if (file != null && file.equals(AntSettings.getDefaultAntHome())) {
            file = null;
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("setAntHome: " + file);
        }
        if (file != null) {
            AntSettings.prefs().put(PROP_ANT_HOME, file.getAbsolutePath());
        } else {
            AntSettings.prefs().remove(PROP_ANT_HOME);
        }
        antVersion = null;
        AntSettings.firePropertyChange(PROP_ANT_HOME);
    }

    public static List<File> getExtraClasspath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : AntSettings.prefs().get(PROP_EXTRA_CLASSPATH, "").split(Pattern.quote(File.pathSeparator))) {
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    public static void setExtraClasspath(List<File> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(file);
        }
        AntSettings.prefs().put(PROP_EXTRA_CLASSPATH, stringBuilder.toString());
        AntSettings.firePropertyChange(PROP_EXTRA_CLASSPATH);
    }

    public static synchronized List<File> getAutomaticExtraClasspath() {
        if (aecpResult == null) {
            aecpResult = Lookup.getDefault().lookupResult(AutomaticExtraClasspathProvider.class);
            aecpResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    defAECP = null;
                    AntSettings.firePropertyChange(AntSettings.PROP_AUTOMATIC_EXTRA_CLASSPATH);
                }
            });
        }
        if (defAECP == null) {
            defAECP = new ArrayList<File>();
            for (AutomaticExtraClasspathProvider automaticExtraClasspathProvider : aecpResult.allInstances()) {
                defAECP.addAll(Arrays.asList(automaticExtraClasspathProvider.getClasspathItems()));
            }
        }
        return defAECP;
    }

    public static boolean getAutoCloseTabs() {
        return AntSettings.prefs().getBoolean(PROP_AUTO_CLOSE_TABS, true);
    }

    public static void setAutoCloseTabs(boolean bl) {
        AntSettings.prefs().putBoolean(PROP_AUTO_CLOSE_TABS, bl);
    }

    public static boolean getAlwaysShowOutput() {
        return AntSettings.prefs().getBoolean(PROP_ALWAYS_SHOW_OUTPUT, false);
    }

    public static void setAlwaysShowOutput(boolean bl) {
        AntSettings.prefs().putBoolean(PROP_ALWAYS_SHOW_OUTPUT, bl);
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private static void firePropertyChange(String string) {
        pcs.firePropertyChange(string, null, null);
    }

    static {
        new IntrospectedInfo();
        defaultAntHome = null;
        defAECP = null;
        aecpResult = null;
        pcs = new PropertyChangeSupport(AntSettings.class);
    }

    public static abstract class IntrospectedInfoSerializer {
        public static IntrospectedInfoSerializer instance;

        public abstract IntrospectedInfo load(Preferences var1);

        public abstract void store(Preferences var1, IntrospectedInfo var2);
    }
}

