/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.multiview.mapper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.netbeans.modules.xslt.core.XSLTDataEditorSupport;
import org.netbeans.modules.xslt.core.XSLTDataObject;
import org.netbeans.modules.xslt.core.multiview.mapper.MapperPasteAction;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.mapper.palette.XsltPaletteFactory;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class MapperMultiViewElement
extends TopComponent
implements MultiViewElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient MultiViewElementCallback myMultiViewObserver;
    private transient XsltMapper myMapperView;
    private transient InstanceContent nodesHack;
    private XSLTDataObject myDataObject;
    private transient JComponent myToolBarPanel;
    private static Boolean groupVisible = null;
    private PropertyChangeListener myActiveNodeChangeListener;

    private MapperMultiViewElement() {
    }

    public MapperMultiViewElement(XSLTDataObject xSLTDataObject) {
        this.myDataObject = xSLTDataObject;
        this.initializeLookup();
        this.initializeUI();
    }

    private void removeActiveNodeChangeListener() {
        if (this.myActiveNodeChangeListener != null) {
            this.removePropertyChangeListener(this.myActiveNodeChangeListener);
        }
        this.myActiveNodeChangeListener = null;
    }

    private void initActiveNodeChangeListener() {
        if (this.myActiveNodeChangeListener == null) {
            this.myActiveNodeChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("activatedNodes")) {
                        TopComponent topComponent = TopComponent.getRegistry().getActivated();
                        MapperMultiViewElement.this.nodesHack.set((Collection)Collections.EMPTY_LIST, null);
                        MapperMultiViewElement.this.nodesHack.set(Arrays.asList(MapperMultiViewElement.this.getActivatedNodes()), null);
                    }
                }
            };
        } else {
            this.removePropertyChangeListener(this.myActiveNodeChangeListener);
        }
        this.addPropertyChangeListener(this.myActiveNodeChangeListener);
        this.setActivatedNodes(new Node[0]);
        this.setActivatedNodes(new Node[]{this.getDataObject().getNodeDelegate()});
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myDataObject = (XSLTDataObject)((Object)objectInput.readObject());
        this.initializeLookup();
        this.initializeUI();
    }

    private GridBagConstraints createGBConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        return gridBagConstraints;
    }

    public int getPersistenceType() {
        return 2;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        XSLTDataEditorSupport xSLTDataEditorSupport = this.myDataObject.getEditorSupport();
        boolean bl2 = xSLTDataEditorSupport.isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", null, null);
    }

    public void componentActivated() {
        super.componentActivated();
        this.addUndoManager();
    }

    public void componentClosed() {
        super.componentClosed();
        this.myMapperView = null;
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
        if (this.myMapperView != null) {
            this.myMapperView.setVisible(false);
        }
        MapperMultiViewElement.updateXsltTcGroupVisibility(false);
        this.removeActiveNodeChangeListener();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.myMapperView != null) {
            this.myMapperView.setVisible(true);
        }
        this.addUndoManager();
        MapperMultiViewElement.updateXsltTcGroupVisibility(true);
        this.initActiveNodeChangeListener();
    }

    public JComponent getToolbarRepresentation() {
        if (this.myToolBarPanel == null) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            int n = 0;
            for (Component component : jToolBar.getComponents()) {
                if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
                n = Math.max(component.getPreferredSize().height, n);
            }
            for (Component component : jToolBar.getComponents()) {
                Dimension dimension;
                if (component instanceof JButton || component instanceof JToggleButton) {
                    dimension = component.getMaximumSize();
                    dimension.height = n;
                    component.setMaximumSize(dimension);
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JTextComponent) {
                    component.setMaximumSize(component.getPreferredSize());
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JSlider) {
                    dimension = component.getMaximumSize();
                    dimension.width = 160;
                    component.setMaximumSize(dimension);
                    dimension = component.getPreferredSize();
                    dimension.width = 160;
                    component.setPreferredSize(dimension);
                    continue;
                }
                component.setMinimumSize(component.getPreferredSize());
            }
            this.myToolBarPanel = jToolBar;
        }
        return this.myToolBarPanel;
    }

    public UndoRedo getUndoRedo() {
        return this.getDataObject().getEditorSupport().getUndoManager();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected boolean closeLast() {
        return true;
    }

    private XsltMapper createMapperView() {
        return new XsltMapper(this.getLookup());
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.myMapperView = this.createMapperView();
        this.add((Component)this.myMapperView, "Center");
        this.setVisible(true);
    }

    private static void updateXsltTcGroupVisibility(boolean bl) {
        WindowManager windowManager = WindowManager.getDefault();
        TopComponentGroup topComponentGroup = windowManager.findTopComponentGroup("xslt_mapper");
        if (topComponentGroup == null) {
            return;
        }
        boolean bl2 = false;
        for (Mode mode : windowManager.getModes()) {
            String string;
            MultiViewPerspective multiViewPerspective;
            MultiViewHandler multiViewHandler;
            TopComponent topComponent = mode.getSelectedTopComponent();
            if (topComponent == null || (multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent)) == null || (multiViewPerspective = multiViewHandler.getSelectedPerspective()) == null || !"xslt-mapper".equals(string = multiViewPerspective.preferredID())) continue;
            bl2 = true;
            break;
        }
        if (bl2 && !Boolean.TRUE.equals(groupVisible)) {
            topComponentGroup.open();
        } else if (!bl2 && !Boolean.FALSE.equals(groupVisible)) {
            topComponentGroup.close();
        }
        groupVisible = bl2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getMVEditorActivePanelPrefferedId() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective != null) {
            return multiViewPerspective.preferredID();
        }
        return null;
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private XSLTDataObject getDataObject() {
        return this.myDataObject;
    }

    private void initializeLookup() {
        this.associateLookup(this.createAssociateLookup());
        this.initActiveNodeChangeListener();
    }

    private Lookup createAssociateLookup() {
        MapperContext mapperContext = (MapperContext)this.myDataObject.getLookup().lookup(MapperContext.class);
        if (mapperContext != null) {
            // empty if block
        }
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", null);
        actionMap.put("cut-to-clipboard", null);
        actionMap.put("paste-from-clipboard", (Action)SystemAction.get(MapperPasteAction.class));
        this.nodesHack = new InstanceContent();
        return new ProxyLookup(new Lookup[]{this.myDataObject.getLookup(), Lookups.fixed((Object[])new Object[]{this.getDataObject().getLookup(), this.getDataObject().getNodeDelegate(), actionMap, new AbstractLookup((AbstractLookup.Content)this.nodesHack), XsltPaletteFactory.getPalette()})});
    }

    private void addUndoManager() {
        XSLTDataEditorSupport xSLTDataEditorSupport = this.myDataObject.getEditorSupport();
        if (xSLTDataEditorSupport != null) {
            QuietUndoManager quietUndoManager = xSLTDataEditorSupport.getUndoManager();
            xSLTDataEditorSupport.addUndoManagerToModel(quietUndoManager);
        }
    }
}

