/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;

public class ValidateXSLSupport
implements ValidateXMLCookie {
    private final InputSource inputSource;
    private CookieObserver console;
    private int fatalErrors;
    private int errors;

    public ValidateXSLSupport(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateXML(CookieObserver cookieObserver) {
        try {
            this.console = cookieObserver;
            boolean bl = false;
            boolean bl2 = false;
            String string = this.inputSource.getSystemId();
            this.sendMessage(NbBundle.getMessage(ValidateXSLSupport.class, (String)"MSG_checking", (Object)string));
            XslErrorListener xslErrorListener = new XslErrorListener();
            try {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                sAXTransformerFactory.setErrorListener(xslErrorListener);
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(new SAXSource(this.inputSource));
            }
            catch (TransformerException transformerException) {
                CookieMessage cookieMessage = new CookieMessage(transformerException.getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail(transformerException));
                this.sendMessage(cookieMessage);
            }
            boolean bl3 = !bl2 && !bl;
            return bl3;
        }
        finally {
            this.console = null;
        }
    }

    private void sendMessage(String string) {
        if (this.console != null) {
            this.console.receive(new CookieMessage(string));
        }
    }

    private void sendMessage(CookieMessage cookieMessage) {
        if (this.console != null) {
            this.console.receive(cookieMessage);
        }
    }

    private class XslErrorListener
    implements ErrorListener {
        private XslErrorListener() {
        }

        public void error(TransformerException transformerException) throws TransformerException {
            if (ValidateXSLSupport.this.errors++ == this.getMaxErrorCount()) {
                ValidateXSLSupport.this.sendMessage(NbBundle.getMessage(ValidateXSLSupport.class, (String)"MSG_too_many_errs"));
                throw transformerException;
            }
            CookieMessage cookieMessage = new CookieMessage(transformerException.getLocalizedMessage(), 2, (Object)new DefaultXMLProcessorDetail(transformerException));
            ValidateXSLSupport.this.sendMessage(cookieMessage);
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            ValidateXSLSupport.this.fatalErrors++;
            CookieMessage cookieMessage = new CookieMessage(transformerException.getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail(transformerException));
            ValidateXSLSupport.this.sendMessage(cookieMessage);
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            CookieMessage cookieMessage = new CookieMessage(transformerException.getLocalizedMessage(), 1, (Object)new DefaultXMLProcessorDetail(transformerException));
            ValidateXSLSupport.this.sendMessage(cookieMessage);
        }

        private int getMaxErrorCount() {
            return 20;
        }
    }
}

