/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.CreateTableDDL;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.netbeans.modules.db.explorer.dlg.TypeElement;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.util.TextFieldValidator;
import org.netbeans.modules.db.util.ValidableTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CreateTableDialog {
    boolean result = false;
    Dialog dialog = null;
    JTextField dbnamefield;
    JTextField dbownerfield;
    JTable table;
    JComboBox ownercombo;
    JButton addbtn;
    JButton delbtn;
    Specification spec;
    private Vector ttab;
    private static Map dlgtab = null;
    private static final String filename = "org/netbeans/modules/db/resources/CreateTableDialog.plist";
    private ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private static Logger LOGGER = Logger.getLogger(CreateTableDialog.class.getName());

    public static final Map getProperties() {
        if (dlgtab == null) {
            try {
                ClassLoader classLoader = CreateTableDialog.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(filename);
                if (inputStream == null) {
                    String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_UnableToOpenStream"), filename);
                    throw new Exception(string);
                }
                PListReader pListReader = new PListReader(inputStream);
                dlgtab = pListReader.getData();
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dlgtab = null;
            }
        }
        return dlgtab;
    }

    public CreateTableDialog(Specification specification, DatabaseNodeInfo databaseNodeInfo) throws SQLException {
        this.spec = specification;
        try {
            Object object;
            Object object22;
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            jPanel.setMinimumSize(new Dimension(200, 100));
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.bundle.getString("CreateTableName"));
            jLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableNameA11yDesc"));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.dbnamefield = new JTextField(this.bundle.getString("CreateTableUntitledName"), 10);
            this.dbnamefield.setToolTipText(this.bundle.getString("ACS_CreateTableNameTextFieldA11yDesc"));
            this.dbnamefield.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableNameTextFieldA11yName"));
            jLabel.setLabelFor(this.dbnamefield);
            gridBagLayout.setConstraints(this.dbnamefield, gridBagConstraints);
            jPanel.add(this.dbnamefield);
            jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.bundle.getString("CreateTableOwner"));
            jLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableOwnerA11yDesc"));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 10, 2, 2);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            Vector<String> vector = new Vector<String>();
            String string = databaseNodeInfo.getDriverSpecification().getSchema();
            if (string != null && string.length() > 0) {
                vector.add(string);
            } else {
                vector.add(" ");
            }
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.ownercombo = new JComboBox(vector);
            this.ownercombo.setSelectedIndex(0);
            this.ownercombo.setRenderer(new ListCellRendererImpl());
            this.ownercombo.setToolTipText(this.bundle.getString("ACS_CreateTableOwnerComboBoxA11yDesc"));
            this.ownercombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableOwnerComboBoxA11yName"));
            jLabel.setLabelFor(this.ownercombo);
            gridBagLayout.setConstraints(this.ownercombo, gridBagConstraints);
            jPanel.add(this.ownercombo);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.table = new DataTable(new DataModel());
            this.table.setAutoResizeMode(0);
            this.table.setToolTipText(this.bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            this.table.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableColumnTableA11yName"));
            this.table.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            JScrollPane jScrollPane = new JScrollPane(this.table);
            jScrollPane.setBorder(new BevelBorder(1));
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
            Map map = this.spec.getTypeMap();
            this.ttab = new Vector(map.size());
            for (Object object22 : map.keySet()) {
                object = (String)map.get(object22);
                this.ttab.add(new TypeElement((String)object22, (String)object));
            }
            object22 = new JComboBox(this.ttab);
            ((JComboBox)object22).setSelectedIndex(0);
            this.table.setDefaultEditor(String.class, new DataCellEditor(new JTextField()));
            this.table.getColumn("type").setCellEditor(new ComboBoxEditor((JComboBox)object22));
            this.table.getColumn("size").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            this.table.getColumn("scale").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            this.table.setRowHeight(((JComponent)object22).getPreferredSize().height);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(2, 8, 2, 2);
            object = new JPanel();
            GridLayout gridLayout = new GridLayout(2, 1, 0, 5);
            ((Container)object).setLayout(gridLayout);
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            jPanel.add((Component)object);
            this.addbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addbtn, (String)this.bundle.getString("CreateTableAddButtonTitle"));
            this.addbtn.setToolTipText(this.bundle.getString("ACS_CreateTableAddButtonTitleA11yDesc"));
            ((Container)object).add(this.addbtn);
            this.addbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                    ColumnItem columnItem = new ColumnItem();
                    columnItem.setProperty("type", CreateTableDialog.this.ttab.elementAt(0));
                    dataModel.addRow(columnItem);
                }
            });
            this.delbtn = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.delbtn, (String)this.bundle.getString("CreateTableRemoveButtonTitle"));
            this.delbtn.setToolTipText(this.bundle.getString("ACS_CreateTableRemoveButtonTitleA11yDesc"));
            ((Container)object).add(this.delbtn);
            this.delbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    if ((n = CreateTableDialog.this.table.getSelectedRow()) != -1) {
                        ((DataModel)CreateTableDialog.this.table.getModel()).removeRow(n);
                    }
                }
            });
            ActionListener actionListener = new ActionListener((JComboBox)object22){
                final /* synthetic */ JComboBox val$combo;
                {
                    this.val$combo = jComboBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    final ActionEvent actionEvent2 = actionEvent;
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            if (actionEvent2.getSource() == DialogDescriptor.OK_OPTION) {
                                String string;
                                CreateTableDialog.this.result = CreateTableDialog.this.validate();
                                CommandBuffer commandBuffer = new CommandBuffer();
                                Vector vector = new Vector();
                                if (!CreateTableDialog.this.result) {
                                    string = CreateTableDialog.this.bundle.getString("EXC_InsufficientCreateTableInfo");
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                                }
                                try {
                                    string = CreateTableDialog.this.getTableName();
                                    DataModel dataModel = (DataModel)CreateTableDialog.this.table.getModel();
                                    Vector vector2 = dataModel.getData();
                                    String string2 = ((String)CreateTableDialog.this.ownercombo.getSelectedItem()).trim();
                                    CreateTableDDL createTableDDL = new CreateTableDDL(CreateTableDialog.this.spec, string2, string);
                                    boolean bl = createTableDDL.execute(vector2, dataModel.getTablePrimaryKeys());
                                    val$combo.setSelectedItem(val$combo.getSelectedItem());
                                    if (!bl) {
                                        CreateTableDialog.this.dialog.setVisible(false);
                                        CreateTableDialog.this.dialog.dispose();
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }, 0);
                }
            };
            jPanel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableDialogA11yDesc"));
            this.addbtn.doClick();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, this.bundle.getString("CreateTableDialogTitle"), true, actionListener);
            Object[] objectArray = new Object[]{DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor.setClosingOptions(objectArray);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setResizable(true);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
    }

    public boolean run() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        return this.result;
    }

    public String getTableName() {
        return this.dbnamefield.getText();
    }

    private boolean validate() {
        String string = this.getTableName();
        if (string == null || string.length() < 1) {
            return false;
        }
        Vector vector = ((DataModel)this.table.getModel()).getData();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (((ColumnItem)enumeration.nextElement()).validate()) continue;
            return false;
        }
        return true;
    }

    private static final class ListCellRendererImpl
    extends DefaultListCellRenderer {
        private ListCellRendererImpl() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (Utilities.isWindows()) {
                dimension.width += 4;
            }
            return dimension;
        }
    }

    class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(final JComboBox jComboBox) {
            super(jComboBox);
            jComboBox.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    SwingUtilities.invokeLater(new PopupInvoker(jComboBox));
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            });
        }
    }

    class PopupInvoker
    implements Runnable {
        private JComboBox jComboBox;

        public PopupInvoker(JComboBox jComboBox) {
            this.jComboBox = jComboBox;
        }

        public void run() {
            try {
                this.jComboBox.showPopup();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    class DataCellEditor
    extends DefaultCellEditor {
        static final long serialVersionUID = 3855371868128838794L;

        public DataCellEditor(JTextField jTextField) {
            super(jTextField);
            this.setClickCountToStart(1);
        }
    }

    class FocusInvoker
    implements Runnable {
        private JTextField xxx;

        public FocusInvoker(JTextField jTextField) {
            this.xxx = jTextField;
        }

        public void run() {
            this.xxx.selectAll();
        }
    }

    class DataTable
    extends JTable {
        static final long serialVersionUID = 1222037401669064863L;

        public DataTable(TableModel tableModel) {
            super(tableModel);
            this.setSurrendersFocusOnKeystroke(true);
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableModel.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                Map map = ColumnItem.getColumnProperty(i);
                tableColumn.setIdentifier(map.get("name"));
                String string = CreateTableDialog.this.bundle.getString("CreateTable_" + i);
                int n3 = new Double(this.getFontMetrics(this.getFont()).getStringBounds(string, this.getGraphics()).getWidth()).intValue() + 20;
                if (map.containsKey("width")) {
                    if ((Integer)map.get("width") < n3) {
                        tableColumn.setPreferredWidth(n3);
                    } else {
                        tableColumn.setPreferredWidth((Integer)map.get("width"));
                    }
                    int n4 = tableColumn.getPreferredWidth();
                }
                if (map.containsKey("minwidth")) {
                    if ((Integer)map.get("minwidth") < n3) {
                        tableColumn.setMinWidth(n3);
                    } else {
                        tableColumn.setMinWidth((Integer)map.get("minwidth"));
                    }
                }
                if (i >= 7) continue;
                n2 += tableColumn.getPreferredWidth();
            }
            n2 = Math.min(Math.max(n2, 380), Toolkit.getDefaultToolkit().getScreenSize().width - 100);
            this.setPreferredScrollableViewportSize(new Dimension(n2, 150));
        }
    }
}

