/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class ConnectAction
extends DatabaseAction {
    static final long serialVersionUID = -6822218300035053411L;
    ConnectionDialog dlg;
    boolean advancedPanel = false;
    boolean okPressed = false;

    protected boolean enable(Node[] nodeArray) {
        DatabaseNodeInfo databaseNodeInfo;
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo2 = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        if (databaseNodeInfo2 != null && (databaseNodeInfo = databaseNodeInfo2.getParent("connection")) != null) {
            return databaseNodeInfo.getConnection() == null;
        }
        return false;
    }

    protected int mode() {
        return 4;
    }

    public void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)databaseNodeInfo.getParent("connection");
        new ConnectionDialogDisplayer().showDialog(connectionNodeInfo, false);
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;
        boolean failed = false;

        public void showDialog(final ConnectionNodeInfo connectionNodeInfo, boolean bl) {
            String string = connectionNodeInfo.getUser();
            String string2 = connectionNodeInfo.getPassword();
            Boolean bl2 = (Boolean)connectionNodeInfo.get("rememberpwd");
            boolean bl3 = bl2 != null ? bl2 : false;
            final DatabaseConnection databaseConnection = connectionNodeInfo.getDatabaseConnection();
            ExceptionListener exceptionListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        Logger.getLogger("global").log(Level.INFO, null, exception.getCause());
                    } else {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(DbUtilities.formatError(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            databaseConnection.addExceptionListener(exceptionListener);
            if (string == null || !bl3 || bl) {
                final ConnectPanel connectPanel = new ConnectPanel(this, databaseConnection);
                final SchemaPanel schemaPanel = new SchemaPanel(this, databaseConnection);
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                            schemaPanel.setSchemas(new Vector(), "");
                            schemaPanel.resetProgress();
                            try {
                                Connection connection = databaseConnection.getConnection();
                                if (connection != null && !connection.isClosed()) {
                                    connection.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                };
                connectPanel.addPropertyChangeListener(propertyChangeListener);
                PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                            ConnectionDialogDisplayer.this.fireConnectionStarted();
                        }
                        if (propertyChangeEvent.getPropertyName().equals("failed")) {
                            ConnectionDialogDisplayer.this.fireConnectionFailed();
                        }
                        if (propertyChangeEvent.getPropertyName().equals("connected")) {
                            if (ConnectionDialogDisplayer.this.advancedPanel && !ConnectionDialogDisplayer.this.okPressed) {
                                if (ConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, databaseConnection, connectionNodeInfo.getSchema())) {
                                    databaseConnection.setSchema(connectionNodeInfo.getSchema());
                                }
                                ConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                                ConnectionDialogDisplayer.this.fireConnectionFinished();
                                return;
                            }
                            ConnectionDialogDisplayer.this.fireConnectionFinished();
                            databaseConnection.setSchema(connectionNodeInfo.getSchema());
                            try {
                                connectionNodeInfo.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                            }
                            catch (DatabaseException databaseException) {
                                Logger.getLogger("global").log(Level.INFO, null, databaseException);
                                DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                return;
                            }
                            DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
                            if (databaseConnection2 != null) {
                                databaseConnection2.setPassword(databaseConnection.getPassword());
                                databaseConnection2.setRememberPassword(databaseConnection.rememberPassword());
                            }
                            connectionNodeInfo.put("rememberpwd", (Object)connectPanel.rememberPassword());
                            if (connectPanel.rememberPassword()) {
                                connectionNodeInfo.put("rememberpwd", (Object)Boolean.TRUE);
                            }
                            if (ConnectionDialogDisplayer.this.dlg != null) {
                                ConnectionDialogDisplayer.this.dlg.close();
                            }
                        } else {
                            ConnectionDialogDisplayer.this.okPressed = false;
                        }
                    }
                };
                databaseConnection.addPropertyChangeListener(propertyChangeListener2);
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                            block8: {
                                ConnectionDialogDisplayer.this.okPressed = true;
                                connectionNodeInfo.setUser(connectPanel.getUser());
                                connectionNodeInfo.setPassword(connectPanel.getPassword());
                                databaseConnection.setUser(connectPanel.getUser());
                                databaseConnection.setPassword(connectPanel.getPassword());
                                databaseConnection.setRememberPassword(connectPanel.rememberPassword());
                                try {
                                    if (databaseConnection.getConnection() == null || databaseConnection.getConnection().isClosed()) {
                                        databaseConnection.connect();
                                        break block8;
                                    }
                                    databaseConnection.setSchema(schemaPanel.getSchema());
                                    connectionNodeInfo.setSchema(schemaPanel.getSchema());
                                    try {
                                        connectionNodeInfo.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                                    }
                                    catch (DatabaseException databaseException) {
                                        Logger.getLogger("global").log(Level.INFO, null, databaseException);
                                        DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                        return;
                                    }
                                    DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
                                    if (databaseConnection2 != null) {
                                        databaseConnection2.setPassword(databaseConnection.getPassword());
                                        databaseConnection2.setRememberPassword(connectPanel.rememberPassword());
                                    }
                                    connectionNodeInfo.put("rememberpwd", (Object)connectPanel.rememberPassword());
                                    if (ConnectionDialogDisplayer.this.dlg != null) {
                                        ConnectionDialogDisplayer.this.dlg.close();
                                    }
                                }
                                catch (SQLException sQLException) {
                                    databaseConnection.connect();
                                }
                            }
                            return;
                        }
                    }
                };
                ChangeListener changeListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(schemaPanel)) {
                            ConnectionDialogDisplayer.this.advancedPanel = true;
                            connectionNodeInfo.setUser(connectPanel.getUser());
                            connectionNodeInfo.setPassword(connectPanel.getPassword());
                            databaseConnection.setPassword(connectPanel.getPassword());
                        } else {
                            ConnectionDialogDisplayer.this.advancedPanel = false;
                        }
                    }
                };
                this.dlg = new ConnectionDialog(this, connectPanel, schemaPanel, connectPanel.getTitle(), new HelpCtx("db_save_password"), actionListener, changeListener);
                this.dlg.setVisible(true);
            } else {
                try {
                    DialogDescriptor dialogDescriptor = null;
                    ProgressHandle progressHandle = null;
                    progressHandle = ProgressHandleFactory.createHandle((String)"handle");
                    JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                    jComponent.setPreferredSize(new Dimension(350, 20));
                    ConnectProgressDialog connectProgressDialog = new ConnectProgressDialog(jComponent);
                    dialogDescriptor = new DialogDescriptor((Object)connectProgressDialog, DatabaseAction.bundle().getString("ConnectingDialogTitle"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
                    final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName().equals("connected")) {
                                try {
                                    connectionNodeInfo.finishConnect(null, databaseConnection, databaseConnection.getConnection());
                                    if (dialog == null) return;
                                    dialog.setVisible(false);
                                    return;
                                }
                                catch (DatabaseException databaseException) {
                                    Logger.getLogger("global").log(Level.INFO, null, databaseException);
                                    DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), databaseException.getMessage());
                                    return;
                                }
                            } else {
                                if (!propertyChangeEvent.getPropertyName().equals("failed")) return;
                                if (dialog != null) {
                                    dialog.setVisible(false);
                                }
                                ConnectionDialogDisplayer.this.failed = true;
                            }
                        }
                    };
                    this.failed = false;
                    databaseConnection.addPropertyChangeListener(propertyChangeListener);
                    databaseConnection.connect();
                    progressHandle.start();
                    progressHandle.switchToIndeterminate();
                    dialog.setVisible(true);
                    progressHandle.finish();
                    dialog.dispose();
                    if (this.failed) {
                        this.showDialog(connectionNodeInfo, true);
                    }
                }
                catch (Exception exception) {
                    String string3 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exception.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
                    this.showDialog(connectionNodeInfo, true);
                }
            }
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet = databaseConnection.getConnection().getMetaData().getSchemas();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }
    }
}

