/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.DbURLClassLoader;

public class DbDriverManager {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.db.explorer.DbDriverManager");
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final DbDriverManager DEFAULT = new DbDriverManager();
    private Set registeredDrivers;
    private Map conn2Driver = new WeakHashMap();
    private Map driver2Loader = new WeakHashMap();

    private DbDriverManager() {
    }

    public static DbDriverManager getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, Properties properties, JDBCDriver jDBCDriver) throws SQLException {
        Driver driver;
        if (LOG) {
            LOGGER.log(Level.FINE, "Attempting to connect to '" + string + "'");
        }
        if ((driver = this.getDriverInternal(string, jDBCDriver, false)) != null) {
            Connection connection;
            if (driver.getClass().getName().equals("com.mysql.jdbc.Driver")) {
                properties.put("useUnicode", "true");
                properties.put("characterEncoding", "utf8");
            }
            if ((connection = driver.connect(string, properties)) == null) {
                if (LOG) {
                    LOGGER.log(Level.FINE, driver.getClass().getName() + ".connect() returned null");
                }
                throw this.createDriverNotFoundException();
            }
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(connection, driver);
            }
            return connection;
        }
        try {
            Connection connection = DriverManager.getConnection(string, properties);
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(connection, null);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw this.createDriverNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getSameDriverConnection(Connection connection, String string, Properties properties) throws SQLException {
        if (connection == null) {
            throw new NullPointerException();
        }
        Driver driver = null;
        Object object = this.conn2Driver;
        synchronized (object) {
            if (!this.conn2Driver.containsKey(connection)) {
                throw new IllegalArgumentException("A connection not obtained through DbDriverManager was passed.");
            }
            driver = (Driver)this.conn2Driver.get(connection);
        }
        if (driver != null) {
            object = driver.connect(string, properties);
            if (object == null) {
                throw new SQLException("Unable to connect using existingConn's original driver", "08001");
            }
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(object, driver);
            }
            return object;
        }
        return DriverManager.getConnection(string, properties);
    }

    public synchronized void registerDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            this.registeredDrivers = new HashSet();
        }
        this.registeredDrivers.add(driver);
    }

    public synchronized void deregisterDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            return;
        }
        this.registeredDrivers.remove(driver);
    }

    public Driver getDriver(String string, JDBCDriver jDBCDriver) throws SQLException {
        Driver driver = this.getDriverInternal(string, jDBCDriver, true);
        if (driver == null) {
            throw this.createDriverNotFoundException();
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getDriverInternal(String string, JDBCDriver jDBCDriver, boolean bl) throws SQLException {
        Object object = this;
        synchronized (object) {
            if (this.registeredDrivers != null) {
                for (Object object2 : this.registeredDrivers) {
                    try {
                        if (!object2.acceptsURL(string)) continue;
                        return object2;
                    }
                    catch (SQLException sQLException) {
                    }
                }
            }
        }
        if (jDBCDriver != null) {
            object = this.getClassLoader(jDBCDriver);
            try {
                return (Driver)Class.forName(jDBCDriver.getClassName(), true, (ClassLoader)object).newInstance();
            }
            catch (Exception exception) {
                Object object2;
                object2 = this.createDriverNotFoundException();
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
        if (bl) {
            try {
                return DriverManager.getDriver(string);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(JDBCDriver jDBCDriver) {
        ClassLoader classLoader = null;
        Map map = this.driver2Loader;
        synchronized (map) {
            classLoader = (ClassLoader)this.driver2Loader.get(jDBCDriver);
            if (classLoader == null) {
                classLoader = new DbURLClassLoader(jDBCDriver.getURLs());
                if (LOG) {
                    LOGGER.log(Level.FINE, "Creating " + classLoader);
                }
                this.driver2Loader.put(jDBCDriver, classLoader);
            } else if (LOG) {
                LOGGER.log(Level.FINE, "Reusing " + classLoader);
            }
        }
        return classLoader;
    }

    private SQLException createDriverNotFoundException() {
        return new SQLException("Unable to find a suitable driver", "08001");
    }
}

