/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public class ConnectionList {
    private static ConnectionList DEFAULT;
    private Lookup.Result result = this.getLookupResult();
    private List listeners = new ArrayList(1);

    public static synchronized ConnectionList getDefault() {
        if (DEFAULT == null) {
            DatabaseConnectionConvertor.importOldConnections();
            RootNodeInfo.getOption().save();
            DEFAULT = new ConnectionList();
        }
        return DEFAULT;
    }

    private ConnectionList() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ConnectionList.this.fireListeners();
            }
        });
    }

    public DatabaseConnection[] getConnections() {
        Collection collection = this.result.allInstances();
        return collection.toArray(new DatabaseConnection[collection.size()]);
    }

    public DatabaseConnection getConnection(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        DatabaseConnection[] databaseConnectionArray = this.getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            if (!databaseConnection.equals(databaseConnectionArray[i])) continue;
            return databaseConnectionArray[i];
        }
        return null;
    }

    public void add(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.create(databaseConnection);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    public boolean contains(DatabaseConnection databaseConnection) {
        return this.getConnection(databaseConnection) != null;
    }

    public void remove(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.remove(databaseConnection);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener connectionListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(connectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        ArrayList arrayList;
        List list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList(this.listeners);
        }
        for (ConnectionListener connectionListener : arrayList) {
            connectionListener.connectionsChanged();
        }
    }

    private synchronized Lookup.Result getLookupResult() {
        return Lookups.forPath((String)"Databases/Connections").lookupResult(DatabaseConnection.class);
    }
}

