/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.compapp.projects.common.CatalogWSDL;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xdm.xam.XDMAccessProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class XAMCatalogWSDLSerializer
extends CatalogWSDL.CatalogWSDLSerializer {
    private static final Logger sLogger = Logger.getLogger(XAMCatalogWSDLSerializer.class.getName());
    private static ModelSourceProvider sModelSourceProvider = new ModelSourceProvider();

    static void setModelSourceProvider(ModelSourceProvider modelSourceProvider) {
        sLogger.fine("new MessageSourceProvider set");
        sModelSourceProvider = modelSourceProvider;
    }

    static ModelSourceProvider getModelSourceProvider() {
        if (sModelSourceProvider == null) {
            sModelSourceProvider = new ModelSourceProvider();
        }
        return sModelSourceProvider;
    }

    public void marshall(CatalogWSDL catalogWSDL, FileObject fileObject) throws IOException {
        this.saveCatalogWSDL(catalogWSDL, fileObject);
    }

    public CatalogWSDL unmarshall(FileObject fileObject) throws IOException {
        CatalogWSDL catalogWSDL = null;
        Definitions definitions = this.loadCatalogWSDLDefinitions(fileObject);
        catalogWSDL = this.loadCatalogWSDL(definitions);
        return catalogWSDL;
    }

    private Definitions loadCatalogWSDLDefinitions(FileObject fileObject) {
        try {
            ModelSource modelSource = XAMCatalogWSDLSerializer.getModelSourceProvider().getModelSource(fileObject, true);
            WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
            Definitions definitions = wSDLModel.getDefinitions();
            return definitions;
        }
        catch (CatalogModelException catalogModelException) {
            sLogger.log(Level.WARNING, catalogModelException.getMessage(), catalogModelException);
            return null;
        }
    }

    private void addXSDEntries(CatalogWSDL catalogWSDL, Definitions definitions) {
        Object object;
        Collection collection = definitions.getTypes().getSchemas();
        Schema schema = null;
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            object = (Schema)iterator.next();
            schema = object;
        }
        if (schema != null) {
            iterator = schema.getImports();
            object = iterator.iterator();
            while (object.hasNext()) {
                org.netbeans.modules.xml.schema.model.Import import_ = (org.netbeans.modules.xml.schema.model.Import)object.next();
                CatalogWSDL.Entry entry = new CatalogWSDL.Entry(CatalogWSDL.EntryType.XSD);
                entry.setNamespace(import_.getNamespace());
                entry.setLocation(import_.getSchemaLocation());
                catalogWSDL.addEntry(entry);
            }
        }
    }

    private void addWSDLEntries(CatalogWSDL catalogWSDL, Definitions definitions) {
        Collection collection = definitions.getImports();
        for (Import import_ : collection) {
            CatalogWSDL.Entry entry = new CatalogWSDL.Entry(CatalogWSDL.EntryType.WSDL);
            entry.setNamespace(import_.getNamespace());
            entry.setLocation(import_.getLocation());
            catalogWSDL.addEntry(entry);
        }
    }

    private CatalogWSDL loadCatalogWSDL(Definitions definitions) throws IOException {
        CatalogWSDL catalogWSDL = new CatalogWSDL();
        if (!"catalog".equalsIgnoreCase(definitions.getName()) || !"http://soa.netbeans.org/wsdl/catalog".equals(definitions.getTargetNamespace())) {
            throw new IOException("Not a CATALOG WSDL File");
        }
        this.addWSDLEntries(catalogWSDL, definitions);
        this.addXSDEntries(catalogWSDL, definitions);
        return catalogWSDL;
    }

    protected void addNamespacePrefix(WSDLModel wSDLModel, String string) {
        String string2 = null;
        String string3 = "ns";
        Map map = null;
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)wSDLModel.getDefinitions();
        map = abstractDocumentComponent.getPrefixes();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (map.containsKey(string3 + i)) continue;
            string2 = string3 + i;
            abstractDocumentComponent.addPrefix(string2, string);
            break;
        }
    }

    private void addEntryAsSchemaImport(Definitions definitions, CatalogWSDL.Entry entry) {
        Object object;
        WSDLModel wSDLModel = definitions.getModel();
        Types types = definitions.getTypes();
        if (types == null) {
            types = wSDLModel.getFactory().createTypes();
            definitions.setTypes(types);
        }
        Schema schema = null;
        Collection collection = types.getSchemas();
        if (collection == null || collection.size() == 0) {
            object = wSDLModel.getFactory().createWSDLSchema();
            types.addExtensibilityElement((ExtensibilityElement)object);
            schema = object.getSchemaModel().getSchema();
            schema.setTargetNamespace("http://soa.netbeans.org/wsdl/catalog");
        } else {
            object = collection.iterator();
            if (object.hasNext()) {
                Schema schema2;
                schema = schema2 = (Schema)object.next();
            }
        }
        object = schema.getModel().getFactory().createImport();
        object.setNamespace(entry.getNamesapce());
        object.setSchemaLocation(entry.getLocation());
        schema.addExternalReference((SchemaModelReference)object);
        this.addNamespacePrefix(wSDLModel, entry.getNamesapce());
    }

    private void addEntryAsWSDLImport(Definitions definitions, CatalogWSDL.Entry entry) {
        WSDLModel wSDLModel = definitions.getModel();
        Import import_ = wSDLModel.getFactory().createImport();
        import_.setNamespace(entry.getNamesapce());
        import_.setLocation(entry.getLocation());
        definitions.addImport(import_);
        this.addNamespacePrefix(wSDLModel, entry.getNamesapce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCatalogWSDL(CatalogWSDL catalogWSDL, FileObject fileObject) throws IOException {
        Definitions definitions = this.loadCatalogWSDLDefinitions(fileObject);
        List<CatalogWSDL.Entry> list = catalogWSDL.getEntries();
        WSDLModel wSDLModel = definitions.getModel();
        try {
            wSDLModel.startTransaction();
            for (CatalogWSDL.Entry object2 : list) {
                if (CatalogWSDL.EntryType.XSD.equals((Object)object2.getType())) {
                    this.addEntryAsSchemaImport(definitions, object2);
                    continue;
                }
                if (CatalogWSDL.EntryType.WSDL.equals((Object)object2.getType())) {
                    this.addEntryAsWSDLImport(definitions, object2);
                    continue;
                }
                sLogger.fine("!!!!!Unsupported CatalogWSDL entry!!!!!");
            }
        }
        finally {
            if (wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
        }
        Object object3 = null;
        Document document = (Document)wSDLModel.getModelSource().getLookup().lookup(BaseDocument.class);
        if (document != null) {
            int dataObject = document.getLength();
            try {
                object3 = document.getText(0, dataObject);
            }
            catch (Exception saveCookie) {
                sLogger.log(Level.FINE, saveCookie.getMessage(), saveCookie);
            }
        }
        if (object3 != null) {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            if (editorCookie != null) {
                editorCookie.saveDocument();
            }
            XAMCatalogWSDLSerializer.saveToFileObject(fileObject, new StringBuffer((String)object3));
        } else {
            sLogger.fine("BASE DOCUMENT TEXT IS NULL. Can not save catalog wsdl");
        }
    }

    public static class ModelSourceProvider {
        public ModelSource getModelSource(FileObject fileObject, boolean bl) throws CatalogModelException {
            BaseDocument baseDocument = null;
            baseDocument = (BaseDocument)this.loadSwingDocument(fileObject);
            Lookup lookup = Lookups.fixed((Object[])new Object[]{baseDocument});
            return new ModelSource(lookup, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document loadSwingDocument(FileObject fileObject) {
            InputStream inputStream = null;
            Document document = null;
            try {
                inputStream = fileObject.getInputStream();
                document = new XDMAccessProvider().loadSwingDocument(inputStream);
            }
            catch (IOException iOException) {
                sLogger.log(Level.FINE, iOException.getMessage(), iOException);
            }
            catch (BadLocationException badLocationException) {
                sLogger.log(Level.FINE, badLocationException.getMessage(), badLocationException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (document == null) {
                sLogger.fine("BaseDocument is NULL in loadSwingDocument");
            }
            return document;
        }
    }
}

