/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.base.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.compapp.projects.base.ui.PackageViewChildren;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

final class PackageRootNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    static Image PACKAGE_BADGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    private static Action[] actions;
    private SourceGroup group;
    private final FileObject file;
    private final Set files;
    private FileStatusListener fileSystemListener;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;
    private static Component CONVERTOR_COMPONENT;

    PackageRootNode(SourceGroup sourceGroup) {
        this(sourceGroup, new InstanceContent());
    }

    private PackageRootNode(SourceGroup sourceGroup, InstanceContent instanceContent) {
        super((Children)new PackageViewChildren(sourceGroup.getRootFolder()), (Lookup)new ProxyLookup(new Lookup[]{PackageRootNode.createLookup(sourceGroup), new AbstractLookup((AbstractLookup.Content)instanceContent)}));
        instanceContent.add((Object)PackageRootNode.alwaysSearchableSearchInfo(SearchInfoFactory.createSearchInfoBySubnodes((Node)this)));
        this.group = sourceGroup;
        this.file = sourceGroup.getRootFolder();
        this.files = Collections.singleton(this.file);
        try {
            FileSystem fileSystem = this.file.getFileSystem();
            this.fileSystemListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
            fileSystem.addFileStatusListener(this.fileSystemListener);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)fileStateInvalidException, "Can not get " + this.file + " filesystem, ignoring...");
            errorManager.notify(1, (Throwable)fileStateInvalidException);
        }
        this.setName(sourceGroup.getName());
        this.setDisplayName(sourceGroup.getDisplayName());
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.file.getFileSystem().getStatus().annotateName(string, this.files);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return string;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.file.getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), this.files);
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return super.getHtmlDisplayName();
    }

    public void run() {
        if (this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }

    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        if ((!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) && fileStatusEvent.hasChanged(this.file)) {
            this.iconChange |= fileStatusEvent.isIconChange();
            this.nameChange |= fileStatusEvent.isNameChange();
        }
        this.task.schedule(50);
    }

    public Action[] getActions(boolean bl) {
        if (actions == null) {
            actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class)};
        }
        return actions;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] propertySetArray = this.getDataFolderNodeDelegate().getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            if (!"properties".equals(propertySetArray[i].getName())) continue;
            propertySetArray[i] = Sheet.createPropertiesSet();
            ((Sheet.Set)propertySetArray[i]).put((Node.Property)new PropertySupport.ReadOnly("name", String.class, NbBundle.getMessage(PackageRootNode.class, (String)"PROP_name"), NbBundle.getMessage(PackageRootNode.class, (String)"HINT_name")){

                public Object getValue() {
                    return PackageRootNode.this.getDisplayName();
                }
            });
            ((Sheet.Set)propertySetArray[i]).put((Node.Property)new PropertySupport.ReadOnly("ROOT_PATH", String.class, NbBundle.getMessage(PackageRootNode.class, (String)"PROP_rootpath"), NbBundle.getMessage(PackageRootNode.class, (String)"HINT_rootpath")){

                public Object getValue() {
                    return FileUtil.getFileDisplayName((FileObject)PackageRootNode.this.file);
                }
            });
        }
        return propertySetArray;
    }

    public void createPasteTypes(Transferable transferable, List list) {
        if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                ArrayList<PackageViewChildren.PackageNode> arrayList = new ArrayList<PackageViewChildren.PackageNode>();
                boolean bl = false;
                boolean bl2 = false;
                int n = -1;
                for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                    Transferable transferable2 = multiTransferObject.getTransferableAt(i);
                    DataFlavor[] dataFlavorArray = multiTransferObject.getTransferDataFlavors(i);
                    for (int j = 0; j < dataFlavorArray.length; ++j) {
                        if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(dataFlavorArray[j].getSubType()) || !"application".equals(dataFlavorArray[j].getPrimaryType())) continue;
                        if (n == -1) {
                            n = Integer.valueOf(dataFlavorArray[j].getParameter("mask"));
                        }
                        PackageViewChildren.PackageNode packageNode = (PackageViewChildren.PackageNode)((Object)transferable2.getTransferData(dataFlavorArray[j]));
                        if (!((PackageViewChildren)this.getChildren()).getRoot().equals(packageNode.getRoot())) {
                            arrayList.add(packageNode);
                        } else {
                            bl2 = true;
                        }
                        bl = true;
                    }
                }
                if (bl && !bl2) {
                    list.add(new PackageViewChildren.PackagePasteType(this.group.getRootFolder(), arrayList.toArray(new PackageViewChildren.PackageNode[arrayList.size()]), n));
                } else if (!bl) {
                    list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(transferable)));
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        } else {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            FileObject fileObject = this.group.getRootFolder();
            boolean bl = false;
            if (fileObject != null && fileObject.canWrite()) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(dataFlavorArray[i].getSubType()) || !"application".equals(dataFlavorArray[i].getPrimaryType())) continue;
                    bl = true;
                    try {
                        int n = Integer.valueOf(dataFlavorArray[i].getParameter("mask"));
                        PackageViewChildren.PackageNode packageNode = (PackageViewChildren.PackageNode)((Object)transferable.getTransferData(dataFlavorArray[i]));
                        if (((PackageViewChildren)this.getChildren()).getRoot().equals(packageNode.getRoot())) continue;
                        list.add(new PackageViewChildren.PackagePasteType(fileObject, new PackageViewChildren.PackageNode[]{packageNode}, n));
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        continue;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        ErrorManager.getDefault().notify((Throwable)unsupportedFlavorException);
                    }
                }
            }
            if (!bl) {
                list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(transferable)));
            }
        }
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        PasteType pasteType = super.getDropType(transferable, n, n2);
        if (pasteType instanceof PackageViewChildren.PackagePasteType) {
            ((PackageViewChildren.PackagePasteType)pasteType).setOperation(n);
        }
        return pasteType;
    }

    private Node getDataFolderNodeDelegate() {
        return ((DataFolder)this.getLookup().lookup(DataFolder.class)).getNodeDelegate();
    }

    private Image computeIcon(boolean bl, int n) {
        Image image;
        Icon icon = this.group.getIcon(bl);
        if (icon == null) {
            image = bl ? this.getDataFolderNodeDelegate().getOpenedIcon(n) : this.getDataFolderNodeDelegate().getIcon(n);
            image = Utilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
        } else {
            image = icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : PackageRootNode.icon2image(icon);
        }
        return image;
    }

    static Image icon2image(Icon icon) {
        int n = icon.getIconHeight();
        int n2 = icon.getIconWidth();
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        icon.paintIcon(CONVERTOR_COMPONENT, bufferedImage.getGraphics(), 0, 0);
        return bufferedImage;
    }

    private static Lookup createLookup(SourceGroup sourceGroup) {
        FileObject fileObject = sourceGroup.getRootFolder();
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return Lookups.fixed((Object[])new Object[]{dataFolder, new PathFinder(sourceGroup)});
    }

    static SearchInfo alwaysSearchableSearchInfo(SearchInfo searchInfo) {
        return new AlwaysSearchableSearchInfo(searchInfo);
    }

    static {
        CONVERTOR_COMPONENT = new Panel();
    }

    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(SearchInfo searchInfo) {
            this.delegate = searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    public static class PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup sourceGroup) {
            this.group = sourceGroup;
        }

        public Node findPath(Node node, Object object) {
            FileObject fileObject;
            if (object instanceof FileObject) {
                fileObject = (FileObject)object;
            } else if (object instanceof DataObject) {
                fileObject = ((DataObject)object).getPrimaryFile();
            } else {
                return null;
            }
            FileObject fileObject2 = this.group.getRootFolder();
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                int n = string.lastIndexOf(47);
                String[] stringArray = null;
                if (fileObject.isFolder()) {
                    String string2 = string.replace('/', '.');
                    stringArray = new String[]{string2};
                } else if (n == -1) {
                    stringArray = new String[]{"", fileObject.getName()};
                } else {
                    String string3 = string.substring(0, n).replace('/', '.');
                    stringArray = new String[]{string3, fileObject.getName()};
                }
                try {
                    return NodeOp.findPath((Node)node, (String[])stringArray);
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    if (!fileObject.isFolder()) {
                        if (n == -1) {
                            stringArray = new String[]{"", fileObject.getNameExt()};
                        } else {
                            String string4 = string.substring(0, n).replace('/', '.');
                            stringArray = new String[]{string4, fileObject.getNameExt()};
                        }
                        try {
                            return NodeOp.findPath((Node)node, (String[])stringArray);
                        }
                        catch (NodeNotFoundException nodeNotFoundException2) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
            if (fileObject2.equals(fileObject)) {
                try {
                    return NodeOp.findPath((Node)node, (String[])new String[]{""});
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    return node;
                }
            }
            return null;
        }

        public String toString() {
            return "PathFinder[" + this.group + "]";
        }
    }
}

