/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.openide.util.Utilities;

public final class InfoPresenter
extends DynamicPresenter {
    private Resolver resolver;
    private String cachedPrimary;
    private String cachedSecondary;
    private String cachedTertiary;
    private Image cached16;
    private Image cached32;
    private Image cached48;
    private Image cached64;

    public static InfoPresenter create(Resolver resolver) {
        return new InfoPresenter(resolver);
    }

    private InfoPresenter(Resolver resolver) {
        this.resolver = resolver;
    }

    protected void notifyAttached(DesignComponent designComponent) {
    }

    protected void notifyDetached(DesignComponent designComponent) {
    }

    protected DesignEventFilter getEventFilter() {
        return this.resolver.getEventFilter(this.getComponent());
    }

    protected void designChanged(DesignEvent designEvent) {
        this.cachedTertiary = null;
        this.cachedSecondary = null;
        this.cachedPrimary = null;
        this.cached64 = null;
        this.cached48 = null;
        this.cached32 = null;
        this.cached16 = null;
        this.firePresenterChanged();
    }

    protected void presenterChanged(PresenterEvent presenterEvent) {
    }

    public String getDisplayName(NameType nameType) {
        switch (nameType) {
            case PRIMARY: {
                if (this.cachedPrimary == null) {
                    this.cachedPrimary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedPrimary;
            }
            case SECONDARY: {
                if (this.cachedSecondary == null) {
                    this.cachedSecondary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedSecondary;
            }
            case TERTIARY: {
                if (this.cachedTertiary == null) {
                    this.cachedTertiary = this.resolver.getDisplayName(this.getComponent(), nameType);
                }
                return this.cachedTertiary;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isEditable() {
        return this.resolver.isEditable(this.getComponent());
    }

    public String getEditableName() {
        return this.resolver.getEditableName(this.getComponent());
    }

    public void setEditableName(String string) {
        this.resolver.setEditableName(this.getComponent(), string);
    }

    public Image getIcon(IconType iconType) {
        switch (iconType) {
            case COLOR_16x16: {
                if (this.cached16 == null) {
                    this.cached16 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached16;
            }
            case COLOR_32x32: {
                if (this.cached32 == null) {
                    this.cached32 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached32;
            }
            case COLOR_48x48: {
                if (this.cached48 == null) {
                    this.cached48 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached48;
            }
            case COLOR_64x64: {
                if (this.cached64 == null) {
                    this.cached64 = this.resolver.getIcon(this.getComponent(), iconType);
                }
                return this.cached64;
            }
        }
        throw new IllegalStateException();
    }

    public static InfoPresenter createStatic(String string, String string2, String string3) {
        return InfoPresenter.createStatic(string, string2, null, string3);
    }

    public static InfoPresenter createStatic(String string, String string2, String string3, String string4) {
        return InfoPresenter.createStatic(string, string2, string3, Utilities.loadImage((String)string4));
    }

    public static InfoPresenter createStatic(final String string, final String string2, final String string3, final Image image) {
        return new InfoPresenter(new Resolver(){

            public DesignEventFilter getEventFilter(DesignComponent designComponent) {
                return null;
            }

            public String getDisplayName(DesignComponent designComponent, NameType nameType) {
                switch (nameType) {
                    case PRIMARY: {
                        return string;
                    }
                    case SECONDARY: {
                        return string2;
                    }
                    case TERTIARY: {
                        return string3;
                    }
                }
                throw Debug.illegalState(new Object[0]);
            }

            public boolean isEditable(DesignComponent designComponent) {
                return false;
            }

            public String getEditableName(DesignComponent designComponent) {
                throw new IllegalStateException();
            }

            public void setEditableName(DesignComponent designComponent, String string4) {
                throw new IllegalStateException();
            }

            public Image getIcon(DesignComponent designComponent, IconType iconType) {
                return IconType.COLOR_16x16.equals((Object)iconType) ? image : null;
            }
        });
    }

    public static String getHtmlDisplayName(DesignComponent designComponent) {
        InfoPresenter infoPresenter = designComponent.getPresenter(InfoPresenter.class);
        if (infoPresenter == null) {
            Debug.warning("Missing InfoPresenter for: ", designComponent);
            return null;
        }
        String string = infoPresenter.getDisplayName(NameType.PRIMARY);
        String string2 = infoPresenter.getDisplayName(NameType.SECONDARY);
        return string2 != null ? string + " <font color=\"#808080\">[" + string2 + "]" : string;
    }

    public static String getDisplayName(DesignComponent designComponent) {
        InfoPresenter infoPresenter = designComponent.getPresenter(InfoPresenter.class);
        if (infoPresenter == null) {
            Debug.warning("Missing InfoPresenter for: ", designComponent);
            return null;
        }
        String string = infoPresenter.getDisplayName(NameType.PRIMARY);
        String string2 = infoPresenter.getDisplayName(NameType.SECONDARY);
        return string2 != null ? string + " [" + string2 + "]" : string;
    }

    public static String getToolTip(DesignComponent designComponent) {
        InfoPresenter infoPresenter = designComponent.getPresenter(InfoPresenter.class);
        if (infoPresenter == null) {
            Debug.warning("Missing InfoPresenter for: ", designComponent);
            return null;
        }
        return InfoPresenter.getToolTip(infoPresenter);
    }

    public static String getToolTip(InfoPresenter infoPresenter) {
        String string = infoPresenter.getDisplayName(NameType.TERTIARY);
        if (string != null) {
            return string;
        }
        return infoPresenter.getDisplayName(NameType.SECONDARY);
    }

    public static interface Resolver {
        public DesignEventFilter getEventFilter(DesignComponent var1);

        public String getDisplayName(DesignComponent var1, NameType var2);

        public boolean isEditable(DesignComponent var1);

        public String getEditableName(DesignComponent var1);

        public void setEditableName(DesignComponent var1, String var2);

        public Image getIcon(DesignComponent var1, IconType var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IconType {
        COLOR_16x16,
        COLOR_32x32,
        COLOR_48x48,
        COLOR_64x64;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameType {
        PRIMARY,
        SECONDARY,
        TERTIARY;

    }
}

