/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactory;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;

final class PrimitiveDescriptorFactoryRegistry {
    private static final Lookup.Result<PrimitiveDescriptorFactory> factoriesLookupResult = Lookup.getDefault().lookupResult(PrimitiveDescriptorFactory.class);

    PrimitiveDescriptorFactoryRegistry() {
    }

    static PrimitiveDescriptor getDescriptor(String string, TypeID typeID) {
        assert (Debug.isFriend(PropertyValue.class));
        assert (typeID.getKind() == TypeID.Kind.PRIMITIVE);
        assert (typeID.getDimension() == 0);
        for (PrimitiveDescriptorFactory primitiveDescriptorFactory : factoriesLookupResult.allInstances()) {
            PrimitiveDescriptor primitiveDescriptor;
            if (string == null || !string.equals(primitiveDescriptorFactory.getProjectType()) || (primitiveDescriptor = primitiveDescriptorFactory.getDescriptorForTypeIDString(typeID.getString())) == null) continue;
            return primitiveDescriptor;
        }
        Debug.warning("No PrimitiveDescriptorFactory found", typeID);
        return null;
    }
}

