/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentDescriptor {
    private Collection<PropertyDescriptor> propertyDescriptors;
    private ComponentDescriptor superDescriptor;

    public final ComponentDescriptor getSuperDescriptor() {
        return this.superDescriptor;
    }

    public final Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public final PropertyDescriptor getPropertyDescriptor(String string) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    final void setSuperComponentDescriptor(ComponentDescriptor componentDescriptor) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "resolveDescriptor") || Debug.isFriend(GlobalDescriptorRegistry.class, "reloadCore") || Debug.isFriend(DescriptorRegistry.class, "reloadCore"));
        this.superDescriptor = componentDescriptor;
    }

    final void setPropertyDescriptors(Collection<PropertyDescriptor> collection) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "resolveDescriptor") || Debug.isFriend(GlobalDescriptorRegistry.class, "reloadCore") || Debug.isFriend(DescriptorRegistry.class, "reloadCore"));
        this.propertyDescriptors = collection == null ? null : Collections.unmodifiableCollection(new ArrayList<PropertyDescriptor>(collection));
    }

    public final String toString() {
        TypeDescriptor typeDescriptor = this.getTypeDescriptor();
        if (typeDescriptor == null) {
            return super.toString();
        }
        return typeDescriptor.getThisType().toString();
    }

    public void postInitialize(DesignComponent designComponent) {
    }

    public abstract TypeDescriptor getTypeDescriptor();

    public abstract VersionDescriptor getVersionDescriptor();

    public Collection<String> getExcludedPropertyDescriptorNames() {
        return null;
    }

    public abstract List<PropertyDescriptor> getDeclaredPropertyDescriptors();

    public PaletteDescriptor getPaletteDescriptor() {
        return null;
    }

    protected void gatherPresenters(ArrayList<Presenter> arrayList) {
        List<? extends Presenter> list = this.createPresenters();
        if (list != null) {
            for (Presenter presenter : list) {
                if (presenter != null) {
                    arrayList.add(presenter);
                    continue;
                }
                Debug.warning("Null presenter", this);
            }
        }
    }

    protected abstract List<? extends Presenter> createPresenters();
}

