/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.renderkit.html.AbstractDesignTimeRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public abstract class ValueHolderDesignTimeRenderer
extends AbstractDesignTimeRenderer {
    protected static String STYLE_CLASS_PROP = "styleClass";
    protected static String VALUE_PROP = "value";
    boolean isTextSet;
    boolean isStyleSet;

    public ValueHolderDesignTimeRenderer(Renderer renderer) {
        super(renderer);
    }

    protected abstract String getShadowText();

    protected boolean needsShadowText(ValueHolder component) {
        return component.getValue() == null;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (ValueHolder.class.isAssignableFrom(component.getClass())) {
            ValueBinding valueBinding = component.getValueBinding(VALUE_PROP);
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (valueBinding != null && (value == null || value.getClass().equals(Object.class) || value.toString().length() == 0)) {
                Object dummyValue = ValueHolderDesignTimeRenderer.getDummyData(context, valueBinding);
                valueHolder.setValue(dummyValue);
                this.isTextSet = true;
            } else if (this.needsShadowText(valueHolder)) {
                valueHolder.setValue((Object)this.getShadowText());
                String styleClass = (String)component.getAttributes().get(STYLE_CLASS_PROP);
                component.getAttributes().put(STYLE_CLASS_PROP, ValueHolderDesignTimeRenderer.addStyleClass(styleClass, UNINITITIALIZED_STYLE_CLASS));
                this.isTextSet = true;
                this.isStyleSet = true;
            }
        }
        super.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        if (this.isTextSet) {
            ValueHolder valueHolder = (ValueHolder)component;
            valueHolder.setValue(null);
            this.isTextSet = false;
        }
        if (this.isStyleSet) {
            String styleClass = (String)component.getAttributes().get(STYLE_CLASS_PROP);
            component.getAttributes().put(STYLE_CLASS_PROP, ValueHolderDesignTimeRenderer.removeStyleClass(styleClass, UNINITITIALIZED_STYLE_CLASS));
            this.isStyleSet = false;
        }
    }
}

