/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Breadcrumbs;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import com.sun.webui.jsf.renderkit.html.AbstractDesignTimeRenderer;
import com.sun.webui.jsf.renderkit.html.BreadcrumbsRenderer;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class BreadcrumbsDesignTimeRenderer
extends AbstractDesignTimeRenderer {
    static int DUMMY_PAGES_SET = 1;
    static int COMPONENT_SHADOWED = 2;
    static int LINK_CHILDREN_SHADOWED = 3;
    int rendererStatus;
    static Hyperlink[] dummyHyperlinks;

    public BreadcrumbsDesignTimeRenderer() {
        super((Renderer)new BreadcrumbsRenderer());
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererStatus = 0;
        if (component instanceof Breadcrumbs) {
            if (component.getValueBinding("pages") != null) {
                ValueBinding pagesBinding = component.getValueBinding("pages");
                Object value = pagesBinding.getValue(context);
                if (value != null && value instanceof Hyperlink[] && ((Hyperlink[])value).length == 0) {
                    ((Breadcrumbs)component).setPages(BreadcrumbsDesignTimeRenderer.getDummyHyperlinks());
                    this.rendererStatus = DUMMY_PAGES_SET;
                }
            } else if (component.getChildCount() == 0) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("div", component);
                String style = ((Breadcrumbs)component).getStyle();
                writer.writeAttribute("style", (Object)style, "style");
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)AbstractDesignTimeRenderer.UNINITITIALIZED_STYLE_CLASS, "class");
                String label = DesignMessageUtil.getMessage(BreadcrumbsDesignTimeRenderer.class, "breadcrumbs.label");
                char[] chars = label.toCharArray();
                writer.writeText(chars, 0, chars.length);
                writer.endElement("span");
                writer.endElement("div");
                this.rendererStatus = COMPONENT_SHADOWED;
            } else {
                Hyperlink link;
                int i;
                List children = component.getChildren();
                if (Hyperlink.class.isAssignableFrom(children.get(i = children.size() - 1).getClass()) && (link = (Hyperlink)children.get(i)).getText() == null && link.getChildCount() == 0) {
                    if (link instanceof ImageHyperlink) {
                        link.setText((Object)DesignMessageUtil.getMessage(BreadcrumbsDesignTimeRenderer.class, "imageHyperlink.label"));
                    } else {
                        link.setText((Object)DesignMessageUtil.getMessage(BreadcrumbsDesignTimeRenderer.class, "hyperlink.label"));
                    }
                    link.setStyleClass(BreadcrumbsDesignTimeRenderer.addStyleClass(link.getStyleClass(), UNINITITIALIZED_STYLE_CLASS));
                    this.rendererStatus = LINK_CHILDREN_SHADOWED;
                }
            }
        }
        if (this.rendererStatus != COMPONENT_SHADOWED) {
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (this.rendererStatus != COMPONENT_SHADOWED) {
            super.encodeEnd(context, component);
        }
        if (this.rendererStatus == DUMMY_PAGES_SET) {
            ((Breadcrumbs)component).setPages(null);
        } else if (this.rendererStatus == LINK_CHILDREN_SHADOWED) {
            List children = component.getChildren();
            int i = children.size() - 1;
            Hyperlink link = (Hyperlink)children.get(i);
            link.setText(null);
            link.setStyleClass(BreadcrumbsDesignTimeRenderer.removeStyleClass(link.getStyleClass(), UNINITITIALIZED_STYLE_CLASS));
        }
        this.rendererStatus = 0;
    }

    static Hyperlink[] getDummyHyperlinks() {
        if (dummyHyperlinks == null) {
            Hyperlink dummyHyperlink = new Hyperlink();
            String dummyText = BreadcrumbsDesignTimeRenderer.getDummyData(String.class).toString();
            dummyHyperlink.setText((Object)dummyText);
            dummyHyperlinks = new Hyperlink[]{dummyHyperlink, dummyHyperlink, dummyHyperlink};
        }
        return dummyHyperlinks;
    }
}

