/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.design;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignEvent;
import com.sun.rave.designtime.DesignInfo;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.DisplayAction;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.designtime.faces.ResolveResult;
import com.sun.rave.designtime.impl.BasicDisplayAction;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.faces.converter.CalendarConverter;
import com.sun.rave.faces.converter.SqlDateConverter;
import com.sun.rave.faces.converter.SqlTimeConverter;
import com.sun.rave.propertyeditors.binding.DataBindingHelper;
import com.sun.rave.propertyeditors.binding.DataBindingHelperRegistry;
import com.sun.webui.jsf.component.Alert;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.component.FormDesignInfo;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.component.Page;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.WebuiCommand;
import com.sun.webui.jsf.component.customizers.AutoSubmitOnChangeAction;
import com.sun.webui.jsf.component.customizers.OptionsListCustomizerAction;
import com.sun.webui.jsf.model.DefaultOptionsList;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.BooleanConverter;
import javax.faces.convert.ByteConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.DoubleConverter;
import javax.faces.convert.FloatConverter;
import javax.faces.convert.IntegerConverter;
import javax.faces.convert.LongConverter;
import javax.faces.convert.ShortConverter;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import org.w3c.dom.Element;

public abstract class AbstractDesignInfo
implements DesignInfo {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com.sun.webui.jsf.design.Bundle", Locale.getDefault(), AbstractDesignInfo.class.getClassLoader());
    private Class beanClass = null;
    private static Pattern fieldKeysPattern = Pattern.compile("options\\s*\\[\\s*'\\s*([\\w.]+)\\s*(,\\s*([\\w.]+)\\s*)?'\\s*\\]");
    static final String CONVERTER = "converter";
    private static final String PROPERTY_DESCRIPTOR_MAP = "com.sun.rave.designtime.PROPERTY_DESCRIPTOR_MAP";
    private static final Class[] VALIDATE_PARAMS = new Class[]{FacesContext.class, UIComponent.class, Object.class};

    public AbstractDesignInfo(Class clazz) {
        this.beanClass = clazz;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public boolean acceptParent(DesignBean parentBean, DesignBean childBean, Class childClass) {
        if (parentBean == null || parentBean.getInstance() == null) {
            return false;
        }
        Class<?> parentClass = parentBean.getInstance().getClass();
        return AbstractDesignInfo.acceptFiliation(parentBean, parentClass, childBean, childClass);
    }

    public boolean acceptChild(DesignBean parentBean, DesignBean childBean, Class childClass) {
        if (parentBean == null || parentBean.getInstance() == null) {
            return false;
        }
        Class<?> parentClass = parentBean.getInstance().getClass();
        return AbstractDesignInfo.acceptFiliation(parentBean, parentClass, childBean, childClass);
    }

    protected static boolean isSunWebUIContext(DesignBean bean) {
        DesignBean thisBean = bean;
        while (thisBean.getBeanParent() != null) {
            Element element;
            if (thisBean.getInstance() instanceof Page) {
                return true;
            }
            if (thisBean instanceof MarkupDesignBean && (element = ((MarkupDesignBean)thisBean).getElement()).getTagName().compareTo("div") == 0 && thisBean.getBeanParent().getInstance() instanceof UIViewRoot) {
                return true;
            }
            thisBean = thisBean.getBeanParent();
        }
        return false;
    }

    private static boolean acceptFiliation(DesignBean parentBean, Class parentClass, DesignBean childBean, Class childClass) {
        if (parentClass.equals(childClass)) {
            return false;
        }
        if (EditableValueHolder.class.isAssignableFrom(parentClass)) {
            return false;
        }
        if (ValueHolder.class.isAssignableFrom(parentClass)) {
            if (Label.class.equals((Object)parentClass) && EditableValueHolder.class.isAssignableFrom(childClass)) {
                return false;
            }
            if (ValueHolder.class.isAssignableFrom(childClass)) {
                return false;
            }
        }
        return !WebuiCommand.class.isAssignableFrom(parentClass) && !HtmlCommandLink.class.isAssignableFrom(parentClass) && !DropDown.class.isAssignableFrom(parentClass) && !HtmlCommandButton.class.isAssignableFrom(parentClass) || childClass.equals(StaticText.class) || childClass.equals(ImageComponent.class);
    }

    public Result beanCreatedSetup(DesignBean bean) {
        return Result.SUCCESS;
    }

    public Result beanDeletedCleanup(DesignBean bean) {
        this.modifyVirtualFormsOnBeanDeletedCleanup(bean);
        if (ValueHolder.class.isAssignableFrom(bean.getInstance().getClass())) {
            DesignContext context = bean.getDesignContext();
            DesignBean[] designBeans = context.getBeans();
            String instanceName = bean.getInstanceName();
            for (int i = 0; i < designBeans.length; ++i) {
                DesignProperty property = designBeans[i].getProperty("for");
                if (property == null || !instanceName.equals(property.getValue())) continue;
                property.setValue(null);
            }
        }
        return Result.SUCCESS;
    }

    private DesignBean findFormBean(DesignBean bean) {
        DesignBean formBean = null;
        DesignBean testBean = null;
        if (bean != null) {
            testBean = bean.getBeanParent();
        }
        while (testBean != null) {
            Object testInstance = testBean.getInstance();
            if (testInstance instanceof Form) {
                formBean = testBean;
                break;
            }
            testBean = testBean.getBeanParent();
        }
        return formBean;
    }

    private void modifyVirtualFormsOnBeanDeletedCleanup(DesignBean bean) {
        Object vformsConfigValueObj;
        DesignProperty vformsConfigProp;
        DesignBean formBean = this.findFormBean(bean);
        if (formBean != null && (vformsConfigProp = formBean.getProperty("virtualFormsConfig")) != null && (vformsConfigValueObj = vformsConfigProp.getValue()) instanceof String) {
            String vfc = (String)vformsConfigValueObj;
            Form.VirtualFormDescriptor[] descriptors = Form.generateVirtualForms((String)vfc);
            String beanId = FormDesignInfo.getFullyQualifiedId(bean);
            boolean modified = false;
            if (beanId != null) {
                modified = this.removeIdFromVirtualFormDescriptors(descriptors, beanId);
            }
            if (modified) {
                String newVfc = Form.generateVirtualFormsConfig((Form.VirtualFormDescriptor[])descriptors);
                vformsConfigProp.setValue((Object)newVfc);
            }
        }
    }

    private boolean removeIdFromVirtualFormDescriptors(Form.VirtualFormDescriptor[] descriptors, String idToRemove) {
        boolean modified = false;
        for (int d = 0; descriptors != null && d < descriptors.length; ++d) {
            Form.VirtualFormDescriptor vfd = descriptors[d];
            String[] pids = vfd.getParticipatingIds();
            String[] newPids = this.removeIdFromArray(pids, idToRemove);
            if (pids != null && newPids != null && pids.length != newPids.length) {
                modified = true;
            }
            vfd.setParticipatingIds(newPids);
            String[] sids = vfd.getSubmittingIds();
            String[] newSids = this.removeIdFromArray(sids, idToRemove);
            if (sids != null && newSids != null && sids.length != newSids.length) {
                modified = true;
            }
            vfd.setSubmittingIds(newSids);
        }
        return modified;
    }

    private String[] removeIdFromArray(String[] ids, String idToRemove) {
        if (ids == null || ids.length == 0) {
            return ids;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            if (id == null || id.length() <= 0 || Form.fullyQualifiedIdMatchesPattern((String)idToRemove, (String)id)) continue;
            list.add(id);
        }
        return list.toArray(new String[list.size()]);
    }

    public Result beanPastedSetup(DesignBean bean) {
        return Result.SUCCESS;
    }

    public boolean supportsAutoSubmit(DesignBean bean) {
        return EditableValueHolder.class.isAssignableFrom(this.beanClass);
    }

    public DisplayAction[] getContextItems(DesignBean bean) {
        DesignProperty itemsProperty;
        DesignProperty property = this.getDefaultBindingProperty(bean);
        if (property == null) {
            return new DisplayAction[0];
        }
        ArrayList<BasicDisplayAction> displayActions = new ArrayList<BasicDisplayAction>();
        if (this.supportsAutoSubmit(bean)) {
            displayActions.add(new AutoSubmitOnChangeAction(bean));
        }
        Class<?> beanClass = bean.getInstance().getClass();
        DataBindingHelper.Panel bindingPanel = null;
        bindingPanel = Selector.class.isAssignableFrom(beanClass) ? (RbCbSelector.class.isAssignableFrom(beanClass) ? DataBindingHelper.Panel.BIND_VALUE_TO_DATAPROVIDER : DataBindingHelper.Panel.BIND_OPTIONS_TO_DATAPROVIDER) : DataBindingHelper.Panel.BIND_VALUE_TO_DATAPROVIDER;
        DataBindingHelper dataBindingHelper = DataBindingHelperRegistry.getDataBindingHelper();
        if (dataBindingHelper != null) {
            displayActions.add((BasicDisplayAction)dataBindingHelper.getDataBindingAction(bean, property.getPropertyDescriptor().getName(), new DataBindingHelper.Panel[]{bindingPanel, DataBindingHelper.Panel.BIND_VALUE_TO_OBJECT}));
        }
        if (Selector.class.isAssignableFrom(beanClass) && (itemsProperty = bean.getProperty("items")) instanceof FacesDesignProperty && ((FacesDesignProperty)itemsProperty).isBound()) {
            String expression = ((FacesDesignProperty)itemsProperty).getValueBinding().getExpressionString();
            ResolveResult resolveResult = ((FacesDesignContext)bean.getDesignContext()).resolveBindingExprToBean(expression);
            if (resolveResult != null && resolveResult.getDesignBean() != null && resolveResult.getDesignBean().getInstance() instanceof DefaultOptionsList) {
                displayActions.add(new OptionsListCustomizerAction(bean));
            }
        }
        return displayActions.toArray(new DisplayAction[displayActions.size()]);
    }

    public boolean acceptLink(DesignBean targetBean, DesignBean sourceBean, Class sourceClass) {
        Class<?> targetClass = targetBean.getInstance().getClass();
        if (Converter.class.isAssignableFrom(sourceClass) && ValueHolder.class.isAssignableFrom(targetClass)) {
            return true;
        }
        if (Validator.class.isAssignableFrom(sourceClass) && EditableValueHolder.class.isAssignableFrom(targetClass)) {
            return true;
        }
        return DataProvider.class.isAssignableFrom(sourceClass) && this.getDefaultBindingProperty(targetBean) != null;
    }

    public Result linkBeans(DesignBean targetBean, DesignBean sourceBean) {
        DesignProperty property;
        Class<?> sourceClass = sourceBean.getInstance().getClass();
        Class<?> targetClass = targetBean.getInstance().getClass();
        if (!this.acceptLink(targetBean, sourceBean, sourceClass)) {
            return Result.FAILURE;
        }
        if (Converter.class.isAssignableFrom(sourceClass)) {
            DesignProperty property2 = targetBean.getProperty(CONVERTER);
            property2.setValue(sourceBean.getInstance());
        } else if (Validator.class.isAssignableFrom(sourceClass)) {
            DesignProperty property3 = targetBean.getProperty("validatorExpression");
            FacesDesignContext fdc = (FacesDesignContext)targetBean.getDesignContext();
            String validateBinding = fdc.getBindingExpr(sourceBean, ".validate");
            Application app = fdc.getFacesContext().getApplication();
            MethodExpression me = app.getExpressionFactory().createMethodExpression(fdc.getFacesContext().getELContext(), validateBinding, null, VALIDATE_PARAMS);
            property3.setValue((Object)me);
        } else if (DataProvider.class.isAssignableFrom(sourceClass) && (property = this.getDefaultBindingProperty(targetBean)) != null && property instanceof FacesDesignProperty) {
            if (Selector.class.isAssignableFrom(targetClass)) {
                if (RbCbSelector.class.isAssignableFrom(targetClass)) {
                    this.linkDataProviderToSingleton((FacesDesignProperty)property, sourceBean);
                } else {
                    this.linkDataProviderToListSelector((FacesDesignProperty)property, sourceBean);
                }
            } else if (ListManager.class.isAssignableFrom(targetClass)) {
                this.linkDataProviderToStringListSelector((FacesDesignProperty)property, sourceBean);
            } else {
                this.linkDataProviderToSingleton((FacesDesignProperty)property, sourceBean);
            }
        }
        return Result.SUCCESS;
    }

    protected DesignProperty getDefaultBindingProperty(DesignBean targetBean) {
        Class<?> targetClass = targetBean.getInstance().getClass();
        DesignProperty property = null;
        if (Alert.class.isAssignableFrom(targetClass)) {
            property = targetBean.getProperty("summary");
        } else if (ListSelector.class.isAssignableFrom(targetClass)) {
            property = targetBean.getProperty("items");
        } else if (ValueHolder.class.isAssignableFrom(targetClass)) {
            property = targetBean.getProperty("text");
        } else if (ActionSource.class.isAssignableFrom(targetClass)) {
            property = targetBean.getProperty("text");
        }
        if (property == null) {
            property = targetBean.getProperty("value");
        }
        return property;
    }

    public Result linkDataProviderToSingleton(FacesDesignProperty property, DesignBean dataBean) {
        FacesDesignContext fdc = (FacesDesignContext)property.getDesignBean().getDesignContext();
        DataProvider provider = (DataProvider)dataBean.getInstance();
        FieldKey[] fieldKeys = provider.getFieldKeys();
        if (fieldKeys != null && fieldKeys.length > 0) {
            FieldKey fieldKey = null;
            Class<?> propertyClass = property.getPropertyDescriptor().getPropertyType();
            for (int i = 0; i < fieldKeys.length && fieldKey == null; ++i) {
                if (!provider.getType(fieldKeys[i]).isAssignableFrom(propertyClass)) continue;
                fieldKey = fieldKeys[i];
            }
            if (fieldKey == null) {
                fieldKey = fieldKeys[0];
            }
            StringBuffer expr = new StringBuffer();
            expr.append("#{");
            expr.append(fdc.getReferenceName());
            expr.append(".");
            expr.append(dataBean.getInstanceName());
            expr.append(".value['");
            expr.append(fieldKey.getFieldId());
            expr.append("']}");
            ValueBinding vb = fdc.getFacesContext().getApplication().createValueBinding(expr.toString());
            property.setValueBinding(vb);
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public Result linkDataProviderToListSelector(FacesDesignProperty property, DesignBean dataBean) {
        FacesDesignContext fdc = (FacesDesignContext)property.getDesignBean().getDesignContext();
        DataProvider provider = (DataProvider)dataBean.getInstance();
        FieldKey[] fieldKeys = provider.getFieldKeys();
        if (fieldKeys != null && fieldKeys.length > 0) {
            String valueField = null;
            String displayField = null;
            Class valueFieldType = null;
            for (int i = 0; i < fieldKeys.length; ++i) {
                if (valueField == null && AbstractDesignInfo.isTypeOf(Integer.class, "int", provider.getType(fieldKeys[i]))) {
                    valueField = fieldKeys[i].getFieldId();
                    valueFieldType = provider.getType(fieldKeys[i]);
                }
                if (displayField != null || !provider.getType(fieldKeys[i]).isAssignableFrom(String.class)) continue;
                displayField = fieldKeys[i].getFieldId();
            }
            if (valueField == null) {
                valueField = fieldKeys[0].getFieldId();
                valueFieldType = provider.getType(fieldKeys[0]);
            }
            if (displayField == null) {
                displayField = fieldKeys[0].getFieldId();
            }
            StringBuffer expr = new StringBuffer();
            expr.append("#{");
            expr.append(fdc.getReferenceName());
            expr.append(".");
            expr.append(dataBean.getInstanceName());
            expr.append(".options['");
            expr.append(valueField);
            expr.append(",");
            expr.append(displayField);
            expr.append("']}");
            ValueBinding vb = fdc.getFacesContext().getApplication().createValueBinding(expr.toString());
            property.setValueBinding(vb);
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public Result linkDataProviderToStringListSelector(FacesDesignProperty property, DesignBean dataBean) {
        FacesDesignContext fdc = (FacesDesignContext)property.getDesignBean().getDesignContext();
        DataProvider provider = (DataProvider)dataBean.getInstance();
        FieldKey[] fieldKeys = provider.getFieldKeys();
        if (fieldKeys != null && fieldKeys.length > 0) {
            FieldKey fieldKey = null;
            for (int i = 0; i < fieldKeys.length && fieldKey == null; ++i) {
                if (!provider.getType(fieldKeys[i]).isAssignableFrom(String.class)) continue;
                fieldKey = fieldKeys[i];
            }
            if (fieldKey == null) {
                fieldKey = fieldKeys[0];
            }
            StringBuffer expr = new StringBuffer();
            expr.append("#{");
            expr.append(fdc.getReferenceName());
            expr.append(".");
            expr.append(dataBean.getInstanceName());
            expr.append(".stringList['");
            expr.append(fieldKey.getFieldId());
            expr.append("']}");
            ValueBinding vb = fdc.getFacesContext().getApplication().createValueBinding(expr.toString());
            property.setValueBinding(vb);
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public static Class getConverterClass(Class type) {
        if (AbstractDesignInfo.isTypeOf(Integer.class, "int", type)) {
            return IntegerConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Byte.class, "byte", type)) {
            return ByteConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Long.class, "long", type)) {
            return LongConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Boolean.class, "boolean", type)) {
            return BooleanConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Short.class, "short", type)) {
            return ShortConverter.class;
        }
        if (type.isAssignableFrom(Date.class)) {
            return SqlDateConverter.class;
        }
        if (type.isAssignableFrom(Time.class)) {
            return SqlTimeConverter.class;
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return BigDecimalConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Double.class, "double", type)) {
            return DoubleConverter.class;
        }
        if (AbstractDesignInfo.isTypeOf(Float.class, "float", type)) {
            return FloatConverter.class;
        }
        if (type.isAssignableFrom(Calendar.class)) {
            return CalendarConverter.class;
        }
        return null;
    }

    public void beanContextActivated(DesignBean bean) {
    }

    public void beanContextDeactivated(DesignBean bean) {
    }

    public void instanceNameChanged(DesignBean bean, String oldInstanceName) {
        if (ValueHolder.class.isAssignableFrom(bean.getInstance().getClass())) {
            DesignContext context = bean.getDesignContext();
            DesignBean[] designBeans = context.getBeans();
            for (int i = 0; i < designBeans.length; ++i) {
                DesignProperty property = designBeans[i].getProperty("for");
                if (property == null || !oldInstanceName.equals(property.getValue())) continue;
                property.setValue((Object)bean.getInstanceName());
            }
        }
    }

    public void beanChanged(DesignBean bean) {
    }

    public void eventChanged(DesignEvent event) {
    }

    public void propertyChanged(DesignProperty property, Object oldValue) {
        this.modifyVirtualFormsOnPropertyChanged(property, oldValue);
        this.modifyAutoSubmitOnPropertyChanged(property);
    }

    public void modifyConverter(DesignProperty property) {
        DesignBean designBean = property.getDesignBean();
        DesignProperty converterProp = designBean.getProperty(CONVERTER);
        if (converterProp != null) {
            FacesDesignContext context = (FacesDesignContext)designBean.getDesignContext();
            if (((FacesDesignProperty)property).isBound()) {
                DesignBean converterBean;
                DesignBean oldConverterBean;
                String expression = ((FacesDesignProperty)property).getValueBinding().getExpressionString();
                ResolveResult resolveResult = context.resolveBindingExprToBean(expression);
                if (resolveResult == null || resolveResult.getDesignBean() == null || !DataProvider.class.isAssignableFrom(resolveResult.getDesignBean().getInstance().getClass())) {
                    return;
                }
                DataProvider dataProvider = (DataProvider)resolveResult.getDesignBean().getInstance();
                Matcher matcher = fieldKeysPattern.matcher(resolveResult.getRemainder());
                if (!matcher.matches()) {
                    return;
                }
                FieldKey valueKey = dataProvider.getFieldKey(matcher.group(1));
                Class converterClass = AbstractDesignInfo.getConverterClass(dataProvider.getType(valueKey));
                if (converterProp.isModified() && (oldConverterBean = AbstractDesignInfo.getConverterBean(designBean)) != null) {
                    context.deleteBean(oldConverterBean);
                }
                if (converterClass != null && (converterBean = context.createBean(converterClass.getName(), null, null)) != null) {
                    converterBean.setInstanceName(AbstractDesignInfo.getConverterName(designBean));
                    converterProp.setValue(converterBean.getInstance());
                }
            }
        }
    }

    public void deleteConverter(DesignBean designBean) {
        DesignBean converter = AbstractDesignInfo.getConverterBean(designBean);
        if (converter != null) {
            FacesDesignProperty converterProperty = (FacesDesignProperty)designBean.getProperty(CONVERTER);
            String oldExpression = converterProperty.getValueBinding().getExpressionString();
            converterProperty.unset();
            DesignBean[] beans = designBean.getDesignContext().getBeansOfType(EditableValueHolder.class);
            int referenceCount = 0;
            for (int i = 0; i < beans.length; ++i) {
                String expression;
                DesignProperty p = beans[i].getProperty(CONVERTER);
                if (p == null || !(p instanceof FacesDesignProperty) || !oldExpression.equals(expression = ((FacesDesignProperty)p).getValueBinding().getExpressionString())) continue;
                ++referenceCount;
            }
            if (referenceCount == 0) {
                designBean.getDesignContext().deleteBean(converter);
            }
        }
    }

    protected static String getConverterName(DesignBean designBean) {
        return designBean.getInstanceName() + "Converter";
    }

    protected static DesignBean getConverterBean(DesignBean designBean) {
        FacesDesignContext context = (FacesDesignContext)designBean.getDesignContext();
        FacesDesignProperty converterProperty = (FacesDesignProperty)designBean.getProperty(CONVERTER);
        if (converterProperty == null || !converterProperty.isBound()) {
            return null;
        }
        String expression = converterProperty.getValueBinding().getExpressionString();
        return AbstractDesignInfo.getConverterBean(context, expression);
    }

    protected static DesignBean getConverterBean(FacesDesignContext context, String expression) {
        ResolveResult resolveResult = context.resolveBindingExprToBean(expression);
        if (resolveResult == null || resolveResult.getDesignBean() == null) {
            return null;
        }
        DesignBean converterBean = resolveResult.getDesignBean();
        if (Converter.class.isAssignableFrom(converterBean.getInstance().getClass())) {
            return converterBean;
        }
        return null;
    }

    private static boolean isTypeOf(Class ofType, String primitiveType, Class tobecheckType) {
        return tobecheckType.isAssignableFrom(ofType) || tobecheckType.isPrimitive() && tobecheckType.getName().equals(primitiveType);
    }

    private void modifyAutoSubmitOnPropertyChanged(DesignProperty property) {
        AutoSubmitOnChangeAction autoSubmitAction;
        DesignBean bean;
        PropertyDescriptor pd = property.getPropertyDescriptor();
        String propertyName = pd.getName();
        if ("id".equals(propertyName) && (bean = property.getDesignBean()) != null && bean.getInstance() instanceof EditableValueHolder && (autoSubmitAction = new AutoSubmitOnChangeAction(bean)).isAutoSubmit()) {
            autoSubmitAction.toggleAutoSubmit();
            autoSubmitAction.toggleAutoSubmit();
        }
    }

    private void modifyVirtualFormsOnPropertyChanged(DesignProperty property, Object oldValue) {
        DesignBean bean;
        PropertyDescriptor pd = property.getPropertyDescriptor();
        String propertyName = pd.getName();
        if ("id".equals(propertyName) && oldValue instanceof String && (bean = property.getDesignBean()) != null) {
            String parentBeanFqId;
            DesignBean parentBean;
            String vfc;
            Form.VirtualFormDescriptor[] vfds;
            Object vfcObj;
            DesignProperty vfcProp;
            DesignBean formBean;
            String fqId = FormDesignInfo.getFullyQualifiedId(bean);
            String replacementId = fqId;
            if (replacementId == null) {
                Object replacementIdObj = property.getValue();
                if (replacementIdObj instanceof String) {
                    replacementId = (String)replacementIdObj;
                }
            } else if (replacementId.startsWith(String.valueOf(':')) && replacementId.length() > 1) {
                replacementId = replacementId.substring(1, replacementId.length());
            }
            if (replacementId != null && (formBean = this.findFormBean(bean)) != null && (vfcProp = formBean.getProperty("virtualFormsConfig")) != null && (vfcObj = vfcProp.getValue()) instanceof String && (vfds = Form.generateVirtualForms((String)(vfc = (String)vfcObj))) != null && vfds.length > 0 && (parentBean = bean.getBeanParent()) != null && (parentBeanFqId = FormDesignInfo.getFullyQualifiedId(parentBean)) != null && parentBeanFqId.length() > 0) {
                String oldFqId = parentBeanFqId;
                String sep = String.valueOf(':');
                if (!sep.equals(oldFqId)) {
                    oldFqId = oldFqId + sep;
                }
                oldFqId = oldFqId + oldValue;
                boolean vfdsModified = false;
                for (int v = 0; v < vfds.length; ++v) {
                    String[] participants = vfds[v].getParticipatingIds();
                    String[] submitters = vfds[v].getSubmittingIds();
                    boolean pMod = this.modifyIdArray(participants, oldFqId, replacementId);
                    boolean sMod = this.modifyIdArray(submitters, oldFqId, replacementId);
                    if (!pMod && !sMod) continue;
                    vfdsModified = true;
                }
                if (vfdsModified) {
                    String newVfc = Form.generateVirtualFormsConfig((Form.VirtualFormDescriptor[])vfds);
                    vfcProp.setValue((Object)newVfc);
                }
            }
        }
    }

    private boolean modifyIdArray(String[] ids, String oldFqId, String replacementId) {
        if (ids == null || ids.length < 1) {
            return false;
        }
        boolean modified = false;
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            boolean idRepresentsOldFqId = Form.fullyQualifiedIdMatchesPattern((String)oldFqId, (String)id);
            if (!idRepresentsOldFqId) continue;
            ids[i] = replacementId;
            modified = true;
        }
        return modified;
    }

    protected BeanDescriptor getBeanDescriptor() {
        try {
            return this.getBeanInfo().getBeanDescriptor();
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    protected BeanInfo getBeanInfo() throws IntrospectionException {
        return Introspector.getBeanInfo(this.getBeanClass());
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        Map map = this.getPropertyDescriptorMap();
        if (map != null) {
            return (PropertyDescriptor)map.get(name);
        }
        return null;
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        try {
            return this.getBeanInfo().getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    private Map getPropertyDescriptorMap() {
        BeanDescriptor bd = this.getBeanDescriptor();
        if (bd == null) {
            return null;
        }
        HashMap<String, PropertyDescriptor> map = (HashMap<String, PropertyDescriptor>)bd.getValue(PROPERTY_DESCRIPTOR_MAP);
        if (map == null) {
            PropertyDescriptor[] pd = this.getPropertyDescriptors();
            if (pd == null) {
                return null;
            }
            map = new HashMap<String, PropertyDescriptor>(pd.length);
            for (int i = 0; i < pd.length; ++i) {
                map.put(pd[i].getName(), pd[i]);
            }
            bd.setValue(PROPERTY_DESCRIPTOR_MAP, map);
        }
        return map;
    }
}

