/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.table;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectArrayDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.ext.DesignBeanExt;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroupDesignInfo;
import com.sun.webui.jsf.component.table.TableColumnDesignState;
import com.sun.webui.jsf.component.table.TableDesignHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class TableRowGroupDesignState {
    private ResourceBundle bundle = ResourceBundle.getBundle(TableRowGroupDesignState.class.getPackage().getName() + ".Bundle");
    private static final String MODEL_INSTANCE_NAME_SUFFIX = "DefaultModel";
    private static final String SOURCE_DATA_PROPERTY = "sourceData";
    private static final String SOURCE_VARIABLE_PROPERTY = "sourceVar";
    private static final String ROWS_PROPERTY = "rows";
    private static final String EMPTY_DATA_MSG_PROPERTY = "emptyDataMsg";
    private static final String PAGINATED_PROPERTY = "paginated";
    private DesignBean tableRowGroupBean = null;
    FacesDesignContext fcontext = null;
    public static final String sourceVarNameBase = "currentRow";
    private String sourceVarName = "currentRow";
    private Map selectedColumnsDesignStates = new HashMap();
    private Vector selectedColumnNames = new Vector();
    private Vector availableColumnNames = new Vector();
    private TableDataProvider tableDataProvider;
    private DesignBean dataProviderBean = null;
    private int paginationRows = 10;
    private String emptyDataMsg = null;
    private boolean childBeansDeleted = false;
    private boolean rowGroupPaginated = false;
    private boolean dataProviderReset = false;
    private static int varCount = 0;
    private List sourceVariableList = new ArrayList();

    public TableRowGroupDesignState(DesignBean tblGrpBean) {
        this.tableRowGroupBean = tblGrpBean;
        this.fcontext = (FacesDesignContext)this.tableRowGroupBean.getDesignContext();
    }

    public void setSelectedColumnNames(Vector selectedColNames) {
        this.selectedColumnNames = selectedColNames;
    }

    public Vector getSelectedColumnNames() {
        return this.selectedColumnNames;
    }

    public void setAvailableColumnNames(Vector availColNames) {
        this.availableColumnNames = availColNames;
    }

    public Vector getAvailableColumnNames() {
        return this.availableColumnNames;
    }

    public void setColumnDesignStates(Map colDesignStates) {
        this.selectedColumnsDesignStates = colDesignStates;
    }

    public Map getColumnDesignStates() {
        return this.selectedColumnsDesignStates;
    }

    public DesignBean getDataProviderBean() {
        return this.dataProviderBean;
    }

    public void setDataProviderBean(DesignBean modelBean) {
        this.setDataProviderBean(modelBean, true);
    }

    public void setDataProviderBean(DesignBean modelBean, boolean resetColumns) {
        if (modelBean != this.dataProviderBean) {
            if (modelBean.getInstance() instanceof TableDataProvider) {
                this.tableDataProvider = (TableDataProvider)modelBean.getInstance();
            } else if (List.class.isAssignableFrom(modelBean.getBeanInfo().getBeanDescriptor().getBeanClass())) {
                ArrayList listObject = (ArrayList)modelBean.getInstance();
                if (listObject == null) {
                    listObject = new ArrayList();
                }
                this.tableDataProvider = new ObjectListDataProvider(listObject);
                if (modelBean instanceof DesignBeanExt) {
                    try {
                        Type[] parameterTypes = ((DesignBeanExt)modelBean).getTypeParameters();
                        if (parameterTypes != null && parameterTypes.length > 0) {
                            ((ObjectListDataProvider)this.tableDataProvider).setObjectType((Class)parameterTypes[0]);
                        }
                    }
                    catch (ClassNotFoundException exc) {
                        exc.printStackTrace();
                    }
                }
            } else if (modelBean.getInstance() instanceof Object[]) {
                this.tableDataProvider = new ObjectArrayDataProvider((Object[])modelBean.getInstance());
            } else {
                throw new IllegalArgumentException(this.dataProviderBean.getInstanceName() + this.bundle.getString("NOT_DATA_PROVIDER"));
            }
            FieldKey[] columns = this.tableDataProvider.getFieldKeys();
            if (columns == null || columns.length == 0) {
                return;
            }
            DesignBean[] children = this.tableRowGroupBean.getChildBeans();
            for (int i = 0; i < children.length; ++i) {
                this.fcontext.deleteBean(children[i]);
            }
            this.childBeansDeleted = true;
        } else {
            this.childBeansDeleted = false;
        }
        this.dataProviderBean = modelBean;
        if (resetColumns) {
            this.resetTableColumns();
        }
    }

    public void loadState() {
        this.loadModelBean();
        if (!this.dataProviderReset) {
            int i;
            HashMap<String, FieldKey> dpFields = new HashMap<String, FieldKey>();
            try {
                FieldKey[] columns = this.tableDataProvider.getFieldKeys();
                if (columns != null && columns.length > 0) {
                    for (i = 0; i < columns.length; ++i) {
                        if (this.tableDataProvider.getType(columns[i]).toString().indexOf("java.lang.Class") != -1) continue;
                        dpFields.put(columns[i].getDisplayName(), columns[i]);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.loadSourceVariable();
            int childCount = this.tableRowGroupBean.getChildBeanCount();
            for (i = 0; i < childCount; ++i) {
                DesignBean tblColumndBean = this.tableRowGroupBean.getChildBean(i);
                if (!(tblColumndBean.getInstance() instanceof TableColumn)) continue;
                TableColumnDesignState tblColDesignState = new TableColumnDesignState(tblColumndBean);
                tblColDesignState.loadState();
                if (dpFields.keySet().contains(tblColDesignState.getName())) {
                    FieldKey column = (FieldKey)dpFields.get(tblColDesignState.getName());
                    tblColDesignState.setColumnType(this.tableDataProvider.getType(column));
                }
                this.selectedColumnsDesignStates.put(tblColDesignState.getName(), tblColDesignState);
                this.selectedColumnNames.add(tblColDesignState.getName());
            }
        }
        this.paginationRows = this.getIntegerPropertyValue(ROWS_PROPERTY);
        if (this.paginationRows == 0) {
            this.paginationRows = 10;
        }
        this.emptyDataMsg = this.getStringPropertyValue(EMPTY_DATA_MSG_PROPERTY);
    }

    public void loadSourceVariable() {
        this.sourceVarName = this.getStringPropertyValue(SOURCE_VARIABLE_PROPERTY);
    }

    private DesignContext[] getDesignContexts(DesignBean designBean) {
        DesignProject designProject = designBean.getDesignContext().getProject();
        DesignContext[] contexts = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
        DesignContext[] designContexts = new DesignContext[contexts.length + 1];
        designContexts[0] = designBean.getDesignContext();
        System.arraycopy(contexts, 0, designContexts, 1, contexts.length);
        return designContexts;
    }

    private void loadModelBean() {
        String sourceDataStr = this.getPropertyValueSource(SOURCE_DATA_PROPERTY);
        if (sourceDataStr != null) {
            DesignContext[] contexts = this.getDesignContexts(this.tableRowGroupBean);
            block2: for (int i = 0; i < contexts.length; ++i) {
                DesignBean[] dpModelBeans = contexts[i].getBeansOfType(TableDataProvider.class);
                for (int j = 0; j < dpModelBeans.length; ++j) {
                    String modelBindingExpr = ((FacesDesignContext)contexts[i]).getBindingExpr(dpModelBeans[j]);
                    if (!sourceDataStr.startsWith(modelBindingExpr)) continue;
                    this.dataProviderBean = dpModelBeans[j];
                    this.tableDataProvider = (TableDataProvider)this.dataProviderBean.getInstance();
                    break;
                }
                DesignBean[] listModelBeans = contexts[i].getBeansOfType(List.class);
                for (int j = 0; j < listModelBeans.length; ++j) {
                    String modelBindingExpr = ((FacesDesignContext)contexts[i]).getBindingExpr(listModelBeans[j]);
                    if (!sourceDataStr.startsWith(modelBindingExpr)) continue;
                    this.dataProviderBean = listModelBeans[j];
                    ArrayList listObject = (ArrayList)this.dataProviderBean.getInstance();
                    if (listObject == null) {
                        listObject = new ArrayList();
                    }
                    this.tableDataProvider = new ObjectListDataProvider(listObject);
                    if (!(this.dataProviderBean instanceof DesignBeanExt)) break;
                    try {
                        Type[] parameterTypes = ((DesignBeanExt)this.dataProviderBean).getTypeParameters();
                        if (parameterTypes == null || parameterTypes.length <= 0) break;
                        ((ObjectListDataProvider)this.tableDataProvider).setObjectType((Class)parameterTypes[0]);
                    }
                    catch (ClassNotFoundException exc) {
                        exc.printStackTrace();
                    }
                    break;
                }
                DesignBean[] arrayModelBeans = contexts[i].getBeansOfType(Object[].class);
                for (int j = 0; j < arrayModelBeans.length; ++j) {
                    String modelBindingExpr = ((FacesDesignContext)contexts[i]).getBindingExpr(arrayModelBeans[j]);
                    if (!sourceDataStr.startsWith(modelBindingExpr)) continue;
                    this.dataProviderBean = arrayModelBeans[j];
                    this.tableDataProvider = new ObjectArrayDataProvider((Object[])this.dataProviderBean.getInstance());
                    continue block2;
                }
            }
        }
        if (this.dataProviderBean == null) {
            this.dataProviderBean = TableDesignHelper.createDefaultDataProvider(this.tableRowGroupBean.getBeanParent());
            this.tableDataProvider = (TableDataProvider)this.dataProviderBean.getInstance();
            this.resetTableColumns();
            this.dataProviderReset = true;
        }
    }

    private void resetTableColumns() {
        FieldKey[] columns = this.tableDataProvider.getFieldKeys();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                if (this.tableDataProvider.getType(columns[i]).toString().indexOf("java.lang.Class") != -1) continue;
                this.selectedColumnNames.add(columns[i].getDisplayName());
                TableColumnDesignState tblColDesignState = new TableColumnDesignState(columns[i].getDisplayName());
                tblColDesignState.setColumnType(this.tableDataProvider.getType(columns[i]));
                if (this.tableDataProvider.getType(columns[i]).isAssignableFrom(Boolean.class)) {
                    tblColDesignState.setChildType(Checkbox.class);
                }
                this.selectedColumnsDesignStates.put(tblColDesignState.getName(), tblColDesignState);
            }
        }
    }

    public void clearProperties() {
        this.paginationRows = 5;
    }

    public boolean getBooleanPropertyValue(String propertyname) {
        boolean value = false;
        Object propValue = this.getPropertyValue(propertyname);
        if (propValue != null) {
            value = (Boolean)propValue;
        }
        return value;
    }

    private boolean getBooleanPropertyValue(String propertyname, DesignBean bean) {
        boolean value = false;
        Object propValue = this.getPropertyValue(propertyname, bean);
        if (propValue != null) {
            value = (Boolean)propValue;
        }
        return value;
    }

    private String getStringPropertyValue(String propertyname) {
        Object value = this.getPropertyValue(propertyname);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private int getIntegerPropertyValue(String propertyname) {
        Object value = this.getPropertyValue(propertyname);
        if (value != null) {
            return (Integer)value;
        }
        return -1;
    }

    private Object getPropertyValue(String propertyname, DesignBean bean) {
        Object propertyValue = null;
        DesignProperty designProperty = bean.getProperty(propertyname);
        if (designProperty != null && designProperty.getValue() != null) {
            propertyValue = designProperty.getValue();
        }
        return propertyValue;
    }

    private Object getPropertyValue(String propertyname) {
        return this.getPropertyValue(propertyname, this.tableRowGroupBean);
    }

    private String getPropertyValueSource(String propertyname) {
        String propertyValue = null;
        DesignProperty designProperty = this.tableRowGroupBean.getProperty(propertyname);
        if (designProperty != null) {
            propertyValue = designProperty.getValueSource();
        }
        return propertyValue;
    }

    private void setPropertyValue(String propertyname, Object value) {
        Object origValue;
        DesignProperty designProperty;
        if (value != null && (designProperty = this.tableRowGroupBean.getProperty(propertyname)) != null && value != (origValue = this.getPropertyValue(propertyname))) {
            if (value instanceof String && value.toString().equals("")) {
                designProperty.unset();
            } else {
                designProperty.setValue(value);
            }
        }
    }

    private void setPropertyValue(String propertyname, Object value, DesignBean bean) {
        Object origValue;
        DesignProperty designProperty;
        if (value != null && (designProperty = bean.getProperty(propertyname)) != null && value != (origValue = this.getPropertyValue(propertyname, bean))) {
            if (value instanceof String && value.toString().equals("")) {
                designProperty.unset();
            } else {
                designProperty.setValue(value);
            }
        }
    }

    private void setBooleanPropertyValue(String propertyname, boolean value) {
        boolean origValue;
        DesignProperty designProperty = this.tableRowGroupBean.getProperty(propertyname);
        if (designProperty != null && (origValue = this.getBooleanPropertyValue(propertyname)) != value) {
            if (value) {
                designProperty.setValue((Object)new Boolean(true));
            } else {
                designProperty.unset();
            }
        }
    }

    public void setEmptyDataMsg(String msg) {
        this.emptyDataMsg = msg;
    }

    public String getEmptyDataMsg() {
        return this.emptyDataMsg;
    }

    public void setPaginated(boolean paginated) {
        this.rowGroupPaginated = paginated;
    }

    public boolean getPaginated() {
        return this.rowGroupPaginated;
    }

    public void setRows(int rows) {
        this.paginationRows = rows;
    }

    public int getRows() {
        return this.paginationRows;
    }

    public void saveState() {
        int i;
        if (this.selectedColumnNames.size() < 1) {
            return;
        }
        String dataProviderBeanExpr = ((FacesDesignContext)this.dataProviderBean.getDesignContext()).getBindingExpr(this.dataProviderBean);
        TableRowGroupDesignInfo rgdi = (TableRowGroupDesignInfo)this.tableRowGroupBean.getDesignInfo();
        rgdi.setColumnsAlreadyReconstructed(true);
        this.setPropertyValue(SOURCE_DATA_PROPERTY, dataProviderBeanExpr);
        this.setPropertyValue(EMPTY_DATA_MSG_PROPERTY, this.emptyDataMsg);
        this.setBooleanPropertyValue(PAGINATED_PROPERTY, this.rowGroupPaginated);
        if (this.sourceVarName == null) {
            this.sourceVarName = sourceVarNameBase;
        }
        this.setPropertyValue(SOURCE_VARIABLE_PROPERTY, this.sourceVarName);
        try {
            this.setPropertyValue(ROWS_PROPERTY, new Integer(this.paginationRows));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.dataProviderReset) {
            DesignBean[] children = this.tableRowGroupBean.getChildBeans();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.fcontext.deleteBean(children[i2]);
            }
            this.childBeansDeleted = true;
        }
        for (i = 0; i < this.selectedColumnNames.size(); ++i) {
            TableColumnDesignState tblColDesignState = (TableColumnDesignState)this.selectedColumnsDesignStates.get(this.selectedColumnNames.get(i));
            if (tblColDesignState.getTableColumnBean() == null || this.childBeansDeleted) {
                DesignBean tableColumnBean = this.fcontext.createBean(TableColumn.class.getName(), this.tableRowGroupBean, null);
                tblColDesignState.setTableColumnBean(tableColumnBean);
            }
            tblColDesignState.setSourceVariable(this.sourceVarName);
            tblColDesignState.saveState();
            this.fcontext.moveBean(tblColDesignState.getTableColumnBean(), this.tableRowGroupBean, new Position(i));
        }
        for (i = 0; i < this.availableColumnNames.size(); ++i) {
            TableColumnDesignState tblColDesignState = (TableColumnDesignState)this.selectedColumnsDesignStates.get(this.availableColumnNames.get(i));
            if (tblColDesignState.getTableColumnBean() == null) continue;
            this.fcontext.deleteBean(tblColDesignState.getTableColumnBean());
            tblColDesignState.setTableColumnBean(null);
        }
        String tableRowGroupBeanName = this.tableRowGroupBean.getInstanceName();
        String selectionColumnName = tableRowGroupBeanName + "SelectionColumn";
        DesignBean selectionColumnBean = TableDesignHelper.findChildBeanByName(this.tableRowGroupBean, selectionColumnName);
        DesignBean tableBean = this.tableRowGroupBean.getBeanParent();
        boolean useSelectMultipleButton = this.getBooleanPropertyValue("selectMultipleButton", tableBean);
        boolean useDeselectMultipleButton = this.getBooleanPropertyValue("deselectMultipleButton", tableBean);
        if (useSelectMultipleButton || useDeselectMultipleButton) {
            if (selectionColumnBean == null) {
                selectionColumnBean = this.fcontext.createBean(TableColumn.class.getName(), this.tableRowGroupBean, new Position(0));
                selectionColumnBean.setInstanceName(selectionColumnName);
                DesignBean selectionChildBean = this.fcontext.createBean(Checkbox.class.getName(), selectionColumnBean, null);
                String selectionChildName = tableRowGroupBeanName + "SelectionChild";
                selectionChildBean.setInstanceName(selectionChildName);
                this.setPropertyValue("selectId", selectionChildName, selectionColumnBean);
                UIComponent tableComponent = (UIComponent)tableBean.getInstance();
                FacesContext facesContext = this.fcontext.getFacesContext();
                String tableClientId = tableComponent.getClientId(facesContext);
                String javascript = "setTimeout(function(){document.getElementById('" + tableClientId + "').initAllRows()}, 0);";
                this.setPropertyValue("onClick", javascript, selectionColumnBean);
            }
        } else if (selectionColumnBean != null) {
            this.fcontext.deleteBean(selectionColumnBean);
        }
        if (this.childBeansDeleted) {
            TableDesignHelper.adjustTableWidth(this.tableRowGroupBean);
        }
        this.childBeansDeleted = false;
        if (!TableDesignHelper.isDefaultDataProvider(this.tableRowGroupBean.getBeanParent(), this.dataProviderBean)) {
            TableDesignHelper.deleteDefaultDataProvider(this.tableRowGroupBean.getBeanParent());
        }
    }
}

