/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.table;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.Message;
import com.sun.webui.jsf.component.RadioButton;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.component.TextField;

public class TableColumnDesignState {
    private static final String ID_PROPERTY = "id";
    private static final String TEXT_PROPERTY = "text";
    private static final String LABEL_PROPERTY = "label";
    private static final String HEADER_TEXT_PROPERTY = "headerText";
    private static final String FOOTER_TEXT_PROPERTY = "footerText";
    private static final String HORIZONTAL_ALIGN_PROPERTY = "align";
    private static final String VERTICAL_ALIGN_PROPERTY = "valign";
    private static final String SORT_PROPERTY = "sort";
    private static final String WIDTH_PROPERTY = "width";
    private static final String ITEMS_PROPERTY = "items";
    private static final String URL_PROPERTY = "url";
    private static final String SELECTED_PROPERTY = "selected";
    private String columnName = null;
    private String columnHeader = null;
    private String columnFooter = null;
    private String horizontalAlign = null;
    private String verticalAlign = null;
    private String valueExpression = null;
    private String sourceVariable = "currentRow";
    private DesignBean tableColumnBean = null;
    private Class childBeanType = StaticText.class;
    private boolean sortable = true;
    private String columnWidth = null;
    private Class columnType = String.class;

    public TableColumnDesignState(String colName, String colHeader, String valExpression) {
        this.columnName = colName;
        this.columnHeader = colHeader;
        this.valueExpression = valExpression;
    }

    public TableColumnDesignState(String colName) {
        this.columnName = colName;
        this.columnHeader = colName.lastIndexOf(".") > 0 ? this.columnName.substring(this.columnName.lastIndexOf(".") + 1) : this.columnName;
        this.valueExpression = "#{" + this.sourceVariable + ".value['" + this.columnName + "']" + "}";
    }

    public TableColumnDesignState(DesignBean tblColumnBean) {
        this.tableColumnBean = tblColumnBean;
    }

    public void loadState() {
        if (this.tableColumnBean.getChildBeanCount() > 0) {
            DesignBean tableColumnChildBean = this.tableColumnBean.getChildBean(0);
            Object instance = tableColumnChildBean.getInstance();
            this.childBeanType = instance.getClass();
            DesignProperty valueProperty = this.getValueDesignProperty(tableColumnChildBean);
            if (valueProperty != null) {
                this.valueExpression = valueProperty.getValueSource();
                if (this.valueExpression != null) {
                    int startIndex = this.valueExpression.indexOf(91);
                    int endIndex = this.valueExpression.indexOf(93);
                    if (startIndex != -1 && endIndex != -1) {
                        this.columnName = this.valueExpression.substring(startIndex + 2, endIndex - 1);
                    }
                }
            }
        }
        if (this.columnName == null) {
            this.columnName = this.getStringPropertyValue(ID_PROPERTY);
        }
        this.columnFooter = this.getStringPropertyValue(FOOTER_TEXT_PROPERTY);
        this.columnHeader = this.getStringPropertyValue(HEADER_TEXT_PROPERTY);
        this.horizontalAlign = this.getStringPropertyValue(HORIZONTAL_ALIGN_PROPERTY);
        this.verticalAlign = this.getStringPropertyValue(VERTICAL_ALIGN_PROPERTY);
        String sort = this.getStringPropertyValue(SORT_PROPERTY);
        this.sortable = sort != null;
        this.columnWidth = this.getStringPropertyValue(WIDTH_PROPERTY);
    }

    public void clearProperties() {
        this.columnFooter = null;
        this.columnHeader = null;
        this.horizontalAlign = null;
        this.verticalAlign = null;
        this.valueExpression = null;
        this.sortable = true;
    }

    private int getIntegerPropertyValue(String propertyname) {
        Object value = this.getPropertyValue(propertyname);
        if (value != null) {
            return (Integer)value;
        }
        return -1;
    }

    public boolean getBooleanPropertyValue(String propertyname) {
        boolean value = false;
        Object propValue = this.getPropertyValue(propertyname);
        if (propValue != null) {
            value = (Boolean)propValue;
        }
        return value;
    }

    private String getStringPropertyValue(String propertyname) {
        Object value = this.getPropertyValue(propertyname);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Object getPropertyValue(String propertyname) {
        Object propertyValue = null;
        DesignProperty designProperty = this.tableColumnBean.getProperty(propertyname);
        if (designProperty != null && designProperty.getValue() != null) {
            propertyValue = designProperty.getValue();
        }
        return propertyValue;
    }

    private String getPropertyValueSource(String propertyname) {
        String propertyValue = null;
        DesignProperty designProperty = this.tableColumnBean.getProperty(propertyname);
        if (designProperty != null) {
            propertyValue = designProperty.getValueSource();
        }
        return propertyValue;
    }

    private void setPropertyValue(String propertyname, Object value) {
        Object origValue;
        DesignProperty designProperty;
        if (value != null && (designProperty = this.tableColumnBean.getProperty(propertyname)) != null && value != (origValue = this.getPropertyValue(propertyname))) {
            if (value instanceof String && value.toString().equals("")) {
                designProperty.unset();
            } else {
                designProperty.setValue(value);
            }
        }
    }

    private void setBooleanPropertyValue(String propertyname, boolean value) {
        boolean origValue;
        DesignProperty designProperty = this.tableColumnBean.getProperty(propertyname);
        if (designProperty != null && (origValue = this.getBooleanPropertyValue(propertyname)) != value) {
            if (value) {
                designProperty.setValue((Object)new Boolean(true));
            } else {
                designProperty.unset();
            }
        }
    }

    private void unsetPropertyValue(String propertyname) {
        DesignProperty designProperty = this.tableColumnBean.getProperty(propertyname);
        if (designProperty != null) {
            designProperty.unset();
        }
    }

    private DesignProperty getValueDesignProperty(DesignBean tblColumnChildBean) {
        DesignProperty valueProperty = null;
        if (tblColumnChildBean.getInstance() instanceof Button) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof Checkbox) {
            valueProperty = tblColumnChildBean.getProperty(SELECTED_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof RadioButton) {
            valueProperty = tblColumnChildBean.getProperty(LABEL_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof DropDown) {
            valueProperty = tblColumnChildBean.getProperty(SELECTED_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof ImageComponent) {
            valueProperty = tblColumnChildBean.getProperty(URL_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof TextField) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof TextArea) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof StaticText) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof Label) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof Message) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof Hyperlink) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        } else if (tblColumnChildBean.getInstance() instanceof ImageHyperlink) {
            valueProperty = tblColumnChildBean.getProperty(TEXT_PROPERTY);
        }
        return valueProperty;
    }

    public void setTableColumnBean(DesignBean tblColumnBean) {
        this.tableColumnBean = tblColumnBean;
    }

    public DesignBean getTableColumnBean() {
        return this.tableColumnBean;
    }

    public void setValueExpression(String expression) {
        this.valueExpression = expression;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setSourceVariable(String srcVariable) {
        this.sourceVariable = srcVariable;
    }

    public String getSourceVariable() {
        return this.sourceVariable;
    }

    public void setChildType(Class childType) {
        this.childBeanType = childType;
    }

    public Class getChildType() {
        return this.childBeanType;
    }

    public Class getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Class columnType) {
        this.columnType = columnType;
    }

    public String getName() {
        return this.columnName;
    }

    public void setName(String name) {
        this.columnName = name;
    }

    public String getHeader() {
        return this.columnHeader;
    }

    public void setHeader(String header) {
        this.columnHeader = header;
    }

    public String getFooter() {
        return this.columnFooter;
    }

    public void setFooter(String footer) {
        this.columnFooter = footer;
    }

    public void setHorizontalAlign(String horizAlign) {
        this.horizontalAlign = horizAlign;
    }

    public String getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setVerticalAlign(String vertAlign) {
        this.verticalAlign = vertAlign;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setSortable(boolean sort) {
        this.sortable = sort;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setWidth(String width) {
        this.setWidth(width, false);
    }

    public void setWidth(String width, boolean immediat) {
        this.columnWidth = width;
        if (immediat) {
            this.setPropertyValue(WIDTH_PROPERTY, String.valueOf(this.columnWidth));
        }
    }

    public String getWidth() {
        return this.columnWidth;
    }

    public void saveState() {
        DesignProperty valueProperty;
        FacesDesignContext fcontext = (FacesDesignContext)this.tableColumnBean.getDesignContext();
        DesignBean tableColumnChildBean = null;
        if (this.tableColumnBean.getChildBeanCount() > 0) {
            tableColumnChildBean = this.tableColumnBean.getChildBean(0);
            if (!tableColumnChildBean.getInstance().getClass().isAssignableFrom(this.childBeanType)) {
                fcontext.deleteBean(tableColumnChildBean);
                tableColumnChildBean = fcontext.createBean(this.childBeanType.getName(), this.tableColumnBean, null);
            }
        } else {
            tableColumnChildBean = fcontext.createBean(this.childBeanType.getName(), this.tableColumnBean, null);
        }
        if ((valueProperty = this.getValueDesignProperty(tableColumnChildBean)) != null) {
            if (this.valueExpression == null && this.columnName != null && this.sourceVariable != null) {
                this.valueExpression = "#{" + this.sourceVariable + ".value['" + this.columnName + "']" + "}";
            }
            valueProperty.setValue((Object)this.valueExpression);
        }
        if (tableColumnChildBean.getInstance() instanceof DropDown) {
            DesignProperty itemsProperty = tableColumnChildBean.getProperty(ITEMS_PROPERTY);
            if (this.valueExpression != null && itemsProperty != null && itemsProperty.getValue() == null) {
                itemsProperty.setValue((Object)this.valueExpression);
            }
        }
        this.setPropertyValue(FOOTER_TEXT_PROPERTY, this.columnFooter);
        this.setPropertyValue(HEADER_TEXT_PROPERTY, this.columnHeader);
        this.setPropertyValue(HORIZONTAL_ALIGN_PROPERTY, this.horizontalAlign);
        this.setPropertyValue(VERTICAL_ALIGN_PROPERTY, this.verticalAlign);
        if (this.sortable) {
            if (this.isSortAllowed(this.valueExpression, this.columnName)) {
                this.setPropertyValue(SORT_PROPERTY, this.columnName);
            }
        } else {
            this.unsetPropertyValue(SORT_PROPERTY);
        }
        this.setPropertyValue(WIDTH_PROPERTY, this.columnWidth);
    }

    public boolean isSortAllowed() {
        return this.isSortAllowed(this.valueExpression, this.columnName);
    }

    private boolean isSortAllowed(String valueExpression, String colName) {
        if (DropDown.class.isAssignableFrom(this.childBeanType)) {
            return false;
        }
        if (valueExpression != null && valueExpression.trim().startsWith("#{")) {
            String columnName;
            int startIndex = valueExpression.indexOf(91);
            int endIndex = valueExpression.indexOf(93);
            if (startIndex != -1 && endIndex != -1 && (columnName = valueExpression.substring(startIndex + 2, endIndex - 1)).trim().equals(columnName.trim())) {
                return true;
            }
        }
        return false;
    }
}

