/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.hints;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class InlineIncludeHint
implements Fix {
    private static File LAST_DIRECTORY;
    protected Document doc;
    protected int start;
    protected int end;
    protected File file;
    private String fileName;

    public InlineIncludeHint(BaseDocument baseDocument, int n, String string) {
        this.doc = baseDocument;
        this.start = n;
        try {
            this.end = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            this.end = n;
        }
        this.fileName = string;
    }

    private synchronized void findFile() {
        Sources sources;
        if (this.file != null) {
            return;
        }
        this.file = new File(this.fileName);
        if (this.file.isFile()) {
            return;
        }
        Project project = J2MEProjectUtils.getProjectForDocument((Document)this.doc);
        if (project != null && (sources = (Sources)project.getLookup().lookup(Sources.class)) != null) {
            this.file = this.findInGroups(sources, "java");
            if (this.file != null) {
                return;
            }
            this.file = this.findInGroups(sources, "generic");
            if (this.file != null) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findInGroups(Sources sources, String string) {
        SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            File file = FileUtil.toFile((FileObject)sourceGroupArray[i].getRootFolder());
            if (file == null) continue;
            Object object = this;
            synchronized (object) {
                if (LAST_DIRECTORY == null) {
                    LAST_DIRECTORY = file;
                }
            }
            object = new File(file, this.fileName);
            if (!((File)object).isFile()) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ChangeInfo implement() {
        Object object;
        if (this.file == null) {
            object = new JFileChooser(LAST_DIRECTORY);
            ((JFileChooser)object).setDialogTitle(NbBundle.getMessage(InlineIncludeHint.class, (String)"Title_SelectFileToInclude"));
            FF fF = new FF(this.fileName);
            ((JFileChooser)object).addChoosableFileFilter(fF);
            ((JFileChooser)object).setFileFilter(fF);
            if (0 != ((JFileChooser)object).showOpenDialog(WindowManager.getDefault().getMainWindow())) {
                return null;
            }
            this.file = ((JFileChooser)object).getSelectedFile();
            InlineIncludeHint inlineIncludeHint = this;
            synchronized (inlineIncludeHint) {
                LAST_DIRECTORY = this.file.getParentFile();
            }
        }
        object = this.readFile();
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable((String)object){
            final /* synthetic */ String val$content;
            {
                this.val$content = string;
            }

            public void run() {
                try {
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, NbBundle.getMessage(InlineIncludeHint.class, (String)"Comment_After_Insert", (Object)InlineIncludeHint.this.file.getAbsolutePath()), null);
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, this.val$content, null);
                    InlineIncludeHint.this.doc.insertString(InlineIncludeHint.this.end, NbBundle.getMessage(InlineIncludeHint.class, (String)"Comment_Before_Insert", (Object)InlineIncludeHint.this.file.getAbsolutePath()), null);
                    InlineIncludeHint.this.doc.remove(InlineIncludeHint.this.start, InlineIncludeHint.this.end - InlineIncludeHint.this.start);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                RecommentAction.actionPerformed(InlineIncludeHint.this.doc);
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile() {
        String string;
        FileObject fileObject = FileUtil.toFileObject((File)this.file);
        String string2 = string = fileObject != null ? (String)fileObject.getAttribute("Content-Encoding") : null;
        if (string == null || string.length() == 0) {
            string = System.getProperty("file.encoding");
        }
        char[] cArray = new char[(int)this.file.length()];
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.file), string);
            inputStreamReader.read(cArray);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new String(cArray);
    }

    public String getText() {
        this.findFile();
        if (this.file == null) {
            return NbBundle.getMessage(InlineIncludeHint.class, (String)"HintInlineInclude...", (Object)this.fileName);
        }
        return NbBundle.getMessage(InlineIncludeHint.class, (String)"HintInlineInclude", (Object)this.file.getName(), (Object)this.file.getParent());
    }

    private static class FF
    extends FileFilter {
        String name;

        public FF(String string) {
            this.name = string;
            int n = Math.max(this.name.lastIndexOf(47), this.name.lastIndexOf(92));
            if (n >= 0) {
                this.name = this.name.substring(n + 1);
            }
        }

        public boolean accept(File file) {
            return file.isDirectory() || this.name.equals(file.getName());
        }

        public String getDescription() {
            return this.name;
        }
    }
}

