/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Utilities;

public class PPDirectiveCompletionItem
implements CompletionItem {
    private static ImageIcon icon;
    private final String name;
    private final String description;
    private String leftText;

    public PPDirectiveCompletionItem(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        this.substitute(jTextComponent, this.name);
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ' && !keyEvent.isControlDown()) {
            Completion.get().hideCompletion();
        }
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        PPDirectiveCompletionItem pPDirectiveCompletionItem = this;
        synchronized (pPDirectiveCompletionItem) {
            if (icon == null) {
                icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/mobility/editor/resources/d.png"));
            }
        }
        if (bl) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return 50;
    }

    public CharSequence getSortText() {
        return this.name;
    }

    private String getLeftText() {
        if (this.leftText == null) {
            this.leftText = "<b>" + PPDirectiveCompletionItem.toHtmlText(this.name) + "</b>  ";
        }
        return this.leftText;
    }

    private String getRightText() {
        return PPDirectiveCompletionItem.toHtmlText(this.description);
    }

    private void substitute(JTextComponent jTextComponent, String string) {
        int n = jTextComponent.getCaret().getDot();
        Document document = jTextComponent.getDocument();
        try {
            int n2 = org.netbeans.editor.Utilities.getWordStart((JTextComponent)jTextComponent, (int)n);
            int n3 = org.netbeans.editor.Utilities.getWordEnd((JTextComponent)jTextComponent, (int)n);
            if (n2 > 0) {
                String string2 = document.getText(n2, n3 - n2);
                if (string2.startsWith("//#")) {
                    string2 = string2.substring(3);
                    n2 += 3;
                }
                document.remove(n2, string2.length());
                document.insertString(n2, string, null);
            } else {
                document.insertString(n, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static String toHtmlText(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\n': {
                    string2 = "<br>";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(120 * string.length() / 100);
                    if (i > 0) {
                        stringBuffer.append(string.substring(0, i));
                    }
                }
                stringBuffer.append(string2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public CharSequence getInsertPrefix() {
        return this.name;
    }
}

