/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.B2CConverter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.IOException;
import java.util.logging.Level;

public abstract class GrizzlyAdapter
extends StaticResourcesAdapter {
    public static final int ADAPTER_NOTES = 1;
    protected static final boolean ALLOW_BACKSLASH = false;
    private static final boolean COLLAPSE_ADJACENT_SLASHES = true;

    public GrizzlyAdapter() {
    }

    public GrizzlyAdapter(String publicDirectory) {
        super(publicDirectory);
    }

    public void service(Request req, Response res) {
        GrizzlyRequest request = (GrizzlyRequest)req.getNote(1);
        GrizzlyResponse response = (GrizzlyResponse)res.getNote(1);
        if (request == null) {
            request = new GrizzlyRequest();
            request.setRequest(req);
            response = new GrizzlyResponse();
            response.setResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, request);
            res.setNote(1, response);
        }
        try {
            MessageBytes decodedURI = req.decodedURI();
            decodedURI.duplicate(req.requestURI());
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI: " + ioe.getMessage());
                return;
            }
            this.convertURI(decodedURI, request);
            if (!GrizzlyAdapter.normalize(decodedURI)) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return;
            }
            this.service(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace();
            res.setStatus(500);
            res.setMessage("Internal Error");
            return;
        }
    }

    public abstract void service(GrizzlyRequest var1, GrizzlyResponse var2);

    public abstract void afterService(GrizzlyRequest var1, GrizzlyResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterService(Request req, Response res) throws Exception {
        GrizzlyRequest request = (GrizzlyRequest)req.getNote(1);
        GrizzlyResponse response = (GrizzlyResponse)res.getNote(1);
        if (request == null || response == null) {
            return;
        }
        try {
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "afterService exception", t);
        }
        finally {
            request.recycle();
            response.recycle();
            req.recycle();
            res.recycle();
        }
        this.afterService(request, response);
    }

    protected void convertURI(MessageBytes uri, GrizzlyRequest request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        B2CConverter conv = request.getURIConverter();
        try {
            if (conv == null) {
                conv = new B2CConverter("utf-8");
                request.setURIConverter(conv);
            } else {
                conv.recycle();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (conv != null) {
            try {
                conv.convert(bc, cc);
                uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                return;
            }
            catch (IOException e) {
                cc.recycle();
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        int type = uriMB.getType();
        if (type == 3) {
            return GrizzlyAdapter.normalizeChars(uriMB);
        }
        return GrizzlyAdapter.normalizeBytes(uriMB);
    }

    private static boolean normalizeBytes(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                return false;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                GrizzlyAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            GrizzlyAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            GrizzlyAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    private static boolean normalizeChars(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        if (end - start == 1 && c[start] == '*') {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        if (c[start] != '/') {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (c[pos] != '/') continue;
            while (pos + 1 < end && c[pos + 1] == '/') {
                GrizzlyAdapter.copyChars(c, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start > 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            c[end] = 47;
            ++end;
        }
        uriCC.setEnd(end);
        index = 0;
        while ((index = uriCC.indexOf("/./", 0, 3, index)) >= 0) {
            GrizzlyAdapter.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            uriCC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriCC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            GrizzlyAdapter.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriCC.setEnd(end);
            index = index2;
        }
        uriCC.setChars(c, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    private static void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    protected void log(String message) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, message, throwable);
        }
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, bc.getLength());
    }
}

