/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueue;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncReadQueueRecord;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class UDPAsyncQueueReader
implements AsyncQueueReader {
    private SelectorHandler selectorHandler;
    private AsyncQueue<SelectableChannel, AsyncReadQueueRecord> readQueue;
    private ConcurrentLinkedQueue<AsyncReadQueueRecord> recordQueue;

    public UDPAsyncQueueReader(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        this.readQueue = new AsyncQueue();
        this.recordQueue = new ConcurrentLinkedQueue();
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        this.read(key, buffer, callbackHandler, null);
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        this.read(key, buffer, callbackHandler, condition, null);
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (key == null) {
            throw new IOException("SelectionKey is null! Probably key was cancelled or connection was closed?");
        }
        DatagramChannel channel = (DatagramChannel)key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncReadQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        try {
            block23: {
                try {
                    AsyncReadQueueRecord record = null;
                    SocketAddress address = null;
                    boolean isDirectReadCompleted = false;
                    if (currentElement.get() == null && lock.tryLock()) {
                        record = this.obtainRecord();
                        if (currentElement.compareAndSet(null, record)) {
                            do {
                                if ((address = this.doRead(channel, buffer, readPostProcessor)) == null || buffer.hasRemaining() && (condition == null || !condition.checkAsyncReadCompleted(key, address, buffer))) continue;
                                isDirectReadCompleted = true;
                                break;
                            } while (address != null);
                        } else {
                            lock.unlock();
                        }
                    }
                    if (!isDirectReadCompleted && buffer.hasRemaining()) {
                        if (record == null) {
                            record = this.obtainRecord();
                        }
                        record.set(buffer, callbackHandler, condition, readPostProcessor);
                        boolean isRegisterForReading = false;
                        if (currentElement.get() != record) {
                            queue.offer(record);
                            if (!lock.isLocked()) {
                                isRegisterForReading = true;
                            }
                        } else {
                            isRegisterForReading = true;
                            lock.unlock();
                        }
                        if (isRegisterForReading) {
                            this.registerForReading(key);
                        }
                        break block23;
                    }
                    if (callbackHandler != null) {
                        callbackHandler.onReadCompleted(key, address, buffer);
                    }
                    if (lock.isHeldByCurrentThread()) {
                        AsyncReadQueueRecord nextRecord = (AsyncReadQueueRecord)queue.poll();
                        if (nextRecord != null) {
                            currentElement.set(nextRecord);
                            lock.unlock();
                            this.registerForReading(key);
                        } else {
                            currentElement.set(null);
                            lock.unlock();
                            if (queue.peek() != null) {
                                this.registerForReading(key);
                            }
                        }
                    }
                    if (record == null) break block23;
                    this.recordQueue.offer(record);
                }
                catch (IOException e) {
                    this.onClose(channel);
                    throw e;
                }
            }
            Object var16_17 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
            throw throwable;
        }
    }

    public boolean isAsyncQueueReaderEnabledFor(SelectionKey key) {
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.getAsyncQueueEntry(key.channel());
        return channelEntry != null && (channelEntry.currentElement != null || channelEntry.queue != null && !channelEntry.queue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onRead(SelectionKey key) throws IOException {
        DatagramChannel channel = (DatagramChannel)key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncReadQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        if (currentElement.get() == null) {
            AsyncReadQueueRecord nextRecord = (AsyncReadQueueRecord)queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        try {
            while (currentElement.get() != null) {
                AsyncReadQueueRecord queueRecord = (AsyncReadQueueRecord)currentElement.get();
                ByteBuffer byteBuffer = queueRecord.byteBuffer;
                SocketAddress address = null;
                AsyncQueueDataProcessor readPostProcessor = queueRecord.readPostProcessor;
                try {
                    address = this.doRead(channel, byteBuffer, readPostProcessor);
                }
                catch (IOException e) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onIOException(e, key, byteBuffer, queue);
                    } else {
                        Controller.logger().log(Level.SEVERE, "Exception occured when executing asynchronous queue reading", e);
                    }
                    this.onClose(channel);
                }
                AsyncReadCondition condition = queueRecord.condition;
                if (!byteBuffer.hasRemaining() || condition != null && condition.checkAsyncReadCompleted(key, address, byteBuffer)) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onReadCompleted(key, address, byteBuffer);
                    }
                    currentElement.set(queue.poll());
                    this.recordQueue.offer(queueRecord);
                    if (currentElement.get() != null) continue;
                    lock.unlock();
                    AsyncReadQueueRecord nextRecord = queue.peek();
                    if (nextRecord == null || !lock.tryLock()) break;
                    if (!currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                lock.unlock();
                this.registerForReading(key);
                break;
            }
            Object var14_14 = null;
            if (!lock.isHeldByCurrentThread()) return;
            channelEntry.queuedActionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!lock.isHeldByCurrentThread()) throw throwable;
            channelEntry.queuedActionLock.unlock();
            throw throwable;
        }
    }

    public void onClose(SelectableChannel channel) {
        this.readQueue.removeEntry(channel);
    }

    public void close() {
        this.readQueue.clear();
        this.readQueue = null;
    }

    private SocketAddress doRead(DatagramChannel channel, ByteBuffer byteBuffer, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (readPostProcessor != null) {
            ByteBuffer inputByteBuffer = readPostProcessor.getInternalByteBuffer();
            SocketAddress address = this.doRead(channel, inputByteBuffer);
            if (address != null) {
                readPostProcessor.process(byteBuffer);
            }
            return address;
        }
        return this.doRead(channel, byteBuffer);
    }

    private SocketAddress doRead(DatagramChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.receive(byteBuffer);
    }

    private void registerForReading(SelectionKey key) {
        this.selectorHandler.register(key, 1);
    }

    private AsyncReadQueueRecord obtainRecord() {
        AsyncReadQueueRecord record = this.recordQueue.poll();
        if (record == null) {
            record = new AsyncReadQueueRecord();
        }
        return record;
    }
}

