/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.FrameworkStatisticsData;
import com.sun.esb.management.common.data.NMRStatisticsData;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.modules.sun.manager.jbi.actions.RefreshAction;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.JBIComponentType;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.nodes.property.JBIPropertySupportFactory;
import org.netbeans.modules.sun.manager.jbi.util.ComparableAttribute;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBINode
extends AppserverJBIMgmtContainerNode {
    private static final String FRAMEWORK_STATISTICS_SHEET_SET_NAME = "FRAMEWORK_STATISTICS";
    private static final String NMR_STATISTICS_SHEET_SET_NAME = "NMR_STATISTICS";
    private static final String LOGGERS_SHEET_SET_NAME = "LOGGERS";
    private static Logger logger = Logger.getLogger("org.netbeans.modules.sun.manager.jbi.nodes.JBINode");
    private static final String RUNTIME_CONFIG_DISPLAY_NAME = "displayName";
    private static final String RUNTIME_CONFIG_TOOLTIP = "toolTip";
    private static final String RUNTIME_CONFIG_IS_STATIC = "isStatic";
    private static final List<String> hiddenRuntimeConfigNames = new ArrayList<String>();

    public JBINode(AppserverJBIMgmtController appserverJBIMgmtController) {
        super(appserverJBIMgmtController, NodeType.JBI);
    }

    @Override
    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(PropertiesAction.class), SystemAction.get(RefreshAction.class)};
    }

    public Image getIcon(int n) {
        return new ImageIcon(this.getClass().getResource("resources/JBI.png")).getImage();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public void refresh() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        runtimeManagementServiceWrapper.clearJBIComponentStatusCache(JBIComponentType.SERVICE_ENGINE);
        runtimeManagementServiceWrapper.clearJBIComponentStatusCache(JBIComponentType.BINDING_COMPONENT);
        runtimeManagementServiceWrapper.clearJBIComponentStatusCache(JBIComponentType.SHARED_LIBRARY);
        runtimeManagementServiceWrapper.clearServiceAssemblyStatusCache();
        super.refresh();
        this.setSheet(this.createSheet());
    }

    protected Sheet createSheet() {
        Sheet sheet = new Sheet();
        try {
            PropertySupport[] propertySupportArray = this.getGeneralSheetSetPropertySupports();
            Sheet.Set set = this.createSheetSet("GENERAL", "LBL_GENERAL_PROPERTIES", "DSC_GENERAL_PROPERTIES", propertySupportArray);
            if (set != null) {
                sheet.put(set);
            }
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
        }
        try {
            this.addSheetSet(sheet, LOGGERS_SHEET_SET_NAME, "LBL_LOGGERS_PROPERTIES", "DSC_LOGGERS_PROPERTIES", this.getLoggerSheetSetProperties());
        }
        catch (ManagementRemoteException managementRemoteException) {
            logger.warning(managementRemoteException.getMessage());
        }
        try {
            this.addSheetSet(sheet, FRAMEWORK_STATISTICS_SHEET_SET_NAME, "LBL_FRAMEWORK_STATISTICS_PROPERTIES", "DSC_FRAMEWORK_STATISTICS_PROPERTIES", this.getFrameworkStatisticsSheetSetProperties());
        }
        catch (ManagementRemoteException managementRemoteException) {
            logger.warning(managementRemoteException.getMessage());
        }
        try {
            this.addSheetSet(sheet, NMR_STATISTICS_SHEET_SET_NAME, "LBL_NMR_STATISTICS_PROPERTIES", "DSC_NMR_STATISTICS_PROPERTIES", this.getNMRStatisticsSheetSetProperties());
        }
        catch (ManagementRemoteException managementRemoteException) {
            logger.warning(managementRemoteException.getMessage());
        }
        return sheet;
    }

    private PropertySupport[] getGeneralSheetSetPropertySupports() throws ManagementRemoteException {
        ArrayList<PropertySupport> arrayList = new ArrayList<PropertySupport>();
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        ConfigurationService configurationService = appserverJBIMgmtController.getConfigurationService();
        Map map = configurationService.getRuntimeConfigurationAsMap("server");
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(map.keySet());
        Collections.sort(arrayList2);
        for (String string : arrayList2) {
            if (hiddenRuntimeConfigNames.contains(string)) continue;
            Object v = map.get(string);
            Attribute attribute = new Attribute(string, v);
            Properties properties = configurationService.getRuntimeConfigurationMetaData(string);
            String string2 = properties.getProperty(RUNTIME_CONFIG_DISPLAY_NAME);
            String string3 = properties.getProperty(RUNTIME_CONFIG_TOOLTIP);
            String string4 = properties.getProperty(RUNTIME_CONFIG_IS_STATIC, "false");
            MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo(string2, v.getClass().getName(), string3, true, !Boolean.parseBoolean(string4), false);
            PropertySupport propertySupport = JBIPropertySupportFactory.getPropertySupport(this, attribute, mBeanAttributeInfo);
            arrayList.add(propertySupport);
        }
        return arrayList.toArray(new PropertySupport[0]);
    }

    private Map<Attribute, MBeanAttributeInfo> getLoggerSheetSetProperties() throws ManagementRemoteException {
        TreeMap<Attribute, MBeanAttributeInfo> treeMap = new TreeMap<Attribute, MBeanAttributeInfo>();
        ConfigurationService configurationService = this.getConfigurationService();
        Map map = configurationService.getRuntimeLoggerLevels("server");
        for (String string : map.keySet()) {
            Level level = (Level)map.get(string);
            String string2 = configurationService.getRuntimeLoggerDisplayName(string, "server");
            Attribute attribute = new Attribute(string, level);
            MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo(string2, "java.util.logging.Level", string2 + " (" + string + ")", true, true, false);
            treeMap.put(new ComparableAttribute(attribute), mBeanAttributeInfo);
        }
        return treeMap;
    }

    private Map<Attribute, MBeanAttributeInfo> getFrameworkStatisticsSheetSetProperties() throws ManagementRemoteException {
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        FrameworkStatisticsData frameworkStatisticsData = performanceMeasurementServiceWrapper.getFrameworkStatistics("server");
        return Utils.getIntrospectedPropertyMap(frameworkStatisticsData, true, "org.netbeans.modules.sun.manager.jbi.management.model.beaninfo");
    }

    private Map<Attribute, MBeanAttributeInfo> getNMRStatisticsSheetSetProperties() throws ManagementRemoteException {
        AppserverJBIMgmtController appserverJBIMgmtController = this.getAppserverJBIMgmtController();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        NMRStatisticsData nMRStatisticsData = performanceMeasurementServiceWrapper.getNMRStatistics("server");
        return Utils.getIntrospectedPropertyMap(nMRStatisticsData, true);
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        try {
            ConfigurationService configurationService = this.getConfigurationService();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object);
            configurationService.setRuntimeConfiguration(hashMap, "server");
            object = configurationService.getRuntimeConfigurationAsMap("server").get(string);
        }
        catch (ManagementRemoteException managementRemoteException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)managementRemoteException.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return new Attribute(string, object);
    }

    public Attribute setLoggerSheetProperty(String string, Level level) {
        try {
            ConfigurationService configurationService = this.getConfigurationService();
            configurationService.setRuntimeLoggerLevel(string, level, "server");
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            level = null;
        }
        return new Attribute(string, level);
    }

    @Override
    protected boolean needRefresh(String string) {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JBINode.class);
    }

    static {
        hiddenRuntimeConfigNames.add("jbiHome");
        hiddenRuntimeConfigNames.add("autoInstallDir");
        hiddenRuntimeConfigNames.add("autoDeployDir");
    }
}

