/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationMBeanAttributeInfo;
import org.netbeans.modules.sun.manager.jbi.nodes.property.PropertySheetOwner;
import org.netbeans.modules.sun.manager.jbi.nodes.property.SchemaBasedConfigPropertySupportFactory;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIComponentInstallationConfigurationDialog
extends JDialog
implements PropertySheetOwner {
    private String componentName;
    private JBIComponentConfigurationDescriptor rootDescriptor;
    private Properties defaultProperties;
    private Properties properties;
    private boolean cancelled = false;
    private JButton cancelButton;
    private JButton installButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton restoreDefaultButton;

    public JBIComponentInstallationConfigurationDialog(String string, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor) {
        super((Frame)null, true);
        this.componentName = string;
        this.initComponents();
        this.rootDescriptor = jBIComponentConfigurationDescriptor;
        this.initPropertyTable();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void initPropertyTable() {
        final PropertySheetView propertySheetView = new PropertySheetView();
        this.jScrollPane1.setViewportView((Component)propertySheetView);
        ArrayList<PropertySupport> arrayList = new ArrayList<PropertySupport>();
        this.defaultProperties = new Properties();
        this.addPropertySupport(arrayList, this.rootDescriptor, this.defaultProperties);
        this.properties = new Properties(this.defaultProperties);
        final Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Component Configuration");
        if (arrayList != null) {
            set.put((Node.Property[])arrayList.toArray(new PropertySupport[0]));
            sheet.put(set);
        }
        AbstractNode abstractNode = new AbstractNode(Children.LEAF){

            public Node.PropertySet[] getPropertySets() {
                return sheet.toArray();
            }
        };
        SwingUtilities.invokeLater(new Runnable((Node)abstractNode){
            final /* synthetic */ Node val$fakeNode;
            {
                this.val$fakeNode = node;
            }

            public void run() {
                propertySheetView.setNodes(new Node[]{this.val$fakeNode});
                JBIComponentInstallationConfigurationDialog.this.jScrollPane1.validate();
            }
        });
    }

    private void addPropertySupport(List<PropertySupport> list, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, Properties properties) {
        if (!(jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationConfiguration) && !(jBIComponentConfigurationDescriptor instanceof JBIComponentConfigurationDescriptor.ApplicationVariable)) {
            if (jBIComponentConfigurationDescriptor.isProperty()) {
                if (!jBIComponentConfigurationDescriptor.showDisplayAtInstallation()) {
                    return;
                }
                String string = jBIComponentConfigurationDescriptor.getName();
                String string2 = jBIComponentConfigurationDescriptor.getDefaultValue();
                QName qName = jBIComponentConfigurationDescriptor.getTypeQName();
                if (string2 == null) {
                    if (JBIComponentConfigurationDescriptor.XSD_STRING.equals(qName)) {
                        string2 = "";
                    } else if (JBIComponentConfigurationDescriptor.XSD_BOOLEAN.equals(qName)) {
                        string2 = "false";
                    } else if (JBIComponentConfigurationDescriptor.XSD_INT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_BYTE.equals(qName) || JBIComponentConfigurationDescriptor.XSD_SHORT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NEGATIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_NEGATIVE_INTEGER.equals(qName)) {
                        string2 = "0";
                    }
                }
                properties.setProperty(string, string2);
                Object object = null;
                if (JBIComponentConfigurationDescriptor.XSD_INT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_BYTE.equals(qName) || JBIComponentConfigurationDescriptor.XSD_SHORT.equals(qName) || JBIComponentConfigurationDescriptor.XSD_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NEGATIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_POSITIVE_INTEGER.equals(qName) || JBIComponentConfigurationDescriptor.XSD_NON_NEGATIVE_INTEGER.equals(qName)) {
                    object = Integer.parseInt(string2);
                } else if (JBIComponentConfigurationDescriptor.XSD_STRING.equals(qName)) {
                    object = string2;
                } else if (JBIComponentConfigurationDescriptor.XSD_BOOLEAN.equals(qName)) {
                    object = Boolean.parseBoolean(string2);
                } else {
                    String string3 = System.getProperty("line.separator");
                    throw new RuntimeException("The type for configuration property '" + string + "' is not supported: " + qName + string3 + "The supported types are: " + string3 + Arrays.toString(JBIComponentConfigurationDescriptor.SUPPORTED_TYPES));
                }
                Attribute attribute = new Attribute(string, object);
                JBIComponentConfigurationMBeanAttributeInfo jBIComponentConfigurationMBeanAttributeInfo = new JBIComponentConfigurationMBeanAttributeInfo(jBIComponentConfigurationDescriptor, object.getClass().getName(), true, true, false);
                list.add(SchemaBasedConfigPropertySupportFactory.getPropertySupport(this, attribute, jBIComponentConfigurationMBeanAttributeInfo));
            } else {
                for (JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor2 : jBIComponentConfigurationDescriptor.getChildren()) {
                    this.addPropertySupport(list, jBIComponentConfigurationDescriptor2, properties);
                }
            }
        }
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        this.properties.setProperty(string, object.toString());
        return new Attribute(string, object);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.installButton = new JButton();
        this.restoreDefaultButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(JBIComponentInstallationConfigurationDialog.class, (String)"JBIComponentInstallationConfigurationDialog.title", (Object[])new Object[]{this.componentName}));
        this.jLabel1.setText(NbBundle.getMessage(JBIComponentInstallationConfigurationDialog.class, (String)"JBIComponentInstallationConfigurationDialog.jLabel1.text"));
        this.installButton.setText(NbBundle.getMessage(JBIComponentInstallationConfigurationDialog.class, (String)"JBIComponentInstallationConfigurationDialog.installButton.text"));
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBIComponentInstallationConfigurationDialog.this.installButtonActionPerformed(actionEvent);
            }
        });
        this.restoreDefaultButton.setText(NbBundle.getMessage(JBIComponentInstallationConfigurationDialog.class, (String)"JBIComponentInstallationConfigurationDialog.restoreDefaultButton.text"));
        this.restoreDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBIComponentInstallationConfigurationDialog.this.restoreDefaultButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText(NbBundle.getMessage(JBIComponentInstallationConfigurationDialog.class, (String)"JBIComponentInstallationConfigurationDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBIComponentInstallationConfigurationDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 481, Short.MAX_VALUE).add(1, (Component)this.jLabel1, -1, 481, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0).add((Component)this.restoreDefaultButton).addPreferredGap(0).add((Component)this.cancelButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((Component)this.jLabel1, -2, 23, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 217, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.restoreDefaultButton).add((Component)this.installButton)).addContainerGap()));
        this.pack();
    }

    private void restoreDefaultButtonActionPerformed(ActionEvent actionEvent) {
        this.properties = new Properties(this.defaultProperties);
        this.initPropertyTable();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JBIComponentInstallationConfigurationDialog jBIComponentInstallationConfigurationDialog = new JBIComponentInstallationConfigurationDialog("FOO", null);
                jBIComponentInstallationConfigurationDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                jBIComponentInstallationConfigurationDialog.setVisible(true);
            }
        });
    }
}

