/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JBIFrameworkService
implements Serializable {
    public static final String ADMIN_SERVICE_OBJECTNAME = "com.sun.jbi:ServiceName=JbiAdminUiService,ComponentType=System";
    public static final String JBI_CLASS_NAME_KEY = "class-name";
    public static final String JBI_CLASSPATH_KEY = "classpath";
    public static final String DESCRIPTION_KEY = "description";
    public static final String ENABLED_KEY = "enabled";
    public static final String IS_FAILURE_FATAL_KEY = "is-failure-fatal";
    public static final String LOAD_ORDER_KEY = "load-order";
    public static final String NAME_KEY = "name";
    public static final String JBI_CONFIG_OBJECTNAME = "com.sun.appserv:name=JBIFramework,type=lifecycle-module,category=config";
    public static final String JBI_GETPROPERTYVALUE_OPERATION_NAME = "getPropertyValue";
    public static final String JBI_SETPROPERTY_OPERATION_NAME = "setProperty";
    private MBeanServerConnection serverConnection = null;
    private String className;
    private String classpath;
    private String description;
    private boolean enabled;
    private boolean failureFatal;
    private String loadOrder;
    private String name;
    boolean jbiFrameworkEnabled;
    boolean isUIMBeanRegistered;

    public JBIFrameworkService(MBeanServerConnection mBeanServerConnection) {
        this.serverConnection = mBeanServerConnection;
        this.initialize();
    }

    void initialize() {
        try {
            this.jbiInitialize();
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            attributeNotFoundException.printStackTrace();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            instanceNotFoundException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (MBeanException mBeanException) {
            mBeanException.printStackTrace();
        }
        catch (ReflectionException reflectionException) {
            reflectionException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void jbiInitialize() throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        QueryExp queryExp = null;
        Set<ObjectName> set = null;
        ObjectName objectName = null;
        objectName = new ObjectName(JBI_CONFIG_OBJECTNAME);
        ObjectName objectName2 = new ObjectName(ADMIN_SERVICE_OBJECTNAME);
        if (this.serverConnection != null) {
            try {
                this.isUIMBeanRegistered = this.serverConnection.isRegistered(objectName2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            set = this.serverConnection.queryNames(objectName, queryExp);
            Iterator<ObjectName> iterator = set.iterator();
            if (iterator != null && iterator.hasNext()) {
                objectName = iterator.next();
            }
            if (objectName != null) {
                this.className = (String)this.serverConnection.getAttribute(objectName, JBI_CLASS_NAME_KEY);
                this.description = (String)this.serverConnection.getAttribute(objectName, DESCRIPTION_KEY);
                String string = (String)this.serverConnection.getAttribute(objectName, ENABLED_KEY);
                if (string != null) {
                    this.enabled = string.equalsIgnoreCase("True");
                }
                this.classpath = (String)this.serverConnection.getAttribute(objectName, JBI_CLASSPATH_KEY);
                string = (String)this.serverConnection.getAttribute(objectName, IS_FAILURE_FATAL_KEY);
                if (string != null) {
                    this.failureFatal = string.equalsIgnoreCase("True");
                }
                this.loadOrder = (String)this.serverConnection.getAttribute(objectName, LOAD_ORDER_KEY);
                this.name = (String)this.serverConnection.getAttribute(objectName, NAME_KEY);
                this.jbiFrameworkEnabled = true;
            } else {
                this.jbiFrameworkEnabled = false;
                System.out.println("Cound not find the JBI Configuration MBean");
            }
        } else {
            System.out.println("Could not connect to application server");
        }
    }

    Object invoke(ObjectName objectName, String string) {
        String string2 = JBI_GETPROPERTYVALUE_OPERATION_NAME;
        String string3 = null;
        Object[] objectArray = new String[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        try {
            string3 = (String)this.serverConnection.invoke(objectName, string2, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            instanceNotFoundException.printStackTrace();
        }
        catch (MBeanException mBeanException) {
            mBeanException.printStackTrace();
        }
        catch (ReflectionException reflectionException) {
            reflectionException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string3;
    }

    public MBeanServerConnection getServerConnection() {
        return this.serverConnection;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFailureFatal() {
        return this.failureFatal;
    }

    public String getLoadOrder() {
        return this.loadOrder;
    }

    public String getName() {
        return this.name;
    }

    public boolean isJbiFrameworkEnabled() {
        return this.jbiFrameworkEnabled && this.isEnabled();
    }

    public void printOut() {
        System.out.println("//////////////////////////////////////////////////////////////////");
        System.out.println("//                 -- JBI Configuration --                      //");
        System.out.println("//////////////////////////////////////////////////////////////////");
        System.out.println("// description is: " + this.getDescription());
        System.out.println("// enabled is: " + this.isEnabled());
        System.out.println("// is-failure-fatal is: " + this.isFailureFatal());
        System.out.println("// class-name is: " + this.getClassName());
        System.out.println("// classpath is: " + this.getClasspath());
        System.out.println("// load-order is: " + this.getLoadOrder());
        System.out.println("// name is: " + this.getName());
        System.out.println("//////////////////////////////////////////////////////////////////");
    }

    public static JBIFrameworkService getJBIConfiguration() {
        JBIFrameworkService jBIFrameworkService = null;
        return jBIFrameworkService;
    }

    public static void test(MBeanServerConnection mBeanServerConnection) {
        if (mBeanServerConnection != null) {
            JBIFrameworkService jBIFrameworkService = new JBIFrameworkService(mBeanServerConnection);
            jBIFrameworkService.printOut();
            if (jBIFrameworkService.isJbiFrameworkEnabled()) {
                System.out.println("**** JBI Framework is Enabled ****");
            } else {
                System.out.println("**** JBI Framework is NOT Enabled ****");
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "com.sun.enterprise.admin.jmx.remote.protocol";
        String string2 = "com.sun.enterprise.as.http.auth";
        String string3 = "BASIC";
        String string4 = "USER";
        String string5 = "PASSWORD";
        String string6 = "s1ashttp";
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        string7 = "localhost";
        string8 = "4848";
        string9 = "admin";
        string10 = "adminadmin";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jmx.remote.protocol.provider.pkgs", string);
        hashMap.put(string2, string3);
        hashMap.put(string4, string9);
        hashMap.put(string5, string10);
        try {
            int n = new Integer(string8);
            MBeanServerConnection mBeanServerConnection = null;
            JMXServiceURL jMXServiceURL = new JMXServiceURL(string6, string7, n);
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            System.out.println("Connection Retrieved." + mBeanServerConnection.toString());
            JBIFrameworkService.test(mBeanServerConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Connection Failed " + exception.getMessage());
        }
    }
}

