/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.api.notification.NotificationService;
import com.sun.esb.management.client.ManagementClient;
import com.sun.esb.management.client.ManagementClientFactory;
import com.sun.esb.management.common.ManagementRemoteException;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.sun.manager.jbi.management.JBIClassLoader;
import org.netbeans.modules.sun.manager.jbi.management.JBIFrameworkService;
import org.netbeans.modules.sun.manager.jbi.management.connectors.HTTPServerConnector;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.impl.PerformanceMeasurementServiceWrapperImpl;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.impl.RuntimeManagementServiceWrapperImpl;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstance;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstanceReader;

public class AppserverJBIMgmtController {
    private MBeanServerConnection mBeanServerConnection;
    private MBeanServerConnection myMBeanServerConnection;
    private ManagementClient managementClient;
    private AdministrationService administrationService;
    private DeploymentService deploymentService;
    private InstallationService installationService;
    private ConfigurationService configurationService;
    private PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper;
    private RuntimeManagementServiceWrapper runtimeManagementServiceWrapper;
    private NotificationService notificationService;
    private String hostName;
    private String port;
    private String userName;
    private String password;
    public static final String SERVER_TARGET = "server";
    private static final String HOST_MBEAN_NAME = "com.sun.appserv:name=server,type=virtual-server,category=monitor,server=server";
    private static final String HOST_ASADMIN_MBEAN_NAME = "com.sun.appserv:type=Host,host=__asadmin";
    private static final String HTTP_PORT_MBEAN_NAME = "com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config";
    private static Logger logger = Logger.getLogger("org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController");

    public AppserverJBIMgmtController(MBeanServerConnection mBeanServerConnection) {
        this.mBeanServerConnection = mBeanServerConnection;
        this.init();
        this.managementClient = new ManagementClient(this.myMBeanServerConnection, true);
    }

    public boolean isJBIFrameworkEnabled() {
        JBIFrameworkService jBIFrameworkService = new JBIFrameworkService(this.mBeanServerConnection);
        return jBIFrameworkService.isJbiFrameworkEnabled();
    }

    public AdministrationService getAdministrationService() throws ManagementRemoteException {
        if (this.administrationService == null) {
            this.administrationService = this.managementClient.getAdministrationService();
        }
        return this.administrationService;
    }

    public DeploymentService getDeploymentService() throws ManagementRemoteException {
        if (this.deploymentService == null) {
            this.deploymentService = this.managementClient.getDeploymentService();
        }
        return this.deploymentService;
    }

    public InstallationService getInstallationService() throws ManagementRemoteException {
        if (this.installationService == null) {
            this.installationService = this.managementClient.getInstallationService();
        }
        return this.installationService;
    }

    public ConfigurationService getConfigurationService() throws ManagementRemoteException {
        if (this.configurationService == null) {
            this.configurationService = this.managementClient.getConfigurationService();
        }
        return this.configurationService;
    }

    public NotificationService getNotificationService() throws ManagementRemoteException {
        if (this.notificationService == null) {
            String string = this.managementClient.getAdministrationService().getJmxRmiPort();
            this.notificationService = ManagementClientFactory.getInstance((String)this.hostName, (int)Integer.parseInt(string), (String)this.userName, (String)this.password).getNotificationService();
        }
        return this.notificationService;
    }

    public PerformanceMeasurementServiceWrapper getPerformanceMeasurementServiceWrapper() throws ManagementRemoteException {
        if (this.performanceMeasurementServiceWrapper == null) {
            this.performanceMeasurementServiceWrapper = new PerformanceMeasurementServiceWrapperImpl(this.managementClient.getPerformanceMeasurementService());
        }
        return this.performanceMeasurementServiceWrapper;
    }

    public RuntimeManagementServiceWrapper getRuntimeManagementServiceWrapper() throws ManagementRemoteException {
        if (this.runtimeManagementServiceWrapper == null) {
            this.runtimeManagementServiceWrapper = new RuntimeManagementServiceWrapperImpl(this.managementClient.getRuntimeManagementService());
        }
        return this.runtimeManagementServiceWrapper;
    }

    private void init() {
        String string = System.getProperty("netbeans.user");
        try {
            if (string != null) {
                ServerInstance serverInstance = null;
                String string2 = string + ServerInstanceReader.RELATIVE_FILE_PATH;
                File file = new File(string2);
                if (!file.exists()) {
                    logger.warning("The application server definition file " + string2 + " is missing.");
                } else {
                    ServerInstanceReader serverInstanceReader = new ServerInstanceReader(string2);
                    List<ServerInstance> list = serverInstanceReader.getServerInstances();
                    for (ServerInstance object : list) {
                        if (!this.isCurrentInstance(object)) continue;
                        serverInstance = object;
                        break;
                    }
                    if (serverInstance == null && list.size() == 1) {
                        logger.warning("Could not find the server instance. Use the only instance available in " + string2 + ".");
                        serverInstance = list.get(0);
                    }
                    if (serverInstance == null) {
                        int n = 0;
                        for (ServerInstance serverInstance2 : list) {
                            if (serverInstance2.getHostName().equals("localhost")) continue;
                            ++n;
                        }
                        if (n == 1) {
                            for (ServerInstance serverInstance2 : list) {
                                if (serverInstance2.getHostName().equals("localhost")) continue;
                                logger.warning("Could not find the server instance. Use the only remote instance defined in " + string2 + ".");
                                serverInstance = serverInstance2;
                                break;
                            }
                        }
                    }
                    if (serverInstance != null) {
                        JBIClassLoader jBIClassLoader = new JBIClassLoader(serverInstance);
                        this.hostName = serverInstance.getHostName();
                        this.port = serverInstance.getAdminPort();
                        this.userName = serverInstance.getUserName();
                        this.password = serverInstance.getPassword();
                        HTTPServerConnector hTTPServerConnector = new HTTPServerConnector(this.hostName, this.port, this.userName, this.password, jBIClassLoader);
                        this.myMBeanServerConnection = hTTPServerConnector.getConnection();
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
        }
        if (this.myMBeanServerConnection == null) {
            try {
                logger.warning("Could not find the server instance. Falling back on the mBeanServerConnection provided by NetBeans.");
                this.myMBeanServerConnection = this.mBeanServerConnection;
            }
            catch (Exception exception) {
                logger.warning(exception.getMessage());
            }
        }
    }

    private boolean isCurrentInstance(ServerInstance serverInstance) {
        boolean bl = false;
        String string = serverInstance.getHostName();
        if (string.equals("localhost")) {
            string = AppserverJBIMgmtController.getHostName();
            bl = true;
        }
        try {
            ObjectName objectName = new ObjectName(HOST_MBEAN_NAME);
            String string2 = (String)this.mBeanServerConnection.getAttribute(objectName, "hosts-current");
            String string3 = InetAddress.getByName(string).getCanonicalHostName();
            String string4 = InetAddress.getByName(string2).getCanonicalHostName();
            String string5 = InetAddress.getByName(string).getHostAddress();
            String string6 = InetAddress.getByName(string2).getHostAddress();
            logger.fine("isCurrentInstance():");
            logger.fine("    isLocalHost? " + bl);
            logger.fine("    instanceHost=" + string + " CanonicalHostName=" + string3 + " IP=" + string5);
            logger.fine("            host=" + string2 + " CanonicalHostName=" + string4 + " IP=" + string6);
            if (string3.equals(string4) || string5.equals(string6)) {
                objectName = new ObjectName(HOST_ASADMIN_MBEAN_NAME);
                String string7 = (String)this.mBeanServerConnection.getAttribute(objectName, "appBase");
                String string8 = serverInstance.getLocation();
                assert (string8 != null);
                string8 = string8.replace('\\', '/');
                if (bl) {
                    logger.fine("    localInstanceLocation=" + string8);
                    logger.fine("                  appBase=" + string7);
                }
                if (!bl || string7.toLowerCase().startsWith(string8.toLowerCase()) && new File(string8).exists()) {
                    objectName = new ObjectName(HTTP_PORT_MBEAN_NAME);
                    String string9 = (String)this.mBeanServerConnection.getAttribute(objectName, "port");
                    String string10 = serverInstance.getHttpPortNumber();
                    logger.fine("    instanceHttpPort=" + string10);
                    logger.fine("                port=" + string9);
                    if (string9.equals(string10)) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static String getHostName() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string;
    }
}

