/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.netbeans.modules.sun.manager.jbi.editors.SimpleTabularDataCustomEditor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class SimpleTabularDataEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    protected String tableLabelText;
    protected String tableLabelDescription;
    private TabularType tabularType;
    protected JBIComponentConfigurationDescriptor descriptor;
    protected SimpleTabularDataCustomEditor customEditor;
    protected boolean isWritable;

    public SimpleTabularDataEditor(String string, String string2, TabularType tabularType, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, boolean bl) {
        this.tabularType = tabularType;
        this.tableLabelText = string;
        this.tableLabelDescription = string2;
        this.descriptor = jBIComponentConfigurationDescriptor;
        this.isWritable = bl;
    }

    public String getAsText() {
        Object object = this.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            assert (object instanceof TabularData);
            TabularData tabularData = (TabularData)object;
            stringBuilder.append("{");
            for (Object obj : tabularData.values()) {
                CompositeData compositeData = (CompositeData)obj;
                String string = this.getStringForRowData(compositeData);
                stringBuilder.append(string);
            }
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    protected String getStringForRowData(CompositeData compositeData) {
        Collection<?> collection = compositeData.values();
        return collection.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            TabularType tabularType = ((TabularData)this.getValue()).getTabularType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            CompositeType compositeType = tabularType.getRowType();
            String[] stringArray = compositeType.keySet().toArray(new String[0]);
            if (string != null) {
                String string2 = string.trim().replaceFirst("\\{\\s*\\[", "").replaceAll("\\]\\s*\\[", "\n").replaceFirst("\\]\\s*\\}", "");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        arrayList.add(stringTokenizer2.nextToken().trim());
                    }
                    Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
                    this.validateRowData((String[])objectArray);
                    CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                    tabularDataSupport.put(compositeDataSupport);
                }
            }
            this.setValue(tabularDataSupport);
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    protected void validateRowData(String[] stringArray) throws Exception {
    }

    public void setValue(Object object) {
        super.setValue(object);
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.customEditor = new SimpleTabularDataCustomEditor(this, this.tableLabelText, this.tableLabelDescription, this.descriptor, this.isWritable);
        return this.customEditor;
    }

    TabularType getTabluarType() {
        return this.tabularType;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.getFeatureDescriptor().setValue("canEditAsText", false);
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("state".equals(propertyChangeEvent.getPropertyName())) {
                    try {
                        SimpleTabularDataEditor.this.customEditor.getPropertyValue();
                    }
                    catch (Exception exception) {
                        throw new PropertyVetoException(exception.getMessage(), propertyChangeEvent);
                    }
                }
            }
        });
    }
}

