/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import com.sun.esb.management.api.administration.AdministrationService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.IEndpointStatisticsData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.model.beaninfo.EndpointStatisticsDataBeanInfo;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.PerformanceMeasurementServiceWrapper;
import org.openide.util.NbBundle;

public class ComponentEndpointsStatisticsDialog
extends JDialog {
    private TableModel pTableModel;
    private TableModel cTableModel;
    private JLabel cLabel;
    private JTable cTable;
    private JScrollPane cTableScrollPane;
    private JPanel jPanel1;
    private JButton okButton;
    private JLabel pLabel;
    private JTable pTable;
    private JScrollPane pTableScrollPane;

    public ComponentEndpointsStatisticsDialog(AppserverJBIMgmtController appserverJBIMgmtController, String string) throws ManagementRemoteException {
        super((Frame)null, true);
        this.setTitle(NbBundle.getMessage(ComponentEndpointsStatisticsDialog.class, (String)"TTL_ENDPOINT_STATISTICS", (Object)string));
        this.pTableModel = this.getStatisticsTableModel(appserverJBIMgmtController, string, false);
        this.cTableModel = this.getStatisticsTableModel(appserverJBIMgmtController, string, true);
        this.initComponents();
    }

    private TableModel getStatisticsTableModel(AppserverJBIMgmtController appserverJBIMgmtController, String string, boolean bl) throws ManagementRemoteException {
        AdministrationService administrationService = appserverJBIMgmtController.getAdministrationService();
        PerformanceMeasurementServiceWrapper performanceMeasurementServiceWrapper = appserverJBIMgmtController.getPerformanceMeasurementServiceWrapper();
        HashMap<Endpoint, IEndpointStatisticsData> hashMap = new HashMap<Endpoint, IEndpointStatisticsData>();
        String[] stringArray = bl ? administrationService.getConsumingEndpoints(string, "server") : administrationService.getProvisioningEndpoints(string, "server");
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        for (String string2 : stringArray) {
            assert (bl && string2.endsWith(",Consumer") || !bl && string2.endsWith(",Provider"));
            string2 = string2.substring(0, string2.lastIndexOf(","));
            IEndpointStatisticsData iEndpointStatisticsData = performanceMeasurementServiceWrapper.getEndpointStatistics(string2, "server");
            String[] stringArray2 = string2.split(",");
            Endpoint endpoint = new Endpoint(stringArray2[0], stringArray2[1], stringArray2[2]);
            arrayList.add(endpoint);
            hashMap.put(endpoint, iEndpointStatisticsData);
        }
        return new EndpointStatisticsTableModel(arrayList, hashMap);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.pLabel = new JLabel();
        this.pTableScrollPane = new JScrollPane();
        this.pTable = new JTable();
        this.cLabel = new JLabel();
        this.cTableScrollPane = new JScrollPane();
        this.cTable = new JTable();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.pLabel.setText(NbBundle.getMessage(ComponentEndpointsStatisticsDialog.class, (String)"ComponentEndpointsStatisticsDialog.pLabel.text"));
        this.pTable.setModel(this.pTableModel);
        this.pTableScrollPane.setViewportView(this.pTable);
        this.pTable.setAutoResizeMode(4);
        this.pTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.pTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(300);
        this.cLabel.setText(NbBundle.getMessage(ComponentEndpointsStatisticsDialog.class, (String)"ComponentEndpointsStatisticsDialog.cLabel.text"));
        this.cTable.setModel(this.cTableModel);
        this.cTableScrollPane.setViewportView(this.cTable);
        this.cTable.setAutoResizeMode(4);
        this.cTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn2 = this.cTable.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(300);
        this.okButton.setText(NbBundle.getMessage(ComponentEndpointsStatisticsDialog.class, (String)"ComponentEndpointsStatisticsDialog.okButton.text"));
        this.okButton.setSelected(true);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentEndpointsStatisticsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.pLabel).add((Component)this.cLabel)).addContainerGap(860, Short.MAX_VALUE)).add((Component)this.pTableScrollPane, -1, 971, Short.MAX_VALUE).add((Component)this.cTableScrollPane, -1, 971, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.okButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pLabel).addPreferredGap(0).add((Component)this.pTableScrollPane, -1, 134, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.cLabel).addPreferredGap(0).add((Component)this.cTableScrollPane, -1, 121, Short.MAX_VALUE).add(17, 17, 17).add((Component)this.okButton)));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EndpointStatisticsTableModel
    extends AbstractTableModel {
        private List<Endpoint> endpoints;
        private Map<Endpoint, IEndpointStatisticsData> statisticsMap;

        EndpointStatisticsTableModel(List<Endpoint> list, Map<Endpoint, IEndpointStatisticsData> map) {
            this.endpoints = list;
            this.statisticsMap = map;
        }

        @Override
        public int getRowCount() {
            return this.statisticsMap.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = "Endpoint";
            } else if (n == 1) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_RECEIVED_DONES");
            } else if (n == 2) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_RECEIVED_ERRORS");
            } else if (n == 3) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_RECEIVED_FAULTS");
            } else if (n == 4) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_SENT_DONES");
            } else if (n == 5) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_SENT_ERRORS");
            } else if (n == 6) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_NUM_OF_SENT_FAULTS");
            } else if (n == 7) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_MSG_EXCHANGE_COMPONENT_TIME_AVERAGE");
            } else if (n == 8) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_MSG_EXCHANGE_DELIVERY_CHANNEL_TIME_AVERAGE");
            } else if (n == 9) {
                string = NbBundle.getMessage(EndpointStatisticsDataBeanInfo.class, (String)"LBL_MSG_EXCHANGE_MESSAGE_SERVICE_TIME_AVERAGE");
            }
            return "<HTML><B>" + string + "</B></HTML>";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Endpoint endpoint = this.endpoints.get(n);
            if (n2 == 0) {
                return endpoint.getServiceName() + "," + endpoint.getEndpointName();
            }
            if (n2 == 1) {
                return this.statisticsMap.get(endpoint).getNumberOfReceivedDones();
            }
            if (n2 == 2) {
                return this.statisticsMap.get(endpoint).getNumberOfReceivedErrors();
            }
            if (n2 == 3) {
                return this.statisticsMap.get(endpoint).getNumberOfReceivedFaults();
            }
            if (n2 == 4) {
                return this.statisticsMap.get(endpoint).getNumberOfSentDones();
            }
            if (n2 == 5) {
                return this.statisticsMap.get(endpoint).getNumberOfSentErrors();
            }
            if (n2 == 6) {
                return this.statisticsMap.get(endpoint).getNumberOfSentFaults();
            }
            if (n2 == 7) {
                return this.statisticsMap.get(endpoint).getMessageExchangeComponentTimeAverage();
            }
            if (n2 == 8) {
                return this.statisticsMap.get(endpoint).getMessageExchangeDeliveryChannelTimeAverage();
            }
            if (n2 == 9) {
                return this.statisticsMap.get(endpoint).getMessageExchangeServiceTimeAverage();
            }
            return null;
        }
    }

    class Endpoint {
        private String namespaceURI;
        private String serviceName;
        private String endpointName;

        Endpoint(String string, String string2, String string3) {
            this.namespaceURI = string;
            this.serviceName = string2;
            this.endpointName = string3;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

