/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexUtilities {
    private static final Set<TokenId> END_PAIRS = new HashSet<TokenId>();
    private static final Set<TokenId> INDENT_WORDS = new HashSet<TokenId>();

    private LexUtilities() {
    }

    public static int getLexerOffset(CompilationInfo compilationInfo, int n) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-ruby", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            return translatedSource.getLexicalOffset(n);
        }
        return n;
    }

    public static OffsetRange getLexerOffsets(CompilationInfo compilationInfo, OffsetRange offsetRange) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-ruby", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            int n = offsetRange.getStart();
            int n2 = translatedSource.getLexicalOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    public static TokenSequence<? extends RubyTokenId> getRubyTokenSequence(BaseDocument baseDocument, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        return LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
    }

    private static TokenSequence<? extends RubyTokenId> findRhtmlDelimited(TokenSequence tokenSequence, int n) {
        if (tokenSequence.language().mimeType().equals("application/x-httpd-eruby")) {
            TokenSequence tokenSequence2;
            tokenSequence.move(n);
            if (tokenSequence.moveNext() && tokenSequence.token() != null && "ruby-delimiter".equals(tokenSequence.token().id().primaryCategory()) && tokenSequence.moveNext() && tokenSequence.token() != null && "ruby".equals(tokenSequence.token().id().primaryCategory()) && (tokenSequence2 = tokenSequence.embedded()) != null) {
                return tokenSequence2;
            }
        }
        return null;
    }

    public static TokenSequence<? extends RubyTokenId> getRubyTokenSequence(TokenHierarchy<Document> tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(RubyTokenId.language());
        if (tokenSequence == null) {
            TokenSequence<? extends RubyTokenId> tokenSequence2;
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence3 : list) {
                if (tokenSequence3.language() == RubyTokenId.language()) {
                    tokenSequence = tokenSequence3;
                    break;
                }
                tokenSequence2 = LexUtilities.findRhtmlDelimited(tokenSequence3, n);
                if (tokenSequence2 == null) continue;
                return tokenSequence2;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence3 : list) {
                    if (tokenSequence3.language() == RubyTokenId.language()) {
                        tokenSequence = tokenSequence3;
                        break;
                    }
                    tokenSequence2 = LexUtilities.findRhtmlDelimited(tokenSequence3, n);
                    if (tokenSequence2 == null) continue;
                    return tokenSequence2;
                }
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<? extends RubyTokenId> getPositionedSequence(BaseDocument baseDocument, int n) {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static Token<? extends RubyTokenId> getToken(BaseDocument baseDocument, int n) {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null) {
            return tokenSequence.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument baseDocument, int n) {
        String string;
        Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token != null && (string = ((Object)token.text()).toString()).length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static OffsetRange findHeredocEnd(TokenSequence<? extends RubyTokenId> tokenSequence, Token<? extends RubyTokenId> token) {
        String string = ((Object)token.text()).toString();
        assert (string.startsWith("<<"));
        if ((string = string.substring(2)).startsWith("-")) {
            string = string.substring(1);
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(0, string.length() - 2);
        }
        String string2 = string + "\n";
        while (tokenSequence.moveNext()) {
            String string3;
            Token token2 = tokenSequence.token();
            TokenId tokenId = token2.id();
            if (tokenId != RubyTokenId.STRING_END && tokenId != RubyTokenId.QUOTED_STRING_END || !string.equals(string3 = ((Object)token2.text()).toString()) && !string2.equals(string3)) continue;
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token2.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findHeredocBegin(TokenSequence<? extends RubyTokenId> tokenSequence, Token<? extends RubyTokenId> token) {
        String string = ((Object)token.text()).toString();
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = "\"" + string + "\"";
        String string3 = "'" + string + "'";
        while (tokenSequence.movePrevious()) {
            Token token2 = tokenSequence.token();
            TokenId tokenId = token2.id();
            if (tokenId != RubyTokenId.STRING_BEGIN && tokenId != RubyTokenId.QUOTED_STRING_BEGIN) continue;
            String string4 = ((Object)token2.text()).toString();
            String string5 = null;
            if (string4.startsWith("<<-")) {
                string5 = string4.substring(3);
            } else if (string4.startsWith("<<")) {
                string5 = string4.substring(2);
            }
            if (string5 == null || !string.equals(string5) && !string2.equals(string5) && !string3.equals(string5)) continue;
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token2.length());
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findFwd(BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBegin(BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                --n;
                continue;
            }
            if (tokenId != RubyTokenId.END) continue;
            ++n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findEnd(BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                --n;
                continue;
            }
            if (tokenId != RubyTokenId.END) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            ++n;
        }
        return OffsetRange.NONE;
    }

    public static boolean isEndmatchingDo(BaseDocument baseDocument, int n) {
        try {
            TokenId tokenId;
            Token<? extends RubyTokenId> token;
            int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            if (n2 != -1 && (token = LexUtilities.getToken(baseDocument, n2)) != null && ((tokenId = token.id()) == RubyTokenId.WHILE || tokenId == RubyTokenId.UNTIL || tokenId == RubyTokenId.FOR)) {
                return false;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return true;
    }

    public static boolean isBeginToken(TokenId tokenId, BaseDocument baseDocument, int n) {
        if (tokenId == RubyTokenId.DO) {
            return LexUtilities.isEndmatchingDo(baseDocument, n);
        }
        return END_PAIRS.contains(tokenId);
    }

    public static boolean isBeginToken(TokenId tokenId, BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence) {
        if (tokenId == RubyTokenId.DO) {
            return LexUtilities.isEndmatchingDo(baseDocument, tokenSequence.offset());
        }
        return END_PAIRS.contains(tokenId);
    }

    public static boolean isIndentToken(TokenId tokenId) {
        return INDENT_WORDS.contains(tokenId);
    }

    public static int getBeginEndLineBalance(BaseDocument baseDocument, int n, boolean bl) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = bl ? n : Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId;
                if (LexUtilities.isBeginToken(tokenId = (token = tokenSequence.token()).id(), baseDocument, tokenSequence)) {
                    ++n4;
                    continue;
                }
                if (tokenId != RubyTokenId.END) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getLineBalance(BaseDocument baseDocument, int n, TokenId tokenId, TokenId tokenId2) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId3;
                if ((tokenId3 = (token = tokenSequence.token()).id()) == tokenId) {
                    ++n4;
                    continue;
                }
                if (tokenId3 != tokenId2) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument baseDocument, TokenId tokenId, TokenId tokenId2, int n) throws BadLocationException {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, 0);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.moveIndex(0);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n2 = 0;
        do {
            Token token;
            if ((token = tokenSequence.token()).id() == tokenId) {
                ++n2;
                continue;
            }
            if (token.id() != tokenId2) continue;
            --n2;
        } while (tokenSequence.moveNext());
        return n2;
    }

    public static int getLineIndent(BaseDocument baseDocument, int n) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2) ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
            int n4 = Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static void indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    public static String getIndentString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        LexUtilities.indent(stringBuilder, n);
        return stringBuilder.toString();
    }

    public static boolean isCommentOnlyLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1) {
            return false;
        }
        if (n2 == baseDocument.getLength()) {
            return false;
        }
        return baseDocument.getText(n2, 1).equals("#");
    }

    public static void adjustLineIndentation(BaseDocument baseDocument, int n, int n2) {
        try {
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n2 > 0) {
                baseDocument.remove(n3, n2);
            } else if (n2 < 0) {
                baseDocument.insertString(n2, LexUtilities.getIndentString(n2), null);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public static int setLineIndentation(BaseDocument baseDocument, int n, int n2) {
        int n3 = LexUtilities.getLineIndent(baseDocument, n);
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n4 == -1) {
                return n3;
            }
            int n5 = n3 - n2;
            if (n5 > 0) {
                String string = baseDocument.getText(n4, n5);
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    throw new RuntimeException("Illegal indentation adjustment: Deleting non-whitespace chars: " + string);
                }
                baseDocument.remove(n4, n5);
            } else if (n5 < 0) {
                n5 = -n5;
                baseDocument.insertString(n4, LexUtilities.getIndentString(n5), null);
            }
            return n2;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n3;
        }
    }

    public static String getStringAt(int n, TokenHierarchy<Document> tokenHierarchy) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return null;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return null;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            String string = null;
            int n2 = 0;
            while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                string = ((Object)token.text()).toString();
                ++n2;
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                if (n2 == 1) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY)) {
                    stringBuilder.append(token.text());
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public static int getRequireStringOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        Token token;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                tokenId = token.id();
            }
            int n2 = tokenSequence.offset() + token.length();
            if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                while (tokenSequence.movePrevious()) {
                    token = tokenSequence.token();
                    tokenId = token.id();
                    if (tokenId == RubyTokenId.WHITESPACE || tokenId == RubyTokenId.LPAREN || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL) continue;
                    if (tokenId == RubyTokenId.IDENTIFIER) {
                        String string = ((Object)token.text()).toString();
                        if (string.equals("require") || string.equals("load")) {
                            return n2;
                        }
                        return -1;
                    }
                    return -1;
                }
            }
        }
        return -1;
    }

    public static int getSingleQuotedStringOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, RubyTokenId.STRING_BEGIN);
    }

    public static int getDoubleQuotedStringOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, RubyTokenId.QUOTED_STRING_BEGIN);
    }

    public static int getRegexpOffset(int n, TokenHierarchy<Document> tokenHierarchy) {
        return LexUtilities.getLiteralStringOffset(n, tokenHierarchy, RubyTokenId.REGEXP_BEGIN);
    }

    private static int getLiteralStringOffset(int n, TokenHierarchy<Document> tokenHierarchy, RubyTokenId rubyTokenId) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == rubyTokenId) {
                if (!tokenSequence.moveNext()) {
                    return -1;
                }
                return tokenSequence.offset();
            }
        }
        return -1;
    }

    public static boolean isInsideQuotedString(BaseDocument baseDocument, int n) {
        Token token;
        TokenId tokenId;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_END)) {
            return true;
        }
        return tokenSequence.movePrevious() && ((tokenId = (token = tokenSequence.token()).id()) == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_BEGIN);
    }

    public static boolean isInsideRegexp(BaseDocument baseDocument, int n) {
        Token token;
        TokenId tokenId;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && ((tokenId = (token = tokenSequence.token()).id()) == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.REGEXP_END)) {
            return true;
        }
        return tokenSequence.movePrevious() && ((tokenId = (token = tokenSequence.token()).id()) == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.REGEXP_BEGIN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OffsetRange getCommentBlock(BaseDocument baseDocument, int n) {
        int n2;
        int n3;
        int n4;
        block8: {
            try {
                Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n);
                if (token != null && token.id() == RubyTokenId.LINE_COMMENT) {
                    n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    if (!LexUtilities.isCommentOnlyLine(baseDocument, n)) {
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                        int n5 = token.offset(tokenHierarchy);
                        return new OffsetRange(n5, n5 + token.length());
                    }
                    break block8;
                }
                if (token == null) return OffsetRange.NONE;
                if (token.id() != RubyTokenId.DOCUMENTATION) return OffsetRange.NONE;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n6 = token.offset(tokenHierarchy);
                int n7 = n6 + token.length();
                return new OffsetRange(n6, n7);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return OffsetRange.NONE;
        }
        while (n4 > 0) {
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n4 - 1));
            if (n2 < 0 || !LexUtilities.isCommentOnlyLine(baseDocument, n2)) {
                n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4);
                break;
            }
            n4 = n2;
        }
        n2 = baseDocument.getLength();
        while (true) {
            int n8;
            if ((n8 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n3 + 1))) >= n2 || !LexUtilities.isCommentOnlyLine(baseDocument, n8)) {
                n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1;
                if (n4 >= n3) return OffsetRange.NONE;
                return new OffsetRange(n4, n3);
            }
            n3 = n8;
        }
    }

    public static int findSpaceBegin(BaseDocument baseDocument, int n) {
        int n2;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return n;
        }
        boolean bl = false;
        try {
            int n3;
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(n, baseDocument.getLength()));
            int n4 = n2 - 1;
            if (n2 > 0 && (n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)(n2 - 1))) != -1 && (n3 = (int)baseDocument.getText(n4, 1).charAt(0)) == 44) {
                bl = true;
            }
            if (!bl) {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n <= n3 || n3 == -1) {
                    return n;
                }
            } else {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n4 >= 0 && (n <= n3 || n3 == -1)) {
                    return n4 + 1;
                }
                n2 = 0;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            if (n > tokenSequence.offset()) {
                return Math.max(tokenSequence.token().id() == RubyTokenId.WHITESPACE ? tokenSequence.offset() : n, n2);
            }
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                if (token.id() == RubyTokenId.WHITESPACE) continue;
                return Math.max(tokenSequence.offset() + token.length(), n2);
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OffsetRange findRDocRange(BaseDocument baseDocument, int n) {
        int n2 = n;
        try {
            if (n >= baseDocument.getLength()) {
                return OffsetRange.NONE;
            }
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            --n3;
            while (n3 >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3))) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n3))) {
                --n3;
            }
            if (n3 < 0) {
                return OffsetRange.NONE;
            }
            while (n3 >= 0 && !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3))) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n3)) {
                int n4;
                int n5 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                String string = baseDocument.getText(n5, (n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1) - n5);
                if (string.startsWith("#")) {
                    n2 = n5;
                } else if (string.startsWith("=end") && n5 == Utilities.getRowStart((BaseDocument)baseDocument, (int)n3)) {
                    int n6 = LexUtilities.findInlineDocStart(baseDocument, n3);
                    if (n6 == -1) return OffsetRange.NONE;
                    n2 = n6;
                } else {
                    if (!string.equals("public") && !string.equals("private") && !string.equals("protected")) break;
                    --n3;
                    while (n3 >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3))) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n3))) {
                        --n3;
                    }
                    continue;
                }
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        if (n <= n2) return OffsetRange.NONE;
        return new OffsetRange(n2, n);
    }

    private static int findInlineDocStart(BaseDocument baseDocument, int n) throws BadLocationException {
        n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        --n;
        while (n >= 0) {
            int n2;
            int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            String string = baseDocument.getText(n3, (n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) - n3);
            if (string.startsWith("=begin")) {
                return n3;
            }
            --n;
        }
        return -1;
    }

    static {
        END_PAIRS.add(RubyTokenId.BEGIN);
        END_PAIRS.add(RubyTokenId.FOR);
        END_PAIRS.add(RubyTokenId.CLASS);
        END_PAIRS.add(RubyTokenId.DEF);
        END_PAIRS.add(RubyTokenId.DO);
        END_PAIRS.add(RubyTokenId.WHILE);
        END_PAIRS.add(RubyTokenId.IF);
        END_PAIRS.add(RubyTokenId.CLASS);
        END_PAIRS.add(RubyTokenId.MODULE);
        END_PAIRS.add(RubyTokenId.CASE);
        END_PAIRS.add(RubyTokenId.LOOP);
        END_PAIRS.add(RubyTokenId.UNTIL);
        END_PAIRS.add(RubyTokenId.UNLESS);
        INDENT_WORDS.addAll(END_PAIRS);
        INDENT_WORDS.add(RubyTokenId.ELSE);
        INDENT_WORDS.add(RubyTokenId.ELSIF);
        INDENT_WORDS.add(RubyTokenId.ENSURE);
        INDENT_WORDS.add(RubyTokenId.WHEN);
        INDENT_WORDS.add(RubyTokenId.RESCUE);
    }
}

