/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call {
    public static final Call LOCAL = new Call(null, null, false, false);
    public static final Call NONE = new Call(null, null, false, false);
    public static final Call UNKNOWN = new Call(null, null, false, false);
    private final String type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;

    public Call(String string, String string2, boolean bl, boolean bl2) {
        this.type = string;
        this.lhs = string2;
        this.methodExpected = bl2;
        if (string2 == null) {
            string2 = string;
        }
        this.isStatic = bl;
    }

    public String getType() {
        return this.type;
    }

    public String getLhs() {
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(" + this.type + "," + this.lhs + "," + this.isStatic + ")";
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    @NonNull
    public static Call getCallType(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return NONE;
        }
        tokenSequence.move(n);
        boolean bl = false;
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return NONE;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            String string;
            int n2;
            String string2;
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.WHITESPACE) {
                return LOCAL;
            }
            if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return NONE;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CONSTANT || tokenId.primaryCategory().equals("keyword")) {
                string2 = ((Object)token.text()).toString();
                if (".".equals(string2)) {
                    bl = true;
                } else if (!"::".equals(string2)) {
                    bl = true;
                    if (Character.isUpperCase(string2.charAt(0))) {
                        bl = false;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return LOCAL;
                    }
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == RubyTokenId.DOT) {
                bl = true;
            } else if (tokenId != RubyTokenId.COLON3) {
                if (tokenId == RubyTokenId.IDENTIFIER) {
                    string2 = ((Object)token.text()).toString();
                    if (string2.equals(".")) {
                        bl = true;
                    } else if (!string2.equals("::")) {
                        return LOCAL;
                    }
                } else {
                    return LOCAL;
                }
            }
            int n3 = n2 = tokenSequence.offset();
            int n4 = 0;
            try {
                if (n > baseDocument.getLength()) {
                    n = baseDocument.getLength();
                }
                n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            while (tokenSequence.movePrevious() && tokenSequence.offset() >= n4) {
                token = tokenSequence.token();
                tokenId = token.id();
                string = null;
                if (tokenId == RubyTokenId.ANY_KEYWORD) {
                    string = ((Object)token.text()).toString();
                }
                if (tokenId == RubyTokenId.WHITESPACE) break;
                if (tokenId == RubyTokenId.RBRACKET) {
                    return new Call("Array", null, false, bl);
                }
                if (tokenId == RubyTokenId.RBRACE) {
                    return new Call("Hash", null, false, bl);
                }
                if (tokenId == RubyTokenId.STRING_END || tokenId == RubyTokenId.QUOTED_STRING_END) {
                    return new Call("String", null, false, bl);
                }
                if (tokenId == RubyTokenId.REGEXP_END) {
                    return new Call("Regexp", null, false, bl);
                }
                if (tokenId == RubyTokenId.INT_LITERAL) {
                    return new Call("Fixnum", null, false, bl);
                }
                if (tokenId == RubyTokenId.FLOAT_LITERAL) {
                    return new Call("Float", null, false, bl);
                }
                if (tokenId == RubyTokenId.TYPE_SYMBOL) {
                    return new Call("Symbol", null, false, bl);
                }
                if (tokenId == RubyTokenId.RANGE) {
                    return new Call("Range", null, false, bl);
                }
                if (tokenId == RubyTokenId.ANY_KEYWORD && "nil".equals(string)) {
                    return new Call("NilClass", null, false, bl);
                }
                if (tokenId == RubyTokenId.ANY_KEYWORD && "true".equals(string)) {
                    return new Call("TrueClass", null, false, bl);
                }
                if (tokenId == RubyTokenId.ANY_KEYWORD && "false".equals(string)) {
                    return new Call("FalseClass", null, false, bl);
                }
                if (tokenId == RubyTokenId.GLOBAL_VAR || tokenId == RubyTokenId.INSTANCE_VAR || tokenId == RubyTokenId.CLASS_VAR || tokenId == RubyTokenId.IDENTIFIER || tokenId.primaryCategory().equals("keyword") || tokenId == RubyTokenId.DOT || tokenId == RubyTokenId.COLON3 || tokenId == RubyTokenId.CONSTANT || tokenId == RubyTokenId.SUPER || tokenId == RubyTokenId.SELF) {
                    n3 = tokenSequence.offset();
                    continue;
                }
                if (tokenId == RubyTokenId.LPAREN || tokenId == RubyTokenId.LBRACE || tokenId == RubyTokenId.LBRACKET) break;
                return UNKNOWN;
            }
            if (n3 < n2) {
                try {
                    string = baseDocument.getText(n3, n2 - n3);
                    if (string.equals("super") || string.equals("self")) {
                        return new Call(string, string, false, true);
                    }
                    if (Character.isUpperCase(string.charAt(0))) {
                        String string3;
                        if (string.endsWith(".new") && RubyUtils.isValidRubyModuleName(string3 = string.substring(0, string.length() - 4))) {
                            return new Call(string3, string, false, bl);
                        }
                        string3 = null;
                        if (RubyUtils.isValidRubyModuleName(string)) {
                            string3 = string;
                        }
                        return new Call(string3, string, true, bl);
                    }
                    return new Call(null, string, false, bl);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            } else {
                return UNKNOWN;
            }
        }
        return LOCAL;
    }
}

