/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticAnalysis
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> semanticHighlights;

    public Map<OffsetRange, ColoringAttributes> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(compilationInfo);
        if (rubyParseResult == null) {
            return;
        }
        Node node = rubyParseResult.getRootNode();
        if (node == null) {
            return;
        }
        HashMap<OffsetRange, Object> hashMap = new HashMap<OffsetRange, ColoringAttributes>(100);
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.annotate(node, hashMap, astPath, null, false);
        astPath.ascend();
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            if (rubyParseResult.getTranslatedSource() != null) {
                HashMap hashMap2 = new HashMap(2 * hashMap.size());
                for (Map.Entry entry : hashMap.entrySet()) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                    if (offsetRange == OffsetRange.NONE) continue;
                    hashMap2.put(offsetRange, entry.getValue());
                }
                hashMap = hashMap2;
            }
            this.semanticHighlights = hashMap;
        } else {
            this.semanticHighlights = null;
        }
    }

    private void annotate(Node node, Map<OffsetRange, ColoringAttributes> map, AstPath astPath, List<String> list, boolean bl) {
        Object object;
        Object object2;
        switch (node.nodeId) {
            case ARGSNODE: {
                bl = true;
                break;
            }
            case LOCALASGNNODE: {
                String string;
                object2 = (LocalAsgnNode)node;
                object = AstUtilities.findLocalScope(node, astPath);
                boolean bl2 = this.isUsedInMethod((Node)object, object2.getName(), bl);
                if (!bl2) {
                    OffsetRange object32 = AstUtilities.getLValueRange((AssignableNode)object2);
                    map.put(object32, ColoringAttributes.UNUSED);
                    break;
                }
                if (list == null || !list.contains(string = ((LocalAsgnNode)node).getName())) break;
                OffsetRange offsetRange = AstUtilities.getRange(node);
                offsetRange = new OffsetRange(offsetRange.getStart(), offsetRange.getStart() + string.length());
                map.put(offsetRange, ColoringAttributes.PARAMETER);
                break;
            }
            case DASGNNODE: {
                object2 = (DAsgnNode)node;
                object = AstUtilities.findLocalScope(node, astPath);
                boolean bl3 = this.isUsedInMethod((Node)object, object2.getName(), false);
                if (bl3) break;
                OffsetRange offsetRange = AstUtilities.getLValueRange((AssignableNode)object2);
                map.put(offsetRange, ColoringAttributes.UNUSED);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                object2 = (MethodDefNode)node;
                list = AstUtilities.getDefArgs((MethodDefNode)object2, true);
                if (list != null && list.size() > 0) {
                    object = new ArrayList();
                    for (String string : list) {
                        boolean bl2 = this.isUsedInMethod(node, string, true);
                        if (bl2) continue;
                        object.add(string);
                    }
                    if (object.size() > 0) {
                        this.annotateUnusedParameters((MethodDefNode)object2, map, (List<String>)object);
                        list.removeAll((Collection<?>)object);
                    }
                    if (list != null) {
                        if (list.size() == 0) {
                            list = null;
                        } else {
                            this.annotateParameters((MethodDefNode)object2, map, list);
                        }
                    }
                }
                this.highlightMethodName(node, map);
                break;
            }
            case LOCALVARNODE: {
                if (list == null || !list.contains(((LocalVarNode)node).getName())) break;
                object2 = AstUtilities.getRange(node);
                map.put((OffsetRange)object2, ColoringAttributes.PARAMETER);
                break;
            }
            case FCALLNODE: 
            case VCALLNODE: {
                object2 = AstUtilities.getCallRange(node);
                map.put((OffsetRange)object2, ColoringAttributes.METHOD);
                break;
            }
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            astPath.descend(node2);
            this.annotate(node2, map, astPath, list, bl);
            astPath.ascend();
        }
    }

    private void annotateParameters(MethodDefNode methodDefNode, Map<OffsetRange, ColoringAttributes> map, List<String> list) {
        List list2 = methodDefNode.childNodes();
        for (Node node : list2) {
            OffsetRange offsetRange;
            List list3;
            if (node.nodeId != NodeType.ARGSNODE) continue;
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getRequiredArgsCount() > 0) {
                list3 = argsNode.childNodes();
                for (Node node2 : list3) {
                    if (!(node2 instanceof ListNode)) continue;
                    List list4 = node2.childNodes();
                    for (Node node3 : list4) {
                        OffsetRange offsetRange2;
                        if (node3.nodeId == NodeType.ARGUMENTNODE) {
                            if (!list.contains(((ArgumentNode)node3).getName())) continue;
                            offsetRange2 = AstUtilities.getRange(node3);
                            map.put(offsetRange2, ColoringAttributes.PARAMETER);
                            continue;
                        }
                        if (node3.nodeId != NodeType.LOCALASGNNODE || !list.contains(((LocalAsgnNode)node3).getName())) continue;
                        offsetRange2 = AstUtilities.getRange(node3);
                        map.put(offsetRange2, ColoringAttributes.PARAMETER);
                    }
                }
            }
            if (argsNode.getRestArgNode() != null && list.contains((list3 = argsNode.getRestArgNode()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.PARAMETER);
            }
            if (argsNode.getRestArgNode() != null && list.contains((list3 = argsNode.getRestArgNode()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.PARAMETER);
            }
            if (argsNode.getBlockArgNode() == null || !list.contains((list3 = argsNode.getBlockArgNode()).getName())) continue;
            offsetRange = AstUtilities.getRange((Node)list3);
            map.put(offsetRange, ColoringAttributes.PARAMETER);
        }
    }

    private void annotateUnusedParameters(MethodDefNode methodDefNode, Map<OffsetRange, ColoringAttributes> map, List<String> list) {
        List list2 = methodDefNode.childNodes();
        for (Node node : list2) {
            OffsetRange offsetRange;
            List list3;
            if (node.nodeId != NodeType.ARGSNODE) continue;
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getRequiredArgsCount() > 0) {
                list3 = argsNode.childNodes();
                for (Node node2 : list3) {
                    if (!(node2 instanceof ListNode)) continue;
                    List list4 = node2.childNodes();
                    for (Node node3 : list4) {
                        OffsetRange offsetRange2;
                        if (node3.nodeId == NodeType.ARGUMENTNODE) {
                            if (!list.contains(((ArgumentNode)node3).getName())) continue;
                            offsetRange2 = AstUtilities.getRange(node3);
                            map.put(offsetRange2, ColoringAttributes.UNUSED);
                            continue;
                        }
                        if (node3.nodeId != NodeType.LOCALASGNNODE || !list.contains(((LocalAsgnNode)node3).getName())) continue;
                        offsetRange2 = AstUtilities.getRange(node3);
                        map.put(offsetRange2, ColoringAttributes.UNUSED);
                    }
                }
            }
            if (argsNode.getRestArgNode() != null && list.contains((list3 = argsNode.getRestArgNode()).getName())) {
                offsetRange = AstUtilities.getRange((Node)list3);
                map.put(offsetRange, ColoringAttributes.UNUSED);
            }
            if (argsNode.getBlockArgNode() == null || !list.contains((list3 = argsNode.getBlockArgNode()).getName())) continue;
            offsetRange = AstUtilities.getRange((Node)list3);
            map.put(offsetRange, ColoringAttributes.UNUSED);
        }
    }

    private boolean isUsedInMethod(Node node, String string, boolean bl) {
        Object object;
        switch (node.nodeId) {
            case LOCALVARNODE: {
                if (node.nodeId != NodeType.LOCALVARNODE || !string.equals(object = ((LocalVarNode)node).getName())) break;
                return true;
            }
            case FORNODE: {
                object = ((ForNode)node).getIterNode();
                if (!(object instanceof INameNode) || !string.equals(((INameNode)object).getName())) break;
                return true;
            }
            case DVARNODE: {
                if (!string.equals(((DVarNode)node).getName())) break;
                return true;
            }
            case ALIASNODE: {
                object = (AliasNode)node;
                if (!object.getOldName().equals(string)) break;
                return true;
            }
            case ZSUPERNODE: {
                if (!bl) break;
                return true;
            }
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            Node node2 = (Node)iterator.next();
            if (node2.nodeId == NodeType.DEFSNODE || node2.nodeId == NodeType.DEFNNODE || !(bl2 = this.isUsedInMethod(node2, string, bl))) continue;
            return true;
        }
        return false;
    }

    private void highlightMethodName(Node node, Map<OffsetRange, ColoringAttributes> map) {
        OffsetRange offsetRange = AstUtilities.getFunctionNameRange(node);
        if (offsetRange != OffsetRange.NONE && !map.containsKey(offsetRange)) {
            map.put(offsetRange, ColoringAttributes.METHOD);
        }
    }
}

